/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcgregor;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregorChecks;

@Deprecated
public class QueryProcessor {
    private final List<String> cTab1Copy;
    private final List<String> cTab2Copy;
    private final String[] signs;
    private int neighborBondNumA;
    private int setBondNumA;
    private final List<Integer> iBondNeighborsA;
    private final List<String> cBondNeighborsA;
    private final int newNeighborNumA;
    private final List<Integer> newINeighborsA;
    private final List<String> newCNeighborsA;

    protected QueryProcessor(List<String> cTab1Copy, List<String> cTab2Copy, String[] signArray, int neighborBondnumA, int setBondnumA, List<Integer> iBondNeighborsA, List<String> cBondNeighborsA, int mappingSize, List<Integer> iBondSetA, List<String> cBondSetA) {
        this.cTab1Copy = cTab1Copy;
        this.cTab2Copy = cTab2Copy;
        this.signs = signArray;
        this.neighborBondNumA = neighborBondnumA;
        this.setBondNumA = setBondnumA;
        this.iBondNeighborsA = iBondNeighborsA;
        this.cBondNeighborsA = cBondNeighborsA;
        this.newNeighborNumA = mappingSize;
        this.newINeighborsA = iBondSetA;
        this.newCNeighborsA = cBondSetA;
    }

    protected void process(IAtomContainer query, IAtomContainer target, List<Integer> unmappedAtomsMolA, List<Integer> mappedAtoms, int counter) {
        int unmappedNumA = unmappedAtomsMolA.size();
        boolean bondConsidered = false;
        boolean normalBond = true;
        for (int atomIndex = 0; atomIndex < query.getBondCount(); ++atomIndex) {
            Integer indexI = query.indexOf(query.getBond(atomIndex).getBegin());
            Integer indexJ = query.indexOf(query.getBond(atomIndex).getEnd());
            Integer order = query.getBond(atomIndex).getOrder().numeric();
            for (Integer integer : unmappedAtomsMolA) {
                if (integer.equals(indexI)) {
                    normalBond = this.unMappedAtomsEqualsIndexJ(query, target, atomIndex, counter, mappedAtoms, indexI, indexJ, order);
                    bondConsidered = true;
                } else if (integer.equals(indexJ)) {
                    normalBond = this.unMappedAtomsEqualsIndexI(query, target, atomIndex, counter, mappedAtoms, indexI, indexJ, order);
                    bondConsidered = true;
                }
                if (!normalBond || !bondConsidered) continue;
                this.markNormalBonds(atomIndex, indexI, indexJ, order);
                normalBond = true;
                break;
            }
            bondConsidered = false;
        }
    }

    protected void process(IQueryAtomContainer query, IAtomContainer target, List<Integer> unmappedAtomsMolA, List<Integer> mappedAtoms, int counter) {
        int unmappedNumA = unmappedAtomsMolA.size();
        boolean bondConsidered = false;
        boolean normalBond = true;
        for (int atomIndex = 0; atomIndex < query.getBondCount(); ++atomIndex) {
            Integer indexI = query.indexOf(query.getBond(atomIndex).getBegin());
            Integer indexJ = query.indexOf(query.getBond(atomIndex).getEnd());
            Integer order = 0;
            if (query.getBond(atomIndex).getOrder() != null) {
                order = query.getBond(atomIndex).getOrder().numeric();
            }
            for (Integer integer : unmappedAtomsMolA) {
                if (integer.equals(indexI)) {
                    normalBond = this.unMappedAtomsEqualsIndexJ(query, target, atomIndex, counter, mappedAtoms, indexI, indexJ, order);
                    bondConsidered = true;
                } else if (integer.equals(indexJ)) {
                    normalBond = this.unMappedAtomsEqualsIndexI(query, target, atomIndex, counter, mappedAtoms, indexI, indexJ, order);
                    bondConsidered = true;
                }
                if (!normalBond || !bondConsidered) continue;
                this.markNormalBonds(atomIndex, indexI, indexJ, order);
                normalBond = true;
                break;
            }
            bondConsidered = false;
        }
    }

    protected void process(int setNumA, int setNumB, List<Integer> iBondSetA, List<Integer> iBondSetB, List<Integer> unmappedAtomsMolA, List<Integer> newMapping, int counter) {
        boolean bondConsidered = false;
        boolean normalBond = true;
        for (int atomIndex = 0; atomIndex < setNumA; ++atomIndex) {
            Integer indexI = iBondSetA.get(atomIndex * 3 + 0);
            Integer indexJ = iBondSetA.get(atomIndex * 3 + 1);
            Integer order = iBondSetA.get(atomIndex * 3 + 2);
            for (Integer unMappedAtomIndex : unmappedAtomsMolA) {
                if (unMappedAtomIndex.equals(indexI)) {
                    normalBond = this.unMappedAtomsEqualsIndexJ(setNumA, setNumB, iBondSetA, iBondSetB, atomIndex, counter, newMapping, indexI, indexJ, order);
                    bondConsidered = true;
                } else if (unMappedAtomIndex.equals(indexJ)) {
                    normalBond = this.unMappedAtomsEqualsIndexI(setNumA, setNumB, iBondSetA, iBondSetB, atomIndex, counter, newMapping, indexI, indexJ, order);
                    bondConsidered = true;
                }
                if (!normalBond || !bondConsidered) continue;
                this.markNormalBonds(atomIndex, indexI, indexJ, order);
                normalBond = true;
                break;
            }
            bondConsidered = false;
        }
    }

    private int searchCorrespondingAtom(int mappedAtomsSize, int atomFromOtherMolecule, int molecule, List<Integer> mappedAtomsOrg) {
        ArrayList<Integer> mappedAtoms = new ArrayList<Integer>(mappedAtomsOrg);
        int correspondingAtom = 0;
        for (int a = 0; a < mappedAtomsSize; ++a) {
            if (molecule == 1 && (Integer)mappedAtoms.get(a * 2 + 0) == atomFromOtherMolecule) {
                correspondingAtom = (Integer)mappedAtoms.get(a * 2 + 1);
            }
            if (molecule != 2 || (Integer)mappedAtoms.get(a * 2 + 1) != atomFromOtherMolecule) continue;
            correspondingAtom = (Integer)mappedAtoms.get(a * 2 + 0);
        }
        return correspondingAtom;
    }

    private void markNormalBonds(int atomIndex, Integer indexI, Integer indexJ, Integer order) {
        this.newINeighborsA.add(indexI);
        this.newINeighborsA.add(indexJ);
        this.newINeighborsA.add(order);
        this.newCNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.newCNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
        this.newCNeighborsA.add("X");
        this.newCNeighborsA.add("X");
        ++this.setBondNumA;
    }

    private void step1(int atomIndex, int counter) {
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsA.add(this.signs[counter]);
        this.cBondNeighborsA.add("X");
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
    }

    private void step2(int atomIndex) {
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsA.add("X");
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 3));
    }

    private void step3(int atomIndex, int counter) {
        this.cBondNeighborsA.add(this.signs[counter]);
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsA.add("X");
    }

    private void step4(int atomIndex) {
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 0));
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 1));
        this.cBondNeighborsA.add(this.cTab1Copy.get(atomIndex * 4 + 2));
        this.cBondNeighborsA.add("X");
    }

    private boolean unMappedAtomsEqualsIndexJ(IAtomContainer query, IAtomContainer target, int atomIndex, int counter, List<Integer> mappedAtoms, Integer indexI, Integer indexJ, Integer order) {
        boolean normalBond = true;
        for (int c = 0; c < this.newNeighborNumA; ++c) {
            if (!mappedAtoms.get(c * 2).equals(indexJ)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab1Copy.get(atomIndex * 4 + 3).compareToIgnoreCase("X") == 0) {
                this.step1(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexI, this.signs[counter], query.getBondCount(), query, this.cTab1Copy);
                int corAtom = this.searchCorrespondingAtom(this.newNeighborNumA, indexI, 1, mappedAtoms);
                McGregorChecks.changeCharBonds(corAtom, this.signs[counter], target.getBondCount(), target, this.cTab2Copy);
                ++counter;
            } else {
                this.step2(atomIndex);
            }
            normalBond = false;
            ++this.neighborBondNumA;
        }
        return normalBond;
    }

    private boolean unMappedAtomsEqualsIndexI(IAtomContainer query, IAtomContainer target, int atomIndex, int counter, List<Integer> mappedAtoms, Integer indexI, Integer indexJ, Integer order) {
        boolean normalBond = true;
        for (int c = 0; c < this.newNeighborNumA; ++c) {
            if (!mappedAtoms.get(c * 2 + 0).equals(indexI)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab1Copy.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                this.step3(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexJ, this.signs[counter], query.getBondCount(), query, this.cTab1Copy);
                int corAtom = this.searchCorrespondingAtom(this.newNeighborNumA, indexJ, 1, mappedAtoms);
                McGregorChecks.changeCharBonds(corAtom, this.signs[counter], target.getBondCount(), target, this.cTab2Copy);
                ++counter;
            } else {
                this.step4(atomIndex);
            }
            normalBond = false;
            ++this.neighborBondNumA;
        }
        return normalBond;
    }

    private boolean unMappedAtomsEqualsIndexJ(int setNumA, int setNumB, List<Integer> iBondSetA, List<Integer> iBondSetB, int atomIndex, int counter, List<Integer> newMapping, Integer indexI, Integer indexJ, Integer order) {
        boolean normalBond = true;
        for (int c = 0; c < this.newNeighborNumA; ++c) {
            if (!newMapping.get(c * 2 + 0).equals(indexJ)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab1Copy.get(atomIndex * 4 + 3).compareToIgnoreCase("X") == 0) {
                this.step1(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexI, this.signs[counter], setNumA, iBondSetA, this.cTab1Copy);
                int corAtom = McGregorChecks.searchCorrespondingAtom(this.newNeighborNumA, indexI, 1, newMapping);
                McGregorChecks.changeCharBonds(corAtom, this.signs[counter], setNumB, iBondSetB, this.cTab2Copy);
                ++counter;
            } else {
                this.step2(atomIndex);
            }
            normalBond = false;
            ++this.neighborBondNumA;
        }
        return normalBond;
    }

    private boolean unMappedAtomsEqualsIndexI(int setNumA, int setNumB, List<Integer> iBondSetA, List<Integer> iBondSetB, int atomIndex, int counter, List<Integer> newMapping, Integer indexI, Integer indexJ, Integer order) {
        boolean normalBond = true;
        for (int c = 0; c < this.newNeighborNumA; ++c) {
            if (!newMapping.get(c * 2 + 0).equals(indexI)) continue;
            this.setBondNeighbors(indexI, indexJ, order);
            if (this.cTab1Copy.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                this.step3(atomIndex, counter);
                McGregorChecks.changeCharBonds((int)indexJ, this.signs[counter], setNumA, iBondSetA, this.cTab1Copy);
                int corAtom = McGregorChecks.searchCorrespondingAtom(this.newNeighborNumA, indexJ, 1, newMapping);
                McGregorChecks.changeCharBonds(corAtom, this.signs[counter], setNumB, iBondSetB, this.cTab2Copy);
                ++counter;
            } else {
                this.step4(atomIndex);
            }
            normalBond = false;
            ++this.neighborBondNumA;
        }
        return normalBond;
    }

    private void setBondNeighbors(Integer indexI, Integer indexJ, Integer order) {
        this.iBondNeighborsA.add(indexI);
        this.iBondNeighborsA.add(indexJ);
        this.iBondNeighborsA.add(order);
    }

    protected List<String> getCTab1() {
        return this.cTab1Copy;
    }

    protected List<String> getCTab2() {
        return this.cTab2Copy;
    }

    protected int getNeighborBondNumA() {
        return this.neighborBondNumA;
    }

    protected int getBondNumA() {
        return this.setBondNumA;
    }

    List<Integer> getIBondNeighboursA() {
        return this.iBondNeighborsA;
    }

    List<String> getCBondNeighborsA() {
        return this.cBondNeighborsA;
    }
}

