/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.labelling;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.smsd.labelling.ICanonicalMoleculeLabeller;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;

@Deprecated
public class AbstractReactionLabeller {
    private final boolean fixAtomMappingCastType = false;

    private void fixAtomMapping(IAtomContainer canonicalForm) {
        for (IAtom a : canonicalForm.atoms()) {
            String v = (String)a.getProperty("cdk:AtomAtomMapping");
            if (v == null) continue;
            a.setProperty("cdk:AtomAtomMapping", Integer.valueOf(v));
        }
    }

    private Map<IAtom, IAtom> atomAtomMap(IReaction reaction, IReaction clone, Map<IAtomContainer, int[]> permutationMap) {
        Hashtable<IAtom, IAtom> atomAtom = new Hashtable<IAtom, IAtom>();
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet clonedReactants = clone.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            IAtomContainer mol2 = clonedReactants.getAtomContainer(i);
            int[] permutation = permutationMap.get(mol2);
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                atomAtom.put(mol.getAtom(j), mol2.getAtom(permutation[j]));
            }
        }
        IAtomContainerSet products = reaction.getProducts();
        IAtomContainerSet clonedProducts = clone.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            IAtomContainer mol2 = clonedProducts.getAtomContainer(i);
            int[] permutation = permutationMap.get(mol2);
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                atomAtom.put(mol.getAtom(j), mol2.getAtom(permutation[j]));
            }
        }
        for (IAtom key : atomAtom.keySet()) {
            IAtomContainer keyAC = ReactionManipulator.getRelevantAtomContainer(reaction, key);
            int keyIndex = keyAC.indexOf(key);
            IAtom value = (IAtom)atomAtom.get(key);
            IAtomContainer valueAC = ReactionManipulator.getRelevantAtomContainer(clone, value);
            int valueIndex = valueAC.indexOf(value);
            System.out.println("key " + keyIndex + key.getSymbol() + " mapped to " + valueIndex + value.getSymbol());
        }
        return atomAtom;
    }

    private List<IMapping> cloneMappings(IReaction reaction, Map<IAtom, IAtom> atomAtomMap) {
        int numberOfMappings = reaction.getMappingCount();
        ArrayList<IMapping> map = new ArrayList<IMapping>();
        for (int mappingIndex = 0; mappingIndex < numberOfMappings; ++mappingIndex) {
            IMapping mapping = reaction.getMapping(mappingIndex);
            IChemObject keyChemObj0 = mapping.getChemObject(0);
            IChemObject keyChemObj1 = mapping.getChemObject(1);
            IChemObject co0 = atomAtomMap.get(keyChemObj0);
            IChemObject co1 = atomAtomMap.get(keyChemObj1);
            map.add(new Mapping(co0, co1));
        }
        return map;
    }

    private void cloneAndSortMappings(IReaction reaction, IReaction copyOfReaction, Map<IAtomContainer, int[]> permutationMap) {
        final HashMap<IAtom, Integer> indexMap = new HashMap<IAtom, Integer>();
        List<IAtomContainer> all = ReactionManipulator.getAllAtomContainers(copyOfReaction);
        int globalIndex = 0;
        for (IAtomContainer ac : all) {
            for (IAtom atom : ac.atoms()) {
                indexMap.put(atom, globalIndex);
                ++globalIndex;
            }
        }
        Map<IAtom, IAtom> atomAtomMap = this.atomAtomMap(reaction, copyOfReaction, permutationMap);
        List<IMapping> map = this.cloneMappings(reaction, atomAtomMap);
        Comparator<IMapping> mappingSorter = new Comparator<IMapping>(){

            @Override
            public int compare(IMapping o1, IMapping o2) {
                IChemObject o10 = o1.getChemObject(0);
                IChemObject o20 = o2.getChemObject(0);
                return ((Integer)indexMap.get(o10)).compareTo((Integer)indexMap.get(o20));
            }
        };
        map.sort(mappingSorter);
        int mappingIndex = 0;
        for (IMapping mapping : map) {
            mapping.getChemObject(0).setProperty("cdk:AtomAtomMapping", mappingIndex);
            mapping.getChemObject(1).setProperty("cdk:AtomAtomMapping", mappingIndex);
            copyOfReaction.addMapping(mapping);
            ++mappingIndex;
        }
    }

    public IReaction labelReaction(IReaction reaction, ICanonicalMoleculeLabeller labeller) {
        System.out.println("labelling");
        Reaction canonReaction = new Reaction();
        HashMap<IAtomContainer, int[]> permutationMap = new HashMap<IAtomContainer, int[]>();
        IAtomContainerSet canonicalProducts = DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainerSet.class, new Object[0]);
        for (IAtomContainer product : reaction.getProducts().atomContainers()) {
            IAtomContainer canonicalForm = labeller.getCanonicalMolecule(product);
            IAtomContainer canonicalMolecule = canonicalForm.getBuilder().newInstance(IAtomContainer.class, canonicalForm);
            permutationMap.put(canonicalMolecule, labeller.getCanonicalPermutation(product));
            canonicalProducts.addAtomContainer(canonicalMolecule);
        }
        IAtomContainerSet canonicalReactants = DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainerSet.class, new Object[0]);
        for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
            IAtomContainer canonicalForm = labeller.getCanonicalMolecule(reactant);
            IAtomContainer canonicalMolecule = canonicalForm.getBuilder().newInstance(IAtomContainer.class, canonicalForm);
            permutationMap.put(canonicalMolecule, labeller.getCanonicalPermutation(reactant));
            canonicalReactants.addAtomContainer(canonicalMolecule);
        }
        canonReaction.setProducts(canonicalProducts);
        canonReaction.setReactants(canonicalReactants);
        this.cloneAndSortMappings(reaction, canonReaction, permutationMap);
        return canonReaction;
    }
}

