/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Bond;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

@Deprecated
public class ExtAtomContainerManipulator
extends AtomContainerManipulator {
    private static void printAtoms(IAtomContainer mol) {
        System.out.print("Atom: ");
        for (IAtom a : mol.atoms()) {
            System.out.print(a.getSymbol());
            System.out.print("[" + a.getFormalCharge() + "]");
            if (a.getID() == null) continue;
            System.out.print("[" + a.getID() + "]");
        }
        System.out.println();
        System.out.println();
    }

    public static IAtomContainer makeDeepCopy(IAtomContainer container2) {
        int index;
        IAtomContainer newAtomContainer = container2.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom[] atoms = ExtAtomContainerManipulator.copyAtoms(container2, newAtomContainer);
        ExtAtomContainerManipulator.copyBonds(atoms, container2, newAtomContainer);
        for (index = 0; index < container2.getLonePairCount(); ++index) {
            if (container2.getAtom(index).getSymbol().equalsIgnoreCase("R") || container2.getAtom(index).getSymbol().equalsIgnoreCase("A")) {
                newAtomContainer.addLonePair(container2.getBuilder().newInstance(ILonePair.class, container2.getAtom(index)));
                continue;
            }
            newAtomContainer.addLonePair(index);
        }
        for (index = 0; index < container2.getSingleElectronCount(); ++index) {
            newAtomContainer.addSingleElectron(index);
        }
        newAtomContainer.addProperties(container2.getProperties());
        newAtomContainer.setFlags(container2.getFlags());
        newAtomContainer.setID(container2.getID());
        newAtomContainer.notifyChanged();
        return newAtomContainer;
    }

    public static void aromatizeMolecule(IAtomContainer mol) {
        IRingSet ringSet = null;
        try {
            AllRingsFinder arf = new AllRingsFinder();
            ringSet = arf.findAllRings(mol);
        }
        catch (Exception e2) {
            LoggingToolFactory.createLoggingTool(ExtAtomContainerManipulator.class).warn("Unexpected Error:", e2);
        }
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
            Aromaticity.cdkLegacy().apply(mol);
            RingSetManipulator.markAromaticRings(ringSet);
        }
        catch (Exception e3) {
            LoggingToolFactory.createLoggingTool(ExtAtomContainerManipulator.class).warn("Unexpected Error:", e3);
        }
        for (int i = 0; i <= mol.getAtomCount() - 1; ++i) {
            mol.getAtom(i).setFlag(32, false);
            for (int j = 0; j <= ringSet.getAtomContainerCount() - 1; ++j) {
                boolean haveatom;
                IRing ring = (IRing)ringSet.getAtomContainer(j);
                if (!ring.getFlag(32) || !(haveatom = ring.contains(mol.getAtom(i))) || ring.getAtomCount() != 6) continue;
                mol.getAtom(i).setFlag(32, true);
            }
        }
    }

    public static int getExplicitHydrogenCount(IAtomContainer atomContainer, IAtom atom) {
        int hCount = 0;
        for (IAtom iAtom : atomContainer.getConnectedAtomsList(atom)) {
            IAtom connectedAtom = iAtom;
            if (connectedAtom.getAtomicNumber() != 1) continue;
            ++hCount;
        }
        return hCount;
    }

    public static int getImplicitHydrogenCount(IAtom atom) {
        return atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
    }

    public static int getHydrogenCount(IAtomContainer atomContainer, IAtom atom) {
        return ExtAtomContainerManipulator.getExplicitHydrogenCount(atomContainer, atom) + ExtAtomContainerManipulator.getImplicitHydrogenCount(atom);
    }

    public static IAtomContainer removeHydrogensExceptSingleAndPreserveAtomID(IAtomContainer atomContainer) {
        IAtomContainer mol;
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        if (atomContainer.getBondCount() > 0) {
            mol = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            int count = atomContainer.getAtomCount();
            for (int i = 0; i < count; ++i) {
                IAtom atom = atomContainer.getAtom(i);
                if (atom.getAtomicNumber() != 1) {
                    IAtom clonedAtom = null;
                    try {
                        clonedAtom = atom.clone();
                        clonedAtom.setID(atom.getID());
                        clonedAtom.setFlags(atom.getFlags());
                        int countH = 0;
                        if (atom.getImplicitHydrogenCount() != null) {
                            countH = atom.getImplicitHydrogenCount();
                        }
                        clonedAtom.setImplicitHydrogenCount(countH);
                        mol.addAtom(clonedAtom);
                        map.put(atom, clonedAtom);
                        continue;
                    }
                    catch (CloneNotSupportedException e2) {
                        throw new IllegalStateException("Atom could not be cloned", e2);
                    }
                }
                remove.add(atom);
            }
            mol = ExtAtomContainerManipulator.cloneAndMarkNonHBonds(mol, atomContainer, remove, map);
            mol = ExtAtomContainerManipulator.reComputeHydrogens(mol, atomContainer, remove, map);
        } else {
            mol = atomContainer.getBuilder().newInstance(IAtomContainer.class, atomContainer);
            if (atomContainer.getAtom(0).getSymbol().equalsIgnoreCase("H")) {
                System.err.println("WARNING: single hydrogen atom removal not supported!");
            }
            mol.setFlags(atomContainer.getFlags());
        }
        mol.addProperties(atomContainer.getProperties());
        if (atomContainer.getID() != null) {
            mol.setID(atomContainer.getID());
        }
        return mol;
    }

    public static IAtomContainer convertExplicitToImplicitHydrogens(IAtomContainer atomContainer) {
        IAtomContainer mol = atomContainer.getBuilder().newInstance(IAtomContainer.class, atomContainer);
        ExtAtomContainerManipulator.convertImplicitToExplicitHydrogens(mol);
        if (mol.getAtomCount() > 1) {
            mol = ExtAtomContainerManipulator.removeHydrogens(mol);
        } else if (atomContainer.atoms().iterator().next().getSymbol().equalsIgnoreCase("H")) {
            System.err.println("WARNING: single hydrogen atom removal not supported!");
        }
        mol.addProperties(atomContainer.getProperties());
        mol.setFlags(atomContainer.getFlags());
        if (atomContainer.getID() != null) {
            mol.setID(atomContainer.getID());
        }
        return mol;
    }

    public static void percieveAtomTypesAndConfigureAtoms(IAtomContainer container2) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container2.getBuilder());
        for (IAtom atom : container2.atoms()) {
            IAtomType matched;
            if (atom instanceof IPseudoAtom || (matched = matcher.findMatchingAtomType(container2, atom)) == null) continue;
            AtomTypeManipulator.configure(atom, matched);
        }
    }

    private static IAtom[] copyAtoms(IAtomContainer container2, IAtomContainer newAtomContainer) {
        int atomCount = container2.getAtomCount();
        IAtom[] atoms = new IAtom[atomCount];
        for (int index = 0; index < container2.getAtomCount(); ++index) {
            atoms[index] = container2.getAtom(index) instanceof IPseudoAtom ? (IAtom)container2.getBuilder().newInstance(IPseudoAtom.class, container2.getAtom(index)) : container2.getBuilder().newInstance(IAtom.class, container2.getAtom(index));
            ExtAtomContainerManipulator.set2D(container2, index, atoms);
            ExtAtomContainerManipulator.set3D(container2, index, atoms);
            ExtAtomContainerManipulator.setFractionalPoint3d(container2, index, atoms);
            ExtAtomContainerManipulator.setID(container2, index, atoms);
            ExtAtomContainerManipulator.setHydrogenCount(container2, index, atoms);
            ExtAtomContainerManipulator.setCharge(container2, index, atoms);
            newAtomContainer.addAtom(atoms[index]);
        }
        for (IStereoElement stereoElement : container2.stereoElements()) {
            newAtomContainer.addStereoElement(stereoElement);
        }
        return atoms;
    }

    private static void copyBonds(IAtom[] atoms, IAtomContainer container2, IAtomContainer newAtomContainer) {
        int bondCount = container2.getBondCount();
        IBond[] bonds = new IBond[bondCount];
        for (int index = 0; index < container2.getBondCount(); ++index) {
            bonds[index] = new Bond();
            int indexI = 999;
            for (int i = 0; i < container2.getAtomCount(); ++i) {
                if (!container2.getBond(index).getBegin().equals(container2.getAtom(i))) continue;
                indexI = i;
                break;
            }
            int indexJ = 999;
            for (int j = 0; j < container2.getAtomCount(); ++j) {
                if (!container2.getBond(index).getEnd().equals(container2.getAtom(j))) continue;
                indexJ = j;
                break;
            }
            IAtom atom1 = atoms[indexI];
            IAtom atom2 = atoms[indexJ];
            IBond.Order order = container2.getBond(index).getOrder();
            IBond.Stereo stereo = container2.getBond(index).getStereo();
            bonds[index] = new Bond(atom1, atom2, order, stereo);
            if (container2.getBond(index).getID() != null) {
                bonds[index].setID(container2.getBond(index).getID());
            }
            newAtomContainer.addBond(bonds[index]);
        }
    }

    private static IAtomContainer reComputeHydrogens(IAtomContainer mol, IAtomContainer atomContainer, List<IAtom> remove, Map<IAtom, IAtom> map) {
        for (IAtom aRemove : remove) {
            for (IAtom iAtom : atomContainer.getConnectedAtomsList(aRemove)) {
                IAtom neighb = map.get(iAtom);
                if (neighb == null) continue;
                if (!(neighb instanceof IPseudoAtom)) {
                    neighb.setImplicitHydrogenCount((neighb.getImplicitHydrogenCount() == null ? 0 : neighb.getImplicitHydrogenCount()) + 1);
                    continue;
                }
                neighb.setImplicitHydrogenCount(0);
            }
        }
        mol.addProperties(atomContainer.getProperties());
        mol.setFlags(atomContainer.getFlags());
        if (atomContainer.getID() != null) {
            mol.setID(atomContainer.getID());
        }
        return mol;
    }

    private static IAtomContainer cloneAndMarkNonHBonds(IAtomContainer mol, IAtomContainer atomContainer, List<IAtom> remove, Map<IAtom, IAtom> map) {
        int count = atomContainer.getBondCount();
        for (int i = 0; i < count; ++i) {
            IBond bond = atomContainer.getBond(i);
            boolean removedBond = false;
            int length = bond.getAtomCount();
            for (int k = 0; k < length; ++k) {
                if (!remove.contains(bond.getAtom(k))) continue;
                removedBond = true;
                break;
            }
            if (removedBond) continue;
            IBond clone = null;
            try {
                clone = atomContainer.getBond(i).clone();
            }
            catch (CloneNotSupportedException e2) {
                LoggingToolFactory.createLoggingTool(ExtAtomContainerManipulator.class).warn("Unexpected Error:", e2);
            }
            assert (clone != null);
            clone.setAtoms(new IAtom[]{map.get(bond.getBegin()), map.get(bond.getEnd())});
            clone.setOrder(atomContainer.getBond(i).getOrder());
            clone.setStereo(atomContainer.getBond(i).getStereo());
            mol.addBond(clone);
        }
        return mol;
    }

    private static void set2D(IAtomContainer container2, int index, IAtom[] atoms) {
        if (container2.getAtom(index).getPoint2d() != null) {
            atoms[index].setPoint2d(new Point2d(container2.getAtom(index).getPoint2d()));
        }
    }

    private static void set3D(IAtomContainer container2, int index, IAtom[] atoms) {
        if (container2.getAtom(index).getPoint3d() != null) {
            atoms[index].setPoint3d(new Point3d(container2.getAtom(index).getPoint3d()));
        }
    }

    private static void setFractionalPoint3d(IAtomContainer container2, int index, IAtom[] atoms) {
        if (container2.getAtom(index).getFractionalPoint3d() != null) {
            atoms[index].setFractionalPoint3d(new Point3d(container2.getAtom(index).getFractionalPoint3d()));
        }
    }

    private static void setID(IAtomContainer container2, int index, IAtom[] atoms) {
        if (container2.getAtom(index).getID() != null) {
            atoms[index].setID(container2.getAtom(index).getID());
        }
    }

    private static void setHydrogenCount(IAtomContainer container2, int index, IAtom[] atoms) {
        if (container2.getAtom(index).getImplicitHydrogenCount() != null) {
            atoms[index].setImplicitHydrogenCount(container2.getAtom(index).getImplicitHydrogenCount());
        }
    }

    private static void setCharge(IAtomContainer container2, int index, IAtom[] atoms) {
        if (container2.getAtom(index).getCharge() != null) {
            atoms[index].setCharge(container2.getAtom(index).getCharge());
        }
    }
}

