/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.stereo.Projection;
import org.openscience.cdk.stereo.Stereocenters;
import org.openscience.cdk.stereo.TetrahedralChirality;

final class CyclicCarbohydrateRecognition {
    public static final double CARDINALITY_THRESHOLD = Math.toRadians(5.0);
    public static final double QUART_CARDINALITY_THRESHOLD = CARDINALITY_THRESHOLD / 4.0;
    private final IAtomContainer container;
    private final int[][] graph;
    private final GraphUtil.EdgeToBondMap bonds;
    private final Stereocenters stereocenters;

    CyclicCarbohydrateRecognition(IAtomContainer container2, int[][] graph, GraphUtil.EdgeToBondMap bonds, Stereocenters stereocenters) {
        this.container = container2;
        this.graph = graph;
        this.bonds = bonds;
        this.stereocenters = stereocenters;
    }

    List<IStereoElement> recognise(Set<Projection> projections) {
        if (!projections.contains((Object)Projection.Haworth) && !projections.contains((Object)Projection.Chair)) {
            return Collections.emptyList();
        }
        ArrayList<IStereoElement> elements = new ArrayList<IStereoElement>();
        RingSearch ringSearch = new RingSearch(this.container, this.graph);
        for (int[] isolated : ringSearch.isolated()) {
            int[] below;
            int[] above;
            int[] cycle;
            Point2d[] points;
            Turn[] turns;
            WoundProjection projection;
            if (isolated.length < 5 || isolated.length > 7 || !projections.contains((Object)(projection = WoundProjection.ofTurns(turns = CyclicCarbohydrateRecognition.turns(points = CyclicCarbohydrateRecognition.coordinatesOfCycle(cycle = Arrays.copyOf(GraphUtil.cycle(this.graph, isolated), isolated.length), this.container)))).projection) || projection.projection == Projection.Haworth && !this.checkHaworthAlignment(points)) continue;
            Point2d horizontalXy = this.horizontalOffset(points, turns, projection.projection);
            if (1.0 - Math.abs(horizontalXy.y) < QUART_CARDINALITY_THRESHOLD || !this.assignSubstituents(cycle, above = (int[])cycle.clone(), below = (int[])cycle.clone(), projection, horizontalXy)) continue;
            elements.addAll(this.newTetrahedralCenters(cycle, above, below, projection));
        }
        return elements;
    }

    static Turn[] turns(Point2d[] points) {
        Turn[] turns = new Turn[points.length];
        for (int i = 1; i <= points.length; ++i) {
            Point2d prevXy = points[i - 1];
            Point2d currXy = points[i % points.length];
            Point2d nextXy = points[(i + 1) % points.length];
            int parity = (int)Math.signum(CyclicCarbohydrateRecognition.det(prevXy.x, prevXy.y, currXy.x, currXy.y, nextXy.x, nextXy.y));
            if (parity == 0) {
                return null;
            }
            turns[i % points.length] = parity < 0 ? Turn.Right : Turn.Left;
        }
        return turns;
    }

    private boolean assignSubstituents(int[] cycle, int[] above, int[] below, WoundProjection projection, Point2d horizontalXy) {
        boolean haworth = projection.projection == Projection.Haworth;
        int found = 0;
        for (int i = 1; i <= cycle.length; ++i) {
            int j = i % cycle.length;
            int curr = cycle[j];
            int prev = cycle[i - 1];
            int next = cycle[(i + 1) % cycle.length];
            int[] ws = CyclicCarbohydrateRecognition.filter(this.graph[curr], prev, next);
            if (ws.length > 2 || ws.length < 1) continue;
            Point2d centerXy = this.container.getAtom(curr).getPoint2d();
            block6: for (int w : ws) {
                Point2d otherXy = this.container.getAtom(w).getPoint2d();
                Direction direction = CyclicCarbohydrateRecognition.direction(centerXy, otherXy, horizontalXy, haworth);
                switch (direction) {
                    case Up: {
                        if (above[j] != curr) {
                            return false;
                        }
                        above[j] = w;
                        continue block6;
                    }
                    case Down: {
                        if (below[j] != curr) {
                            return false;
                        }
                        below[j] = w;
                        continue block6;
                    }
                    case Other: {
                        return false;
                    }
                }
            }
            if (above[j] == curr && below[j] == curr) continue;
            ++found;
        }
        return found > 1 || projection.projection != Projection.Haworth;
    }

    private List<ITetrahedralChirality> newTetrahedralCenters(int[] cycle, int[] above, int[] below, WoundProjection type) {
        ArrayList<ITetrahedralChirality> centers = new ArrayList<ITetrahedralChirality>(cycle.length);
        for (int i = 1; i <= cycle.length; ++i) {
            int prev = cycle[i - 1];
            int curr = cycle[i % cycle.length];
            int next = cycle[(i + 1) % cycle.length];
            int up = above[i % cycle.length];
            int down = below[i % cycle.length];
            if (!this.stereocenters.isStereocenter(curr)) continue;
            if (!CyclicCarbohydrateRecognition.isPlanarSigmaBond(this.bonds.get(curr, prev)) || !CyclicCarbohydrateRecognition.isPlanarSigmaBond(this.bonds.get(curr, next)) || up != curr && !CyclicCarbohydrateRecognition.isPlanarSigmaBond(this.bonds.get(curr, up)) || down != curr && !CyclicCarbohydrateRecognition.isPlanarSigmaBond(this.bonds.get(curr, down))) {
                return Collections.emptyList();
            }
            centers.add(new TetrahedralChirality(this.container.getAtom(curr), new IAtom[]{this.container.getAtom(up), this.container.getAtom(prev), this.container.getAtom(down), this.container.getAtom(next)}, type.winding));
        }
        return centers;
    }

    private static Point2d[] coordinatesOfCycle(int[] cycle, IAtomContainer container2) {
        Point2d[] points = new Point2d[cycle.length];
        for (int i = 0; i < cycle.length; ++i) {
            points[i] = container2.getAtom(cycle[i]).getPoint2d();
        }
        return points;
    }

    private static int[] filter(int[] org, int skip1, int skip2) {
        int n = 0;
        int[] dest = new int[org.length - 2];
        for (int w : org) {
            if (w == skip1 || w == skip2) continue;
            dest[n++] = w;
        }
        return dest;
    }

    private static Direction direction(Point2d centerXy, Point2d substituentXy, Point2d horizontalXy, boolean haworth) {
        double deltaX = substituentXy.x - centerXy.x;
        double deltaY = substituentXy.y - centerXy.y;
        double mag = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        deltaX /= mag;
        deltaY /= mag;
        if (deltaX > 0.0) {
            deltaX -= horizontalXy.x;
            deltaY -= horizontalXy.y;
        } else {
            deltaX += horizontalXy.x;
            deltaY += horizontalXy.y;
        }
        mag = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        deltaX /= mag;
        deltaY /= mag;
        if (haworth && Math.abs(deltaX) > CARDINALITY_THRESHOLD) {
            return Direction.Other;
        }
        return deltaY > 0.0 ? Direction.Up : Direction.Down;
    }

    private boolean checkHaworthAlignment(Point2d[] points) {
        for (int i = 0; i < points.length; ++i) {
            Point2d curr = points[i];
            Point2d next = points[(i + 1) % points.length];
            double deltaY = curr.y - next.y;
            if (!(Math.abs(deltaY) < CARDINALITY_THRESHOLD)) continue;
            return true;
        }
        return false;
    }

    private Point2d horizontalOffset(Point2d[] points, Turn[] turns, Projection projection) {
        if (projection != Projection.Chair) {
            return new Point2d(0.0, 0.0);
        }
        int offset = CyclicCarbohydrateRecognition.chairCenterOffset(turns);
        int prev = (offset + 5) % 6;
        int next = (offset + 7) % 6;
        double deltaX = points[prev].x - points[next].x;
        double deltaY = points[prev].y - points[next].y;
        double mag = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        deltaX /= mag;
        deltaY /= mag;
        if (deltaX < 0.0) {
            deltaX = -deltaX;
            deltaY = -deltaY;
        }
        return new Point2d(1.0 - deltaX, deltaY);
    }

    private static int chairCenterOffset(Turn[] turns) {
        if (turns[1] == turns[2]) {
            return 0;
        }
        if (turns[0] == turns[2]) {
            return 1;
        }
        return 2;
    }

    private static double det(double xa, double ya, double xb, double yb, double xc, double yc) {
        return (xa - xc) * (yb - yc) - (ya - yc) * (xb - xc);
    }

    private static boolean isPlanarSigmaBond(IBond bond) {
        return bond != null && IBond.Order.SINGLE.equals((Object)bond.getOrder()) && IBond.Stereo.NONE.equals((Object)bond.getStereo());
    }

    static enum Turn {
        Left,
        Right;

    }

    private static enum WoundProjection {
        HaworthClockwise(Projection.Haworth, ITetrahedralChirality.Stereo.CLOCKWISE),
        HaworthAnticlockwise(Projection.Haworth, ITetrahedralChirality.Stereo.ANTI_CLOCKWISE),
        ChairClockwise(Projection.Chair, ITetrahedralChirality.Stereo.CLOCKWISE),
        ChairAnticlockwise(Projection.Chair, ITetrahedralChirality.Stereo.ANTI_CLOCKWISE),
        BoatClockwise(null, ITetrahedralChirality.Stereo.CLOCKWISE),
        BoatAnticlockwise(null, ITetrahedralChirality.Stereo.ANTI_CLOCKWISE),
        Other(null, null);

        private final Projection projection;
        private final ITetrahedralChirality.Stereo winding;
        private static final Map<Key, WoundProjection> map;

        private WoundProjection(Projection projection, ITetrahedralChirality.Stereo winding) {
            this.projection = projection;
            this.winding = winding;
        }

        static WoundProjection ofTurns(Turn[] turns) {
            if (turns == null) {
                return Other;
            }
            WoundProjection type = map.get(new Key(turns));
            return type != null ? type : Other;
        }

        static {
            map = new HashMap<Key, WoundProjection>();
            map.put(new Key(new Turn[]{Turn.Left, Turn.Left, Turn.Left, Turn.Left, Turn.Left}), HaworthAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Right, Turn.Right, Turn.Right, Turn.Right}), HaworthClockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Left, Turn.Left, Turn.Left, Turn.Left, Turn.Left}), HaworthAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Right, Turn.Right, Turn.Right, Turn.Right, Turn.Right}), HaworthClockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Left, Turn.Left, Turn.Left, Turn.Left, Turn.Left, Turn.Left}), HaworthAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Right, Turn.Right, Turn.Right, Turn.Right, Turn.Right, Turn.Right}), HaworthClockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Right, Turn.Right, Turn.Left, Turn.Right, Turn.Right}), ChairClockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Left, Turn.Right, Turn.Right, Turn.Left, Turn.Right}), ChairClockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Right, Turn.Left, Turn.Right, Turn.Right, Turn.Left}), ChairClockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Left, Turn.Left, Turn.Right, Turn.Left, Turn.Left}), ChairAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Right, Turn.Left, Turn.Left, Turn.Right, Turn.Left}), ChairAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Left, Turn.Right, Turn.Left, Turn.Left, Turn.Right}), ChairAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Right, Turn.Left, Turn.Left, Turn.Left, Turn.Left}), BoatAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Left, Turn.Left, Turn.Left, Turn.Left, Turn.Right}), BoatAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Left, Turn.Left, Turn.Left, Turn.Right, Turn.Right}), BoatAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Left, Turn.Left, Turn.Right, Turn.Right, Turn.Left}), BoatAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Left, Turn.Right, Turn.Right, Turn.Left, Turn.Left}), BoatAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Right, Turn.Right, Turn.Left, Turn.Left, Turn.Left}), BoatAnticlockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Left, Turn.Right, Turn.Right, Turn.Right, Turn.Right}), BoatClockwise);
            map.put(new Key(new Turn[]{Turn.Left, Turn.Right, Turn.Right, Turn.Right, Turn.Right, Turn.Left}), BoatClockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Right, Turn.Right, Turn.Right, Turn.Left, Turn.Left}), BoatClockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Right, Turn.Right, Turn.Left, Turn.Left, Turn.Right}), BoatClockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Right, Turn.Left, Turn.Left, Turn.Right, Turn.Right}), BoatClockwise);
            map.put(new Key(new Turn[]{Turn.Right, Turn.Left, Turn.Left, Turn.Right, Turn.Right, Turn.Right}), BoatClockwise);
        }

        private static final class Key {
            private final Turn[] turns;

            private Key(Turn ... turns) {
                this.turns = turns;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                return Arrays.equals((Object[])this.turns, (Object[])key.turns);
            }

            public int hashCode() {
                return this.turns != null ? Arrays.hashCode((Object[])this.turns) : 0;
            }
        }
    }

    static enum Direction {
        Up,
        Down,
        Other;

    }
}

