/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.templates;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.AminoAcid;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.dict.DictRef;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAminoAcid;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AminoAcidManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class AminoAcids {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(AminoAcids.class);
    private static AminoAcid[] aminoAcids = null;
    public static final String RESIDUE_NAME = "residueName";
    public static final String RESIDUE_NAME_SHORT = "residueNameShort";
    public static final String NO_ATOMS = "noOfAtoms";
    public static final String NO_BONDS = "noOfBonds";
    public static final String ID = "id";

    public static int[][] aaBondInfo() {
        if (aminoAcids == null) {
            AminoAcids.createAAs();
        }
        int[][] info = new int[153][4];
        int counter = 0;
        int total = 0;
        for (AminoAcid acid : aminoAcids) {
            LOGGER.debug("#bonds for ", acid.getProperty(RESIDUE_NAME).toString(), " = " + acid.getBondCount());
            LOGGER.debug("total #bonds: ", total += acid.getBondCount());
            for (IBond bond : acid.bonds()) {
                info[counter][0] = counter;
                info[counter][1] = acid.indexOf(bond.getBegin());
                info[counter][2] = acid.indexOf(bond.getEnd());
                info[counter][3] = bond.getOrder().numeric();
                ++counter;
            }
        }
        if (counter > 153) {
            LOGGER.error("Error while creating AA info! Bond count is too large: ", counter);
            return null;
        }
        return info;
    }

    public static synchronized AminoAcid[] createAAs() {
        if (aminoAcids != null) {
            return aminoAcids;
        }
        Aromaticity arom = new Aromaticity(ElectronDonation.cdk(), Cycles.all(6));
        aminoAcids = new AminoAcid[20];
        IChemFile list = new ChemFile();
        CMLReader reader = new CMLReader(AminoAcids.class.getClassLoader().getResourceAsStream("org/openscience/cdk/templates/data/list_aminoacids.cml"));
        try {
            list = reader.read(list);
            List<IAtomContainer> containersList = ChemFileManipulator.getAllAtomContainers(list);
            Iterator<IAtomContainer> iterator = containersList.iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                IAtomContainer ac = iterator.next();
                LOGGER.debug("Adding AA: ", ac);
                AminoAcid aminoAcid = new AminoAcid();
                Iterator<IAtom> atoms = ac.atoms().iterator();
                for (Object next : ac.getProperties().keySet()) {
                    LOGGER.debug("Prop class: " + next.getClass().getName());
                    LOGGER.debug("Prop: " + next);
                    if (!(next instanceof DictRef)) continue;
                    DictRef dictRef = (DictRef)next;
                    if (dictRef.getType().equals("pdb:residueName")) {
                        aminoAcid.setProperty(RESIDUE_NAME, ac.getProperty(dictRef).toString().toUpperCase());
                        aminoAcid.setMonomerName(ac.getProperty(dictRef).toString());
                        continue;
                    }
                    if (dictRef.getType().equals("pdb:oneLetterCode")) {
                        aminoAcid.setProperty(RESIDUE_NAME_SHORT, ac.getProperty(dictRef));
                        continue;
                    }
                    if (dictRef.getType().equals("pdb:id")) {
                        aminoAcid.setProperty(ID, ac.getProperty(dictRef));
                        LOGGER.debug("Set AA ID to: " + ac.getProperty(dictRef));
                        continue;
                    }
                    LOGGER.error("Cannot deal with dictRef!");
                }
                while (atoms.hasNext()) {
                    IAtom atom = atoms.next();
                    String dictRef = (String)atom.getProperty("org.openscience.cdk.dict");
                    if (dictRef != null && dictRef.equals("pdb:nTerminus")) {
                        aminoAcid.addNTerminus(atom);
                        continue;
                    }
                    if (dictRef != null && dictRef.equals("pdb:cTerminus")) {
                        aminoAcid.addCTerminus(atom);
                        continue;
                    }
                    aminoAcid.addAtom(atom);
                }
                for (IBond bond : ac.bonds()) {
                    aminoAcid.addBond(bond);
                }
                AminoAcidManipulator.removeAcidicOxygen(aminoAcid);
                aminoAcid.setProperty(NO_ATOMS, "" + aminoAcid.getAtomCount());
                aminoAcid.setProperty(NO_BONDS, "" + aminoAcid.getBondCount());
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(aminoAcid);
                arom.apply(aminoAcid);
                if (counter < aminoAcids.length) {
                    AminoAcids.aminoAcids[counter] = aminoAcid;
                } else {
                    LOGGER.error("Could not store AminoAcid! Array too short!");
                }
                ++counter;
            }
            reader.close();
        }
        catch (IOException | CDKException exception) {
            LOGGER.error("Failed reading file: ", exception.getMessage());
            LOGGER.debug(exception);
        }
        return aminoAcids;
    }

    public static Map<String, IAminoAcid> getHashMapBySingleCharCode() {
        AminoAcid[] monomers = AminoAcids.createAAs();
        HashMap<String, IAminoAcid> map = new HashMap<String, IAminoAcid>();
        for (AminoAcid monomer : monomers) {
            map.put((String)monomer.getProperty(RESIDUE_NAME_SHORT), monomer);
        }
        return map;
    }

    public static Map<String, IAminoAcid> getHashMapByThreeLetterCode() {
        AminoAcid[] monomers = AminoAcids.createAAs();
        HashMap<String, IAminoAcid> map = new HashMap<String, IAminoAcid>();
        for (AminoAcid monomer : monomers) {
            map.put((String)monomer.getProperty(RESIDUE_NAME), monomer);
        }
        return map;
    }

    public static String convertThreeLetterCodeToOneLetterCode(String threeLetterCode) {
        AminoAcid[] monomers;
        for (AminoAcid monomer : monomers = AminoAcids.createAAs()) {
            if (!monomer.getProperty(RESIDUE_NAME).equals(threeLetterCode)) continue;
            return (String)monomer.getProperty(RESIDUE_NAME_SHORT);
        }
        return null;
    }

    public static String convertOneLetterCodeToThreeLetterCode(String oneLetterCode) {
        AminoAcid[] monomers;
        for (AminoAcid monomer : monomers = AminoAcids.createAAs()) {
            if (!monomer.getProperty(RESIDUE_NAME_SHORT).equals(oneLetterCode)) continue;
            return (String)monomer.getProperty(RESIDUE_NAME);
        }
        return null;
    }
}

