/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

public class BondManipulator {
    public static IAtom[] getAtomArray(IBond container2) {
        IAtom[] ret = new IAtom[container2.getAtomCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container2.getAtom(i);
        }
        return ret;
    }

    public static boolean isLowerOrder(IBond.Order first, IBond.Order second) {
        if (first == null || second == null || first == IBond.Order.UNSET || second == IBond.Order.UNSET) {
            return false;
        }
        return first.compareTo(second) < 0;
    }

    public static boolean isHigherOrder(IBond.Order first, IBond.Order second) {
        if (first == null || second == null || first == IBond.Order.UNSET || second == IBond.Order.UNSET) {
            return false;
        }
        return first.compareTo(second) > 0;
    }

    public static IBond.Order increaseBondOrder(IBond.Order oldOrder) {
        switch (oldOrder) {
            case SINGLE: {
                return IBond.Order.DOUBLE;
            }
            case DOUBLE: {
                return IBond.Order.TRIPLE;
            }
            case TRIPLE: {
                return IBond.Order.QUADRUPLE;
            }
            case QUADRUPLE: {
                return IBond.Order.QUINTUPLE;
            }
            case QUINTUPLE: {
                return IBond.Order.SEXTUPLE;
            }
        }
        return oldOrder;
    }

    public static void increaseBondOrder(IBond bond) {
        bond.setOrder(BondManipulator.increaseBondOrder(bond.getOrder()));
    }

    public static IBond.Order decreaseBondOrder(IBond.Order oldOrder) {
        switch (oldOrder) {
            case DOUBLE: {
                return IBond.Order.SINGLE;
            }
            case TRIPLE: {
                return IBond.Order.DOUBLE;
            }
            case QUADRUPLE: {
                return IBond.Order.TRIPLE;
            }
            case QUINTUPLE: {
                return IBond.Order.QUADRUPLE;
            }
            case SEXTUPLE: {
                return IBond.Order.QUINTUPLE;
            }
        }
        return oldOrder;
    }

    public static void decreaseBondOrder(IBond bond) {
        bond.setOrder(BondManipulator.decreaseBondOrder(bond.getOrder()));
    }

    public static IBond.Order createBondOrder(double bondOrder) {
        for (IBond.Order order : IBond.Order.values()) {
            if (order.numeric().doubleValue() != bondOrder) continue;
            return order;
        }
        return null;
    }

    public static double destroyBondOrder(IBond.Order bondOrder) {
        return bondOrder.numeric().doubleValue();
    }

    public static IBond.Order getMaximumBondOrder(List<IBond> bonds) {
        return BondManipulator.getMaximumBondOrder(bonds.iterator());
    }

    public static IBond.Order getMaximumBondOrder(Iterator<IBond> bonds) {
        IBond.Order maxOrder = IBond.Order.SINGLE;
        while (bonds.hasNext()) {
            IBond bond = bonds.next();
            if (!BondManipulator.isHigherOrder(bond.getOrder(), maxOrder)) continue;
            maxOrder = bond.getOrder();
        }
        return maxOrder;
    }

    public static IBond.Order getMaximumBondOrder(IBond firstBond, IBond secondBond) {
        if (firstBond == null || secondBond == null) {
            throw new IllegalArgumentException("null instance of IBond provided");
        }
        return BondManipulator.getMaximumBondOrder(firstBond.getOrder(), secondBond.getOrder());
    }

    public static IBond.Order getMaximumBondOrder(IBond.Order firstOrder, IBond.Order secondOrder) {
        if (firstOrder == IBond.Order.UNSET) {
            if (secondOrder == IBond.Order.UNSET) {
                throw new IllegalArgumentException("Both bond orders are unset");
            }
            return secondOrder;
        }
        if (secondOrder == IBond.Order.UNSET) {
            return firstOrder;
        }
        if (BondManipulator.isHigherOrder(firstOrder, secondOrder)) {
            return firstOrder;
        }
        return secondOrder;
    }

    public static IBond.Order getMinimumBondOrder(List<IBond> bonds) {
        return BondManipulator.getMinimumBondOrder(bonds.iterator());
    }

    public static IBond.Order getMinimumBondOrder(Iterator<IBond> bonds) {
        IBond.Order minOrder = IBond.Order.SEXTUPLE;
        while (bonds.hasNext()) {
            IBond bond = bonds.next();
            if (!BondManipulator.isLowerOrder(bond.getOrder(), minOrder)) continue;
            minOrder = bond.getOrder();
        }
        return minOrder;
    }

    public static int getSingleBondEquivalentSum(List<IBond> bonds) {
        return BondManipulator.getSingleBondEquivalentSum(bonds.iterator());
    }

    public static int getSingleBondEquivalentSum(Iterator<IBond> bonds) {
        int sum = 0;
        while (bonds.hasNext()) {
            IBond.Order order = bonds.next().getOrder();
            if (order == null) continue;
            sum += order.numeric().intValue();
        }
        return sum;
    }
}

