/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.ReactionRole;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;

public class ReactionManipulator {
    public static int getAtomCount(IReaction reaction) {
        int count = 0;
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            count += reactants.getAtomContainer(i).getAtomCount();
        }
        IAtomContainerSet agents = reaction.getAgents();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            count += agents.getAtomContainer(i).getAtomCount();
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            count += products.getAtomContainer(i).getAtomCount();
        }
        return count;
    }

    public static int getBondCount(IReaction reaction) {
        int count = 0;
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            count += reactants.getAtomContainer(i).getBondCount();
        }
        IAtomContainerSet agents = reaction.getAgents();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            count += agents.getAtomContainer(i).getBondCount();
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            count += products.getAtomContainer(i).getBondCount();
        }
        return count;
    }

    public static void removeAtomAndConnectedElectronContainers(IReaction reaction, IAtom atom) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtom(atom);
        }
        IAtomContainerSet agents = reaction.getReactants();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            IAtomContainer mol = agents.getAtomContainer(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtom(atom);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtom(atom);
        }
    }

    public static void removeElectronContainer(IReaction reaction, IElectronContainer electrons) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
        IAtomContainerSet agents = reaction.getReactants();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            IAtomContainer mol = agents.getAtomContainer(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
    }

    public static IAtomContainerSet getAllMolecules(IReaction reaction) {
        IAtomContainerSet moleculeSet = reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        moleculeSet.add(ReactionManipulator.getAllReactants(reaction));
        moleculeSet.add(ReactionManipulator.getAllAgents(reaction));
        moleculeSet.add(ReactionManipulator.getAllProducts(reaction));
        return moleculeSet;
    }

    public static IAtomContainerSet getAllProducts(IReaction reaction) {
        IAtomContainerSet moleculeSet = reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            moleculeSet.addAtomContainer(products.getAtomContainer(i));
        }
        return moleculeSet;
    }

    public static IAtomContainerSet getAllReactants(IReaction reaction) {
        IAtomContainerSet moleculeSet = reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            moleculeSet.addAtomContainer(reactants.getAtomContainer(i));
        }
        return moleculeSet;
    }

    public static IAtomContainerSet getAllAgents(IReaction reaction) {
        IAtomContainerSet moleculeSet = reaction.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet agents = reaction.getAgents();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            moleculeSet.addAtomContainer(agents.getAtomContainer(i));
        }
        return moleculeSet;
    }

    public static IReaction reverse(IReaction reaction) {
        IReaction reversedReaction = reaction.getBuilder().newInstance(IReaction.class, new Object[0]);
        if (reaction.getDirection() == IReaction.Direction.BIDIRECTIONAL) {
            reversedReaction.setDirection(IReaction.Direction.BIDIRECTIONAL);
        } else if (reaction.getDirection() == IReaction.Direction.FORWARD) {
            reversedReaction.setDirection(IReaction.Direction.BACKWARD);
        } else if (reaction.getDirection() == IReaction.Direction.BACKWARD) {
            reversedReaction.setDirection(IReaction.Direction.FORWARD);
        }
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            double coefficient = reaction.getReactantCoefficient(reactants.getAtomContainer(i));
            reversedReaction.addProduct(reactants.getAtomContainer(i), coefficient);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            double coefficient = reaction.getProductCoefficient(products.getAtomContainer(i));
            reversedReaction.addReactant(products.getAtomContainer(i), coefficient);
        }
        return reversedReaction;
    }

    public static List<IAtomContainer> getAllAtomContainers(IReaction reaction) {
        return MoleculeSetManipulator.getAllAtomContainers(ReactionManipulator.getAllMolecules(reaction));
    }

    public static List<String> getAllIDs(IReaction reaction) {
        ArrayList<String> idList = new ArrayList<String>();
        if (reaction.getID() != null) {
            idList.add(reaction.getID());
        }
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IAtomContainer mol = reactants.getAtomContainer(i);
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IAtomContainer mol = products.getAtomContainer(i);
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        return idList;
    }

    public static IAtomContainer getRelevantAtomContainer(IReaction reaction, IAtom atom) {
        IAtomContainer result = MoleculeSetManipulator.getRelevantAtomContainer(reaction.getReactants(), atom);
        if (result != null) {
            return result;
        }
        return MoleculeSetManipulator.getRelevantAtomContainer(reaction.getProducts(), atom);
    }

    public static IAtomContainer getRelevantAtomContainer(IReaction reaction, IBond bond) {
        IAtomContainer result = MoleculeSetManipulator.getRelevantAtomContainer(reaction.getReactants(), bond);
        if (result != null) {
            return result;
        }
        return MoleculeSetManipulator.getRelevantAtomContainer(reaction.getProducts(), bond);
    }

    public static void setAtomProperties(IReaction reaction, Object propKey, Object propVal) {
        IAtomContainerSet reactants = reaction.getReactants();
        for (int j = 0; j < reactants.getAtomContainerCount(); ++j) {
            AtomContainerManipulator.setAtomProperties(reactants.getAtomContainer(j), propKey, propVal);
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int j = 0; j < products.getAtomContainerCount(); ++j) {
            AtomContainerManipulator.setAtomProperties(products.getAtomContainer(j), propKey, propVal);
        }
    }

    public static List<IChemObject> getAllChemObjects(IReaction reaction) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        list.add(reaction);
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            list.add(reactants.getAtomContainer(i));
        }
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            list.add(products.getAtomContainer(i));
        }
        return list;
    }

    public static IChemObject getMappedChemObject(IReaction reaction, IChemObject chemObject) {
        for (IMapping mapping : reaction.mappings()) {
            if (mapping.getChemObject(0).equals(chemObject)) {
                return mapping.getChemObject(1);
            }
            if (!mapping.getChemObject(1).equals(chemObject)) continue;
            return mapping.getChemObject(0);
        }
        return null;
    }

    private static void assignRoleAndGrp(IAtomContainer mol, ReactionRole role, int grpId) {
        for (IAtom atom : mol.atoms()) {
            atom.setProperty("cdk:ReactionRole", (Object)role);
            atom.setProperty("cdk:ReactionGroup", grpId);
        }
    }

    public static IAtomContainer toMolecule(IReaction rxn) {
        if (rxn == null) {
            throw new IllegalArgumentException("Null reaction provided");
        }
        IChemObjectBuilder bldr = rxn.getBuilder();
        IAtomContainer mol = bldr.newInstance(IAtomContainer.class, new Object[0]);
        mol.setProperties(rxn.getProperties());
        mol.setID(rxn.getID());
        int grpId = 0;
        for (IAtomContainer comp : rxn.getReactants().atomContainers()) {
            ReactionManipulator.assignRoleAndGrp(comp, ReactionRole.Reactant, ++grpId);
            mol.add(comp);
        }
        for (IAtomContainer comp : rxn.getAgents().atomContainers()) {
            ReactionManipulator.assignRoleAndGrp(comp, ReactionRole.Agent, ++grpId);
            mol.add(comp);
        }
        for (IAtomContainer comp : rxn.getProducts().atomContainers()) {
            ReactionManipulator.assignRoleAndGrp(comp, ReactionRole.Product, ++grpId);
            mol.add(comp);
        }
        return mol;
    }

    public static IReaction toReaction(IAtomContainer mol) {
        Integer grpIdx;
        if (mol == null) {
            throw new IllegalArgumentException("Null molecule provided");
        }
        IChemObjectBuilder bldr = mol.getBuilder();
        IReaction rxn = bldr.newInstance(IReaction.class, new Object[0]);
        rxn.setProperties(mol.getProperties());
        rxn.setID(mol.getID());
        HashMap<Integer, IAtomContainer> components = new HashMap<Integer, IAtomContainer>();
        for (IAtom iAtom : mol.atoms()) {
            ReactionRole role = (ReactionRole)((Object)iAtom.getProperty("cdk:ReactionRole"));
            Integer grpIdx2 = (Integer)iAtom.getProperty("cdk:ReactionGroup");
            if (role == null || role == ReactionRole.None) {
                throw new IllegalArgumentException("Atom " + mol.indexOf(iAtom) + " had undefined role");
            }
            if (grpIdx2 == null) {
                throw new IllegalArgumentException("Atom " + mol.indexOf(iAtom) + " had no reaction group id");
            }
            IAtomContainer comp = (IAtomContainer)components.get(grpIdx2);
            if (comp == null) {
                comp = bldr.newInstance(IAtomContainer.class, 20, 20, 0, 0);
                components.put(grpIdx2, comp);
                switch (role) {
                    case Reactant: {
                        rxn.addReactant(comp);
                        break;
                    }
                    case Product: {
                        rxn.addProduct(comp);
                        break;
                    }
                    case Agent: {
                        rxn.addAgent(comp);
                    }
                }
            }
            comp.addAtom(iAtom);
        }
        for (IBond iBond : mol.bonds()) {
            IAtom beg = iBond.getBegin();
            IAtom end = iBond.getEnd();
            Integer begIdx = (Integer)beg.getProperty("cdk:ReactionGroup");
            Integer endIdx = (Integer)end.getProperty("cdk:ReactionGroup");
            if (begIdx == null || endIdx == null) {
                throw new IllegalArgumentException("Bond " + mol.indexOf(iBond) + " had atoms with no reaction group id");
            }
            if (!begIdx.equals(endIdx)) {
                throw new IllegalArgumentException("Bond " + mol.indexOf(iBond) + " had atoms with different reaction group id");
            }
            ((IAtomContainer)components.get(begIdx)).addBond(iBond);
        }
        for (IStereoElement iStereoElement : mol.stereoElements()) {
            IAtom focus = null;
            if (iStereoElement instanceof ITetrahedralChirality) {
                focus = ((ITetrahedralChirality)iStereoElement).getChiralAtom();
            } else if (iStereoElement instanceof IDoubleBondStereochemistry) {
                focus = ((IDoubleBondStereochemistry)iStereoElement).getStereoBond().getBegin();
            } else if (iStereoElement instanceof ExtendedTetrahedral) {
                focus = ((ExtendedTetrahedral)iStereoElement).focus();
            }
            if (focus == null) {
                throw new IllegalArgumentException("Stereochemistry had no focus");
            }
            Integer grpIdx2 = (Integer)focus.getProperty("cdk:ReactionGroup");
            ((IAtomContainer)components.get(grpIdx2)).addStereoElement(iStereoElement);
        }
        for (ISingleElectron iSingleElectron : mol.singleElectrons()) {
            grpIdx = (Integer)iSingleElectron.getAtom().getProperty("cdk:ReactionGroup");
            ((IAtomContainer)components.get(grpIdx)).addSingleElectron(iSingleElectron);
        }
        for (ILonePair iLonePair : mol.lonePairs()) {
            grpIdx = (Integer)iLonePair.getAtom().getProperty("cdk:ReactionGroup");
            ((IAtomContainer)components.get(grpIdx)).addLonePair(iLonePair);
        }
        return rxn;
    }

    public static Set<IBond> findMappedBonds(IReaction reaction) {
        Integer endidx;
        Integer begidx;
        HashSet<IBond> mapped = new HashSet<IBond>();
        HashSet<IntTuple> mappedReactantBonds = new HashSet<IntTuple>();
        HashSet<IntTuple> mappedProductBonds = new HashSet<IntTuple>();
        for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
            for (IBond bond : reactant.bonds()) {
                begidx = (Integer)bond.getBegin().getProperty("cdk:AtomAtomMapping");
                endidx = (Integer)bond.getEnd().getProperty("cdk:AtomAtomMapping");
                if (begidx == null || endidx == null) continue;
                mappedReactantBonds.add(new IntTuple(begidx, endidx));
            }
        }
        if (mappedReactantBonds.isEmpty()) {
            return Collections.emptySet();
        }
        for (IAtomContainer product : reaction.getProducts().atomContainers()) {
            for (IBond bond : product.bonds()) {
                begidx = (Integer)bond.getBegin().getProperty("cdk:AtomAtomMapping");
                endidx = (Integer)bond.getEnd().getProperty("cdk:AtomAtomMapping");
                if (begidx == null || endidx == null) continue;
                mappedProductBonds.add(new IntTuple(begidx, endidx));
            }
        }
        if (mappedProductBonds.isEmpty()) {
            return Collections.emptySet();
        }
        for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
            for (IBond bond : reactant.bonds()) {
                begidx = (Integer)bond.getBegin().getProperty("cdk:AtomAtomMapping");
                endidx = (Integer)bond.getEnd().getProperty("cdk:AtomAtomMapping");
                if (begidx == null || endidx == null || !mappedProductBonds.contains(new IntTuple(begidx, endidx))) continue;
                mapped.add(bond);
            }
        }
        for (IAtomContainer product : reaction.getProducts().atomContainers()) {
            for (IBond bond : product.bonds()) {
                begidx = (Integer)bond.getBegin().getProperty("cdk:AtomAtomMapping");
                endidx = (Integer)bond.getEnd().getProperty("cdk:AtomAtomMapping");
                if (begidx == null || endidx == null || !mappedReactantBonds.contains(new IntTuple(begidx, endidx))) continue;
                mapped.add(bond);
            }
        }
        return mapped;
    }

    public static void perceiveAtomTypesAndConfigureAtoms(IReaction reaction) throws CDKException {
        if (reaction == null) {
            return;
        }
        for (IAtomContainer atomContainer : ReactionManipulator.getAllMolecules(reaction).atomContainers()) {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
        }
    }

    public static void perceiveAtomTypesAndConfigureUnsetProperties(IReaction reaction) throws CDKException {
        if (reaction == null) {
            return;
        }
        for (IAtomContainer atomContainer : ReactionManipulator.getAllMolecules(reaction).atomContainers()) {
            AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties(atomContainer);
        }
    }

    public static void clearAtomConfigurations(IReaction reaction) {
        if (reaction == null) {
            return;
        }
        for (IAtomContainer atomContainer : ReactionManipulator.getAllMolecules(reaction).atomContainers()) {
            AtomContainerManipulator.clearAtomConfigurations(atomContainer);
        }
    }

    private static final class IntTuple {
        private final int beg;
        private final int end;

        public IntTuple(int beg, int end) {
            this.beg = beg;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntTuple that = (IntTuple)o;
            return this.beg == that.beg && this.end == that.end || this.beg == that.end && this.end == that.beg;
        }

        public int hashCode() {
            return this.beg ^ this.end;
        }
    }
}

