/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.text.ParseException;
import nu.xom.Attribute;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.euclid.Util;

public class DoubleArraySTAttribute
extends CMLAttribute {
    public static final String JAVA_TYPE = "double[]";
    public static final String JAVA_GET_METHOD = "getDoubleArray";
    public static final String JAVA_SHORT_CLASS = "DoubleArraySTAttribute";
    protected double[] dd = null;
    protected int length = -1;

    public DoubleArraySTAttribute(String name) {
        super(name);
    }

    public DoubleArraySTAttribute(Attribute att) {
        this(att.getLocalName());
        this.setCMLValue(att.getValue());
    }

    public DoubleArraySTAttribute(Attribute att, String value) {
        super(att, value.trim().replace("\\s+", " "));
    }

    public DoubleArraySTAttribute(DoubleArraySTAttribute att) {
        super(att);
        if (att.dd != null) {
            this.dd = new double[att.dd.length];
            for (int i = 0; i < this.dd.length; ++i) {
                this.dd[i] = att.dd[i];
            }
        }
        this.length = att.length;
    }

    @Override
    public Attribute copy() {
        return new DoubleArraySTAttribute(this);
    }

    @Override
    public void setCMLValue(String s) {
        if (s != null && !s.trim().equals("")) {
            double[] dd = DoubleArraySTAttribute.split(s.trim().replace("\\s+", " "), "\\s+");
            this.setCMLValue(dd);
        }
    }

    public void setCMLValue(double[] dd) throws RuntimeException {
        this.checkValue(dd);
        this.dd = new double[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            this.dd[i] = dd[i];
        }
        this.setValue(Util.concatenate(dd, " "));
    }

    public void checkValue(double[] dd) throws RuntimeException {
        if (this.cmlType != null) {
            this.cmlType.checkValue(dd);
        }
    }

    public static double[] split(String s, String delim) {
        String sss = s;
        if (delim == null || delim.trim().equals("") || delim.equals("\\s+")) {
            delim = "\\s+";
            sss = sss.trim();
        }
        String[] ss = sss.split(delim);
        double[] dd = new double[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            try {
                dd[i] = Util.parseFlexibleDouble(ss[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("" + nfe);
            }
            catch (ParseException e2) {
                throw new RuntimeException("Bad double value: " + ss[i] + " at " + i + " in " + sss, e2);
            }
        }
        return dd;
    }

    @Override
    public Object getCMLValue() {
        return this.dd;
    }

    public double[] getDoubleArray() {
        return this.dd;
    }

    @Override
    public String getJavaType() {
        return JAVA_TYPE;
    }

    @Override
    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    @Override
    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

