/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.Text;
import org.xmlcml.cml.attribute.RefAttribute;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.element.AbstractArg;
import org.xmlcml.cml.element.CMLScalar;

public class CMLArg
extends AbstractArg {
    public static final String NS = "cml:arg";
    public static final String START_CHARS = "{$";
    public static final String END_CHARS = "}";

    public CMLArg() {
    }

    public CMLArg(String name, int i) {
        this.setInteger(i);
        this.setName(name);
    }

    public CMLArg(String name, String s) {
        this.setString(s);
        this.setName(name);
    }

    public CMLArg(CMLArg old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLArg(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLArg();
    }

    public static void addArg(CMLElement parent, CMLArg arg, int position) throws RuntimeException {
        Elements args = parent.getChildCMLElements("arg");
        if (parent == null || arg == null || position < 0) {
            throw new RuntimeException("null args or negative position");
        }
        if (position > args.size()) {
            throw new RuntimeException("position > argCount");
        }
        String argName = arg.getName();
        for (int i = 0; i < args.size(); ++i) {
            String name = ((CMLArg)args.get(i)).getName();
            if (name == null || name.trim().equals("")) {
                throw new RuntimeException("missing name in arg: ");
            }
            if (!name.equals(argName)) continue;
            throw new RuntimeException("duplicate arg: " + argName);
        }
        parent.insertChild(arg, position);
    }

    public static void removeArgs(CMLElement element) {
        if (element != null) {
            List<Node> args = CMLUtil.getQueryNodes(element, NS, CMLConstants.CML_XPATH);
            for (Node arg : args) {
                arg.detach();
            }
        }
    }

    public static void substituteNameByValue(CMLElement element) {
        CMLArg.substituteNameByValue(element, new ArrayList<CMLArg>());
    }

    public static void transferArgs(CMLElement fromElem, CMLElement toElem) throws RuntimeException {
        List<CMLArg> fromList = CMLArg.getArgs(fromElem);
        List<CMLArg> toList = CMLArg.getArgs(toElem);
        block0: for (CMLArg fromArg : fromList) {
            String fromName = fromArg.getName();
            if (fromName == null) {
                throw new RuntimeException("missing name in arg");
            }
            for (CMLArg toArg : toList) {
                String toName = toArg.getName();
                if (toName == null) {
                    throw new RuntimeException("missing name in arg");
                }
                if (!fromName.equals(toName)) continue;
                CMLArg copyFromArg = (CMLArg)fromArg.copy();
                int idx = toElem.indexOf(toArg);
                if (idx < 0) {
                    throw new RuntimeException("BUG idx < 0");
                }
                toElem.insertChild(copyFromArg, idx);
                toArg.detach();
                continue block0;
            }
        }
    }

    private static List<CMLArg> getArgs(CMLElement element) {
        ArrayList<CMLArg> argList = new ArrayList<CMLArg>();
        Elements args = element.getChildCMLElements("arg");
        for (int i = 0; i < args.size(); ++i) {
            argList.add((CMLArg)args.get(i));
        }
        return argList;
    }

    public static void substituteNameByValue(CMLElement element, List<CMLArg> oldArgList) {
        Elements args = element.getChildCMLElements("arg");
        ArrayList<CMLArg> newArgList = new ArrayList<CMLArg>();
        for (int i = 0; i < args.size(); ++i) {
            newArgList.add((CMLArg)args.get(i));
        }
        for (CMLArg oldArg : oldArgList) {
            boolean overridden = false;
            for (int i = 0; i < args.size(); ++i) {
                CMLArg arg = (CMLArg)args.get(i);
                if (!oldArg.getName().equals(arg.getName())) continue;
                overridden = true;
                break;
            }
            if (overridden) continue;
            newArgList.add(oldArg);
        }
        for (CMLArg newArg : newArgList) {
            newArg.eval(newArgList);
        }
        for (CMLArg newArg : newArgList) {
            if (newArg.getSubstituteAttribute() == null) continue;
            newArg.substituteAttributes(element);
            if (newArg.getDeleteAttribute() == null) continue;
            newArg.detach();
        }
        Elements elements = element.getChildElements();
        for (int j = 0; j < elements.size(); ++j) {
            CMLElement childCMLElement;
            Element childElement = elements.get(j);
            if (!(childElement instanceof CMLElement) || (childCMLElement = (CMLElement)childElement).getLocalName().equals("arg")) continue;
            CMLArg.substituteNameByValue(childCMLElement, newArgList);
        }
    }

    private void substituteAttributes(Element element) {
        int attCount = element.getAttributeCount();
        ArrayList<Attribute> attList = new ArrayList<Attribute>();
        for (int j = 0; j < attCount; ++j) {
            Attribute att = element.getAttribute(j);
            attList.add(att);
        }
        for (Attribute att : attList) {
            this.substituteNameByValue(att);
        }
    }

    void substituteNameByValue(Attribute att) {
        if (!(att instanceof RefAttribute)) {
            String value;
            String value1 = value = att.getValue();
            String newValue = this.getValue().trim();
            if (!newValue.equals("") && !value.equals(value1 = value1.replaceAll("_" + this.getName() + "_", newValue))) {
                Element parent = (Element)att.getParent();
                parent.removeAttribute(parent.getAttribute(att.getLocalName()));
                att.setValue(value1);
                parent.addAttribute(att);
            }
        }
    }

    @Override
    public String getDataType() {
        CMLScalar scalar;
        String dataType = super.getDataType();
        if (dataType == null && (scalar = this.getScalar()) != null) {
            dataType = scalar.getDataType();
        }
        if (dataType == null) {
            dataType = "xsd:string";
            this.setDataType("xsd:string");
        }
        return dataType;
    }

    public void eval(List<CMLArg> argList) {
        CMLAttribute evalx;
        CMLAttribute eval2 = this.getEvalAttribute();
        if (eval2 != null) {
            for (CMLArg arg : argList) {
                arg.substituteNameByValue(eval2);
            }
            String value = eval2.getValue().trim();
            if (!this.getDataType().equals("xsd:string")) {
                value = value.replace("+", " + ");
                String[] tokens = (value = value.replace("-", " - ")).trim().split("\\s+");
                if (tokens.length % 2 != 1) {
                    throw new RuntimeException("bad eval for numeric data: " + value);
                }
                if (this.getDataType().equals("xsd:double")) {
                    try {
                        double dd = new Double(tokens[0]);
                        String op = "";
                        for (int i = 1; i < tokens.length; i += 2) {
                            op = tokens[i];
                            double d = new Double(tokens[i + 1]);
                            if (op.equals("+")) {
                                dd += d;
                                continue;
                            }
                            if (op.equals("-")) {
                                dd -= d;
                                continue;
                            }
                            throw new RuntimeException("Bad operator: (" + op + ") in eval: " + value);
                        }
                        this.setDouble(dd);
                    }
                    catch (NumberFormatException e2) {
                        throw new RuntimeException("Bad numeric double eval: " + value);
                    }
                }
                if (this.getDataType().equals("xsd:integer")) {
                    try {
                        int jj = Integer.parseInt(tokens[0]);
                        String op = "";
                        for (int i = 1; i < tokens.length; i += 2) {
                            op = tokens[i];
                            int j = Integer.parseInt(tokens[i + 1]);
                            if (op.equals("+")) {
                                jj += j;
                                continue;
                            }
                            if (op.equals("-")) {
                                jj -= j;
                                continue;
                            }
                            throw new RuntimeException("Bad operator: (" + op + ") in eval: " + value);
                        }
                        this.setInteger(jj);
                    }
                    catch (NumberFormatException e3) {
                        throw new RuntimeException("Bad numeric integer eval: " + value);
                    }
                }
            }
        }
        if ((evalx = this.getEvalAttribute()) != null) {
            evalx.detach();
        }
    }

    public int getInteger() throws RuntimeException {
        CMLScalar scalar = this.getScalar();
        if (scalar == null) {
            throw new RuntimeException("no child scalar");
        }
        return scalar.getInt();
    }

    public void setInteger(int i) throws RuntimeException {
        CMLScalar scalar = (CMLScalar)this.getChildCMLElement("scalar", 0);
        if (scalar == null) {
            scalar = new CMLScalar(i);
            this.appendChild(scalar);
        } else {
            scalar.setValue(i);
        }
    }

    public String getString() throws RuntimeException {
        String string = null;
        CMLScalar scalar = this.getScalar();
        string = scalar != null ? scalar.getXMLContent() : this.getValue();
        return string;
    }

    public void setString(String s) throws RuntimeException {
        CMLScalar scalar = (CMLScalar)this.getChildCMLElement("scalar", 0);
        if (scalar == null) {
            scalar = new CMLScalar(s);
            this.appendChild(scalar);
        } else {
            scalar.setXMLContent(s);
        }
    }

    public double getDouble() throws RuntimeException {
        CMLScalar scalar = this.getScalar();
        if (scalar == null) {
            throw new RuntimeException("no child scalar");
        }
        return scalar.getDouble();
    }

    public void setDouble(double d) throws RuntimeException {
        CMLScalar scalar = (CMLScalar)this.getChildCMLElement("scalar", 0);
        if (scalar == null) {
            scalar = new CMLScalar(d);
        } else {
            scalar.setValue(d);
        }
        this.appendChild(scalar);
    }

    public CMLScalar getScalar() {
        Elements scalars = this.getChildCMLElements("scalar");
        return scalars == null || scalars.size() == 0 ? null : (CMLScalar)scalars.get(0);
    }

    public static void processArgs(CMLElement element) {
        Nodes parameterNameArgs = element.query("cml:arg[@parameterName]", CMLConstants.CML_XPATH);
        for (int i = 0; i < parameterNameArgs.size(); ++i) {
            CMLArg cMLArg = (CMLArg)parameterNameArgs.get(i);
        }
    }

    public static void substituteParameterName(CMLElement element, String name, String value) {
        String id = element.getAttributeValue("id");
        CMLArg parameterArg = null;
        Nodes nameArgs = element.query("cml:arg[@parameterName='" + name + "']", CMLConstants.CML_XPATH);
        if (nameArgs.size() == 0) {
            element.debug("ARG NOT FOUND");
            throw new RuntimeException("arg not found: " + name + "/" + id);
        }
        if (nameArgs.size() > 1) {
            throw new RuntimeException("duplicate args: " + name + "/" + id);
        }
        parameterArg = (CMLArg)nameArgs.get(0);
        String orig = START_CHARS + name + END_CHARS;
        Nodes nodes = element.query(".//@* | .//text()");
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            String val = node.getValue();
            if (val.indexOf(orig) == -1) continue;
            val = val.replace(orig, value);
            if (node instanceof Attribute) {
                ((Attribute)node).setValue(val);
                continue;
            }
            if (node instanceof Text) {
                ((Text)node).setValue(val);
                continue;
            }
            throw new RuntimeException("BUG " + node.getClass());
        }
        parameterArg.detach();
    }

    public static void substituteParentAttributes(CMLElement element) {
        Nodes parentAttributeArgs = element.query(".//cml:arg[@parentAttribute]", CMLConstants.CML_XPATH);
        for (int i = 0; i < parentAttributeArgs.size(); ++i) {
            CMLArg parentAttributeArg = (CMLArg)parentAttributeArgs.get(i);
            String parentAttribute = parentAttributeArg.getParentAttribute();
            String attValue = parentAttributeArg.getString();
            Element parent = (Element)parentAttributeArg.getParent();
            ((CMLElement)parent).setAttribute(parentAttribute, attValue);
            parentAttributeArg.detach();
        }
    }

    public static void substituteTextContent(CMLElement element) {
        Nodes textContentArgs = element.query(".//cml:arg[@substitute[.='.']]", CMLConstants.CML_XPATH);
        for (int i = 0; i < textContentArgs.size(); ++i) {
            CMLArg textContentArg = (CMLArg)textContentArgs.get(i);
            String value = textContentArg.getValue();
            if (!value.startsWith(START_CHARS) || !value.endsWith(END_CHARS)) {
                Element parent = (Element)textContentArg.getParent();
                parent.appendChild(new Text(value));
            }
            textContentArg.detach();
        }
    }

    public void processArg(CMLElement element) {
        if (this.getParentAttribute() != null) {
            String parentAttribute = this.getParentAttribute();
            String value = this.getString();
            Element parent = (Element)this.getParent();
            parent.addAttribute(new Attribute(parentAttribute, value));
            this.detach();
        }
    }

    public static void addIdxArgsWithSerialNumber(CMLElement current, String localName) {
        Nodes nodes = current.query(".//cml:" + localName + "[@ref]", CMLConstants.CML_XPATH);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < nodes.size(); ++i) {
            CMLElement element = (CMLElement)nodes.get(i);
            String serial = "" + (i + 1);
            String id = element.getAttributeValue("id");
            if (id == null) {
                id = "" + serial;
            } else if (idSet.contains(id = id + "_" + serial)) {
                throw new RuntimeException("Non-unique element id: " + id);
            }
            element.addAttribute(new Attribute("id", id));
            idSet.add(id);
            CMLArg arg = new CMLArg("idx", serial);
            element.appendChild(arg);
        }
    }
}

