/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Element;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLBuilder;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.element.AbstractDictionary;
import org.xmlcml.cml.element.CMLEntry;

public class CMLDictionary
extends AbstractDictionary {
    private static final Logger LOG = Logger.getLogger(CMLDictionary.class);
    public static final String NS = "cml:dictionary";
    protected Map<String, CMLEntry> entryMap = null;

    public CMLDictionary() {
    }

    public CMLDictionary(CMLDictionary old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLDictionary(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLDictionary();
    }

    public int indexEntries() {
        if (this.entryMap == null) {
            this.entryMap = new HashMap<String, CMLEntry>();
            CMLElements<CMLEntry> entryNodes = this.getEntryElements();
            for (CMLEntry entry : entryNodes) {
                String id = entry.getId();
                if (id == null) continue;
                this.entryMap.put(id, entry);
            }
            LOG.trace("Created dictionary with entries: " + entryNodes.size());
        }
        return this.entryMap.size();
    }

    public CMLDictionary createDictionary(File file) throws IOException {
        return CMLDictionary.createDictionary(file.toURI().toURL());
    }

    public static CMLDictionary createDictionary0(File file) throws IOException {
        return CMLDictionary.createDictionary(file.toURI().toURL());
    }

    public static CMLDictionary createDictionary(URL url) throws IOException {
        InputStream in = null;
        CMLDictionary dictionary = null;
        try {
            in = url.openStream();
            dictionary = CMLDictionary.createDictionary(in);
        }
        catch (Exception e2) {
            throw new RuntimeException("Cannot create dictionary", e2);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        return dictionary;
    }

    public static CMLDictionary createDictionary(InputStream is) throws IOException {
        CMLDictionary cmlDictionary = null;
        try {
            Element element = new CMLBuilder().build(is).getRootElement();
            cmlDictionary = (CMLDictionary)CMLUtil.getSingleElement(element, ".//self::cml:dictionary", CML_XPATH);
            cmlDictionary.indexEntries();
        }
        catch (Exception e2) {
            throw new RuntimeException("Cannot create dictionary", e2);
        }
        return cmlDictionary;
    }

    public CMLEntry getGenericEntry(String id) {
        return this.getCMLEntry(id);
    }

    public CMLEntry getCMLEntry(String id) {
        int nentries = this.indexEntries();
        return this.entryMap.get(id);
    }

    public void addEntry(CMLEntry entry) {
        String id = entry.getId();
        if (id == null) {
            throw new RuntimeException("Entry has no id");
        }
        if (this.getCMLEntry(id) != null) {
            throw new RuntimeException("Entry for " + id + " already present");
        }
        this.entryMap.put(id, entry);
        this.appendChild(entry);
    }

    public void addEntryInOrder(CMLEntry entry) {
        String id = entry.getId();
        if (id == null) {
            throw new RuntimeException("Entry has no id");
        }
        if (this.getCMLEntry(id) == null) {
            this.entryMap.put(id, entry);
            CMLElements<CMLEntry> entries = this.getEntryElements();
            int idx = entries.size();
            for (CMLEntry entry0 : entries) {
                if (id.compareTo(entry0.getId()) >= 0) continue;
                idx = this.indexOf(entry0);
                break;
            }
            this.insertChild(entry, idx);
        }
    }

    public void removeEntry(CMLEntry entry) {
        String id = entry.getId();
        this.removeEntryById(id);
    }

    public void removeEntryById(String id) {
        CMLEntry entry1;
        if (id != null && (entry1 = this.getCMLEntry(id)) != null) {
            this.entryMap.remove(id);
            entry1.detach();
        }
    }
}

