/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.Comparator;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.Real2Range;
import org.xmlcml.euclid.RealRange;
import org.xmlcml.euclid.RealRangeComparator;

public class Real2RangeComparator
implements Comparator<Real2Range> {
    private static final Logger LOG = Logger.getLogger(Real2RangeComparator.class);
    private RealRangeComparator comparatorx;
    private RealRangeComparator comparatory;

    public Real2RangeComparator(RealRangeComparator comparator) {
        this.setComparators(comparator, comparator);
    }

    public Real2RangeComparator(RealRangeComparator comparatorx, RealRangeComparator comparatory) {
        this.setComparators(comparatorx, comparatory);
    }

    public Real2RangeComparator(double d) {
        this(new RealRangeComparator(d));
    }

    @Override
    public int compare(Real2Range r0, Real2Range r1) {
        Real2Range limit = new Real2Range(new RealRange(0.0, 240.0), new RealRange(0.0, 60.0));
        String s1 = "(56.689,231.236),(31.643,49.536)";
        if (r0.toString().contains(s1) || r1.toString().contains(s1)) {
            LOG.trace(r0 + " / " + r1);
        }
        if (r0 == null || r1 == null) {
            return -1;
        }
        RealRange r0x = r0.getXRange();
        RealRange r0y = r0.getYRange();
        RealRange r1x = r1.getXRange();
        RealRange r1y = r1.getYRange();
        if (r0x == null || r1x == null || r0y == null || r1y == null) {
            return -1;
        }
        int comparex = this.comparatorx.compare(r0x, r1x);
        int comparey = this.comparatory.compare(r0y, r1y);
        if (limit.includes(r0) && limit.includes(r1)) {
            LOG.trace(r0 + " / " + r1 + " / " + comparex + "/" + comparey);
        }
        return comparex == comparey ? comparex : -1;
    }

    public void setComparators(RealRangeComparator comparatorx, RealRangeComparator comparatory) {
        this.comparatorx = comparatorx;
        this.comparatory = comparatory;
    }
}

