/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.BiconnectedComponents;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.ElectronDonation;
import uk.ac.ebi.beam.Graph;

final class AllCycles {
    private final int[] ps;
    private final List<PathEdge>[] pathGraph;
    boolean[] aromatic;
    private final Graph org;
    private static final int MAX_VERTEX_DEGREE = 684;
    private static final BitSet EMPTY_SET = new BitSet(0);

    AllCycles(Graph g, ElectronDonation model, int lim) {
        int u;
        this.org = g;
        this.ps = new int[g.order()];
        this.pathGraph = new List[g.order()];
        this.aromatic = new boolean[g.order()];
        ElectronDonation.Cycle cycle = new ElectronDonation.Cycle(){

            @Override
            public boolean contains(int u) {
                throw new UnsupportedOperationException();
            }
        };
        BitSet cyclic = new BiconnectedComponents(g).cyclic();
        for (u = 0; u < g.order(); ++u) {
            this.ps[u] = model.contribution(u, g, cycle, cyclic);
        }
        for (u = 0; u < g.order(); ++u) {
            this.pathGraph[u] = new ArrayList<PathEdge>();
        }
        for (Edge e2 : g.edges()) {
            int u2 = e2.either();
            int v = e2.other(u2);
            if (!cyclic.get(u2) || !cyclic.get(v) || this.ps[u2] < 0 || this.ps[v] < 0) continue;
            PathEdge f = new PathEdge(u2, v, EMPTY_SET, 0);
            this.add(u2, v, f);
        }
        for (int u3 = 0; u3 < g.order(); ++u3) {
            if (this.pathGraph[u3].size() > 684) {
                throw new IllegalArgumentException("too many cycles generated: " + this.pathGraph[u3].size());
            }
            this.reduce(u3, lim);
        }
    }

    public Graph aromaticForm() {
        Graph cpy = new Graph(this.org.order());
        cpy.addFlags(this.org.getFlags(-1));
        for (int i = 0; i < this.org.order(); ++i) {
            if (this.aromatic[i]) {
                cpy.addAtom(this.org.atom(i).toAromatic());
                cpy.addFlags(1);
            } else {
                cpy.addAtom(this.org.atom(i));
            }
            cpy.addTopology(this.org.topologyOf(i));
        }
        for (Edge e2 : this.org.edges()) {
            int u = e2.either();
            int v = e2.other(u);
            if (this.aromatic[u] && this.aromatic[v]) {
                cpy.addEdge(new Edge(u, v, Bond.IMPLICIT));
                continue;
            }
            cpy.addEdge(e2);
        }
        for (int i = 0; i < this.org.order(); ++i) {
            int hCount = this.org.implHCount(i);
            if (hCount == cpy.implHCount(i)) continue;
            cpy.setAtom(i, new AtomImpl.BracketAtom(-1, cpy.atom(i).element(), hCount, 0, 0, true));
        }
        return cpy.sort(new Graph.CanOrderFirst());
    }

    private void add(PathEdge e2) {
        int u = e2.either();
        int v = e2.other(u);
        this.add(u, v, e2);
    }

    private void add(int u, int v, PathEdge e2) {
        this.pathGraph[Math.min(u, v)].add(e2);
    }

    private void reduce(int x, int lim) {
        List<PathEdge> es = this.pathGraph[x];
        int deg = es.size();
        for (int i = 0; i < deg; ++i) {
            PathEdge e1 = es.get(i);
            for (int j = i + 1; j < deg; ++j) {
                PathEdge e2 = es.get(j);
                if (e1.intersects(e2)) continue;
                PathEdge reduced = this.reduce(e1, e2, x);
                if (reduced.xs.cardinality() >= lim) continue;
                if (reduced.loop()) {
                    if (!reduced.checkPiElectrons(this.ps)) continue;
                    reduced.flag(this.aromatic);
                    continue;
                }
                this.add(reduced);
            }
        }
        this.pathGraph[x].clear();
    }

    static BitSet union(BitSet s, BitSet t, int x) {
        BitSet u = (BitSet)s.clone();
        u.or(t);
        u.set(x);
        return u;
    }

    private PathEdge reduce(PathEdge e2, PathEdge f, int x) {
        return new PathEdge(e2.other(x), f.other(x), AllCycles.union(e2.xs, f.xs, x), this.ps[x] + e2.ps + f.ps);
    }

    static AllCycles daylightModel(Graph g) {
        return new AllCycles(g, ElectronDonation.daylight(), g.order());
    }

    static AllCycles daylightModel(Graph g, int lim) {
        return new AllCycles(g, ElectronDonation.daylight(), lim);
    }

    private static final class PathEdge {
        BitSet xs;
        int u;
        int v;
        int ps;

        protected PathEdge(int u, int v, BitSet xs, int ps) {
            this.xs = xs;
            this.ps = ps;
            this.u = u;
            this.v = v;
        }

        final int either() {
            return this.u;
        }

        final int other(int x) {
            return x == this.u ? this.v : this.u;
        }

        final boolean loop() {
            return this.u == this.v;
        }

        final boolean checkPiElectrons(int[] ps) {
            return (this.ps + ps[this.u] - 2) % 4 == 0;
        }

        final void flag(boolean[] mark) {
            mark[this.u] = true;
            int i = this.xs.nextSetBit(0);
            while (i >= 0) {
                mark[i] = true;
                i = this.xs.nextSetBit(i + 1);
            }
        }

        final boolean intersects(PathEdge e2) {
            return e2.xs.intersects(this.xs);
        }
    }
}

