/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class BondBasedConfiguration {
    BondBasedConfiguration() {
    }

    static Configuration.DoubleBond configurationOf(Graph g, int x, int u, int v, int y) {
        Edge e2 = g.edge(u, v);
        if (e2.bond() != Bond.DOUBLE) {
            throw new IllegalArgumentException("atoms u,v are not labelled as a double bond");
        }
        Edge e1 = g.edge(u, x);
        Edge e22 = g.edge(v, y);
        Bond b1 = e1.bond(u);
        Bond b2 = e22.bond(v);
        if (b1 == Bond.IMPLICIT || b1 == Bond.SINGLE) {
            return Configuration.DoubleBond.UNSPECIFIED;
        }
        if (b2 == Bond.IMPLICIT || b2 == Bond.SINGLE) {
            return Configuration.DoubleBond.UNSPECIFIED;
        }
        return b1 == b2 ? Configuration.DoubleBond.TOGETHER : Configuration.DoubleBond.OPPOSITE;
    }
}

