# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCertificateAuthenticationProfileResult',
    'AwaitableGetCertificateAuthenticationProfileResult',
    'get_certificate_authentication_profile',
    'get_certificate_authentication_profile_output',
]

@pulumi.output_type
class GetCertificateAuthenticationProfileResult:
    """
    A collection of values returned by getCertificateAuthenticationProfile.
    """
    def __init__(__self__, allowed_as_user_name=None, certificate_attribute_name=None, description=None, external_identity_store_name=None, id=None, match_mode=None, name=None, username_from=None):
        if allowed_as_user_name and not isinstance(allowed_as_user_name, bool):
            raise TypeError("Expected argument 'allowed_as_user_name' to be a bool")
        pulumi.set(__self__, "allowed_as_user_name", allowed_as_user_name)
        if certificate_attribute_name and not isinstance(certificate_attribute_name, str):
            raise TypeError("Expected argument 'certificate_attribute_name' to be a str")
        pulumi.set(__self__, "certificate_attribute_name", certificate_attribute_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if external_identity_store_name and not isinstance(external_identity_store_name, str):
            raise TypeError("Expected argument 'external_identity_store_name' to be a str")
        pulumi.set(__self__, "external_identity_store_name", external_identity_store_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if match_mode and not isinstance(match_mode, str):
            raise TypeError("Expected argument 'match_mode' to be a str")
        pulumi.set(__self__, "match_mode", match_mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if username_from and not isinstance(username_from, str):
            raise TypeError("Expected argument 'username_from' to be a str")
        pulumi.set(__self__, "username_from", username_from)

    @property
    @pulumi.getter(name="allowedAsUserName")
    def allowed_as_user_name(self) -> bool:
        """
        Allow as username
        """
        return pulumi.get(self, "allowed_as_user_name")

    @property
    @pulumi.getter(name="certificateAttributeName")
    def certificate_attribute_name(self) -> str:
        """
        Attribute name of the Certificate Profile - used only when CERTIFICATE is chosen in `username_from`.
        """
        return pulumi.get(self, "certificate_attribute_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalIdentityStoreName")
    def external_identity_store_name(self) -> str:
        """
        Referred IDStore name for the Certificate Profile or `[not applicable]` in case no identity store is chosen
        """
        return pulumi.get(self, "external_identity_store_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the object
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="matchMode")
    def match_mode(self) -> str:
        """
        Match mode of the Certificate Profile. Allowed values: NEVER, RESOLVE*IDENTITY*AMBIGUITY, BINARY_COMPARISON
        """
        return pulumi.get(self, "match_mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the certificate profile
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="usernameFrom")
    def username_from(self) -> str:
        """
        The attribute in the certificate where the user name should be taken from. Allowed values: `CERTIFICATE` (for a specific attribute as defined in certificateAttributeName), `UPN` (for using any Subject or Alternative Name Attributes in the Certificate - an option only in AD)
        """
        return pulumi.get(self, "username_from")


class AwaitableGetCertificateAuthenticationProfileResult(GetCertificateAuthenticationProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateAuthenticationProfileResult(
            allowed_as_user_name=self.allowed_as_user_name,
            certificate_attribute_name=self.certificate_attribute_name,
            description=self.description,
            external_identity_store_name=self.external_identity_store_name,
            id=self.id,
            match_mode=self.match_mode,
            name=self.name,
            username_from=self.username_from)


def get_certificate_authentication_profile(id: Optional[str] = None,
                                           name: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateAuthenticationProfileResult:
    """
    This data source can read the Certificate Authentication Profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.identitymanagement.get_certificate_authentication_profile(id="76d24097-41c4-4558-a4d0-a8c07ac08470")
    ```


    :param str id: The id of the object
    :param str name: The name of the certificate profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ise:identitymanagement/getCertificateAuthenticationProfile:getCertificateAuthenticationProfile', __args__, opts=opts, typ=GetCertificateAuthenticationProfileResult).value

    return AwaitableGetCertificateAuthenticationProfileResult(
        allowed_as_user_name=pulumi.get(__ret__, 'allowed_as_user_name'),
        certificate_attribute_name=pulumi.get(__ret__, 'certificate_attribute_name'),
        description=pulumi.get(__ret__, 'description'),
        external_identity_store_name=pulumi.get(__ret__, 'external_identity_store_name'),
        id=pulumi.get(__ret__, 'id'),
        match_mode=pulumi.get(__ret__, 'match_mode'),
        name=pulumi.get(__ret__, 'name'),
        username_from=pulumi.get(__ret__, 'username_from'))
def get_certificate_authentication_profile_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateAuthenticationProfileResult]:
    """
    This data source can read the Certificate Authentication Profile.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.identitymanagement.get_certificate_authentication_profile(id="76d24097-41c4-4558-a4d0-a8c07ac08470")
    ```


    :param str id: The id of the object
    :param str name: The name of the certificate profile
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ise:identitymanagement/getCertificateAuthenticationProfile:getCertificateAuthenticationProfile', __args__, opts=opts, typ=GetCertificateAuthenticationProfileResult)
    return __ret__.apply(lambda __response__: GetCertificateAuthenticationProfileResult(
        allowed_as_user_name=pulumi.get(__response__, 'allowed_as_user_name'),
        certificate_attribute_name=pulumi.get(__response__, 'certificate_attribute_name'),
        description=pulumi.get(__response__, 'description'),
        external_identity_store_name=pulumi.get(__response__, 'external_identity_store_name'),
        id=pulumi.get(__response__, 'id'),
        match_mode=pulumi.get(__response__, 'match_mode'),
        name=pulumi.get(__response__, 'name'),
        username_from=pulumi.get(__response__, 'username_from')))
