# coding: utf-8

"""
    SignRequest API

    API for SignRequest.com

    OpenAPI spec version: v1
    Contact: tech-support@signrequest.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from signrequest_client.models.required_attachment import RequiredAttachment  # noqa: F401,E501
from signrequest_client.models.signer import Signer  # noqa: F401,E501


class InlineSignRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'from_email': 'str',
        'from_email_name': 'str',
        'is_being_prepared': 'bool',
        'prepare_url': 'str',
        'redirect_url': 'str',
        'redirect_url_declined': 'str',
        'required_attachments': 'list[RequiredAttachment]',
        'disable_attachments': 'bool',
        'disable_text_signatures': 'bool',
        'disable_text': 'bool',
        'disable_date': 'bool',
        'disable_emails': 'bool',
        'disable_upload_signatures': 'bool',
        'disable_blockchain_proof': 'bool',
        'text_message_verification_locked': 'bool',
        'subject': 'str',
        'message': 'str',
        'who': 'str',
        'send_reminders': 'bool',
        'signers': 'list[Signer]',
        'uuid': 'str'
    }

    attribute_map = {
        'from_email': 'from_email',
        'from_email_name': 'from_email_name',
        'is_being_prepared': 'is_being_prepared',
        'prepare_url': 'prepare_url',
        'redirect_url': 'redirect_url',
        'redirect_url_declined': 'redirect_url_declined',
        'required_attachments': 'required_attachments',
        'disable_attachments': 'disable_attachments',
        'disable_text_signatures': 'disable_text_signatures',
        'disable_text': 'disable_text',
        'disable_date': 'disable_date',
        'disable_emails': 'disable_emails',
        'disable_upload_signatures': 'disable_upload_signatures',
        'disable_blockchain_proof': 'disable_blockchain_proof',
        'text_message_verification_locked': 'text_message_verification_locked',
        'subject': 'subject',
        'message': 'message',
        'who': 'who',
        'send_reminders': 'send_reminders',
        'signers': 'signers',
        'uuid': 'uuid'
    }

    def __init__(self, from_email=None, from_email_name=None, is_being_prepared=None, prepare_url=None, redirect_url=None, redirect_url_declined=None, required_attachments=None, disable_attachments=None, disable_text_signatures=None, disable_text=None, disable_date=None, disable_emails=None, disable_upload_signatures=None, disable_blockchain_proof=None, text_message_verification_locked=None, subject=None, message=None, who=None, send_reminders=None, signers=None, uuid=None):  # noqa: E501
        """InlineSignRequest - a model defined in Swagger"""  # noqa: E501

        self._from_email = None
        self._from_email_name = None
        self._is_being_prepared = None
        self._prepare_url = None
        self._redirect_url = None
        self._redirect_url_declined = None
        self._required_attachments = None
        self._disable_attachments = None
        self._disable_text_signatures = None
        self._disable_text = None
        self._disable_date = None
        self._disable_emails = None
        self._disable_upload_signatures = None
        self._disable_blockchain_proof = None
        self._text_message_verification_locked = None
        self._subject = None
        self._message = None
        self._who = None
        self._send_reminders = None
        self._signers = None
        self._uuid = None
        self.discriminator = None

        if from_email is not None:
            self.from_email = from_email
        if from_email_name is not None:
            self.from_email_name = from_email_name
        if is_being_prepared is not None:
            self.is_being_prepared = is_being_prepared
        if prepare_url is not None:
            self.prepare_url = prepare_url
        if redirect_url is not None:
            self.redirect_url = redirect_url
        if redirect_url_declined is not None:
            self.redirect_url_declined = redirect_url_declined
        if required_attachments is not None:
            self.required_attachments = required_attachments
        if disable_attachments is not None:
            self.disable_attachments = disable_attachments
        if disable_text_signatures is not None:
            self.disable_text_signatures = disable_text_signatures
        if disable_text is not None:
            self.disable_text = disable_text
        if disable_date is not None:
            self.disable_date = disable_date
        if disable_emails is not None:
            self.disable_emails = disable_emails
        if disable_upload_signatures is not None:
            self.disable_upload_signatures = disable_upload_signatures
        if disable_blockchain_proof is not None:
            self.disable_blockchain_proof = disable_blockchain_proof
        if text_message_verification_locked is not None:
            self.text_message_verification_locked = text_message_verification_locked
        if subject is not None:
            self.subject = subject
        if message is not None:
            self.message = message
        if who is not None:
            self.who = who
        if send_reminders is not None:
            self.send_reminders = send_reminders
        if signers is not None:
            self.signers = signers
        if uuid is not None:
            self.uuid = uuid

    @property
    def from_email(self):
        """Gets the from_email of this InlineSignRequest.  # noqa: E501

        Email of user sending the SignRequest (must be a validated email)  # noqa: E501

        :return: The from_email of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._from_email

    @from_email.setter
    def from_email(self, from_email):
        """Sets the from_email of this InlineSignRequest.

        Email of user sending the SignRequest (must be a validated email)  # noqa: E501

        :param from_email: The from_email of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        if from_email is not None and len(from_email) < 1:
            raise ValueError("Invalid value for `from_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._from_email = from_email

    @property
    def from_email_name(self):
        """Gets the from_email_name of this InlineSignRequest.  # noqa: E501

        Name to be used in the `From` email header, e.g. `{from_email_name} <no-reply@signrequest.com>`  # noqa: E501

        :return: The from_email_name of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._from_email_name

    @from_email_name.setter
    def from_email_name(self, from_email_name):
        """Sets the from_email_name of this InlineSignRequest.

        Name to be used in the `From` email header, e.g. `{from_email_name} <no-reply@signrequest.com>`  # noqa: E501

        :param from_email_name: The from_email_name of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        if from_email_name is not None and len(from_email_name) < 1:
            raise ValueError("Invalid value for `from_email_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._from_email_name = from_email_name

    @property
    def is_being_prepared(self):
        """Gets the is_being_prepared of this InlineSignRequest.  # noqa: E501

        Have the sender of a SignRequest prepare the document before sending the request out, see: [prepare using the web interface](#section/Preparing-a-document/Prepare-using-the-web-interface)  # noqa: E501

        :return: The is_being_prepared of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_being_prepared

    @is_being_prepared.setter
    def is_being_prepared(self, is_being_prepared):
        """Sets the is_being_prepared of this InlineSignRequest.

        Have the sender of a SignRequest prepare the document before sending the request out, see: [prepare using the web interface](#section/Preparing-a-document/Prepare-using-the-web-interface)  # noqa: E501

        :param is_being_prepared: The is_being_prepared of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._is_being_prepared = is_being_prepared

    @property
    def prepare_url(self):
        """Gets the prepare_url of this InlineSignRequest.  # noqa: E501


        :return: The prepare_url of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._prepare_url

    @prepare_url.setter
    def prepare_url(self, prepare_url):
        """Sets the prepare_url of this InlineSignRequest.


        :param prepare_url: The prepare_url of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        if prepare_url is not None and len(prepare_url) < 1:
            raise ValueError("Invalid value for `prepare_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._prepare_url = prepare_url

    @property
    def redirect_url(self):
        """Gets the redirect_url of this InlineSignRequest.  # noqa: E501

        URL at which SignRequest will redirect to when a document is signed  # noqa: E501

        :return: The redirect_url of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """Sets the redirect_url of this InlineSignRequest.

        URL at which SignRequest will redirect to when a document is signed  # noqa: E501

        :param redirect_url: The redirect_url of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        if redirect_url is not None and len(redirect_url) < 1:
            raise ValueError("Invalid value for `redirect_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._redirect_url = redirect_url

    @property
    def redirect_url_declined(self):
        """Gets the redirect_url_declined of this InlineSignRequest.  # noqa: E501

        URL at which SignRequest will redirect to when a document is declined  # noqa: E501

        :return: The redirect_url_declined of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._redirect_url_declined

    @redirect_url_declined.setter
    def redirect_url_declined(self, redirect_url_declined):
        """Sets the redirect_url_declined of this InlineSignRequest.

        URL at which SignRequest will redirect to when a document is declined  # noqa: E501

        :param redirect_url_declined: The redirect_url_declined of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        if redirect_url_declined is not None and len(redirect_url_declined) < 1:
            raise ValueError("Invalid value for `redirect_url_declined`, length must be greater than or equal to `1`")  # noqa: E501

        self._redirect_url_declined = redirect_url_declined

    @property
    def required_attachments(self):
        """Gets the required_attachments of this InlineSignRequest.  # noqa: E501


        :return: The required_attachments of this InlineSignRequest.  # noqa: E501
        :rtype: list[RequiredAttachment]
        """
        return self._required_attachments

    @required_attachments.setter
    def required_attachments(self, required_attachments):
        """Sets the required_attachments of this InlineSignRequest.


        :param required_attachments: The required_attachments of this InlineSignRequest.  # noqa: E501
        :type: list[RequiredAttachment]
        """

        self._required_attachments = required_attachments

    @property
    def disable_attachments(self):
        """Gets the disable_attachments of this InlineSignRequest.  # noqa: E501

        Disable uploading/adding of attachments  # noqa: E501

        :return: The disable_attachments of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._disable_attachments

    @disable_attachments.setter
    def disable_attachments(self, disable_attachments):
        """Sets the disable_attachments of this InlineSignRequest.

        Disable uploading/adding of attachments  # noqa: E501

        :param disable_attachments: The disable_attachments of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._disable_attachments = disable_attachments

    @property
    def disable_text_signatures(self):
        """Gets the disable_text_signatures of this InlineSignRequest.  # noqa: E501

        Disable usage of signatures generated by typing (text)  # noqa: E501

        :return: The disable_text_signatures of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._disable_text_signatures

    @disable_text_signatures.setter
    def disable_text_signatures(self, disable_text_signatures):
        """Sets the disable_text_signatures of this InlineSignRequest.

        Disable usage of signatures generated by typing (text)  # noqa: E501

        :param disable_text_signatures: The disable_text_signatures of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._disable_text_signatures = disable_text_signatures

    @property
    def disable_text(self):
        """Gets the disable_text of this InlineSignRequest.  # noqa: E501

        Disable adding of text  # noqa: E501

        :return: The disable_text of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._disable_text

    @disable_text.setter
    def disable_text(self, disable_text):
        """Sets the disable_text of this InlineSignRequest.

        Disable adding of text  # noqa: E501

        :param disable_text: The disable_text of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._disable_text = disable_text

    @property
    def disable_date(self):
        """Gets the disable_date of this InlineSignRequest.  # noqa: E501

        Disable adding of dates  # noqa: E501

        :return: The disable_date of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._disable_date

    @disable_date.setter
    def disable_date(self, disable_date):
        """Sets the disable_date of this InlineSignRequest.

        Disable adding of dates  # noqa: E501

        :param disable_date: The disable_date of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._disable_date = disable_date

    @property
    def disable_emails(self):
        """Gets the disable_emails of this InlineSignRequest.  # noqa: E501

        Disable all SignRequest status emails as well as the email that contains the signed documents  # noqa: E501

        :return: The disable_emails of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._disable_emails

    @disable_emails.setter
    def disable_emails(self, disable_emails):
        """Sets the disable_emails of this InlineSignRequest.

        Disable all SignRequest status emails as well as the email that contains the signed documents  # noqa: E501

        :param disable_emails: The disable_emails of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._disable_emails = disable_emails

    @property
    def disable_upload_signatures(self):
        """Gets the disable_upload_signatures of this InlineSignRequest.  # noqa: E501

        Disable usage of uploaded signatures (images)  # noqa: E501

        :return: The disable_upload_signatures of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._disable_upload_signatures

    @disable_upload_signatures.setter
    def disable_upload_signatures(self, disable_upload_signatures):
        """Sets the disable_upload_signatures of this InlineSignRequest.

        Disable usage of uploaded signatures (images)  # noqa: E501

        :param disable_upload_signatures: The disable_upload_signatures of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._disable_upload_signatures = disable_upload_signatures

    @property
    def disable_blockchain_proof(self):
        """Gets the disable_blockchain_proof of this InlineSignRequest.  # noqa: E501

        Disables storing timestamp proof hashes in blockchain integrations.  # noqa: E501

        :return: The disable_blockchain_proof of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._disable_blockchain_proof

    @disable_blockchain_proof.setter
    def disable_blockchain_proof(self, disable_blockchain_proof):
        """Sets the disable_blockchain_proof of this InlineSignRequest.

        Disables storing timestamp proof hashes in blockchain integrations.  # noqa: E501

        :param disable_blockchain_proof: The disable_blockchain_proof of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._disable_blockchain_proof = disable_blockchain_proof

    @property
    def text_message_verification_locked(self):
        """Gets the text_message_verification_locked of this InlineSignRequest.  # noqa: E501

        When true a text message verification is needed before the signer can see the document  # noqa: E501

        :return: The text_message_verification_locked of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._text_message_verification_locked

    @text_message_verification_locked.setter
    def text_message_verification_locked(self, text_message_verification_locked):
        """Sets the text_message_verification_locked of this InlineSignRequest.

        When true a text message verification is needed before the signer can see the document  # noqa: E501

        :param text_message_verification_locked: The text_message_verification_locked of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._text_message_verification_locked = text_message_verification_locked

    @property
    def subject(self):
        """Gets the subject of this InlineSignRequest.  # noqa: E501

        Subject of SignRequest email  # noqa: E501

        :return: The subject of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this InlineSignRequest.

        Subject of SignRequest email  # noqa: E501

        :param subject: The subject of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        if subject is not None and len(subject) < 1:
            raise ValueError("Invalid value for `subject`, length must be greater than or equal to `1`")  # noqa: E501

        self._subject = subject

    @property
    def message(self):
        """Gets the message of this InlineSignRequest.  # noqa: E501

        Message to include in SignRequest email, may contain the following html tags: `a`, `abbr`, `acronym`, `b`, `blockquote`, `code`, `em`, `i`, `ul`, `li`, `ol`, and `strong`  # noqa: E501

        :return: The message of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this InlineSignRequest.

        Message to include in SignRequest email, may contain the following html tags: `a`, `abbr`, `acronym`, `b`, `blockquote`, `code`, `em`, `i`, `ul`, `li`, `ol`, and `strong`  # noqa: E501

        :param message: The message of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        if message is not None and len(message) < 1:
            raise ValueError("Invalid value for `message`, length must be greater than or equal to `1`")  # noqa: E501

        self._message = message

    @property
    def who(self):
        """Gets the who of this InlineSignRequest.  # noqa: E501

        `m`: only me, `mo`: me and others, `o`: only others  # noqa: E501

        :return: The who of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._who

    @who.setter
    def who(self, who):
        """Sets the who of this InlineSignRequest.

        `m`: only me, `mo`: me and others, `o`: only others  # noqa: E501

        :param who: The who of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["m", "mo", "o"]  # noqa: E501
        if who not in allowed_values:
            raise ValueError(
                "Invalid value for `who` ({0}), must be one of {1}"  # noqa: E501
                .format(who, allowed_values)
            )

        self._who = who

    @property
    def send_reminders(self):
        """Gets the send_reminders of this InlineSignRequest.  # noqa: E501

        Automatically remind signers to sign a document  # noqa: E501

        :return: The send_reminders of this InlineSignRequest.  # noqa: E501
        :rtype: bool
        """
        return self._send_reminders

    @send_reminders.setter
    def send_reminders(self, send_reminders):
        """Sets the send_reminders of this InlineSignRequest.

        Automatically remind signers to sign a document  # noqa: E501

        :param send_reminders: The send_reminders of this InlineSignRequest.  # noqa: E501
        :type: bool
        """

        self._send_reminders = send_reminders

    @property
    def signers(self):
        """Gets the signers of this InlineSignRequest.  # noqa: E501


        :return: The signers of this InlineSignRequest.  # noqa: E501
        :rtype: list[Signer]
        """
        return self._signers

    @signers.setter
    def signers(self, signers):
        """Sets the signers of this InlineSignRequest.


        :param signers: The signers of this InlineSignRequest.  # noqa: E501
        :type: list[Signer]
        """

        self._signers = signers

    @property
    def uuid(self):
        """Gets the uuid of this InlineSignRequest.  # noqa: E501


        :return: The uuid of this InlineSignRequest.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this InlineSignRequest.


        :param uuid: The uuid of this InlineSignRequest.  # noqa: E501
        :type: str
        """
        if uuid is not None and len(uuid) < 1:
            raise ValueError("Invalid value for `uuid`, length must be greater than or equal to `1`")  # noqa: E501

        self._uuid = uuid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InlineSignRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineSignRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
