# coding: utf-8

"""
    Kimai 2 - API Docs

    JSON API for the Kimai 2 time-tracking software. Read more about its usage in the [API documentation](https://www.kimai.org/documentation/rest-api.html) and then download a [Swagger file](doc.json) for import e.g. in Postman. Be aware: it is not yet considered stable and BC breaks might happen.   # noqa: E501

    OpenAPI spec version: 0.5
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from kimai_python.api_client import ApiClient


class TimesheetApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_timesheets_active_get(self, **kwargs):  # noqa: E501
        """Returns the collection of active timesheet records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_active_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TimesheetSubCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_active_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_active_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_timesheets_active_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the collection of active timesheet records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_active_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TimesheetSubCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_active_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/active', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimesheetSubCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_get(self, **kwargs):  # noqa: E501
        """Returns a collection of timesheet records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: User ID to filter timesheets. Needs permission 'view_other_timesheet', pass 'all' to fetch data for all user (default: current user)
        :param str customer: DEPRECATED: Customer ID to filter timesheets (will be removed with 2.0)
        :param str customers: Comma separated list of customer IDs to filter timesheets
        :param str project: DEPRECATED: Project ID to filter timesheets (will be removed with 2.0)
        :param str projects: Comma separated list of project IDs to filter timesheets
        :param str activity: DEPRECATED: Activity ID to filter timesheets (will be removed with 2.0)
        :param str activities: Comma separated list of activity IDs to filter timesheets
        :param str page: The page to display, renders a 404 if not found (default: 1)
        :param str size: The amount of entries for each page (default: 50)
        :param str tags: The name of tags which are in the datasets
        :param str order_by: The field by which results will be ordered. Allowed values: id, begin, end, rate (default: begin)
        :param str order: The result order. Allowed values: ASC, DESC (default: DESC)
        :param str begin: Only records after this date will be included (format: HTML5)
        :param str end: Only records before this date will be included (format: HTML5)
        :param str exported: Use this flag if you want to filter for export state. Allowed values: 0=not exported, 1=exported (default: all)
        :param str active: Filter for running/active records. Allowed values: 0=stopped, 1=active (default: all)
        :param str full: Allows to fetch fully serialized objects including subresources (TimesheetSubCollection). Allowed values: true (default: false)
        :param str term: Free search term
        :return: list[TimesheetCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_timesheets_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a collection of timesheet records  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: User ID to filter timesheets. Needs permission 'view_other_timesheet', pass 'all' to fetch data for all user (default: current user)
        :param str customer: DEPRECATED: Customer ID to filter timesheets (will be removed with 2.0)
        :param str customers: Comma separated list of customer IDs to filter timesheets
        :param str project: DEPRECATED: Project ID to filter timesheets (will be removed with 2.0)
        :param str projects: Comma separated list of project IDs to filter timesheets
        :param str activity: DEPRECATED: Activity ID to filter timesheets (will be removed with 2.0)
        :param str activities: Comma separated list of activity IDs to filter timesheets
        :param str page: The page to display, renders a 404 if not found (default: 1)
        :param str size: The amount of entries for each page (default: 50)
        :param str tags: The name of tags which are in the datasets
        :param str order_by: The field by which results will be ordered. Allowed values: id, begin, end, rate (default: begin)
        :param str order: The result order. Allowed values: ASC, DESC (default: DESC)
        :param str begin: Only records after this date will be included (format: HTML5)
        :param str end: Only records before this date will be included (format: HTML5)
        :param str exported: Use this flag if you want to filter for export state. Allowed values: 0=not exported, 1=exported (default: all)
        :param str active: Filter for running/active records. Allowed values: 0=stopped, 1=active (default: all)
        :param str full: Allows to fetch fully serialized objects including subresources (TimesheetSubCollection). Allowed values: true (default: false)
        :param str term: Free search term
        :return: list[TimesheetCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user', 'customer', 'customers', 'project', 'projects', 'activity', 'activities', 'page', 'size', 'tags', 'order_by', 'order', 'begin', 'end', 'exported', 'active', 'full', 'term']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_get" % key
                )
            params[key] = val
        del params['kwargs']

        if 'user' in params and not re.search(r'\\d+|all', params['user']):  # noqa: E501
            raise ValueError("Invalid value for parameter `user` when calling `api_timesheets_get`, must conform to the pattern `/\\d+|all/`")  # noqa: E501
        if 'customer' in params and not re.search(r'\\d+', params['customer']):  # noqa: E501
            raise ValueError("Invalid value for parameter `customer` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'customers' in params and not re.search(r'[\\d|,]+', params['customers']):  # noqa: E501
            raise ValueError("Invalid value for parameter `customers` when calling `api_timesheets_get`, must conform to the pattern `/[\\d|,]+/`")  # noqa: E501
        if 'project' in params and not re.search(r'\\d+', params['project']):  # noqa: E501
            raise ValueError("Invalid value for parameter `project` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'projects' in params and not re.search(r'[\\d|,]+', params['projects']):  # noqa: E501
            raise ValueError("Invalid value for parameter `projects` when calling `api_timesheets_get`, must conform to the pattern `/[\\d|,]+/`")  # noqa: E501
        if 'activity' in params and not re.search(r'\\d+', params['activity']):  # noqa: E501
            raise ValueError("Invalid value for parameter `activity` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'activities' in params and not re.search(r'[\\d|,]+', params['activities']):  # noqa: E501
            raise ValueError("Invalid value for parameter `activities` when calling `api_timesheets_get`, must conform to the pattern `/[\\d|,]+/`")  # noqa: E501
        if 'page' in params and not re.search(r'\\d+', params['page']):  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'size' in params and not re.search(r'\\d+', params['size']):  # noqa: E501
            raise ValueError("Invalid value for parameter `size` when calling `api_timesheets_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        if 'order_by' in params and not re.search(r'id|begin|end|rate', params['order_by']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order_by` when calling `api_timesheets_get`, must conform to the pattern `/id|begin|end|rate/`")  # noqa: E501
        if 'order' in params and not re.search(r'ASC|DESC', params['order']):  # noqa: E501
            raise ValueError("Invalid value for parameter `order` when calling `api_timesheets_get`, must conform to the pattern `/ASC|DESC/`")  # noqa: E501
        if 'exported' in params and not re.search(r'0|1', params['exported']):  # noqa: E501
            raise ValueError("Invalid value for parameter `exported` when calling `api_timesheets_get`, must conform to the pattern `/0|1/`")  # noqa: E501
        if 'active' in params and not re.search(r'0|1', params['active']):  # noqa: E501
            raise ValueError("Invalid value for parameter `active` when calling `api_timesheets_get`, must conform to the pattern `/0|1/`")  # noqa: E501
        if 'full' in params and not re.search(r'true', params['full']):  # noqa: E501
            raise ValueError("Invalid value for parameter `full` when calling `api_timesheets_get`, must conform to the pattern `/true/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user' in params:
            query_params.append(('user', params['user']))  # noqa: E501
        if 'customer' in params:
            query_params.append(('customer', params['customer']))  # noqa: E501
        if 'customers' in params:
            query_params.append(('customers', params['customers']))  # noqa: E501
        if 'project' in params:
            query_params.append(('project', params['project']))  # noqa: E501
        if 'projects' in params:
            query_params.append(('projects', params['projects']))  # noqa: E501
        if 'activity' in params:
            query_params.append(('activity', params['activity']))  # noqa: E501
        if 'activities' in params:
            query_params.append(('activities', params['activities']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'tags' in params:
            query_params.append(('tags', params['tags']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('orderBy', params['order_by']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'exported' in params:
            query_params.append(('exported', params['exported']))  # noqa: E501
        if 'active' in params:
            query_params.append(('active', params['active']))  # noqa: E501
        if 'full' in params:
            query_params.append(('full', params['full']))  # noqa: E501
        if 'term' in params:
            query_params.append(('term', params['term']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimesheetCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete an existing timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete an existing timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_duplicate_patch(self, id, **kwargs):  # noqa: E501
        """Duplicates an existing timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_duplicate_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to duplicate (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_duplicate_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_duplicate_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_duplicate_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Duplicates an existing timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_duplicate_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to duplicate (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_duplicate_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_duplicate_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/duplicate', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_export_patch(self, id, **kwargs):  # noqa: E501
        """Switch the export state of a timesheet record to (un-)lock it  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_export_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to switch export state (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_export_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_export_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_export_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Switch the export state of a timesheet record to (un-)lock it  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_export_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to switch export state (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_export_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_export_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/export', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_get(self, id, **kwargs):  # noqa: E501
        """Returns one timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to fetch (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns one timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to fetch (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_meta_patch(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing timesheet.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_meta_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to set the meta-field value for (required)
        :param Body4 body:
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_meta_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_meta_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Sets the value of a meta-field for an existing timesheet.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_meta_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to set the meta-field value for (required)
        :param Body4 body:
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_meta_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_meta_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/meta', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_patch(self, body, id, **kwargs):  # noqa: E501
        """Update an existing timesheet record  # noqa: E501

        Update an existing timesheet record, you can pass all or just a subset of the attributes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_patch(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimesheetEditForm body: (required)
        :param int id: Timesheet record ID to update (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_patch_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an existing timesheet record  # noqa: E501

        Update an existing timesheet record, you can pass all or just a subset of the attributes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_patch_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimesheetEditForm body: (required)
        :param int id: Timesheet record ID to update (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_timesheets_id_patch`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_restart_patch(self, id, **kwargs):  # noqa: E501
        """Restarts a previously stopped timesheet record for the current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_restart_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to restart (required)
        :param Body3 body:
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_restart_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_restart_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_restart_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Restarts a previously stopped timesheet record for the current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_restart_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to restart (required)
        :param Body3 body:
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_restart_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_restart_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/restart', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_id_stop_patch(self, id, **kwargs):  # noqa: E501
        """Stops an active timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_stop_patch(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to stop (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_id_stop_patch_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_id_stop_patch_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_timesheets_id_stop_patch_with_http_info(self, id, **kwargs):  # noqa: E501
        """Stops an active timesheet record  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_id_stop_patch_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Timesheet record ID to stop (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_id_stop_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_timesheets_id_stop_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/{id}/stop', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_post(self, body, **kwargs):  # noqa: E501
        """Creates a new timesheet record  # noqa: E501

        Creates a new timesheet record for the current user and returns it afterwards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimesheetEditForm body: (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def api_timesheets_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new timesheet record  # noqa: E501

        Creates a new timesheet record for the current user and returns it afterwards.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TimesheetEditForm body: (required)
        :return: TimesheetEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `api_timesheets_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimesheetEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_timesheets_recent_get(self, **kwargs):  # noqa: E501
        """Returns the collection of recent user activities  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_recent_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: User ID to filter timesheets. Needs permission 'view_other_timesheet', pass 'all' to fetch data for all user (default: current user)
        :param str begin: Only records after this date will be included. Default: today - 1 year (format: HTML5)
        :param str size: The amount of entries (default: 10)
        :return: list[TimesheetSubCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_timesheets_recent_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_timesheets_recent_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_timesheets_recent_get_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the collection of recent user activities  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_timesheets_recent_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: User ID to filter timesheets. Needs permission 'view_other_timesheet', pass 'all' to fetch data for all user (default: current user)
        :param str begin: Only records after this date will be included. Default: today - 1 year (format: HTML5)
        :param str size: The amount of entries (default: 10)
        :return: list[TimesheetSubCollection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user', 'begin', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_timesheets_recent_get" % key
                )
            params[key] = val
        del params['kwargs']

        if 'user' in params and not re.search(r'\\d+|all', params['user']):  # noqa: E501
            raise ValueError("Invalid value for parameter `user` when calling `api_timesheets_recent_get`, must conform to the pattern `/\\d+|all/`")  # noqa: E501
        if 'size' in params and not re.search(r'\\d+', params['size']):  # noqa: E501
            raise ValueError("Invalid value for parameter `size` when calling `api_timesheets_recent_get`, must conform to the pattern `/\\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user' in params:
            query_params.append(('user', params['user']))  # noqa: E501
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['apiToken', 'apiUser']  # noqa: E501

        return self.api_client.call_api(
            '/api/timesheets/recent', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TimesheetSubCollection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
