# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.20.7
    Contact: vrchatapi.lpv0t@aries.fyi
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vrchatapi.api_client import ApiClient
from vrchatapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FilesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_file(self, **kwargs):  # noqa: E501
        """Create File  # noqa: E501

        Creates a new File object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file(async_req=True)
        >>> result = thread.get()

        :param create_file_request:
        :type create_file_request: CreateFileRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_with_http_info(**kwargs)  # noqa: E501

    def create_file_with_http_info(self, **kwargs):  # noqa: E501
        """Create File  # noqa: E501

        Creates a new File object  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_with_http_info(async_req=True)
        >>> result = thread.get()

        :param create_file_request:
        :type create_file_request: CreateFileRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'create_file_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_file_request' in local_var_params:
            body_params = local_var_params['create_file_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
        }

        return self.api_client.call_api(
            '/file', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_file_version(self, file_id, **kwargs):  # noqa: E501
        """Create File Version  # noqa: E501

        Creates a new FileVersion. Once a Version has been created, proceed to the `/file/{fileId}/{versionId}/file/start` endpoint to start a file upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_version(file_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param create_file_version_request:
        :type create_file_version_request: CreateFileVersionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.create_file_version_with_http_info(file_id, **kwargs)  # noqa: E501

    def create_file_version_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Create File Version  # noqa: E501

        Creates a new FileVersion. Once a Version has been created, proceed to the `/file/{fileId}/{versionId}/file/start` endpoint to start a file upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_file_version_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param create_file_version_request:
        :type create_file_version_request: CreateFileVersionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'create_file_version_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `create_file_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_file_version_request' in local_var_params:
            body_params = local_var_params['create_file_version_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
        }

        return self.api_client.call_api(
            '/file/{fileId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_file(self, file_id, **kwargs):  # noqa: E501
        """Delete File  # noqa: E501

        Deletes a File object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file(file_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_file_with_http_info(file_id, **kwargs)  # noqa: E501

    def delete_file_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Delete File  # noqa: E501

        Deletes a File object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `delete_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
            404: "Error",
        }

        return self.api_client.call_api(
            '/file/{fileId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_file_version(self, file_id, version_id, **kwargs):  # noqa: E501
        """Delete File Version  # noqa: E501

        Delete a specific version of a file. You can only delete the latest version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_version(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_file_version_with_http_info(file_id, version_id, **kwargs)  # noqa: E501

    def delete_file_version_with_http_info(self, file_id, version_id, **kwargs):  # noqa: E501
        """Delete File Version  # noqa: E501

        Delete a specific version of a file. You can only delete the latest version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_file_version_with_http_info(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `delete_file_version`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and local_var_params.get('version_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_id` when calling `delete_file_version`")  # noqa: E501

        if self.api_client.client_side_validation and 'version_id' in local_var_params and local_var_params['version_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `delete_file_version`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501
        if 'version_id' in local_var_params:
            path_params['versionId'] = local_var_params['version_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
            400: "Error",
            500: "Error",
        }

        return self.api_client.call_api(
            '/file/{fileId}/{versionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def download_file_version(self, file_id, version_id, **kwargs):  # noqa: E501
        """Download File Version  # noqa: E501

        Downloads the file with the provided version number.  **Version Note:** Version 0 is always when the file was created. The real data is usually always located in version 1 and up.  **Extension Note:** Files are not guaranteed to have a file extensions. UnityPackage files tends to have it, images through this endpoint do not. You are responsible for appending file extension from the `extension` field when neccesary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_file_version(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file
        """
        kwargs['_return_http_data_only'] = True
        return self.download_file_version_with_http_info(file_id, version_id, **kwargs)  # noqa: E501

    def download_file_version_with_http_info(self, file_id, version_id, **kwargs):  # noqa: E501
        """Download File Version  # noqa: E501

        Downloads the file with the provided version number.  **Version Note:** Version 0 is always when the file was created. The real data is usually always located in version 1 and up.  **Extension Note:** Files are not guaranteed to have a file extensions. UnityPackage files tends to have it, images through this endpoint do not. You are responsible for appending file extension from the `extension` field when neccesary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_file_version_with_http_info(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(file, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_file_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `download_file_version`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and local_var_params.get('version_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_id` when calling `download_file_version`")  # noqa: E501

        if self.api_client.client_side_validation and 'version_id' in local_var_params and local_var_params['version_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `download_file_version`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501
        if 'version_id' in local_var_params:
            path_params['versionId'] = local_var_params['version_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "file",
            404: "Error",
        }

        return self.api_client.call_api(
            '/file/{fileId}/{versionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def finish_file_data_upload(self, file_id, version_id, file_type, **kwargs):  # noqa: E501
        """Finish FileData Upload  # noqa: E501

        Finish an upload of a FileData. This will mark it as \"complete\". After uploading the `file` for Avatars and Worlds you then have to upload a `signature` file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finish_file_data_upload(file_id, version_id, file_type, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param file_type: Type of file. (required)
        :type file_type: str
        :param finish_file_data_upload_request: Please see documentation on ETag's: [https://teppen.io/2018/06/23/aws_s3_etags/](https://teppen.io/2018/06/23/aws_s3_etags/)  ETag's should NOT be present when uploading a `signature`.
        :type finish_file_data_upload_request: FinishFileDataUploadRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.finish_file_data_upload_with_http_info(file_id, version_id, file_type, **kwargs)  # noqa: E501

    def finish_file_data_upload_with_http_info(self, file_id, version_id, file_type, **kwargs):  # noqa: E501
        """Finish FileData Upload  # noqa: E501

        Finish an upload of a FileData. This will mark it as \"complete\". After uploading the `file` for Avatars and Worlds you then have to upload a `signature` file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finish_file_data_upload_with_http_info(file_id, version_id, file_type, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param file_type: Type of file. (required)
        :type file_type: str
        :param finish_file_data_upload_request: Please see documentation on ETag's: [https://teppen.io/2018/06/23/aws_s3_etags/](https://teppen.io/2018/06/23/aws_s3_etags/)  ETag's should NOT be present when uploading a `signature`.
        :type finish_file_data_upload_request: FinishFileDataUploadRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'version_id',
            'file_type',
            'finish_file_data_upload_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method finish_file_data_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `finish_file_data_upload`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and local_var_params.get('version_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_id` when calling `finish_file_data_upload`")  # noqa: E501
        # verify the required parameter 'file_type' is set
        if self.api_client.client_side_validation and local_var_params.get('file_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_type` when calling `finish_file_data_upload`")  # noqa: E501

        if self.api_client.client_side_validation and 'version_id' in local_var_params and local_var_params['version_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `finish_file_data_upload`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501
        if 'version_id' in local_var_params:
            path_params['versionId'] = local_var_params['version_id']  # noqa: E501
        if 'file_type' in local_var_params:
            path_params['fileType'] = local_var_params['file_type']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'finish_file_data_upload_request' in local_var_params:
            body_params = local_var_params['finish_file_data_upload_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
        }

        return self.api_client.call_api(
            '/file/{fileId}/{versionId}/{fileType}/finish', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_admin_asset_bundle(self, admin_asset_bundle_id, **kwargs):  # noqa: E501
        """Get AdminAssetBundle  # noqa: E501

        Returns an AdminAssetBundle  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_admin_asset_bundle(admin_asset_bundle_id, async_req=True)
        >>> result = thread.get()

        :param admin_asset_bundle_id: Must be a valid admin asset bundle ID. (required)
        :type admin_asset_bundle_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AdminAssetBundle
        """
        kwargs['_return_http_data_only'] = True
        return self.get_admin_asset_bundle_with_http_info(admin_asset_bundle_id, **kwargs)  # noqa: E501

    def get_admin_asset_bundle_with_http_info(self, admin_asset_bundle_id, **kwargs):  # noqa: E501
        """Get AdminAssetBundle  # noqa: E501

        Returns an AdminAssetBundle  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_admin_asset_bundle_with_http_info(admin_asset_bundle_id, async_req=True)
        >>> result = thread.get()

        :param admin_asset_bundle_id: Must be a valid admin asset bundle ID. (required)
        :type admin_asset_bundle_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AdminAssetBundle, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'admin_asset_bundle_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_admin_asset_bundle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'admin_asset_bundle_id' is set
        if self.api_client.client_side_validation and local_var_params.get('admin_asset_bundle_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `admin_asset_bundle_id` when calling `get_admin_asset_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'admin_asset_bundle_id' in local_var_params:
            path_params['adminAssetBundleId'] = local_var_params['admin_asset_bundle_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "AdminAssetBundle",
        }

        return self.api_client.call_api(
            '/adminassetbundles/{adminAssetBundleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_content_agreement_status(self, agreement_code, content_id, version, **kwargs):  # noqa: E501
        """Get Content Agreement Status  # noqa: E501

        Returns the agreement status of the currently authenticated user for the given agreementCode, contentId, and version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_content_agreement_status(agreement_code, content_id, version, async_req=True)
        >>> result = thread.get()

        :param agreement_code: The type of agreement (currently content.copyright.owned) (required)
        :type agreement_code: AgreementCode
        :param content_id: The id of the content being uploaded, such as a WorldID, AvatarID, or PropID (required)
        :type content_id: str
        :param version: The version of the agreement (currently 1) (required)
        :type version: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AgreementStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.get_content_agreement_status_with_http_info(agreement_code, content_id, version, **kwargs)  # noqa: E501

    def get_content_agreement_status_with_http_info(self, agreement_code, content_id, version, **kwargs):  # noqa: E501
        """Get Content Agreement Status  # noqa: E501

        Returns the agreement status of the currently authenticated user for the given agreementCode, contentId, and version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_content_agreement_status_with_http_info(agreement_code, content_id, version, async_req=True)
        >>> result = thread.get()

        :param agreement_code: The type of agreement (currently content.copyright.owned) (required)
        :type agreement_code: AgreementCode
        :param content_id: The id of the content being uploaded, such as a WorldID, AvatarID, or PropID (required)
        :type content_id: str
        :param version: The version of the agreement (currently 1) (required)
        :type version: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AgreementStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'agreement_code',
            'content_id',
            'version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_content_agreement_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agreement_code' is set
        if self.api_client.client_side_validation and local_var_params.get('agreement_code') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `agreement_code` when calling `get_content_agreement_status`")  # noqa: E501
        # verify the required parameter 'content_id' is set
        if self.api_client.client_side_validation and local_var_params.get('content_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_id` when calling `get_content_agreement_status`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and local_var_params.get('version') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `get_content_agreement_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('agreement_code') is not None:  # noqa: E501
            query_params.append(('agreementCode', local_var_params['agreement_code']))  # noqa: E501
        if local_var_params.get('content_id') is not None:  # noqa: E501
            query_params.append(('contentId', local_var_params['content_id']))  # noqa: E501
        if local_var_params.get('version') is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "AgreementStatus",
            401: "Error",
        }

        return self.api_client.call_api(
            '/agreement', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_file(self, file_id, **kwargs):  # noqa: E501
        """Show File  # noqa: E501

        Shows general information about the \"File\" object. Each File can have several \"Version\"'s, and each Version can have multiple real files or \"Data\" blobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file(file_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_with_http_info(file_id, **kwargs)  # noqa: E501

    def get_file_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Show File  # noqa: E501

        Shows general information about the \"File\" object. Each File can have several \"Version\"'s, and each Version can have multiple real files or \"Data\" blobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
            404: "Error",
        }

        return self.api_client.call_api(
            '/file/{fileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_file_analysis(self, file_id, version_id, **kwargs):  # noqa: E501
        """Get File Version Analysis  # noqa: E501

        Get the performance analysis for the uploaded assets of an avatar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_analysis(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileAnalysis
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_analysis_with_http_info(file_id, version_id, **kwargs)  # noqa: E501

    def get_file_analysis_with_http_info(self, file_id, version_id, **kwargs):  # noqa: E501
        """Get File Version Analysis  # noqa: E501

        Get the performance analysis for the uploaded assets of an avatar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_analysis_with_http_info(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileAnalysis, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file_analysis`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and local_var_params.get('version_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_id` when calling `get_file_analysis`")  # noqa: E501

        if self.api_client.client_side_validation and 'version_id' in local_var_params and local_var_params['version_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `get_file_analysis`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501
        if 'version_id' in local_var_params:
            path_params['versionId'] = local_var_params['version_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "FileAnalysis",
            202: "Error",
            404: "Error",
        }

        return self.api_client.call_api(
            '/analysis/{fileId}/{versionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_file_analysis_security(self, file_id, version_id, **kwargs):  # noqa: E501
        """Get File Version Analysis Security  # noqa: E501

        Get the security performance analysis for the uploaded assets of an avatar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_analysis_security(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileAnalysis
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_analysis_security_with_http_info(file_id, version_id, **kwargs)  # noqa: E501

    def get_file_analysis_security_with_http_info(self, file_id, version_id, **kwargs):  # noqa: E501
        """Get File Version Analysis Security  # noqa: E501

        Get the security performance analysis for the uploaded assets of an avatar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_analysis_security_with_http_info(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileAnalysis, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_analysis_security" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file_analysis_security`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and local_var_params.get('version_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_id` when calling `get_file_analysis_security`")  # noqa: E501

        if self.api_client.client_side_validation and 'version_id' in local_var_params and local_var_params['version_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `get_file_analysis_security`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501
        if 'version_id' in local_var_params:
            path_params['versionId'] = local_var_params['version_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "FileAnalysis",
            202: "Error",
            404: "Error",
        }

        return self.api_client.call_api(
            '/analysis/{fileId}/{versionId}/security', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_file_analysis_standard(self, file_id, version_id, **kwargs):  # noqa: E501
        """Get File Version Analysis Standard  # noqa: E501

        Get the standard performance analysis for the uploaded assets of an avatar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_analysis_standard(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileAnalysis
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_analysis_standard_with_http_info(file_id, version_id, **kwargs)  # noqa: E501

    def get_file_analysis_standard_with_http_info(self, file_id, version_id, **kwargs):  # noqa: E501
        """Get File Version Analysis Standard  # noqa: E501

        Get the standard performance analysis for the uploaded assets of an avatar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_analysis_standard_with_http_info(file_id, version_id, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileAnalysis, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'version_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_analysis_standard" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file_analysis_standard`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and local_var_params.get('version_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_id` when calling `get_file_analysis_standard`")  # noqa: E501

        if self.api_client.client_side_validation and 'version_id' in local_var_params and local_var_params['version_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `get_file_analysis_standard`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501
        if 'version_id' in local_var_params:
            path_params['versionId'] = local_var_params['version_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "FileAnalysis",
            202: "Error",
            404: "Error",
        }

        return self.api_client.call_api(
            '/analysis/{fileId}/{versionId}/standard', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_file_data_upload_status(self, file_id, version_id, file_type, **kwargs):  # noqa: E501
        """Check FileData Upload Status  # noqa: E501

        Retrieves the upload status for file upload. Can currently only be accessed when `status` is `waiting`. Trying to access it on a file version already uploaded currently times out.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_data_upload_status(file_id, version_id, file_type, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param file_type: Type of file. (required)
        :type file_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileVersionUploadStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.get_file_data_upload_status_with_http_info(file_id, version_id, file_type, **kwargs)  # noqa: E501

    def get_file_data_upload_status_with_http_info(self, file_id, version_id, file_type, **kwargs):  # noqa: E501
        """Check FileData Upload Status  # noqa: E501

        Retrieves the upload status for file upload. Can currently only be accessed when `status` is `waiting`. Trying to access it on a file version already uploaded currently times out.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_data_upload_status_with_http_info(file_id, version_id, file_type, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param file_type: Type of file. (required)
        :type file_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileVersionUploadStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'version_id',
            'file_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_data_upload_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_file_data_upload_status`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and local_var_params.get('version_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_id` when calling `get_file_data_upload_status`")  # noqa: E501
        # verify the required parameter 'file_type' is set
        if self.api_client.client_side_validation and local_var_params.get('file_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_type` when calling `get_file_data_upload_status`")  # noqa: E501

        if self.api_client.client_side_validation and 'version_id' in local_var_params and local_var_params['version_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `get_file_data_upload_status`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501
        if 'version_id' in local_var_params:
            path_params['versionId'] = local_var_params['version_id']  # noqa: E501
        if 'file_type' in local_var_params:
            path_params['fileType'] = local_var_params['file_type']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "FileVersionUploadStatus",
        }

        return self.api_client.call_api(
            '/file/{fileId}/{versionId}/{fileType}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_files(self, **kwargs):  # noqa: E501
        """List Files  # noqa: E501

        Returns a list of files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_files(async_req=True)
        >>> result = thread.get()

        :param tag: Tag, for example \"icon\" or \"gallery\", not included by default.
        :type tag: str
        :param user_id: UserID, will always generate a 500 permission error.
        :type user_id: str
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[File]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_files_with_http_info(**kwargs)  # noqa: E501

    def get_files_with_http_info(self, **kwargs):  # noqa: E501
        """List Files  # noqa: E501

        Returns a list of files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_files_with_http_info(async_req=True)
        >>> result = thread.get()

        :param tag: Tag, for example \"icon\" or \"gallery\", not included by default.
        :type tag: str
        :param user_id: UserID, will always generate a 500 permission error.
        :type user_id: str
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[File], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tag',
            'user_id',
            'n',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('tag' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tag']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tag` when calling `get_files`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_files`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_files`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_files`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('tag') is not None:  # noqa: E501
            query_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if local_var_params.get('user_id') is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "list[File]",
        }

        return self.api_client.call_api(
            '/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def set_group_gallery_file_order(self, **kwargs):  # noqa: E501
        """Set Group Gallery File Order  # noqa: E501

        Set the order of the files in a group gallery  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_group_gallery_file_order(async_req=True)
        >>> result = thread.get()

        :param group_gallery_file_order_request:
        :type group_gallery_file_order_request: GroupGalleryFileOrderRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GroupGalleryFileOrder
        """
        kwargs['_return_http_data_only'] = True
        return self.set_group_gallery_file_order_with_http_info(**kwargs)  # noqa: E501

    def set_group_gallery_file_order_with_http_info(self, **kwargs):  # noqa: E501
        """Set Group Gallery File Order  # noqa: E501

        Set the order of the files in a group gallery  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_group_gallery_file_order_with_http_info(async_req=True)
        >>> result = thread.get()

        :param group_gallery_file_order_request:
        :type group_gallery_file_order_request: GroupGalleryFileOrderRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GroupGalleryFileOrder, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_gallery_file_order_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_group_gallery_file_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group_gallery_file_order_request' in local_var_params:
            body_params = local_var_params['group_gallery_file_order_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "GroupGalleryFileOrder",
            404: "Error",
        }

        return self.api_client.call_api(
            '/files/order', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def start_file_data_upload(self, file_id, version_id, file_type, **kwargs):  # noqa: E501
        """Start FileData Upload  # noqa: E501

        Starts an upload of a specific FilePart. This endpoint will return an AWS URL which you can PUT data to. You need to call this and receive a new AWS API URL for each `partNumber`. Please see AWS's REST documentation on \"PUT Object to S3\" on how to upload. Once all parts has been uploaded, proceed to `/finish` endpoint.  **Note:** `nextPartNumber` seems like it is always ignored. Despite it returning 0, first partNumber is always 1.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_file_data_upload(file_id, version_id, file_type, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param file_type: Type of file. (required)
        :type file_type: str
        :param part_number: The part number to start uploading. If not provided, the first part will be started.
        :type part_number: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileUploadURL
        """
        kwargs['_return_http_data_only'] = True
        return self.start_file_data_upload_with_http_info(file_id, version_id, file_type, **kwargs)  # noqa: E501

    def start_file_data_upload_with_http_info(self, file_id, version_id, file_type, **kwargs):  # noqa: E501
        """Start FileData Upload  # noqa: E501

        Starts an upload of a specific FilePart. This endpoint will return an AWS URL which you can PUT data to. You need to call this and receive a new AWS API URL for each `partNumber`. Please see AWS's REST documentation on \"PUT Object to S3\" on how to upload. Once all parts has been uploaded, proceed to `/finish` endpoint.  **Note:** `nextPartNumber` seems like it is always ignored. Despite it returning 0, first partNumber is always 1.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_file_data_upload_with_http_info(file_id, version_id, file_type, async_req=True)
        >>> result = thread.get()

        :param file_id: Must be a valid file ID. (required)
        :type file_id: str
        :param version_id: Version ID of the asset. (required)
        :type version_id: int
        :param file_type: Type of file. (required)
        :type file_type: str
        :param part_number: The part number to start uploading. If not provided, the first part will be started.
        :type part_number: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileUploadURL, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file_id',
            'version_id',
            'file_type',
            'part_number'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_file_data_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and local_var_params.get('file_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `start_file_data_upload`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and local_var_params.get('version_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_id` when calling `start_file_data_upload`")  # noqa: E501
        # verify the required parameter 'file_type' is set
        if self.api_client.client_side_validation and local_var_params.get('file_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_type` when calling `start_file_data_upload`")  # noqa: E501

        if self.api_client.client_side_validation and 'version_id' in local_var_params and local_var_params['version_id'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `version_id` when calling `start_file_data_upload`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'part_number' in local_var_params and local_var_params['part_number'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `part_number` when calling `start_file_data_upload`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_id' in local_var_params:
            path_params['fileId'] = local_var_params['file_id']  # noqa: E501
        if 'version_id' in local_var_params:
            path_params['versionId'] = local_var_params['version_id']  # noqa: E501
        if 'file_type' in local_var_params:
            path_params['fileType'] = local_var_params['file_type']  # noqa: E501

        query_params = []
        if local_var_params.get('part_number') is not None:  # noqa: E501
            query_params.append(('partNumber', local_var_params['part_number']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "FileUploadURL",
            400: "Error",
        }

        return self.api_client.call_api(
            '/file/{fileId}/{versionId}/{fileType}/start', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def submit_content_agreement(self, **kwargs):  # noqa: E501
        """Submit Content Agreement  # noqa: E501

        Returns the agreement of the currently authenticated user for the given agreementCode, contentId, and version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_content_agreement(async_req=True)
        >>> result = thread.get()

        :param agreement_request:
        :type agreement_request: AgreementRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Agreement
        """
        kwargs['_return_http_data_only'] = True
        return self.submit_content_agreement_with_http_info(**kwargs)  # noqa: E501

    def submit_content_agreement_with_http_info(self, **kwargs):  # noqa: E501
        """Submit Content Agreement  # noqa: E501

        Returns the agreement of the currently authenticated user for the given agreementCode, contentId, and version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.submit_content_agreement_with_http_info(async_req=True)
        >>> result = thread.get()

        :param agreement_request:
        :type agreement_request: AgreementRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Agreement, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'agreement_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_content_agreement" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'agreement_request' in local_var_params:
            body_params = local_var_params['agreement_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "Agreement",
            401: "Error",
        }

        return self.api_client.call_api(
            '/agreement', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_asset_review_notes(self, asset_review_id, **kwargs):  # noqa: E501
        """Update Asset Review Notes  # noqa: E501

        Update notes regarding an asset review.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_asset_review_notes(asset_review_id, async_req=True)
        >>> result = thread.get()

        :param asset_review_id: Must be an valid asset review ID. (required)
        :type asset_review_id: str
        :param update_asset_review_notes_request:
        :type update_asset_review_notes_request: UpdateAssetReviewNotesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.update_asset_review_notes_with_http_info(asset_review_id, **kwargs)  # noqa: E501

    def update_asset_review_notes_with_http_info(self, asset_review_id, **kwargs):  # noqa: E501
        """Update Asset Review Notes  # noqa: E501

        Update notes regarding an asset review.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_asset_review_notes_with_http_info(asset_review_id, async_req=True)
        >>> result = thread.get()

        :param asset_review_id: Must be an valid asset review ID. (required)
        :type asset_review_id: str
        :param update_asset_review_notes_request:
        :type update_asset_review_notes_request: UpdateAssetReviewNotesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'asset_review_id',
            'update_asset_review_notes_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset_review_notes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_review_id' is set
        if self.api_client.client_side_validation and local_var_params.get('asset_review_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_review_id` when calling `update_asset_review_notes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_review_id' in local_var_params:
            path_params['assetReviewId'] = local_var_params['asset_review_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_asset_review_notes_request' in local_var_params:
            body_params = local_var_params['update_asset_review_notes_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/assetReview/{assetReviewId}/notes', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upload_gallery_image(self, file, **kwargs):  # noqa: E501
        """Upload gallery image  # noqa: E501

        Upload a gallery image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_gallery_image(file, async_req=True)
        >>> result = thread.get()

        :param file: The binary blob of the png file. (required)
        :type file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_gallery_image_with_http_info(file, **kwargs)  # noqa: E501

    def upload_gallery_image_with_http_info(self, file, **kwargs):  # noqa: E501
        """Upload gallery image  # noqa: E501

        Upload a gallery image  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_gallery_image_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param file: The binary blob of the png file. (required)
        :type file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_gallery_image" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and local_var_params.get('file') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `upload_gallery_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
        }

        return self.api_client.call_api(
            '/gallery', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upload_icon(self, file, **kwargs):  # noqa: E501
        """Upload icon  # noqa: E501

        Upload an icon  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_icon(file, async_req=True)
        >>> result = thread.get()

        :param file: The binary blob of the png file. (required)
        :type file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_icon_with_http_info(file, **kwargs)  # noqa: E501

    def upload_icon_with_http_info(self, file, **kwargs):  # noqa: E501
        """Upload icon  # noqa: E501

        Upload an icon  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_icon_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param file: The binary blob of the png file. (required)
        :type file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_icon" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and local_var_params.get('file') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `upload_icon`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
        }

        return self.api_client.call_api(
            '/icon', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upload_image(self, file, tag, **kwargs):  # noqa: E501
        """Upload gallery image, icon, emoji or sticker  # noqa: E501

        Upload an image, which can be an icon, gallery image, sticker or emoji  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_image(file, tag, async_req=True)
        >>> result = thread.get()

        :param file: The binary blob of the png file. (required)
        :type file: file
        :param tag: (required)
        :type tag: ImagePurpose
        :param animation_style:
        :type animation_style: ImageAnimationStyle
        :param frames: Required for animated images. Total number of frames of the spritesheet to be animated.
        :type frames: int
        :param frames_over_time: Required for animated images. Animation frames per second.
        :type frames_over_time: int
        :param loop_style:
        :type loop_style: ImageLoopStyle
        :param mask_tag:
        :type mask_tag: ImageMask
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: File
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_image_with_http_info(file, tag, **kwargs)  # noqa: E501

    def upload_image_with_http_info(self, file, tag, **kwargs):  # noqa: E501
        """Upload gallery image, icon, emoji or sticker  # noqa: E501

        Upload an image, which can be an icon, gallery image, sticker or emoji  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_image_with_http_info(file, tag, async_req=True)
        >>> result = thread.get()

        :param file: The binary blob of the png file. (required)
        :type file: file
        :param tag: (required)
        :type tag: ImagePurpose
        :param animation_style:
        :type animation_style: ImageAnimationStyle
        :param frames: Required for animated images. Total number of frames of the spritesheet to be animated.
        :type frames: int
        :param frames_over_time: Required for animated images. Animation frames per second.
        :type frames_over_time: int
        :param loop_style:
        :type loop_style: ImageLoopStyle
        :param mask_tag:
        :type mask_tag: ImageMask
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(File, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'file',
            'tag',
            'animation_style',
            'frames',
            'frames_over_time',
            'loop_style',
            'mask_tag'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_image" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'file' is set
        if self.api_client.client_side_validation and local_var_params.get('file') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `file` when calling `upload_image`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if self.api_client.client_side_validation and local_var_params.get('tag') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tag` when calling `upload_image`")  # noqa: E501

        if self.api_client.client_side_validation and 'frames' in local_var_params and local_var_params['frames'] > 64:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frames` when calling `upload_image`, must be a value less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and 'frames' in local_var_params and local_var_params['frames'] < 2:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frames` when calling `upload_image`, must be a value greater than or equal to `2`")  # noqa: E501
        if self.api_client.client_side_validation and 'frames_over_time' in local_var_params and local_var_params['frames_over_time'] > 64:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frames_over_time` when calling `upload_image`, must be a value less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and 'frames_over_time' in local_var_params and local_var_params['frames_over_time'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frames_over_time` when calling `upload_image`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'animation_style' in local_var_params:
            form_params.append(('animationStyle', local_var_params['animation_style']))  # noqa: E501
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501
        if 'frames' in local_var_params:
            form_params.append(('frames', local_var_params['frames']))  # noqa: E501
        if 'frames_over_time' in local_var_params:
            form_params.append(('framesOverTime', local_var_params['frames_over_time']))  # noqa: E501
        if 'loop_style' in local_var_params:
            form_params.append(('loopStyle', local_var_params['loop_style']))  # noqa: E501
        if 'mask_tag' in local_var_params:
            form_params.append(('maskTag', local_var_params['mask_tag']))  # noqa: E501
        if 'tag' in local_var_params:
            form_params.append(('tag', local_var_params['tag']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "File",
        }

        return self.api_client.call_api(
            '/file/image', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
