# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.20.7
    Contact: vrchatapi.lpv0t@aries.fyi
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from vrchatapi.configuration import Configuration


class APIConfig(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'campaign_status': 'str',
        'disable_background_preloads': 'bool',
        'location_gifting_non_sub_prio_enabled': 'bool',
        'voice_enable_degradation': 'bool',
        'voice_enable_receiver_limiting': 'bool',
        'access_logs_urls': 'APIConfigAccessLogsUrls',
        'address': 'str',
        'age_verification_invite_visible': 'bool',
        'age_verification_p': 'bool',
        'age_verification_status_visible': 'bool',
        'analysis_max_retries': 'int',
        'analysis_retry_interval': 'int',
        'analytics_segment_new_ui_pct_of_users': 'int',
        'analytics_segment_new_ui_salt': 'str',
        'announcements': 'list[APIConfigAnnouncement]',
        'audio_config': 'APIConfigAudioConfig',
        'available_language_codes': 'list[str]',
        'available_languages': 'list[str]',
        'avatar_perf_limiter': 'APIConfigAvatarPerfLimiter',
        'chatbox_log_buffer_seconds': 'int',
        'client_api_key': 'str',
        'client_bps_ceiling': 'int',
        'client_disconnect_timeout': 'int',
        'client_net_dispatch_thread': 'bool',
        'client_net_dispatch_thread_mobile': 'bool',
        'client_net_in_thread': 'bool',
        'client_net_in_thread2': 'bool',
        'client_net_in_thread_mobile': 'bool',
        'client_net_in_thread_mobile2': 'bool',
        'client_net_out_thread': 'bool',
        'client_net_out_thread2': 'bool',
        'client_net_out_thread_mobile': 'bool',
        'client_net_out_thread_mobile2': 'bool',
        'client_qr': 'int',
        'client_reserved_player_bps': 'int',
        'client_sent_count_allowance': 'int',
        'constants': 'APIConfigConstants',
        'contact_email': 'str',
        'copyright_email': 'str',
        'copyright_form_url': 'str',
        'current_privacy_version': 'int',
        'current_tos_version': 'int',
        'default_avatar': 'str',
        'default_sticker_set': 'str',
        'dev_language_codes': 'list[str]',
        'dev_sdk_url': 'str',
        'dev_sdk_version': 'str',
        'dis_countdown': 'datetime',
        'disable_av_pro_in_proton': 'bool',
        'disable_avatar_copying': 'bool',
        'disable_avatar_gating': 'bool',
        'disable_captcha': 'bool',
        'disable_community_labs': 'bool',
        'disable_community_labs_promotion': 'bool',
        'disable_email': 'bool',
        'disable_event_stream': 'bool',
        'disable_feedback_gating': 'bool',
        'disable_frontend_builds': 'bool',
        'disable_gift_drops': 'bool',
        'disable_hello': 'bool',
        'disable_oculus_subs': 'bool',
        'disable_registration': 'bool',
        'disable_steam_networking': 'bool',
        'disable_two_factor_auth': 'bool',
        'disable_udon': 'bool',
        'disable_upgrade_account': 'bool',
        'download_link_windows': 'str',
        'download_urls': 'APIConfigDownloadURLList',
        'dynamic_world_rows': 'list[DynamicContentRow]',
        'economy_ledger_backfill': 'bool',
        'economy_ledger_migration_stop': 'str',
        'economy_ledger_mode': 'str',
        'economy_pause_end': 'datetime',
        'economy_pause_start': 'datetime',
        'economy_purchase_repair_enabled': 'bool',
        'economy_state': 'int',
        'events': 'APIConfigEvents',
        'force_use_latest_world': 'bool',
        'gift_display_type': 'str',
        'google_api_client_id': 'str',
        'home_world_id': 'str',
        'homepage_redirect_target': 'str',
        'hub_world_id': 'str',
        'image_host_url_list': 'list[str]',
        'ios_app_version': 'list[str]',
        'ios_version': 'APIConfigIosVersion',
        'jobs_email': 'str',
        'max_user_emoji': 'int',
        'max_user_stickers': 'int',
        'min_supported_client_build_number': 'APIConfigMinSupportedClientBuildNumber',
        'minimum_unity_version_for_uploads': 'str',
        'moderation_email': 'str',
        'not_allowed_to_select_avatar_in_private_world_message': 'str',
        'offline_analysis': 'APIConfigOfflineAnalysis',
        'photon_nameserver_overrides': 'list[str]',
        'photon_public_keys': 'list[str]',
        'player_url_resolver_sha1': 'str',
        'player_url_resolver_version': 'str',
        'public_key': 'str',
        'report_categories': 'dict(str, ReportCategory)',
        'report_form_url': 'str',
        'report_options': 'dict(str, dict(str, list[str]))',
        'report_reasons': 'dict(str, ReportReason)',
        'require_age_verification_beta_tag': 'bool',
        'sdk_developer_faq_url': 'str',
        'sdk_discord_url': 'str',
        'sdk_not_allowed_to_publish_message': 'str',
        'sdk_unity_version': 'str',
        'string_host_url_list': 'list[str]',
        'support_email': 'str',
        'support_form_url': 'str',
        'time_out_world_id': 'str',
        'timekeeping': 'bool',
        'tutorial_world_id': 'str',
        'update_rate_ms_maximum': 'int',
        'update_rate_ms_minimum': 'int',
        'update_rate_ms_normal': 'int',
        'update_rate_ms_udon_manual': 'int',
        'upload_analysis_percent': 'int',
        'url_list': 'list[str]',
        'use_reliable_udp_for_voice': 'bool',
        'vive_windows_url': 'str',
        'websocket_max_friends_refresh_delay': 'int',
        'websocket_quick_reconnect_time': 'int',
        'websocket_reconnect_max_delay': 'int',
        'white_listed_asset_urls': 'list[str]'
    }

    attribute_map = {
        'campaign_status': 'CampaignStatus',
        'disable_background_preloads': 'DisableBackgroundPreloads',
        'location_gifting_non_sub_prio_enabled': 'LocationGiftingNonSubPrioEnabled',
        'voice_enable_degradation': 'VoiceEnableDegradation',
        'voice_enable_receiver_limiting': 'VoiceEnableReceiverLimiting',
        'access_logs_urls': 'accessLogsUrls',
        'address': 'address',
        'age_verification_invite_visible': 'ageVerificationInviteVisible',
        'age_verification_p': 'ageVerificationP',
        'age_verification_status_visible': 'ageVerificationStatusVisible',
        'analysis_max_retries': 'analysisMaxRetries',
        'analysis_retry_interval': 'analysisRetryInterval',
        'analytics_segment_new_ui_pct_of_users': 'analyticsSegment_NewUI_PctOfUsers',
        'analytics_segment_new_ui_salt': 'analyticsSegment_NewUI_Salt',
        'announcements': 'announcements',
        'audio_config': 'audioConfig',
        'available_language_codes': 'availableLanguageCodes',
        'available_languages': 'availableLanguages',
        'avatar_perf_limiter': 'avatarPerfLimiter',
        'chatbox_log_buffer_seconds': 'chatboxLogBufferSeconds',
        'client_api_key': 'clientApiKey',
        'client_bps_ceiling': 'clientBPSCeiling',
        'client_disconnect_timeout': 'clientDisconnectTimeout',
        'client_net_dispatch_thread': 'clientNetDispatchThread',
        'client_net_dispatch_thread_mobile': 'clientNetDispatchThreadMobile',
        'client_net_in_thread': 'clientNetInThread',
        'client_net_in_thread2': 'clientNetInThread2',
        'client_net_in_thread_mobile': 'clientNetInThreadMobile',
        'client_net_in_thread_mobile2': 'clientNetInThreadMobile2',
        'client_net_out_thread': 'clientNetOutThread',
        'client_net_out_thread2': 'clientNetOutThread2',
        'client_net_out_thread_mobile': 'clientNetOutThreadMobile',
        'client_net_out_thread_mobile2': 'clientNetOutThreadMobile2',
        'client_qr': 'clientQR',
        'client_reserved_player_bps': 'clientReservedPlayerBPS',
        'client_sent_count_allowance': 'clientSentCountAllowance',
        'constants': 'constants',
        'contact_email': 'contactEmail',
        'copyright_email': 'copyrightEmail',
        'copyright_form_url': 'copyrightFormUrl',
        'current_privacy_version': 'currentPrivacyVersion',
        'current_tos_version': 'currentTOSVersion',
        'default_avatar': 'defaultAvatar',
        'default_sticker_set': 'defaultStickerSet',
        'dev_language_codes': 'devLanguageCodes',
        'dev_sdk_url': 'devSdkUrl',
        'dev_sdk_version': 'devSdkVersion',
        'dis_countdown': 'dis-countdown',
        'disable_av_pro_in_proton': 'disableAVProInProton',
        'disable_avatar_copying': 'disableAvatarCopying',
        'disable_avatar_gating': 'disableAvatarGating',
        'disable_captcha': 'disableCaptcha',
        'disable_community_labs': 'disableCommunityLabs',
        'disable_community_labs_promotion': 'disableCommunityLabsPromotion',
        'disable_email': 'disableEmail',
        'disable_event_stream': 'disableEventStream',
        'disable_feedback_gating': 'disableFeedbackGating',
        'disable_frontend_builds': 'disableFrontendBuilds',
        'disable_gift_drops': 'disableGiftDrops',
        'disable_hello': 'disableHello',
        'disable_oculus_subs': 'disableOculusSubs',
        'disable_registration': 'disableRegistration',
        'disable_steam_networking': 'disableSteamNetworking',
        'disable_two_factor_auth': 'disableTwoFactorAuth',
        'disable_udon': 'disableUdon',
        'disable_upgrade_account': 'disableUpgradeAccount',
        'download_link_windows': 'downloadLinkWindows',
        'download_urls': 'downloadUrls',
        'dynamic_world_rows': 'dynamicWorldRows',
        'economy_ledger_backfill': 'economyLedgerBackfill',
        'economy_ledger_migration_stop': 'economyLedgerMigrationStop',
        'economy_ledger_mode': 'economyLedgerMode',
        'economy_pause_end': 'economyPauseEnd',
        'economy_pause_start': 'economyPauseStart',
        'economy_purchase_repair_enabled': 'economyPurchaseRepairEnabled',
        'economy_state': 'economyState',
        'events': 'events',
        'force_use_latest_world': 'forceUseLatestWorld',
        'gift_display_type': 'giftDisplayType',
        'google_api_client_id': 'googleApiClientId',
        'home_world_id': 'homeWorldId',
        'homepage_redirect_target': 'homepageRedirectTarget',
        'hub_world_id': 'hubWorldId',
        'image_host_url_list': 'imageHostUrlList',
        'ios_app_version': 'iosAppVersion',
        'ios_version': 'iosVersion',
        'jobs_email': 'jobsEmail',
        'max_user_emoji': 'maxUserEmoji',
        'max_user_stickers': 'maxUserStickers',
        'min_supported_client_build_number': 'minSupportedClientBuildNumber',
        'minimum_unity_version_for_uploads': 'minimumUnityVersionForUploads',
        'moderation_email': 'moderationEmail',
        'not_allowed_to_select_avatar_in_private_world_message': 'notAllowedToSelectAvatarInPrivateWorldMessage',
        'offline_analysis': 'offlineAnalysis',
        'photon_nameserver_overrides': 'photonNameserverOverrides',
        'photon_public_keys': 'photonPublicKeys',
        'player_url_resolver_sha1': 'player-url-resolver-sha1',
        'player_url_resolver_version': 'player-url-resolver-version',
        'public_key': 'publicKey',
        'report_categories': 'reportCategories',
        'report_form_url': 'reportFormUrl',
        'report_options': 'reportOptions',
        'report_reasons': 'reportReasons',
        'require_age_verification_beta_tag': 'requireAgeVerificationBetaTag',
        'sdk_developer_faq_url': 'sdkDeveloperFaqUrl',
        'sdk_discord_url': 'sdkDiscordUrl',
        'sdk_not_allowed_to_publish_message': 'sdkNotAllowedToPublishMessage',
        'sdk_unity_version': 'sdkUnityVersion',
        'string_host_url_list': 'stringHostUrlList',
        'support_email': 'supportEmail',
        'support_form_url': 'supportFormUrl',
        'time_out_world_id': 'timeOutWorldId',
        'timekeeping': 'timekeeping',
        'tutorial_world_id': 'tutorialWorldId',
        'update_rate_ms_maximum': 'updateRateMsMaximum',
        'update_rate_ms_minimum': 'updateRateMsMinimum',
        'update_rate_ms_normal': 'updateRateMsNormal',
        'update_rate_ms_udon_manual': 'updateRateMsUdonManual',
        'upload_analysis_percent': 'uploadAnalysisPercent',
        'url_list': 'urlList',
        'use_reliable_udp_for_voice': 'useReliableUdpForVoice',
        'vive_windows_url': 'viveWindowsUrl',
        'websocket_max_friends_refresh_delay': 'websocketMaxFriendsRefreshDelay',
        'websocket_quick_reconnect_time': 'websocketQuickReconnectTime',
        'websocket_reconnect_max_delay': 'websocketReconnectMaxDelay',
        'white_listed_asset_urls': 'whiteListedAssetUrls'
    }

    def __init__(self, campaign_status=None, disable_background_preloads=True, location_gifting_non_sub_prio_enabled=True, voice_enable_degradation=False, voice_enable_receiver_limiting=True, access_logs_urls=None, address=None, age_verification_invite_visible=None, age_verification_p=None, age_verification_status_visible=None, analysis_max_retries=None, analysis_retry_interval=None, analytics_segment_new_ui_pct_of_users=None, analytics_segment_new_ui_salt=None, announcements=None, audio_config=None, available_language_codes=None, available_languages=None, avatar_perf_limiter=None, chatbox_log_buffer_seconds=40, client_api_key=None, client_bps_ceiling=18432, client_disconnect_timeout=30000, client_net_dispatch_thread=False, client_net_dispatch_thread_mobile=True, client_net_in_thread=False, client_net_in_thread2=False, client_net_in_thread_mobile=False, client_net_in_thread_mobile2=False, client_net_out_thread=False, client_net_out_thread2=False, client_net_out_thread_mobile=False, client_net_out_thread_mobile2=False, client_qr=1, client_reserved_player_bps=7168, client_sent_count_allowance=15, constants=None, contact_email=None, copyright_email=None, copyright_form_url=None, current_privacy_version=1, current_tos_version=None, default_avatar=None, default_sticker_set=None, dev_language_codes=None, dev_sdk_url=None, dev_sdk_version=None, dis_countdown=None, disable_av_pro_in_proton=False, disable_avatar_copying=False, disable_avatar_gating=False, disable_captcha=True, disable_community_labs=False, disable_community_labs_promotion=False, disable_email=False, disable_event_stream=False, disable_feedback_gating=False, disable_frontend_builds=False, disable_gift_drops=False, disable_hello=False, disable_oculus_subs=False, disable_registration=False, disable_steam_networking=True, disable_two_factor_auth=False, disable_udon=False, disable_upgrade_account=False, download_link_windows=None, download_urls=None, dynamic_world_rows=None, economy_ledger_backfill=None, economy_ledger_migration_stop=None, economy_ledger_mode=None, economy_pause_end=None, economy_pause_start=None, economy_purchase_repair_enabled=None, economy_state=1, events=None, force_use_latest_world=True, gift_display_type=None, google_api_client_id='827942544393-r2ouvckvouldn9dg9uruseje575e878f.apps.googleusercontent.com', home_world_id=None, homepage_redirect_target='https://hello.vrchat.com', hub_world_id=None, image_host_url_list=None, ios_app_version=None, ios_version=None, jobs_email=None, max_user_emoji=18, max_user_stickers=18, min_supported_client_build_number=None, minimum_unity_version_for_uploads='2019.0.0f1', moderation_email=None, not_allowed_to_select_avatar_in_private_world_message=None, offline_analysis=None, photon_nameserver_overrides=None, photon_public_keys=None, player_url_resolver_sha1=None, player_url_resolver_version=None, public_key=None, report_categories=None, report_form_url='https://help.vrchat.com/hc/en-us/requests/new?ticket_form_id=1500000182242&tf_360056455174=user_report&tf_360057451993={userId}&tf_1500001445142={reportedId}&tf_subject={reason} {category} By {contentType} {reportedName}&tf_description={description}', report_options=None, report_reasons=None, require_age_verification_beta_tag=None, sdk_developer_faq_url=None, sdk_discord_url=None, sdk_not_allowed_to_publish_message=None, sdk_unity_version=None, string_host_url_list=None, support_email=None, support_form_url=None, time_out_world_id=None, timekeeping=True, tutorial_world_id=None, update_rate_ms_maximum=None, update_rate_ms_minimum=None, update_rate_ms_normal=None, update_rate_ms_udon_manual=None, upload_analysis_percent=None, url_list=None, use_reliable_udp_for_voice=False, vive_windows_url=None, websocket_max_friends_refresh_delay=900, websocket_quick_reconnect_time=2, websocket_reconnect_max_delay=2, white_listed_asset_urls=None, local_vars_configuration=None):  # noqa: E501
        """APIConfig - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._campaign_status = None
        self._disable_background_preloads = None
        self._location_gifting_non_sub_prio_enabled = None
        self._voice_enable_degradation = None
        self._voice_enable_receiver_limiting = None
        self._access_logs_urls = None
        self._address = None
        self._age_verification_invite_visible = None
        self._age_verification_p = None
        self._age_verification_status_visible = None
        self._analysis_max_retries = None
        self._analysis_retry_interval = None
        self._analytics_segment_new_ui_pct_of_users = None
        self._analytics_segment_new_ui_salt = None
        self._announcements = None
        self._audio_config = None
        self._available_language_codes = None
        self._available_languages = None
        self._avatar_perf_limiter = None
        self._chatbox_log_buffer_seconds = None
        self._client_api_key = None
        self._client_bps_ceiling = None
        self._client_disconnect_timeout = None
        self._client_net_dispatch_thread = None
        self._client_net_dispatch_thread_mobile = None
        self._client_net_in_thread = None
        self._client_net_in_thread2 = None
        self._client_net_in_thread_mobile = None
        self._client_net_in_thread_mobile2 = None
        self._client_net_out_thread = None
        self._client_net_out_thread2 = None
        self._client_net_out_thread_mobile = None
        self._client_net_out_thread_mobile2 = None
        self._client_qr = None
        self._client_reserved_player_bps = None
        self._client_sent_count_allowance = None
        self._constants = None
        self._contact_email = None
        self._copyright_email = None
        self._copyright_form_url = None
        self._current_privacy_version = None
        self._current_tos_version = None
        self._default_avatar = None
        self._default_sticker_set = None
        self._dev_language_codes = None
        self._dev_sdk_url = None
        self._dev_sdk_version = None
        self._dis_countdown = None
        self._disable_av_pro_in_proton = None
        self._disable_avatar_copying = None
        self._disable_avatar_gating = None
        self._disable_captcha = None
        self._disable_community_labs = None
        self._disable_community_labs_promotion = None
        self._disable_email = None
        self._disable_event_stream = None
        self._disable_feedback_gating = None
        self._disable_frontend_builds = None
        self._disable_gift_drops = None
        self._disable_hello = None
        self._disable_oculus_subs = None
        self._disable_registration = None
        self._disable_steam_networking = None
        self._disable_two_factor_auth = None
        self._disable_udon = None
        self._disable_upgrade_account = None
        self._download_link_windows = None
        self._download_urls = None
        self._dynamic_world_rows = None
        self._economy_ledger_backfill = None
        self._economy_ledger_migration_stop = None
        self._economy_ledger_mode = None
        self._economy_pause_end = None
        self._economy_pause_start = None
        self._economy_purchase_repair_enabled = None
        self._economy_state = None
        self._events = None
        self._force_use_latest_world = None
        self._gift_display_type = None
        self._google_api_client_id = None
        self._home_world_id = None
        self._homepage_redirect_target = None
        self._hub_world_id = None
        self._image_host_url_list = None
        self._ios_app_version = None
        self._ios_version = None
        self._jobs_email = None
        self._max_user_emoji = None
        self._max_user_stickers = None
        self._min_supported_client_build_number = None
        self._minimum_unity_version_for_uploads = None
        self._moderation_email = None
        self._not_allowed_to_select_avatar_in_private_world_message = None
        self._offline_analysis = None
        self._photon_nameserver_overrides = None
        self._photon_public_keys = None
        self._player_url_resolver_sha1 = None
        self._player_url_resolver_version = None
        self._public_key = None
        self._report_categories = None
        self._report_form_url = None
        self._report_options = None
        self._report_reasons = None
        self._require_age_verification_beta_tag = None
        self._sdk_developer_faq_url = None
        self._sdk_discord_url = None
        self._sdk_not_allowed_to_publish_message = None
        self._sdk_unity_version = None
        self._string_host_url_list = None
        self._support_email = None
        self._support_form_url = None
        self._time_out_world_id = None
        self._timekeeping = None
        self._tutorial_world_id = None
        self._update_rate_ms_maximum = None
        self._update_rate_ms_minimum = None
        self._update_rate_ms_normal = None
        self._update_rate_ms_udon_manual = None
        self._upload_analysis_percent = None
        self._url_list = None
        self._use_reliable_udp_for_voice = None
        self._vive_windows_url = None
        self._websocket_max_friends_refresh_delay = None
        self._websocket_quick_reconnect_time = None
        self._websocket_reconnect_max_delay = None
        self._white_listed_asset_urls = None
        self.discriminator = None

        self.campaign_status = campaign_status
        self.disable_background_preloads = disable_background_preloads
        self.location_gifting_non_sub_prio_enabled = location_gifting_non_sub_prio_enabled
        self.voice_enable_degradation = voice_enable_degradation
        self.voice_enable_receiver_limiting = voice_enable_receiver_limiting
        self.access_logs_urls = access_logs_urls
        self.address = address
        self.age_verification_invite_visible = age_verification_invite_visible
        self.age_verification_p = age_verification_p
        self.age_verification_status_visible = age_verification_status_visible
        self.analysis_max_retries = analysis_max_retries
        self.analysis_retry_interval = analysis_retry_interval
        self.analytics_segment_new_ui_pct_of_users = analytics_segment_new_ui_pct_of_users
        self.analytics_segment_new_ui_salt = analytics_segment_new_ui_salt
        self.announcements = announcements
        if audio_config is not None:
            self.audio_config = audio_config
        self.available_language_codes = available_language_codes
        self.available_languages = available_languages
        self.avatar_perf_limiter = avatar_perf_limiter
        self.chatbox_log_buffer_seconds = chatbox_log_buffer_seconds
        self.client_api_key = client_api_key
        self.client_bps_ceiling = client_bps_ceiling
        self.client_disconnect_timeout = client_disconnect_timeout
        if client_net_dispatch_thread is not None:
            self.client_net_dispatch_thread = client_net_dispatch_thread
        self.client_net_dispatch_thread_mobile = client_net_dispatch_thread_mobile
        if client_net_in_thread is not None:
            self.client_net_in_thread = client_net_in_thread
        if client_net_in_thread2 is not None:
            self.client_net_in_thread2 = client_net_in_thread2
        if client_net_in_thread_mobile is not None:
            self.client_net_in_thread_mobile = client_net_in_thread_mobile
        if client_net_in_thread_mobile2 is not None:
            self.client_net_in_thread_mobile2 = client_net_in_thread_mobile2
        if client_net_out_thread is not None:
            self.client_net_out_thread = client_net_out_thread
        if client_net_out_thread2 is not None:
            self.client_net_out_thread2 = client_net_out_thread2
        if client_net_out_thread_mobile is not None:
            self.client_net_out_thread_mobile = client_net_out_thread_mobile
        if client_net_out_thread_mobile2 is not None:
            self.client_net_out_thread_mobile2 = client_net_out_thread_mobile2
        if client_qr is not None:
            self.client_qr = client_qr
        self.client_reserved_player_bps = client_reserved_player_bps
        self.client_sent_count_allowance = client_sent_count_allowance
        self.constants = constants
        self.contact_email = contact_email
        self.copyright_email = copyright_email
        self.copyright_form_url = copyright_form_url
        self.current_privacy_version = current_privacy_version
        self.current_tos_version = current_tos_version
        self.default_avatar = default_avatar
        self.default_sticker_set = default_sticker_set
        if dev_language_codes is not None:
            self.dev_language_codes = dev_language_codes
        self.dev_sdk_url = dev_sdk_url
        self.dev_sdk_version = dev_sdk_version
        self.dis_countdown = dis_countdown
        if disable_av_pro_in_proton is not None:
            self.disable_av_pro_in_proton = disable_av_pro_in_proton
        self.disable_avatar_copying = disable_avatar_copying
        self.disable_avatar_gating = disable_avatar_gating
        if disable_captcha is not None:
            self.disable_captcha = disable_captcha
        self.disable_community_labs = disable_community_labs
        self.disable_community_labs_promotion = disable_community_labs_promotion
        self.disable_email = disable_email
        self.disable_event_stream = disable_event_stream
        self.disable_feedback_gating = disable_feedback_gating
        self.disable_frontend_builds = disable_frontend_builds
        self.disable_gift_drops = disable_gift_drops
        self.disable_hello = disable_hello
        self.disable_oculus_subs = disable_oculus_subs
        self.disable_registration = disable_registration
        self.disable_steam_networking = disable_steam_networking
        self.disable_two_factor_auth = disable_two_factor_auth
        self.disable_udon = disable_udon
        self.disable_upgrade_account = disable_upgrade_account
        self.download_link_windows = download_link_windows
        self.download_urls = download_urls
        self.dynamic_world_rows = dynamic_world_rows
        self.economy_ledger_backfill = economy_ledger_backfill
        self.economy_ledger_migration_stop = economy_ledger_migration_stop
        self.economy_ledger_mode = economy_ledger_mode
        self.economy_pause_end = economy_pause_end
        self.economy_pause_start = economy_pause_start
        self.economy_purchase_repair_enabled = economy_purchase_repair_enabled
        self.economy_state = economy_state
        self.events = events
        self.force_use_latest_world = force_use_latest_world
        self.gift_display_type = gift_display_type
        self.google_api_client_id = google_api_client_id
        self.home_world_id = home_world_id
        self.homepage_redirect_target = homepage_redirect_target
        self.hub_world_id = hub_world_id
        self.image_host_url_list = image_host_url_list
        self.ios_app_version = ios_app_version
        self.ios_version = ios_version
        self.jobs_email = jobs_email
        self.max_user_emoji = max_user_emoji
        self.max_user_stickers = max_user_stickers
        self.min_supported_client_build_number = min_supported_client_build_number
        self.minimum_unity_version_for_uploads = minimum_unity_version_for_uploads
        self.moderation_email = moderation_email
        self.not_allowed_to_select_avatar_in_private_world_message = not_allowed_to_select_avatar_in_private_world_message
        self.offline_analysis = offline_analysis
        self.photon_nameserver_overrides = photon_nameserver_overrides
        self.photon_public_keys = photon_public_keys
        self.player_url_resolver_sha1 = player_url_resolver_sha1
        self.player_url_resolver_version = player_url_resolver_version
        self.public_key = public_key
        self.report_categories = report_categories
        self.report_form_url = report_form_url
        self.report_options = report_options
        self.report_reasons = report_reasons
        self.require_age_verification_beta_tag = require_age_verification_beta_tag
        self.sdk_developer_faq_url = sdk_developer_faq_url
        self.sdk_discord_url = sdk_discord_url
        self.sdk_not_allowed_to_publish_message = sdk_not_allowed_to_publish_message
        self.sdk_unity_version = sdk_unity_version
        self.string_host_url_list = string_host_url_list
        self.support_email = support_email
        self.support_form_url = support_form_url
        self.time_out_world_id = time_out_world_id
        self.timekeeping = timekeeping
        self.tutorial_world_id = tutorial_world_id
        self.update_rate_ms_maximum = update_rate_ms_maximum
        self.update_rate_ms_minimum = update_rate_ms_minimum
        self.update_rate_ms_normal = update_rate_ms_normal
        self.update_rate_ms_udon_manual = update_rate_ms_udon_manual
        self.upload_analysis_percent = upload_analysis_percent
        self.url_list = url_list
        self.use_reliable_udp_for_voice = use_reliable_udp_for_voice
        self.vive_windows_url = vive_windows_url
        self.websocket_max_friends_refresh_delay = websocket_max_friends_refresh_delay
        self.websocket_quick_reconnect_time = websocket_quick_reconnect_time
        self.websocket_reconnect_max_delay = websocket_reconnect_max_delay
        self.white_listed_asset_urls = white_listed_asset_urls

    @property
    def campaign_status(self):
        """Gets the campaign_status of this APIConfig.  # noqa: E501

        The current platform-wide event taking place  # noqa: E501

        :return: The campaign_status of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._campaign_status

    @campaign_status.setter
    def campaign_status(self, campaign_status):
        """Sets the campaign_status of this APIConfig.

        The current platform-wide event taking place  # noqa: E501

        :param campaign_status: The campaign_status of this APIConfig.  # noqa: E501
        :type campaign_status: str
        """
        if self.local_vars_configuration.client_side_validation and campaign_status is None:  # noqa: E501
            raise ValueError("Invalid value for `campaign_status`, must not be `None`")  # noqa: E501

        self._campaign_status = campaign_status

    @property
    def disable_background_preloads(self):
        """Gets the disable_background_preloads of this APIConfig.  # noqa: E501

        Toggles if certain assets are preloaded in the background  # noqa: E501

        :return: The disable_background_preloads of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_background_preloads

    @disable_background_preloads.setter
    def disable_background_preloads(self, disable_background_preloads):
        """Sets the disable_background_preloads of this APIConfig.

        Toggles if certain assets are preloaded in the background  # noqa: E501

        :param disable_background_preloads: The disable_background_preloads of this APIConfig.  # noqa: E501
        :type disable_background_preloads: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_background_preloads is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_background_preloads`, must not be `None`")  # noqa: E501

        self._disable_background_preloads = disable_background_preloads

    @property
    def location_gifting_non_sub_prio_enabled(self):
        """Gets the location_gifting_non_sub_prio_enabled of this APIConfig.  # noqa: E501

        Toggles whether users without a current VRC+ subscription are priority recipients for gift drops  # noqa: E501

        :return: The location_gifting_non_sub_prio_enabled of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._location_gifting_non_sub_prio_enabled

    @location_gifting_non_sub_prio_enabled.setter
    def location_gifting_non_sub_prio_enabled(self, location_gifting_non_sub_prio_enabled):
        """Sets the location_gifting_non_sub_prio_enabled of this APIConfig.

        Toggles whether users without a current VRC+ subscription are priority recipients for gift drops  # noqa: E501

        :param location_gifting_non_sub_prio_enabled: The location_gifting_non_sub_prio_enabled of this APIConfig.  # noqa: E501
        :type location_gifting_non_sub_prio_enabled: bool
        """
        if self.local_vars_configuration.client_side_validation and location_gifting_non_sub_prio_enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `location_gifting_non_sub_prio_enabled`, must not be `None`")  # noqa: E501

        self._location_gifting_non_sub_prio_enabled = location_gifting_non_sub_prio_enabled

    @property
    def voice_enable_degradation(self):
        """Gets the voice_enable_degradation of this APIConfig.  # noqa: E501

        Unknown, probably voice optimization testing  # noqa: E501

        :return: The voice_enable_degradation of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._voice_enable_degradation

    @voice_enable_degradation.setter
    def voice_enable_degradation(self, voice_enable_degradation):
        """Sets the voice_enable_degradation of this APIConfig.

        Unknown, probably voice optimization testing  # noqa: E501

        :param voice_enable_degradation: The voice_enable_degradation of this APIConfig.  # noqa: E501
        :type voice_enable_degradation: bool
        """
        if self.local_vars_configuration.client_side_validation and voice_enable_degradation is None:  # noqa: E501
            raise ValueError("Invalid value for `voice_enable_degradation`, must not be `None`")  # noqa: E501

        self._voice_enable_degradation = voice_enable_degradation

    @property
    def voice_enable_receiver_limiting(self):
        """Gets the voice_enable_receiver_limiting of this APIConfig.  # noqa: E501

        Unknown, probably voice optimization testing  # noqa: E501

        :return: The voice_enable_receiver_limiting of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._voice_enable_receiver_limiting

    @voice_enable_receiver_limiting.setter
    def voice_enable_receiver_limiting(self, voice_enable_receiver_limiting):
        """Sets the voice_enable_receiver_limiting of this APIConfig.

        Unknown, probably voice optimization testing  # noqa: E501

        :param voice_enable_receiver_limiting: The voice_enable_receiver_limiting of this APIConfig.  # noqa: E501
        :type voice_enable_receiver_limiting: bool
        """
        if self.local_vars_configuration.client_side_validation and voice_enable_receiver_limiting is None:  # noqa: E501
            raise ValueError("Invalid value for `voice_enable_receiver_limiting`, must not be `None`")  # noqa: E501

        self._voice_enable_receiver_limiting = voice_enable_receiver_limiting

    @property
    def access_logs_urls(self):
        """Gets the access_logs_urls of this APIConfig.  # noqa: E501


        :return: The access_logs_urls of this APIConfig.  # noqa: E501
        :rtype: APIConfigAccessLogsUrls
        """
        return self._access_logs_urls

    @access_logs_urls.setter
    def access_logs_urls(self, access_logs_urls):
        """Sets the access_logs_urls of this APIConfig.


        :param access_logs_urls: The access_logs_urls of this APIConfig.  # noqa: E501
        :type access_logs_urls: APIConfigAccessLogsUrls
        """
        if self.local_vars_configuration.client_side_validation and access_logs_urls is None:  # noqa: E501
            raise ValueError("Invalid value for `access_logs_urls`, must not be `None`")  # noqa: E501

        self._access_logs_urls = access_logs_urls

    @property
    def address(self):
        """Gets the address of this APIConfig.  # noqa: E501

        VRChat's office address  # noqa: E501

        :return: The address of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this APIConfig.

        VRChat's office address  # noqa: E501

        :param address: The address of this APIConfig.  # noqa: E501
        :type address: str
        """
        if self.local_vars_configuration.client_side_validation and address is None:  # noqa: E501
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                address is not None and len(address) < 1):
            raise ValueError("Invalid value for `address`, length must be greater than or equal to `1`")  # noqa: E501

        self._address = address

    @property
    def age_verification_invite_visible(self):
        """Gets the age_verification_invite_visible of this APIConfig.  # noqa: E501


        :return: The age_verification_invite_visible of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._age_verification_invite_visible

    @age_verification_invite_visible.setter
    def age_verification_invite_visible(self, age_verification_invite_visible):
        """Sets the age_verification_invite_visible of this APIConfig.


        :param age_verification_invite_visible: The age_verification_invite_visible of this APIConfig.  # noqa: E501
        :type age_verification_invite_visible: bool
        """
        if self.local_vars_configuration.client_side_validation and age_verification_invite_visible is None:  # noqa: E501
            raise ValueError("Invalid value for `age_verification_invite_visible`, must not be `None`")  # noqa: E501

        self._age_verification_invite_visible = age_verification_invite_visible

    @property
    def age_verification_p(self):
        """Gets the age_verification_p of this APIConfig.  # noqa: E501


        :return: The age_verification_p of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._age_verification_p

    @age_verification_p.setter
    def age_verification_p(self, age_verification_p):
        """Sets the age_verification_p of this APIConfig.


        :param age_verification_p: The age_verification_p of this APIConfig.  # noqa: E501
        :type age_verification_p: bool
        """
        if self.local_vars_configuration.client_side_validation and age_verification_p is None:  # noqa: E501
            raise ValueError("Invalid value for `age_verification_p`, must not be `None`")  # noqa: E501

        self._age_verification_p = age_verification_p

    @property
    def age_verification_status_visible(self):
        """Gets the age_verification_status_visible of this APIConfig.  # noqa: E501


        :return: The age_verification_status_visible of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._age_verification_status_visible

    @age_verification_status_visible.setter
    def age_verification_status_visible(self, age_verification_status_visible):
        """Sets the age_verification_status_visible of this APIConfig.


        :param age_verification_status_visible: The age_verification_status_visible of this APIConfig.  # noqa: E501
        :type age_verification_status_visible: bool
        """
        if self.local_vars_configuration.client_side_validation and age_verification_status_visible is None:  # noqa: E501
            raise ValueError("Invalid value for `age_verification_status_visible`, must not be `None`")  # noqa: E501

        self._age_verification_status_visible = age_verification_status_visible

    @property
    def analysis_max_retries(self):
        """Gets the analysis_max_retries of this APIConfig.  # noqa: E501

        Max retries for avatar analysis requests  # noqa: E501

        :return: The analysis_max_retries of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._analysis_max_retries

    @analysis_max_retries.setter
    def analysis_max_retries(self, analysis_max_retries):
        """Sets the analysis_max_retries of this APIConfig.

        Max retries for avatar analysis requests  # noqa: E501

        :param analysis_max_retries: The analysis_max_retries of this APIConfig.  # noqa: E501
        :type analysis_max_retries: int
        """
        if self.local_vars_configuration.client_side_validation and analysis_max_retries is None:  # noqa: E501
            raise ValueError("Invalid value for `analysis_max_retries`, must not be `None`")  # noqa: E501

        self._analysis_max_retries = analysis_max_retries

    @property
    def analysis_retry_interval(self):
        """Gets the analysis_retry_interval of this APIConfig.  # noqa: E501

        Interval between retries for avatar analysis requests  # noqa: E501

        :return: The analysis_retry_interval of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._analysis_retry_interval

    @analysis_retry_interval.setter
    def analysis_retry_interval(self, analysis_retry_interval):
        """Sets the analysis_retry_interval of this APIConfig.

        Interval between retries for avatar analysis requests  # noqa: E501

        :param analysis_retry_interval: The analysis_retry_interval of this APIConfig.  # noqa: E501
        :type analysis_retry_interval: int
        """
        if self.local_vars_configuration.client_side_validation and analysis_retry_interval is None:  # noqa: E501
            raise ValueError("Invalid value for `analysis_retry_interval`, must not be `None`")  # noqa: E501

        self._analysis_retry_interval = analysis_retry_interval

    @property
    def analytics_segment_new_ui_pct_of_users(self):
        """Gets the analytics_segment_new_ui_pct_of_users of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The analytics_segment_new_ui_pct_of_users of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._analytics_segment_new_ui_pct_of_users

    @analytics_segment_new_ui_pct_of_users.setter
    def analytics_segment_new_ui_pct_of_users(self, analytics_segment_new_ui_pct_of_users):
        """Sets the analytics_segment_new_ui_pct_of_users of this APIConfig.

        Unknown  # noqa: E501

        :param analytics_segment_new_ui_pct_of_users: The analytics_segment_new_ui_pct_of_users of this APIConfig.  # noqa: E501
        :type analytics_segment_new_ui_pct_of_users: int
        """
        if self.local_vars_configuration.client_side_validation and analytics_segment_new_ui_pct_of_users is None:  # noqa: E501
            raise ValueError("Invalid value for `analytics_segment_new_ui_pct_of_users`, must not be `None`")  # noqa: E501

        self._analytics_segment_new_ui_pct_of_users = analytics_segment_new_ui_pct_of_users

    @property
    def analytics_segment_new_ui_salt(self):
        """Gets the analytics_segment_new_ui_salt of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The analytics_segment_new_ui_salt of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._analytics_segment_new_ui_salt

    @analytics_segment_new_ui_salt.setter
    def analytics_segment_new_ui_salt(self, analytics_segment_new_ui_salt):
        """Sets the analytics_segment_new_ui_salt of this APIConfig.

        Unknown  # noqa: E501

        :param analytics_segment_new_ui_salt: The analytics_segment_new_ui_salt of this APIConfig.  # noqa: E501
        :type analytics_segment_new_ui_salt: str
        """
        if self.local_vars_configuration.client_side_validation and analytics_segment_new_ui_salt is None:  # noqa: E501
            raise ValueError("Invalid value for `analytics_segment_new_ui_salt`, must not be `None`")  # noqa: E501

        self._analytics_segment_new_ui_salt = analytics_segment_new_ui_salt

    @property
    def announcements(self):
        """Gets the announcements of this APIConfig.  # noqa: E501

        Public Announcements  # noqa: E501

        :return: The announcements of this APIConfig.  # noqa: E501
        :rtype: list[APIConfigAnnouncement]
        """
        return self._announcements

    @announcements.setter
    def announcements(self, announcements):
        """Sets the announcements of this APIConfig.

        Public Announcements  # noqa: E501

        :param announcements: The announcements of this APIConfig.  # noqa: E501
        :type announcements: list[APIConfigAnnouncement]
        """
        if self.local_vars_configuration.client_side_validation and announcements is None:  # noqa: E501
            raise ValueError("Invalid value for `announcements`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                announcements is not None and len(announcements) < 0):
            raise ValueError("Invalid value for `announcements`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._announcements = announcements

    @property
    def audio_config(self):
        """Gets the audio_config of this APIConfig.  # noqa: E501


        :return: The audio_config of this APIConfig.  # noqa: E501
        :rtype: APIConfigAudioConfig
        """
        return self._audio_config

    @audio_config.setter
    def audio_config(self, audio_config):
        """Sets the audio_config of this APIConfig.


        :param audio_config: The audio_config of this APIConfig.  # noqa: E501
        :type audio_config: APIConfigAudioConfig
        """

        self._audio_config = audio_config

    @property
    def available_language_codes(self):
        """Gets the available_language_codes of this APIConfig.  # noqa: E501

        List of supported Languages  # noqa: E501

        :return: The available_language_codes of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._available_language_codes

    @available_language_codes.setter
    def available_language_codes(self, available_language_codes):
        """Sets the available_language_codes of this APIConfig.

        List of supported Languages  # noqa: E501

        :param available_language_codes: The available_language_codes of this APIConfig.  # noqa: E501
        :type available_language_codes: list[str]
        """
        if self.local_vars_configuration.client_side_validation and available_language_codes is None:  # noqa: E501
            raise ValueError("Invalid value for `available_language_codes`, must not be `None`")  # noqa: E501

        self._available_language_codes = available_language_codes

    @property
    def available_languages(self):
        """Gets the available_languages of this APIConfig.  # noqa: E501

        List of supported Languages  # noqa: E501

        :return: The available_languages of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._available_languages

    @available_languages.setter
    def available_languages(self, available_languages):
        """Sets the available_languages of this APIConfig.

        List of supported Languages  # noqa: E501

        :param available_languages: The available_languages of this APIConfig.  # noqa: E501
        :type available_languages: list[str]
        """
        if self.local_vars_configuration.client_side_validation and available_languages is None:  # noqa: E501
            raise ValueError("Invalid value for `available_languages`, must not be `None`")  # noqa: E501

        self._available_languages = available_languages

    @property
    def avatar_perf_limiter(self):
        """Gets the avatar_perf_limiter of this APIConfig.  # noqa: E501


        :return: The avatar_perf_limiter of this APIConfig.  # noqa: E501
        :rtype: APIConfigAvatarPerfLimiter
        """
        return self._avatar_perf_limiter

    @avatar_perf_limiter.setter
    def avatar_perf_limiter(self, avatar_perf_limiter):
        """Sets the avatar_perf_limiter of this APIConfig.


        :param avatar_perf_limiter: The avatar_perf_limiter of this APIConfig.  # noqa: E501
        :type avatar_perf_limiter: APIConfigAvatarPerfLimiter
        """
        if self.local_vars_configuration.client_side_validation and avatar_perf_limiter is None:  # noqa: E501
            raise ValueError("Invalid value for `avatar_perf_limiter`, must not be `None`")  # noqa: E501

        self._avatar_perf_limiter = avatar_perf_limiter

    @property
    def chatbox_log_buffer_seconds(self):
        """Gets the chatbox_log_buffer_seconds of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The chatbox_log_buffer_seconds of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._chatbox_log_buffer_seconds

    @chatbox_log_buffer_seconds.setter
    def chatbox_log_buffer_seconds(self, chatbox_log_buffer_seconds):
        """Sets the chatbox_log_buffer_seconds of this APIConfig.

        Unknown  # noqa: E501

        :param chatbox_log_buffer_seconds: The chatbox_log_buffer_seconds of this APIConfig.  # noqa: E501
        :type chatbox_log_buffer_seconds: int
        """
        if self.local_vars_configuration.client_side_validation and chatbox_log_buffer_seconds is None:  # noqa: E501
            raise ValueError("Invalid value for `chatbox_log_buffer_seconds`, must not be `None`")  # noqa: E501

        self._chatbox_log_buffer_seconds = chatbox_log_buffer_seconds

    @property
    def client_api_key(self):
        """Gets the client_api_key of this APIConfig.  # noqa: E501

        apiKey to be used for all other requests  # noqa: E501

        :return: The client_api_key of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._client_api_key

    @client_api_key.setter
    def client_api_key(self, client_api_key):
        """Sets the client_api_key of this APIConfig.

        apiKey to be used for all other requests  # noqa: E501

        :param client_api_key: The client_api_key of this APIConfig.  # noqa: E501
        :type client_api_key: str
        """
        if self.local_vars_configuration.client_side_validation and client_api_key is None:  # noqa: E501
            raise ValueError("Invalid value for `client_api_key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                client_api_key is not None and len(client_api_key) < 1):
            raise ValueError("Invalid value for `client_api_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._client_api_key = client_api_key

    @property
    def client_bps_ceiling(self):
        """Gets the client_bps_ceiling of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_bps_ceiling of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_bps_ceiling

    @client_bps_ceiling.setter
    def client_bps_ceiling(self, client_bps_ceiling):
        """Sets the client_bps_ceiling of this APIConfig.

        Unknown  # noqa: E501

        :param client_bps_ceiling: The client_bps_ceiling of this APIConfig.  # noqa: E501
        :type client_bps_ceiling: int
        """
        if self.local_vars_configuration.client_side_validation and client_bps_ceiling is None:  # noqa: E501
            raise ValueError("Invalid value for `client_bps_ceiling`, must not be `None`")  # noqa: E501

        self._client_bps_ceiling = client_bps_ceiling

    @property
    def client_disconnect_timeout(self):
        """Gets the client_disconnect_timeout of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_disconnect_timeout of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_disconnect_timeout

    @client_disconnect_timeout.setter
    def client_disconnect_timeout(self, client_disconnect_timeout):
        """Sets the client_disconnect_timeout of this APIConfig.

        Unknown  # noqa: E501

        :param client_disconnect_timeout: The client_disconnect_timeout of this APIConfig.  # noqa: E501
        :type client_disconnect_timeout: int
        """
        if self.local_vars_configuration.client_side_validation and client_disconnect_timeout is None:  # noqa: E501
            raise ValueError("Invalid value for `client_disconnect_timeout`, must not be `None`")  # noqa: E501

        self._client_disconnect_timeout = client_disconnect_timeout

    @property
    def client_net_dispatch_thread(self):
        """Gets the client_net_dispatch_thread of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_dispatch_thread of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_dispatch_thread

    @client_net_dispatch_thread.setter
    def client_net_dispatch_thread(self, client_net_dispatch_thread):
        """Sets the client_net_dispatch_thread of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_dispatch_thread: The client_net_dispatch_thread of this APIConfig.  # noqa: E501
        :type client_net_dispatch_thread: bool
        """

        self._client_net_dispatch_thread = client_net_dispatch_thread

    @property
    def client_net_dispatch_thread_mobile(self):
        """Gets the client_net_dispatch_thread_mobile of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_dispatch_thread_mobile of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_dispatch_thread_mobile

    @client_net_dispatch_thread_mobile.setter
    def client_net_dispatch_thread_mobile(self, client_net_dispatch_thread_mobile):
        """Sets the client_net_dispatch_thread_mobile of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_dispatch_thread_mobile: The client_net_dispatch_thread_mobile of this APIConfig.  # noqa: E501
        :type client_net_dispatch_thread_mobile: bool
        """
        if self.local_vars_configuration.client_side_validation and client_net_dispatch_thread_mobile is None:  # noqa: E501
            raise ValueError("Invalid value for `client_net_dispatch_thread_mobile`, must not be `None`")  # noqa: E501

        self._client_net_dispatch_thread_mobile = client_net_dispatch_thread_mobile

    @property
    def client_net_in_thread(self):
        """Gets the client_net_in_thread of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_in_thread of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_in_thread

    @client_net_in_thread.setter
    def client_net_in_thread(self, client_net_in_thread):
        """Sets the client_net_in_thread of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_in_thread: The client_net_in_thread of this APIConfig.  # noqa: E501
        :type client_net_in_thread: bool
        """

        self._client_net_in_thread = client_net_in_thread

    @property
    def client_net_in_thread2(self):
        """Gets the client_net_in_thread2 of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_in_thread2 of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_in_thread2

    @client_net_in_thread2.setter
    def client_net_in_thread2(self, client_net_in_thread2):
        """Sets the client_net_in_thread2 of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_in_thread2: The client_net_in_thread2 of this APIConfig.  # noqa: E501
        :type client_net_in_thread2: bool
        """

        self._client_net_in_thread2 = client_net_in_thread2

    @property
    def client_net_in_thread_mobile(self):
        """Gets the client_net_in_thread_mobile of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_in_thread_mobile of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_in_thread_mobile

    @client_net_in_thread_mobile.setter
    def client_net_in_thread_mobile(self, client_net_in_thread_mobile):
        """Sets the client_net_in_thread_mobile of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_in_thread_mobile: The client_net_in_thread_mobile of this APIConfig.  # noqa: E501
        :type client_net_in_thread_mobile: bool
        """

        self._client_net_in_thread_mobile = client_net_in_thread_mobile

    @property
    def client_net_in_thread_mobile2(self):
        """Gets the client_net_in_thread_mobile2 of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_in_thread_mobile2 of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_in_thread_mobile2

    @client_net_in_thread_mobile2.setter
    def client_net_in_thread_mobile2(self, client_net_in_thread_mobile2):
        """Sets the client_net_in_thread_mobile2 of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_in_thread_mobile2: The client_net_in_thread_mobile2 of this APIConfig.  # noqa: E501
        :type client_net_in_thread_mobile2: bool
        """

        self._client_net_in_thread_mobile2 = client_net_in_thread_mobile2

    @property
    def client_net_out_thread(self):
        """Gets the client_net_out_thread of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_out_thread of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_out_thread

    @client_net_out_thread.setter
    def client_net_out_thread(self, client_net_out_thread):
        """Sets the client_net_out_thread of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_out_thread: The client_net_out_thread of this APIConfig.  # noqa: E501
        :type client_net_out_thread: bool
        """

        self._client_net_out_thread = client_net_out_thread

    @property
    def client_net_out_thread2(self):
        """Gets the client_net_out_thread2 of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_out_thread2 of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_out_thread2

    @client_net_out_thread2.setter
    def client_net_out_thread2(self, client_net_out_thread2):
        """Sets the client_net_out_thread2 of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_out_thread2: The client_net_out_thread2 of this APIConfig.  # noqa: E501
        :type client_net_out_thread2: bool
        """

        self._client_net_out_thread2 = client_net_out_thread2

    @property
    def client_net_out_thread_mobile(self):
        """Gets the client_net_out_thread_mobile of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_out_thread_mobile of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_out_thread_mobile

    @client_net_out_thread_mobile.setter
    def client_net_out_thread_mobile(self, client_net_out_thread_mobile):
        """Sets the client_net_out_thread_mobile of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_out_thread_mobile: The client_net_out_thread_mobile of this APIConfig.  # noqa: E501
        :type client_net_out_thread_mobile: bool
        """

        self._client_net_out_thread_mobile = client_net_out_thread_mobile

    @property
    def client_net_out_thread_mobile2(self):
        """Gets the client_net_out_thread_mobile2 of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_net_out_thread_mobile2 of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._client_net_out_thread_mobile2

    @client_net_out_thread_mobile2.setter
    def client_net_out_thread_mobile2(self, client_net_out_thread_mobile2):
        """Sets the client_net_out_thread_mobile2 of this APIConfig.

        Unknown  # noqa: E501

        :param client_net_out_thread_mobile2: The client_net_out_thread_mobile2 of this APIConfig.  # noqa: E501
        :type client_net_out_thread_mobile2: bool
        """

        self._client_net_out_thread_mobile2 = client_net_out_thread_mobile2

    @property
    def client_qr(self):
        """Gets the client_qr of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_qr of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_qr

    @client_qr.setter
    def client_qr(self, client_qr):
        """Sets the client_qr of this APIConfig.

        Unknown  # noqa: E501

        :param client_qr: The client_qr of this APIConfig.  # noqa: E501
        :type client_qr: int
        """

        self._client_qr = client_qr

    @property
    def client_reserved_player_bps(self):
        """Gets the client_reserved_player_bps of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_reserved_player_bps of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_reserved_player_bps

    @client_reserved_player_bps.setter
    def client_reserved_player_bps(self, client_reserved_player_bps):
        """Sets the client_reserved_player_bps of this APIConfig.

        Unknown  # noqa: E501

        :param client_reserved_player_bps: The client_reserved_player_bps of this APIConfig.  # noqa: E501
        :type client_reserved_player_bps: int
        """
        if self.local_vars_configuration.client_side_validation and client_reserved_player_bps is None:  # noqa: E501
            raise ValueError("Invalid value for `client_reserved_player_bps`, must not be `None`")  # noqa: E501

        self._client_reserved_player_bps = client_reserved_player_bps

    @property
    def client_sent_count_allowance(self):
        """Gets the client_sent_count_allowance of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The client_sent_count_allowance of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._client_sent_count_allowance

    @client_sent_count_allowance.setter
    def client_sent_count_allowance(self, client_sent_count_allowance):
        """Sets the client_sent_count_allowance of this APIConfig.

        Unknown  # noqa: E501

        :param client_sent_count_allowance: The client_sent_count_allowance of this APIConfig.  # noqa: E501
        :type client_sent_count_allowance: int
        """
        if self.local_vars_configuration.client_side_validation and client_sent_count_allowance is None:  # noqa: E501
            raise ValueError("Invalid value for `client_sent_count_allowance`, must not be `None`")  # noqa: E501

        self._client_sent_count_allowance = client_sent_count_allowance

    @property
    def constants(self):
        """Gets the constants of this APIConfig.  # noqa: E501


        :return: The constants of this APIConfig.  # noqa: E501
        :rtype: APIConfigConstants
        """
        return self._constants

    @constants.setter
    def constants(self, constants):
        """Sets the constants of this APIConfig.


        :param constants: The constants of this APIConfig.  # noqa: E501
        :type constants: APIConfigConstants
        """
        if self.local_vars_configuration.client_side_validation and constants is None:  # noqa: E501
            raise ValueError("Invalid value for `constants`, must not be `None`")  # noqa: E501

        self._constants = constants

    @property
    def contact_email(self):
        """Gets the contact_email of this APIConfig.  # noqa: E501

        VRChat's contact email  # noqa: E501

        :return: The contact_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._contact_email

    @contact_email.setter
    def contact_email(self, contact_email):
        """Sets the contact_email of this APIConfig.

        VRChat's contact email  # noqa: E501

        :param contact_email: The contact_email of this APIConfig.  # noqa: E501
        :type contact_email: str
        """
        if self.local_vars_configuration.client_side_validation and contact_email is None:  # noqa: E501
            raise ValueError("Invalid value for `contact_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                contact_email is not None and len(contact_email) < 1):
            raise ValueError("Invalid value for `contact_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._contact_email = contact_email

    @property
    def copyright_email(self):
        """Gets the copyright_email of this APIConfig.  # noqa: E501

        VRChat's copyright-issues-related email  # noqa: E501

        :return: The copyright_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._copyright_email

    @copyright_email.setter
    def copyright_email(self, copyright_email):
        """Sets the copyright_email of this APIConfig.

        VRChat's copyright-issues-related email  # noqa: E501

        :param copyright_email: The copyright_email of this APIConfig.  # noqa: E501
        :type copyright_email: str
        """
        if self.local_vars_configuration.client_side_validation and copyright_email is None:  # noqa: E501
            raise ValueError("Invalid value for `copyright_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                copyright_email is not None and len(copyright_email) < 1):
            raise ValueError("Invalid value for `copyright_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._copyright_email = copyright_email

    @property
    def copyright_form_url(self):
        """Gets the copyright_form_url of this APIConfig.  # noqa: E501

        VRChat's DMCA claim webform url  # noqa: E501

        :return: The copyright_form_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._copyright_form_url

    @copyright_form_url.setter
    def copyright_form_url(self, copyright_form_url):
        """Sets the copyright_form_url of this APIConfig.

        VRChat's DMCA claim webform url  # noqa: E501

        :param copyright_form_url: The copyright_form_url of this APIConfig.  # noqa: E501
        :type copyright_form_url: str
        """
        if self.local_vars_configuration.client_side_validation and copyright_form_url is None:  # noqa: E501
            raise ValueError("Invalid value for `copyright_form_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                copyright_form_url is not None and len(copyright_form_url) < 1):
            raise ValueError("Invalid value for `copyright_form_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._copyright_form_url = copyright_form_url

    @property
    def current_privacy_version(self):
        """Gets the current_privacy_version of this APIConfig.  # noqa: E501

        Current version number of the Privacy Agreement  # noqa: E501

        :return: The current_privacy_version of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._current_privacy_version

    @current_privacy_version.setter
    def current_privacy_version(self, current_privacy_version):
        """Sets the current_privacy_version of this APIConfig.

        Current version number of the Privacy Agreement  # noqa: E501

        :param current_privacy_version: The current_privacy_version of this APIConfig.  # noqa: E501
        :type current_privacy_version: int
        """
        if self.local_vars_configuration.client_side_validation and current_privacy_version is None:  # noqa: E501
            raise ValueError("Invalid value for `current_privacy_version`, must not be `None`")  # noqa: E501

        self._current_privacy_version = current_privacy_version

    @property
    def current_tos_version(self):
        """Gets the current_tos_version of this APIConfig.  # noqa: E501

        Current version number of the Terms of Service  # noqa: E501

        :return: The current_tos_version of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._current_tos_version

    @current_tos_version.setter
    def current_tos_version(self, current_tos_version):
        """Sets the current_tos_version of this APIConfig.

        Current version number of the Terms of Service  # noqa: E501

        :param current_tos_version: The current_tos_version of this APIConfig.  # noqa: E501
        :type current_tos_version: int
        """
        if self.local_vars_configuration.client_side_validation and current_tos_version is None:  # noqa: E501
            raise ValueError("Invalid value for `current_tos_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                current_tos_version is not None and current_tos_version < 0):  # noqa: E501
            raise ValueError("Invalid value for `current_tos_version`, must be a value greater than or equal to `0`")  # noqa: E501

        self._current_tos_version = current_tos_version

    @property
    def default_avatar(self):
        """Gets the default_avatar of this APIConfig.  # noqa: E501


        :return: The default_avatar of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._default_avatar

    @default_avatar.setter
    def default_avatar(self, default_avatar):
        """Sets the default_avatar of this APIConfig.


        :param default_avatar: The default_avatar of this APIConfig.  # noqa: E501
        :type default_avatar: str
        """
        if self.local_vars_configuration.client_side_validation and default_avatar is None:  # noqa: E501
            raise ValueError("Invalid value for `default_avatar`, must not be `None`")  # noqa: E501

        self._default_avatar = default_avatar

    @property
    def default_sticker_set(self):
        """Gets the default_sticker_set of this APIConfig.  # noqa: E501


        :return: The default_sticker_set of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._default_sticker_set

    @default_sticker_set.setter
    def default_sticker_set(self, default_sticker_set):
        """Sets the default_sticker_set of this APIConfig.


        :param default_sticker_set: The default_sticker_set of this APIConfig.  # noqa: E501
        :type default_sticker_set: str
        """
        if self.local_vars_configuration.client_side_validation and default_sticker_set is None:  # noqa: E501
            raise ValueError("Invalid value for `default_sticker_set`, must not be `None`")  # noqa: E501

        self._default_sticker_set = default_sticker_set

    @property
    def dev_language_codes(self):
        """Gets the dev_language_codes of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The dev_language_codes of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._dev_language_codes

    @dev_language_codes.setter
    def dev_language_codes(self, dev_language_codes):
        """Sets the dev_language_codes of this APIConfig.

        Unknown  # noqa: E501

        :param dev_language_codes: The dev_language_codes of this APIConfig.  # noqa: E501
        :type dev_language_codes: list[str]
        """

        self._dev_language_codes = dev_language_codes

    @property
    def dev_sdk_url(self):
        """Gets the dev_sdk_url of this APIConfig.  # noqa: E501

        Link to download the development SDK, use downloadUrls instead  # noqa: E501

        :return: The dev_sdk_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._dev_sdk_url

    @dev_sdk_url.setter
    def dev_sdk_url(self, dev_sdk_url):
        """Sets the dev_sdk_url of this APIConfig.

        Link to download the development SDK, use downloadUrls instead  # noqa: E501

        :param dev_sdk_url: The dev_sdk_url of this APIConfig.  # noqa: E501
        :type dev_sdk_url: str
        """
        if self.local_vars_configuration.client_side_validation and dev_sdk_url is None:  # noqa: E501
            raise ValueError("Invalid value for `dev_sdk_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dev_sdk_url is not None and len(dev_sdk_url) < 1):
            raise ValueError("Invalid value for `dev_sdk_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._dev_sdk_url = dev_sdk_url

    @property
    def dev_sdk_version(self):
        """Gets the dev_sdk_version of this APIConfig.  # noqa: E501

        Version of the development SDK  # noqa: E501

        :return: The dev_sdk_version of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._dev_sdk_version

    @dev_sdk_version.setter
    def dev_sdk_version(self, dev_sdk_version):
        """Sets the dev_sdk_version of this APIConfig.

        Version of the development SDK  # noqa: E501

        :param dev_sdk_version: The dev_sdk_version of this APIConfig.  # noqa: E501
        :type dev_sdk_version: str
        """
        if self.local_vars_configuration.client_side_validation and dev_sdk_version is None:  # noqa: E501
            raise ValueError("Invalid value for `dev_sdk_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dev_sdk_version is not None and len(dev_sdk_version) < 1):
            raise ValueError("Invalid value for `dev_sdk_version`, length must be greater than or equal to `1`")  # noqa: E501

        self._dev_sdk_version = dev_sdk_version

    @property
    def dis_countdown(self):
        """Gets the dis_countdown of this APIConfig.  # noqa: E501

        Unknown, \"dis\" maybe for disconnect?  # noqa: E501

        :return: The dis_countdown of this APIConfig.  # noqa: E501
        :rtype: datetime
        """
        return self._dis_countdown

    @dis_countdown.setter
    def dis_countdown(self, dis_countdown):
        """Sets the dis_countdown of this APIConfig.

        Unknown, \"dis\" maybe for disconnect?  # noqa: E501

        :param dis_countdown: The dis_countdown of this APIConfig.  # noqa: E501
        :type dis_countdown: datetime
        """
        if self.local_vars_configuration.client_side_validation and dis_countdown is None:  # noqa: E501
            raise ValueError("Invalid value for `dis_countdown`, must not be `None`")  # noqa: E501

        self._dis_countdown = dis_countdown

    @property
    def disable_av_pro_in_proton(self):
        """Gets the disable_av_pro_in_proton of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The disable_av_pro_in_proton of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_av_pro_in_proton

    @disable_av_pro_in_proton.setter
    def disable_av_pro_in_proton(self, disable_av_pro_in_proton):
        """Sets the disable_av_pro_in_proton of this APIConfig.

        Unknown  # noqa: E501

        :param disable_av_pro_in_proton: The disable_av_pro_in_proton of this APIConfig.  # noqa: E501
        :type disable_av_pro_in_proton: bool
        """

        self._disable_av_pro_in_proton = disable_av_pro_in_proton

    @property
    def disable_avatar_copying(self):
        """Gets the disable_avatar_copying of this APIConfig.  # noqa: E501

        Toggles if copying avatars should be disabled  # noqa: E501

        :return: The disable_avatar_copying of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_avatar_copying

    @disable_avatar_copying.setter
    def disable_avatar_copying(self, disable_avatar_copying):
        """Sets the disable_avatar_copying of this APIConfig.

        Toggles if copying avatars should be disabled  # noqa: E501

        :param disable_avatar_copying: The disable_avatar_copying of this APIConfig.  # noqa: E501
        :type disable_avatar_copying: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_avatar_copying is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_avatar_copying`, must not be `None`")  # noqa: E501

        self._disable_avatar_copying = disable_avatar_copying

    @property
    def disable_avatar_gating(self):
        """Gets the disable_avatar_gating of this APIConfig.  # noqa: E501

        Toggles if avatar gating should be disabled. Avatar gating restricts uploading of avatars to people with the `system_avatar_access` Tag or `admin_avatar_access` Tag  # noqa: E501

        :return: The disable_avatar_gating of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_avatar_gating

    @disable_avatar_gating.setter
    def disable_avatar_gating(self, disable_avatar_gating):
        """Sets the disable_avatar_gating of this APIConfig.

        Toggles if avatar gating should be disabled. Avatar gating restricts uploading of avatars to people with the `system_avatar_access` Tag or `admin_avatar_access` Tag  # noqa: E501

        :param disable_avatar_gating: The disable_avatar_gating of this APIConfig.  # noqa: E501
        :type disable_avatar_gating: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_avatar_gating is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_avatar_gating`, must not be `None`")  # noqa: E501

        self._disable_avatar_gating = disable_avatar_gating

    @property
    def disable_captcha(self):
        """Gets the disable_captcha of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The disable_captcha of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_captcha

    @disable_captcha.setter
    def disable_captcha(self, disable_captcha):
        """Sets the disable_captcha of this APIConfig.

        Unknown  # noqa: E501

        :param disable_captcha: The disable_captcha of this APIConfig.  # noqa: E501
        :type disable_captcha: bool
        """

        self._disable_captcha = disable_captcha

    @property
    def disable_community_labs(self):
        """Gets the disable_community_labs of this APIConfig.  # noqa: E501

        Toggles if the Community Labs should be disabled  # noqa: E501

        :return: The disable_community_labs of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_community_labs

    @disable_community_labs.setter
    def disable_community_labs(self, disable_community_labs):
        """Sets the disable_community_labs of this APIConfig.

        Toggles if the Community Labs should be disabled  # noqa: E501

        :param disable_community_labs: The disable_community_labs of this APIConfig.  # noqa: E501
        :type disable_community_labs: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_community_labs is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_community_labs`, must not be `None`")  # noqa: E501

        self._disable_community_labs = disable_community_labs

    @property
    def disable_community_labs_promotion(self):
        """Gets the disable_community_labs_promotion of this APIConfig.  # noqa: E501

        Toggles if promotion out of Community Labs should be disabled  # noqa: E501

        :return: The disable_community_labs_promotion of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_community_labs_promotion

    @disable_community_labs_promotion.setter
    def disable_community_labs_promotion(self, disable_community_labs_promotion):
        """Sets the disable_community_labs_promotion of this APIConfig.

        Toggles if promotion out of Community Labs should be disabled  # noqa: E501

        :param disable_community_labs_promotion: The disable_community_labs_promotion of this APIConfig.  # noqa: E501
        :type disable_community_labs_promotion: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_community_labs_promotion is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_community_labs_promotion`, must not be `None`")  # noqa: E501

        self._disable_community_labs_promotion = disable_community_labs_promotion

    @property
    def disable_email(self):
        """Gets the disable_email of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The disable_email of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_email

    @disable_email.setter
    def disable_email(self, disable_email):
        """Sets the disable_email of this APIConfig.

        Unknown  # noqa: E501

        :param disable_email: The disable_email of this APIConfig.  # noqa: E501
        :type disable_email: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_email is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_email`, must not be `None`")  # noqa: E501

        self._disable_email = disable_email

    @property
    def disable_event_stream(self):
        """Gets the disable_event_stream of this APIConfig.  # noqa: E501

        Toggles if Analytics should be disabled.  # noqa: E501

        :return: The disable_event_stream of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_event_stream

    @disable_event_stream.setter
    def disable_event_stream(self, disable_event_stream):
        """Sets the disable_event_stream of this APIConfig.

        Toggles if Analytics should be disabled.  # noqa: E501

        :param disable_event_stream: The disable_event_stream of this APIConfig.  # noqa: E501
        :type disable_event_stream: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_event_stream is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_event_stream`, must not be `None`")  # noqa: E501

        self._disable_event_stream = disable_event_stream

    @property
    def disable_feedback_gating(self):
        """Gets the disable_feedback_gating of this APIConfig.  # noqa: E501

        Toggles if feedback gating should be disabled. Feedback gating restricts submission of feedback (reporting a World or User) to people with the `system_feedback_access` Tag.  # noqa: E501

        :return: The disable_feedback_gating of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_feedback_gating

    @disable_feedback_gating.setter
    def disable_feedback_gating(self, disable_feedback_gating):
        """Sets the disable_feedback_gating of this APIConfig.

        Toggles if feedback gating should be disabled. Feedback gating restricts submission of feedback (reporting a World or User) to people with the `system_feedback_access` Tag.  # noqa: E501

        :param disable_feedback_gating: The disable_feedback_gating of this APIConfig.  # noqa: E501
        :type disable_feedback_gating: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_feedback_gating is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_feedback_gating`, must not be `None`")  # noqa: E501

        self._disable_feedback_gating = disable_feedback_gating

    @property
    def disable_frontend_builds(self):
        """Gets the disable_frontend_builds of this APIConfig.  # noqa: E501

        Unknown, probably toggles compilation of frontend web builds? So internal flag?  # noqa: E501

        :return: The disable_frontend_builds of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_frontend_builds

    @disable_frontend_builds.setter
    def disable_frontend_builds(self, disable_frontend_builds):
        """Sets the disable_frontend_builds of this APIConfig.

        Unknown, probably toggles compilation of frontend web builds? So internal flag?  # noqa: E501

        :param disable_frontend_builds: The disable_frontend_builds of this APIConfig.  # noqa: E501
        :type disable_frontend_builds: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_frontend_builds is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_frontend_builds`, must not be `None`")  # noqa: E501

        self._disable_frontend_builds = disable_frontend_builds

    @property
    def disable_gift_drops(self):
        """Gets the disable_gift_drops of this APIConfig.  # noqa: E501

        Toggles if gift drops should be disabled  # noqa: E501

        :return: The disable_gift_drops of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_gift_drops

    @disable_gift_drops.setter
    def disable_gift_drops(self, disable_gift_drops):
        """Sets the disable_gift_drops of this APIConfig.

        Toggles if gift drops should be disabled  # noqa: E501

        :param disable_gift_drops: The disable_gift_drops of this APIConfig.  # noqa: E501
        :type disable_gift_drops: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_gift_drops is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_gift_drops`, must not be `None`")  # noqa: E501

        self._disable_gift_drops = disable_gift_drops

    @property
    def disable_hello(self):
        """Gets the disable_hello of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The disable_hello of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_hello

    @disable_hello.setter
    def disable_hello(self, disable_hello):
        """Sets the disable_hello of this APIConfig.

        Unknown  # noqa: E501

        :param disable_hello: The disable_hello of this APIConfig.  # noqa: E501
        :type disable_hello: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_hello is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_hello`, must not be `None`")  # noqa: E501

        self._disable_hello = disable_hello

    @property
    def disable_oculus_subs(self):
        """Gets the disable_oculus_subs of this APIConfig.  # noqa: E501

        Toggles if signing up for Subscriptions in Oculus is disabled or not.  # noqa: E501

        :return: The disable_oculus_subs of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_oculus_subs

    @disable_oculus_subs.setter
    def disable_oculus_subs(self, disable_oculus_subs):
        """Sets the disable_oculus_subs of this APIConfig.

        Toggles if signing up for Subscriptions in Oculus is disabled or not.  # noqa: E501

        :param disable_oculus_subs: The disable_oculus_subs of this APIConfig.  # noqa: E501
        :type disable_oculus_subs: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_oculus_subs is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_oculus_subs`, must not be `None`")  # noqa: E501

        self._disable_oculus_subs = disable_oculus_subs

    @property
    def disable_registration(self):
        """Gets the disable_registration of this APIConfig.  # noqa: E501

        Toggles if new user account registration should be disabled.  # noqa: E501

        :return: The disable_registration of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_registration

    @disable_registration.setter
    def disable_registration(self, disable_registration):
        """Sets the disable_registration of this APIConfig.

        Toggles if new user account registration should be disabled.  # noqa: E501

        :param disable_registration: The disable_registration of this APIConfig.  # noqa: E501
        :type disable_registration: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_registration is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_registration`, must not be `None`")  # noqa: E501

        self._disable_registration = disable_registration

    @property
    def disable_steam_networking(self):
        """Gets the disable_steam_networking of this APIConfig.  # noqa: E501

        Toggles if Steam Networking should be disabled. VRChat these days uses Photon Unity Networking (PUN) instead.  # noqa: E501

        :return: The disable_steam_networking of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_steam_networking

    @disable_steam_networking.setter
    def disable_steam_networking(self, disable_steam_networking):
        """Sets the disable_steam_networking of this APIConfig.

        Toggles if Steam Networking should be disabled. VRChat these days uses Photon Unity Networking (PUN) instead.  # noqa: E501

        :param disable_steam_networking: The disable_steam_networking of this APIConfig.  # noqa: E501
        :type disable_steam_networking: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_steam_networking is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_steam_networking`, must not be `None`")  # noqa: E501

        self._disable_steam_networking = disable_steam_networking

    @property
    def disable_two_factor_auth(self):
        """Gets the disable_two_factor_auth of this APIConfig.  # noqa: E501

        Toggles if 2FA should be disabled.  # noqa: E501

        :return: The disable_two_factor_auth of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_two_factor_auth

    @disable_two_factor_auth.setter
    def disable_two_factor_auth(self, disable_two_factor_auth):
        """Sets the disable_two_factor_auth of this APIConfig.

        Toggles if 2FA should be disabled.  # noqa: E501

        :param disable_two_factor_auth: The disable_two_factor_auth of this APIConfig.  # noqa: E501
        :type disable_two_factor_auth: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_two_factor_auth is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_two_factor_auth`, must not be `None`")  # noqa: E501

        self._disable_two_factor_auth = disable_two_factor_auth

    @property
    def disable_udon(self):
        """Gets the disable_udon of this APIConfig.  # noqa: E501

        Toggles if Udon should be universally disabled in-game.  # noqa: E501

        :return: The disable_udon of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_udon

    @disable_udon.setter
    def disable_udon(self, disable_udon):
        """Sets the disable_udon of this APIConfig.

        Toggles if Udon should be universally disabled in-game.  # noqa: E501

        :param disable_udon: The disable_udon of this APIConfig.  # noqa: E501
        :type disable_udon: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_udon is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_udon`, must not be `None`")  # noqa: E501

        self._disable_udon = disable_udon

    @property
    def disable_upgrade_account(self):
        """Gets the disable_upgrade_account of this APIConfig.  # noqa: E501

        Toggles if account upgrading \"linking with Steam/Oculus\" should be disabled.  # noqa: E501

        :return: The disable_upgrade_account of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_upgrade_account

    @disable_upgrade_account.setter
    def disable_upgrade_account(self, disable_upgrade_account):
        """Sets the disable_upgrade_account of this APIConfig.

        Toggles if account upgrading \"linking with Steam/Oculus\" should be disabled.  # noqa: E501

        :param disable_upgrade_account: The disable_upgrade_account of this APIConfig.  # noqa: E501
        :type disable_upgrade_account: bool
        """
        if self.local_vars_configuration.client_side_validation and disable_upgrade_account is None:  # noqa: E501
            raise ValueError("Invalid value for `disable_upgrade_account`, must not be `None`")  # noqa: E501

        self._disable_upgrade_account = disable_upgrade_account

    @property
    def download_link_windows(self):
        """Gets the download_link_windows of this APIConfig.  # noqa: E501

        Download link for game on the Oculus Rift website.  # noqa: E501

        :return: The download_link_windows of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._download_link_windows

    @download_link_windows.setter
    def download_link_windows(self, download_link_windows):
        """Sets the download_link_windows of this APIConfig.

        Download link for game on the Oculus Rift website.  # noqa: E501

        :param download_link_windows: The download_link_windows of this APIConfig.  # noqa: E501
        :type download_link_windows: str
        """
        if self.local_vars_configuration.client_side_validation and download_link_windows is None:  # noqa: E501
            raise ValueError("Invalid value for `download_link_windows`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                download_link_windows is not None and len(download_link_windows) < 1):
            raise ValueError("Invalid value for `download_link_windows`, length must be greater than or equal to `1`")  # noqa: E501

        self._download_link_windows = download_link_windows

    @property
    def download_urls(self):
        """Gets the download_urls of this APIConfig.  # noqa: E501


        :return: The download_urls of this APIConfig.  # noqa: E501
        :rtype: APIConfigDownloadURLList
        """
        return self._download_urls

    @download_urls.setter
    def download_urls(self, download_urls):
        """Sets the download_urls of this APIConfig.


        :param download_urls: The download_urls of this APIConfig.  # noqa: E501
        :type download_urls: APIConfigDownloadURLList
        """
        if self.local_vars_configuration.client_side_validation and download_urls is None:  # noqa: E501
            raise ValueError("Invalid value for `download_urls`, must not be `None`")  # noqa: E501

        self._download_urls = download_urls

    @property
    def dynamic_world_rows(self):
        """Gets the dynamic_world_rows of this APIConfig.  # noqa: E501

        Array of DynamicWorldRow objects, used by the game to display the list of world rows  # noqa: E501

        :return: The dynamic_world_rows of this APIConfig.  # noqa: E501
        :rtype: list[DynamicContentRow]
        """
        return self._dynamic_world_rows

    @dynamic_world_rows.setter
    def dynamic_world_rows(self, dynamic_world_rows):
        """Sets the dynamic_world_rows of this APIConfig.

        Array of DynamicWorldRow objects, used by the game to display the list of world rows  # noqa: E501

        :param dynamic_world_rows: The dynamic_world_rows of this APIConfig.  # noqa: E501
        :type dynamic_world_rows: list[DynamicContentRow]
        """
        if self.local_vars_configuration.client_side_validation and dynamic_world_rows is None:  # noqa: E501
            raise ValueError("Invalid value for `dynamic_world_rows`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                dynamic_world_rows is not None and len(dynamic_world_rows) < 1):
            raise ValueError("Invalid value for `dynamic_world_rows`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._dynamic_world_rows = dynamic_world_rows

    @property
    def economy_ledger_backfill(self):
        """Gets the economy_ledger_backfill of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The economy_ledger_backfill of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._economy_ledger_backfill

    @economy_ledger_backfill.setter
    def economy_ledger_backfill(self, economy_ledger_backfill):
        """Sets the economy_ledger_backfill of this APIConfig.

        Unknown  # noqa: E501

        :param economy_ledger_backfill: The economy_ledger_backfill of this APIConfig.  # noqa: E501
        :type economy_ledger_backfill: bool
        """
        if self.local_vars_configuration.client_side_validation and economy_ledger_backfill is None:  # noqa: E501
            raise ValueError("Invalid value for `economy_ledger_backfill`, must not be `None`")  # noqa: E501

        self._economy_ledger_backfill = economy_ledger_backfill

    @property
    def economy_ledger_migration_stop(self):
        """Gets the economy_ledger_migration_stop of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The economy_ledger_migration_stop of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._economy_ledger_migration_stop

    @economy_ledger_migration_stop.setter
    def economy_ledger_migration_stop(self, economy_ledger_migration_stop):
        """Sets the economy_ledger_migration_stop of this APIConfig.

        Unknown  # noqa: E501

        :param economy_ledger_migration_stop: The economy_ledger_migration_stop of this APIConfig.  # noqa: E501
        :type economy_ledger_migration_stop: str
        """
        if self.local_vars_configuration.client_side_validation and economy_ledger_migration_stop is None:  # noqa: E501
            raise ValueError("Invalid value for `economy_ledger_migration_stop`, must not be `None`")  # noqa: E501

        self._economy_ledger_migration_stop = economy_ledger_migration_stop

    @property
    def economy_ledger_mode(self):
        """Gets the economy_ledger_mode of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The economy_ledger_mode of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._economy_ledger_mode

    @economy_ledger_mode.setter
    def economy_ledger_mode(self, economy_ledger_mode):
        """Sets the economy_ledger_mode of this APIConfig.

        Unknown  # noqa: E501

        :param economy_ledger_mode: The economy_ledger_mode of this APIConfig.  # noqa: E501
        :type economy_ledger_mode: str
        """
        if self.local_vars_configuration.client_side_validation and economy_ledger_mode is None:  # noqa: E501
            raise ValueError("Invalid value for `economy_ledger_mode`, must not be `None`")  # noqa: E501

        self._economy_ledger_mode = economy_ledger_mode

    @property
    def economy_pause_end(self):
        """Gets the economy_pause_end of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The economy_pause_end of this APIConfig.  # noqa: E501
        :rtype: datetime
        """
        return self._economy_pause_end

    @economy_pause_end.setter
    def economy_pause_end(self, economy_pause_end):
        """Sets the economy_pause_end of this APIConfig.

        Unknown  # noqa: E501

        :param economy_pause_end: The economy_pause_end of this APIConfig.  # noqa: E501
        :type economy_pause_end: datetime
        """
        if self.local_vars_configuration.client_side_validation and economy_pause_end is None:  # noqa: E501
            raise ValueError("Invalid value for `economy_pause_end`, must not be `None`")  # noqa: E501

        self._economy_pause_end = economy_pause_end

    @property
    def economy_pause_start(self):
        """Gets the economy_pause_start of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The economy_pause_start of this APIConfig.  # noqa: E501
        :rtype: datetime
        """
        return self._economy_pause_start

    @economy_pause_start.setter
    def economy_pause_start(self, economy_pause_start):
        """Sets the economy_pause_start of this APIConfig.

        Unknown  # noqa: E501

        :param economy_pause_start: The economy_pause_start of this APIConfig.  # noqa: E501
        :type economy_pause_start: datetime
        """
        if self.local_vars_configuration.client_side_validation and economy_pause_start is None:  # noqa: E501
            raise ValueError("Invalid value for `economy_pause_start`, must not be `None`")  # noqa: E501

        self._economy_pause_start = economy_pause_start

    @property
    def economy_purchase_repair_enabled(self):
        """Gets the economy_purchase_repair_enabled of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The economy_purchase_repair_enabled of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._economy_purchase_repair_enabled

    @economy_purchase_repair_enabled.setter
    def economy_purchase_repair_enabled(self, economy_purchase_repair_enabled):
        """Sets the economy_purchase_repair_enabled of this APIConfig.

        Unknown  # noqa: E501

        :param economy_purchase_repair_enabled: The economy_purchase_repair_enabled of this APIConfig.  # noqa: E501
        :type economy_purchase_repair_enabled: bool
        """
        if self.local_vars_configuration.client_side_validation and economy_purchase_repair_enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `economy_purchase_repair_enabled`, must not be `None`")  # noqa: E501

        self._economy_purchase_repair_enabled = economy_purchase_repair_enabled

    @property
    def economy_state(self):
        """Gets the economy_state of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The economy_state of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._economy_state

    @economy_state.setter
    def economy_state(self, economy_state):
        """Sets the economy_state of this APIConfig.

        Unknown  # noqa: E501

        :param economy_state: The economy_state of this APIConfig.  # noqa: E501
        :type economy_state: int
        """
        if self.local_vars_configuration.client_side_validation and economy_state is None:  # noqa: E501
            raise ValueError("Invalid value for `economy_state`, must not be `None`")  # noqa: E501

        self._economy_state = economy_state

    @property
    def events(self):
        """Gets the events of this APIConfig.  # noqa: E501


        :return: The events of this APIConfig.  # noqa: E501
        :rtype: APIConfigEvents
        """
        return self._events

    @events.setter
    def events(self, events):
        """Sets the events of this APIConfig.


        :param events: The events of this APIConfig.  # noqa: E501
        :type events: APIConfigEvents
        """
        if self.local_vars_configuration.client_side_validation and events is None:  # noqa: E501
            raise ValueError("Invalid value for `events`, must not be `None`")  # noqa: E501

        self._events = events

    @property
    def force_use_latest_world(self):
        """Gets the force_use_latest_world of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The force_use_latest_world of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._force_use_latest_world

    @force_use_latest_world.setter
    def force_use_latest_world(self, force_use_latest_world):
        """Sets the force_use_latest_world of this APIConfig.

        Unknown  # noqa: E501

        :param force_use_latest_world: The force_use_latest_world of this APIConfig.  # noqa: E501
        :type force_use_latest_world: bool
        """
        if self.local_vars_configuration.client_side_validation and force_use_latest_world is None:  # noqa: E501
            raise ValueError("Invalid value for `force_use_latest_world`, must not be `None`")  # noqa: E501

        self._force_use_latest_world = force_use_latest_world

    @property
    def gift_display_type(self):
        """Gets the gift_display_type of this APIConfig.  # noqa: E501

        Display type of gifts  # noqa: E501

        :return: The gift_display_type of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._gift_display_type

    @gift_display_type.setter
    def gift_display_type(self, gift_display_type):
        """Sets the gift_display_type of this APIConfig.

        Display type of gifts  # noqa: E501

        :param gift_display_type: The gift_display_type of this APIConfig.  # noqa: E501
        :type gift_display_type: str
        """
        if self.local_vars_configuration.client_side_validation and gift_display_type is None:  # noqa: E501
            raise ValueError("Invalid value for `gift_display_type`, must not be `None`")  # noqa: E501

        self._gift_display_type = gift_display_type

    @property
    def google_api_client_id(self):
        """Gets the google_api_client_id of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The google_api_client_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._google_api_client_id

    @google_api_client_id.setter
    def google_api_client_id(self, google_api_client_id):
        """Sets the google_api_client_id of this APIConfig.

        Unknown  # noqa: E501

        :param google_api_client_id: The google_api_client_id of this APIConfig.  # noqa: E501
        :type google_api_client_id: str
        """
        if self.local_vars_configuration.client_side_validation and google_api_client_id is None:  # noqa: E501
            raise ValueError("Invalid value for `google_api_client_id`, must not be `None`")  # noqa: E501

        self._google_api_client_id = google_api_client_id

    @property
    def home_world_id(self):
        """Gets the home_world_id of this APIConfig.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The home_world_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._home_world_id

    @home_world_id.setter
    def home_world_id(self, home_world_id):
        """Sets the home_world_id of this APIConfig.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param home_world_id: The home_world_id of this APIConfig.  # noqa: E501
        :type home_world_id: str
        """
        if self.local_vars_configuration.client_side_validation and home_world_id is None:  # noqa: E501
            raise ValueError("Invalid value for `home_world_id`, must not be `None`")  # noqa: E501

        self._home_world_id = home_world_id

    @property
    def homepage_redirect_target(self):
        """Gets the homepage_redirect_target of this APIConfig.  # noqa: E501

        Redirect target if you try to open the base API domain in your browser  # noqa: E501

        :return: The homepage_redirect_target of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._homepage_redirect_target

    @homepage_redirect_target.setter
    def homepage_redirect_target(self, homepage_redirect_target):
        """Sets the homepage_redirect_target of this APIConfig.

        Redirect target if you try to open the base API domain in your browser  # noqa: E501

        :param homepage_redirect_target: The homepage_redirect_target of this APIConfig.  # noqa: E501
        :type homepage_redirect_target: str
        """
        if self.local_vars_configuration.client_side_validation and homepage_redirect_target is None:  # noqa: E501
            raise ValueError("Invalid value for `homepage_redirect_target`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                homepage_redirect_target is not None and len(homepage_redirect_target) < 1):
            raise ValueError("Invalid value for `homepage_redirect_target`, length must be greater than or equal to `1`")  # noqa: E501

        self._homepage_redirect_target = homepage_redirect_target

    @property
    def hub_world_id(self):
        """Gets the hub_world_id of this APIConfig.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The hub_world_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._hub_world_id

    @hub_world_id.setter
    def hub_world_id(self, hub_world_id):
        """Sets the hub_world_id of this APIConfig.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param hub_world_id: The hub_world_id of this APIConfig.  # noqa: E501
        :type hub_world_id: str
        """
        if self.local_vars_configuration.client_side_validation and hub_world_id is None:  # noqa: E501
            raise ValueError("Invalid value for `hub_world_id`, must not be `None`")  # noqa: E501

        self._hub_world_id = hub_world_id

    @property
    def image_host_url_list(self):
        """Gets the image_host_url_list of this APIConfig.  # noqa: E501

        A list of explicitly allowed origins that worlds can request images from via the Udon's [VRCImageDownloader#DownloadImage](https://creators.vrchat.com/worlds/udon/image-loading/#downloadimage).  # noqa: E501

        :return: The image_host_url_list of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._image_host_url_list

    @image_host_url_list.setter
    def image_host_url_list(self, image_host_url_list):
        """Sets the image_host_url_list of this APIConfig.

        A list of explicitly allowed origins that worlds can request images from via the Udon's [VRCImageDownloader#DownloadImage](https://creators.vrchat.com/worlds/udon/image-loading/#downloadimage).  # noqa: E501

        :param image_host_url_list: The image_host_url_list of this APIConfig.  # noqa: E501
        :type image_host_url_list: list[str]
        """
        if self.local_vars_configuration.client_side_validation and image_host_url_list is None:  # noqa: E501
            raise ValueError("Invalid value for `image_host_url_list`, must not be `None`")  # noqa: E501

        self._image_host_url_list = image_host_url_list

    @property
    def ios_app_version(self):
        """Gets the ios_app_version of this APIConfig.  # noqa: E501

        Current app version for iOS  # noqa: E501

        :return: The ios_app_version of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._ios_app_version

    @ios_app_version.setter
    def ios_app_version(self, ios_app_version):
        """Sets the ios_app_version of this APIConfig.

        Current app version for iOS  # noqa: E501

        :param ios_app_version: The ios_app_version of this APIConfig.  # noqa: E501
        :type ios_app_version: list[str]
        """
        if self.local_vars_configuration.client_side_validation and ios_app_version is None:  # noqa: E501
            raise ValueError("Invalid value for `ios_app_version`, must not be `None`")  # noqa: E501

        self._ios_app_version = ios_app_version

    @property
    def ios_version(self):
        """Gets the ios_version of this APIConfig.  # noqa: E501


        :return: The ios_version of this APIConfig.  # noqa: E501
        :rtype: APIConfigIosVersion
        """
        return self._ios_version

    @ios_version.setter
    def ios_version(self, ios_version):
        """Sets the ios_version of this APIConfig.


        :param ios_version: The ios_version of this APIConfig.  # noqa: E501
        :type ios_version: APIConfigIosVersion
        """
        if self.local_vars_configuration.client_side_validation and ios_version is None:  # noqa: E501
            raise ValueError("Invalid value for `ios_version`, must not be `None`")  # noqa: E501

        self._ios_version = ios_version

    @property
    def jobs_email(self):
        """Gets the jobs_email of this APIConfig.  # noqa: E501

        VRChat's job application email  # noqa: E501

        :return: The jobs_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._jobs_email

    @jobs_email.setter
    def jobs_email(self, jobs_email):
        """Sets the jobs_email of this APIConfig.

        VRChat's job application email  # noqa: E501

        :param jobs_email: The jobs_email of this APIConfig.  # noqa: E501
        :type jobs_email: str
        """
        if self.local_vars_configuration.client_side_validation and jobs_email is None:  # noqa: E501
            raise ValueError("Invalid value for `jobs_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                jobs_email is not None and len(jobs_email) < 1):
            raise ValueError("Invalid value for `jobs_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._jobs_email = jobs_email

    @property
    def max_user_emoji(self):
        """Gets the max_user_emoji of this APIConfig.  # noqa: E501

        The maximum number of custom emoji each user may have at a given time.  # noqa: E501

        :return: The max_user_emoji of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._max_user_emoji

    @max_user_emoji.setter
    def max_user_emoji(self, max_user_emoji):
        """Sets the max_user_emoji of this APIConfig.

        The maximum number of custom emoji each user may have at a given time.  # noqa: E501

        :param max_user_emoji: The max_user_emoji of this APIConfig.  # noqa: E501
        :type max_user_emoji: int
        """
        if self.local_vars_configuration.client_side_validation and max_user_emoji is None:  # noqa: E501
            raise ValueError("Invalid value for `max_user_emoji`, must not be `None`")  # noqa: E501

        self._max_user_emoji = max_user_emoji

    @property
    def max_user_stickers(self):
        """Gets the max_user_stickers of this APIConfig.  # noqa: E501

        The maximum number of custom stickers each user may have at a given time.  # noqa: E501

        :return: The max_user_stickers of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._max_user_stickers

    @max_user_stickers.setter
    def max_user_stickers(self, max_user_stickers):
        """Sets the max_user_stickers of this APIConfig.

        The maximum number of custom stickers each user may have at a given time.  # noqa: E501

        :param max_user_stickers: The max_user_stickers of this APIConfig.  # noqa: E501
        :type max_user_stickers: int
        """
        if self.local_vars_configuration.client_side_validation and max_user_stickers is None:  # noqa: E501
            raise ValueError("Invalid value for `max_user_stickers`, must not be `None`")  # noqa: E501

        self._max_user_stickers = max_user_stickers

    @property
    def min_supported_client_build_number(self):
        """Gets the min_supported_client_build_number of this APIConfig.  # noqa: E501


        :return: The min_supported_client_build_number of this APIConfig.  # noqa: E501
        :rtype: APIConfigMinSupportedClientBuildNumber
        """
        return self._min_supported_client_build_number

    @min_supported_client_build_number.setter
    def min_supported_client_build_number(self, min_supported_client_build_number):
        """Sets the min_supported_client_build_number of this APIConfig.


        :param min_supported_client_build_number: The min_supported_client_build_number of this APIConfig.  # noqa: E501
        :type min_supported_client_build_number: APIConfigMinSupportedClientBuildNumber
        """
        if self.local_vars_configuration.client_side_validation and min_supported_client_build_number is None:  # noqa: E501
            raise ValueError("Invalid value for `min_supported_client_build_number`, must not be `None`")  # noqa: E501

        self._min_supported_client_build_number = min_supported_client_build_number

    @property
    def minimum_unity_version_for_uploads(self):
        """Gets the minimum_unity_version_for_uploads of this APIConfig.  # noqa: E501

        Minimum Unity version required for uploading assets  # noqa: E501

        :return: The minimum_unity_version_for_uploads of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._minimum_unity_version_for_uploads

    @minimum_unity_version_for_uploads.setter
    def minimum_unity_version_for_uploads(self, minimum_unity_version_for_uploads):
        """Sets the minimum_unity_version_for_uploads of this APIConfig.

        Minimum Unity version required for uploading assets  # noqa: E501

        :param minimum_unity_version_for_uploads: The minimum_unity_version_for_uploads of this APIConfig.  # noqa: E501
        :type minimum_unity_version_for_uploads: str
        """
        if self.local_vars_configuration.client_side_validation and minimum_unity_version_for_uploads is None:  # noqa: E501
            raise ValueError("Invalid value for `minimum_unity_version_for_uploads`, must not be `None`")  # noqa: E501

        self._minimum_unity_version_for_uploads = minimum_unity_version_for_uploads

    @property
    def moderation_email(self):
        """Gets the moderation_email of this APIConfig.  # noqa: E501

        VRChat's moderation related email  # noqa: E501

        :return: The moderation_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._moderation_email

    @moderation_email.setter
    def moderation_email(self, moderation_email):
        """Sets the moderation_email of this APIConfig.

        VRChat's moderation related email  # noqa: E501

        :param moderation_email: The moderation_email of this APIConfig.  # noqa: E501
        :type moderation_email: str
        """
        if self.local_vars_configuration.client_side_validation and moderation_email is None:  # noqa: E501
            raise ValueError("Invalid value for `moderation_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                moderation_email is not None and len(moderation_email) < 1):
            raise ValueError("Invalid value for `moderation_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._moderation_email = moderation_email

    @property
    def not_allowed_to_select_avatar_in_private_world_message(self):
        """Gets the not_allowed_to_select_avatar_in_private_world_message of this APIConfig.  # noqa: E501

        Used in-game to notify a user they aren't allowed to select avatars in private worlds  # noqa: E501

        :return: The not_allowed_to_select_avatar_in_private_world_message of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._not_allowed_to_select_avatar_in_private_world_message

    @not_allowed_to_select_avatar_in_private_world_message.setter
    def not_allowed_to_select_avatar_in_private_world_message(self, not_allowed_to_select_avatar_in_private_world_message):
        """Sets the not_allowed_to_select_avatar_in_private_world_message of this APIConfig.

        Used in-game to notify a user they aren't allowed to select avatars in private worlds  # noqa: E501

        :param not_allowed_to_select_avatar_in_private_world_message: The not_allowed_to_select_avatar_in_private_world_message of this APIConfig.  # noqa: E501
        :type not_allowed_to_select_avatar_in_private_world_message: str
        """
        if self.local_vars_configuration.client_side_validation and not_allowed_to_select_avatar_in_private_world_message is None:  # noqa: E501
            raise ValueError("Invalid value for `not_allowed_to_select_avatar_in_private_world_message`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not_allowed_to_select_avatar_in_private_world_message is not None and len(not_allowed_to_select_avatar_in_private_world_message) < 1):
            raise ValueError("Invalid value for `not_allowed_to_select_avatar_in_private_world_message`, length must be greater than or equal to `1`")  # noqa: E501

        self._not_allowed_to_select_avatar_in_private_world_message = not_allowed_to_select_avatar_in_private_world_message

    @property
    def offline_analysis(self):
        """Gets the offline_analysis of this APIConfig.  # noqa: E501


        :return: The offline_analysis of this APIConfig.  # noqa: E501
        :rtype: APIConfigOfflineAnalysis
        """
        return self._offline_analysis

    @offline_analysis.setter
    def offline_analysis(self, offline_analysis):
        """Sets the offline_analysis of this APIConfig.


        :param offline_analysis: The offline_analysis of this APIConfig.  # noqa: E501
        :type offline_analysis: APIConfigOfflineAnalysis
        """
        if self.local_vars_configuration.client_side_validation and offline_analysis is None:  # noqa: E501
            raise ValueError("Invalid value for `offline_analysis`, must not be `None`")  # noqa: E501

        self._offline_analysis = offline_analysis

    @property
    def photon_nameserver_overrides(self):
        """Gets the photon_nameserver_overrides of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The photon_nameserver_overrides of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._photon_nameserver_overrides

    @photon_nameserver_overrides.setter
    def photon_nameserver_overrides(self, photon_nameserver_overrides):
        """Sets the photon_nameserver_overrides of this APIConfig.

        Unknown  # noqa: E501

        :param photon_nameserver_overrides: The photon_nameserver_overrides of this APIConfig.  # noqa: E501
        :type photon_nameserver_overrides: list[str]
        """
        if self.local_vars_configuration.client_side_validation and photon_nameserver_overrides is None:  # noqa: E501
            raise ValueError("Invalid value for `photon_nameserver_overrides`, must not be `None`")  # noqa: E501

        self._photon_nameserver_overrides = photon_nameserver_overrides

    @property
    def photon_public_keys(self):
        """Gets the photon_public_keys of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The photon_public_keys of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._photon_public_keys

    @photon_public_keys.setter
    def photon_public_keys(self, photon_public_keys):
        """Sets the photon_public_keys of this APIConfig.

        Unknown  # noqa: E501

        :param photon_public_keys: The photon_public_keys of this APIConfig.  # noqa: E501
        :type photon_public_keys: list[str]
        """
        if self.local_vars_configuration.client_side_validation and photon_public_keys is None:  # noqa: E501
            raise ValueError("Invalid value for `photon_public_keys`, must not be `None`")  # noqa: E501

        self._photon_public_keys = photon_public_keys

    @property
    def player_url_resolver_sha1(self):
        """Gets the player_url_resolver_sha1 of this APIConfig.  # noqa: E501

        Currently used youtube-dl.exe hash in SHA1-delimited format  # noqa: E501

        :return: The player_url_resolver_sha1 of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._player_url_resolver_sha1

    @player_url_resolver_sha1.setter
    def player_url_resolver_sha1(self, player_url_resolver_sha1):
        """Sets the player_url_resolver_sha1 of this APIConfig.

        Currently used youtube-dl.exe hash in SHA1-delimited format  # noqa: E501

        :param player_url_resolver_sha1: The player_url_resolver_sha1 of this APIConfig.  # noqa: E501
        :type player_url_resolver_sha1: str
        """
        if self.local_vars_configuration.client_side_validation and player_url_resolver_sha1 is None:  # noqa: E501
            raise ValueError("Invalid value for `player_url_resolver_sha1`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                player_url_resolver_sha1 is not None and len(player_url_resolver_sha1) < 1):
            raise ValueError("Invalid value for `player_url_resolver_sha1`, length must be greater than or equal to `1`")  # noqa: E501

        self._player_url_resolver_sha1 = player_url_resolver_sha1

    @property
    def player_url_resolver_version(self):
        """Gets the player_url_resolver_version of this APIConfig.  # noqa: E501

        Currently used youtube-dl.exe version  # noqa: E501

        :return: The player_url_resolver_version of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._player_url_resolver_version

    @player_url_resolver_version.setter
    def player_url_resolver_version(self, player_url_resolver_version):
        """Sets the player_url_resolver_version of this APIConfig.

        Currently used youtube-dl.exe version  # noqa: E501

        :param player_url_resolver_version: The player_url_resolver_version of this APIConfig.  # noqa: E501
        :type player_url_resolver_version: str
        """
        if self.local_vars_configuration.client_side_validation and player_url_resolver_version is None:  # noqa: E501
            raise ValueError("Invalid value for `player_url_resolver_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                player_url_resolver_version is not None and len(player_url_resolver_version) < 1):
            raise ValueError("Invalid value for `player_url_resolver_version`, length must be greater than or equal to `1`")  # noqa: E501

        self._player_url_resolver_version = player_url_resolver_version

    @property
    def public_key(self):
        """Gets the public_key of this APIConfig.  # noqa: E501

        Public key, hex encoded  # noqa: E501

        :return: The public_key of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._public_key

    @public_key.setter
    def public_key(self, public_key):
        """Sets the public_key of this APIConfig.

        Public key, hex encoded  # noqa: E501

        :param public_key: The public_key of this APIConfig.  # noqa: E501
        :type public_key: str
        """
        if self.local_vars_configuration.client_side_validation and public_key is None:  # noqa: E501
            raise ValueError("Invalid value for `public_key`, must not be `None`")  # noqa: E501

        self._public_key = public_key

    @property
    def report_categories(self):
        """Gets the report_categories of this APIConfig.  # noqa: E501

        Categories available for reporting objectionable content  # noqa: E501

        :return: The report_categories of this APIConfig.  # noqa: E501
        :rtype: dict(str, ReportCategory)
        """
        return self._report_categories

    @report_categories.setter
    def report_categories(self, report_categories):
        """Sets the report_categories of this APIConfig.

        Categories available for reporting objectionable content  # noqa: E501

        :param report_categories: The report_categories of this APIConfig.  # noqa: E501
        :type report_categories: dict(str, ReportCategory)
        """
        if self.local_vars_configuration.client_side_validation and report_categories is None:  # noqa: E501
            raise ValueError("Invalid value for `report_categories`, must not be `None`")  # noqa: E501

        self._report_categories = report_categories

    @property
    def report_form_url(self):
        """Gets the report_form_url of this APIConfig.  # noqa: E501

        URL to the report form  # noqa: E501

        :return: The report_form_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._report_form_url

    @report_form_url.setter
    def report_form_url(self, report_form_url):
        """Sets the report_form_url of this APIConfig.

        URL to the report form  # noqa: E501

        :param report_form_url: The report_form_url of this APIConfig.  # noqa: E501
        :type report_form_url: str
        """
        if self.local_vars_configuration.client_side_validation and report_form_url is None:  # noqa: E501
            raise ValueError("Invalid value for `report_form_url`, must not be `None`")  # noqa: E501

        self._report_form_url = report_form_url

    @property
    def report_options(self):
        """Gets the report_options of this APIConfig.  # noqa: E501

        Options for reporting content. Select a key+value from this mapping as the `type` of the report. Select one key+value from the object at reportOptions[type] as the `category` of the report. reportCategories[category] contains user-facing text to display for all possible categories. Select one value from the array at reportOptions[type][category] as the `reason` of the report. reportReasons[reason] contains user-facing text to display for all possible categories.  # noqa: E501

        :return: The report_options of this APIConfig.  # noqa: E501
        :rtype: dict(str, dict(str, list[str]))
        """
        return self._report_options

    @report_options.setter
    def report_options(self, report_options):
        """Sets the report_options of this APIConfig.

        Options for reporting content. Select a key+value from this mapping as the `type` of the report. Select one key+value from the object at reportOptions[type] as the `category` of the report. reportCategories[category] contains user-facing text to display for all possible categories. Select one value from the array at reportOptions[type][category] as the `reason` of the report. reportReasons[reason] contains user-facing text to display for all possible categories.  # noqa: E501

        :param report_options: The report_options of this APIConfig.  # noqa: E501
        :type report_options: dict(str, dict(str, list[str]))
        """
        if self.local_vars_configuration.client_side_validation and report_options is None:  # noqa: E501
            raise ValueError("Invalid value for `report_options`, must not be `None`")  # noqa: E501

        self._report_options = report_options

    @property
    def report_reasons(self):
        """Gets the report_reasons of this APIConfig.  # noqa: E501

        Reasons available for submitting a report  # noqa: E501

        :return: The report_reasons of this APIConfig.  # noqa: E501
        :rtype: dict(str, ReportReason)
        """
        return self._report_reasons

    @report_reasons.setter
    def report_reasons(self, report_reasons):
        """Sets the report_reasons of this APIConfig.

        Reasons available for submitting a report  # noqa: E501

        :param report_reasons: The report_reasons of this APIConfig.  # noqa: E501
        :type report_reasons: dict(str, ReportReason)
        """
        if self.local_vars_configuration.client_side_validation and report_reasons is None:  # noqa: E501
            raise ValueError("Invalid value for `report_reasons`, must not be `None`")  # noqa: E501

        self._report_reasons = report_reasons

    @property
    def require_age_verification_beta_tag(self):
        """Gets the require_age_verification_beta_tag of this APIConfig.  # noqa: E501


        :return: The require_age_verification_beta_tag of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._require_age_verification_beta_tag

    @require_age_verification_beta_tag.setter
    def require_age_verification_beta_tag(self, require_age_verification_beta_tag):
        """Sets the require_age_verification_beta_tag of this APIConfig.


        :param require_age_verification_beta_tag: The require_age_verification_beta_tag of this APIConfig.  # noqa: E501
        :type require_age_verification_beta_tag: bool
        """
        if self.local_vars_configuration.client_side_validation and require_age_verification_beta_tag is None:  # noqa: E501
            raise ValueError("Invalid value for `require_age_verification_beta_tag`, must not be `None`")  # noqa: E501

        self._require_age_verification_beta_tag = require_age_verification_beta_tag

    @property
    def sdk_developer_faq_url(self):
        """Gets the sdk_developer_faq_url of this APIConfig.  # noqa: E501

        Link to the developer FAQ  # noqa: E501

        :return: The sdk_developer_faq_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._sdk_developer_faq_url

    @sdk_developer_faq_url.setter
    def sdk_developer_faq_url(self, sdk_developer_faq_url):
        """Sets the sdk_developer_faq_url of this APIConfig.

        Link to the developer FAQ  # noqa: E501

        :param sdk_developer_faq_url: The sdk_developer_faq_url of this APIConfig.  # noqa: E501
        :type sdk_developer_faq_url: str
        """
        if self.local_vars_configuration.client_side_validation and sdk_developer_faq_url is None:  # noqa: E501
            raise ValueError("Invalid value for `sdk_developer_faq_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                sdk_developer_faq_url is not None and len(sdk_developer_faq_url) < 1):
            raise ValueError("Invalid value for `sdk_developer_faq_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._sdk_developer_faq_url = sdk_developer_faq_url

    @property
    def sdk_discord_url(self):
        """Gets the sdk_discord_url of this APIConfig.  # noqa: E501

        Link to the official VRChat Discord  # noqa: E501

        :return: The sdk_discord_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._sdk_discord_url

    @sdk_discord_url.setter
    def sdk_discord_url(self, sdk_discord_url):
        """Sets the sdk_discord_url of this APIConfig.

        Link to the official VRChat Discord  # noqa: E501

        :param sdk_discord_url: The sdk_discord_url of this APIConfig.  # noqa: E501
        :type sdk_discord_url: str
        """
        if self.local_vars_configuration.client_side_validation and sdk_discord_url is None:  # noqa: E501
            raise ValueError("Invalid value for `sdk_discord_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                sdk_discord_url is not None and len(sdk_discord_url) < 1):
            raise ValueError("Invalid value for `sdk_discord_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._sdk_discord_url = sdk_discord_url

    @property
    def sdk_not_allowed_to_publish_message(self):
        """Gets the sdk_not_allowed_to_publish_message of this APIConfig.  # noqa: E501

        Used in the SDK to notify a user they aren't allowed to upload avatars/worlds yet  # noqa: E501

        :return: The sdk_not_allowed_to_publish_message of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._sdk_not_allowed_to_publish_message

    @sdk_not_allowed_to_publish_message.setter
    def sdk_not_allowed_to_publish_message(self, sdk_not_allowed_to_publish_message):
        """Sets the sdk_not_allowed_to_publish_message of this APIConfig.

        Used in the SDK to notify a user they aren't allowed to upload avatars/worlds yet  # noqa: E501

        :param sdk_not_allowed_to_publish_message: The sdk_not_allowed_to_publish_message of this APIConfig.  # noqa: E501
        :type sdk_not_allowed_to_publish_message: str
        """
        if self.local_vars_configuration.client_side_validation and sdk_not_allowed_to_publish_message is None:  # noqa: E501
            raise ValueError("Invalid value for `sdk_not_allowed_to_publish_message`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                sdk_not_allowed_to_publish_message is not None and len(sdk_not_allowed_to_publish_message) < 1):
            raise ValueError("Invalid value for `sdk_not_allowed_to_publish_message`, length must be greater than or equal to `1`")  # noqa: E501

        self._sdk_not_allowed_to_publish_message = sdk_not_allowed_to_publish_message

    @property
    def sdk_unity_version(self):
        """Gets the sdk_unity_version of this APIConfig.  # noqa: E501

        Unity version supported by the SDK  # noqa: E501

        :return: The sdk_unity_version of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._sdk_unity_version

    @sdk_unity_version.setter
    def sdk_unity_version(self, sdk_unity_version):
        """Sets the sdk_unity_version of this APIConfig.

        Unity version supported by the SDK  # noqa: E501

        :param sdk_unity_version: The sdk_unity_version of this APIConfig.  # noqa: E501
        :type sdk_unity_version: str
        """
        if self.local_vars_configuration.client_side_validation and sdk_unity_version is None:  # noqa: E501
            raise ValueError("Invalid value for `sdk_unity_version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                sdk_unity_version is not None and len(sdk_unity_version) < 1):
            raise ValueError("Invalid value for `sdk_unity_version`, length must be greater than or equal to `1`")  # noqa: E501

        self._sdk_unity_version = sdk_unity_version

    @property
    def string_host_url_list(self):
        """Gets the string_host_url_list of this APIConfig.  # noqa: E501

        A list of explicitly allowed origins that worlds can request strings from via the Udon's [VRCStringDownloader.LoadUrl](https://creators.vrchat.com/worlds/udon/string-loading/#ivrcstringdownload).  # noqa: E501

        :return: The string_host_url_list of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._string_host_url_list

    @string_host_url_list.setter
    def string_host_url_list(self, string_host_url_list):
        """Sets the string_host_url_list of this APIConfig.

        A list of explicitly allowed origins that worlds can request strings from via the Udon's [VRCStringDownloader.LoadUrl](https://creators.vrchat.com/worlds/udon/string-loading/#ivrcstringdownload).  # noqa: E501

        :param string_host_url_list: The string_host_url_list of this APIConfig.  # noqa: E501
        :type string_host_url_list: list[str]
        """
        if self.local_vars_configuration.client_side_validation and string_host_url_list is None:  # noqa: E501
            raise ValueError("Invalid value for `string_host_url_list`, must not be `None`")  # noqa: E501

        self._string_host_url_list = string_host_url_list

    @property
    def support_email(self):
        """Gets the support_email of this APIConfig.  # noqa: E501

        VRChat's support email  # noqa: E501

        :return: The support_email of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._support_email

    @support_email.setter
    def support_email(self, support_email):
        """Sets the support_email of this APIConfig.

        VRChat's support email  # noqa: E501

        :param support_email: The support_email of this APIConfig.  # noqa: E501
        :type support_email: str
        """
        if self.local_vars_configuration.client_side_validation and support_email is None:  # noqa: E501
            raise ValueError("Invalid value for `support_email`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                support_email is not None and len(support_email) < 1):
            raise ValueError("Invalid value for `support_email`, length must be greater than or equal to `1`")  # noqa: E501

        self._support_email = support_email

    @property
    def support_form_url(self):
        """Gets the support_form_url of this APIConfig.  # noqa: E501

        VRChat's support form  # noqa: E501

        :return: The support_form_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._support_form_url

    @support_form_url.setter
    def support_form_url(self, support_form_url):
        """Sets the support_form_url of this APIConfig.

        VRChat's support form  # noqa: E501

        :param support_form_url: The support_form_url of this APIConfig.  # noqa: E501
        :type support_form_url: str
        """
        if self.local_vars_configuration.client_side_validation and support_form_url is None:  # noqa: E501
            raise ValueError("Invalid value for `support_form_url`, must not be `None`")  # noqa: E501

        self._support_form_url = support_form_url

    @property
    def time_out_world_id(self):
        """Gets the time_out_world_id of this APIConfig.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The time_out_world_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._time_out_world_id

    @time_out_world_id.setter
    def time_out_world_id(self, time_out_world_id):
        """Sets the time_out_world_id of this APIConfig.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param time_out_world_id: The time_out_world_id of this APIConfig.  # noqa: E501
        :type time_out_world_id: str
        """
        if self.local_vars_configuration.client_side_validation and time_out_world_id is None:  # noqa: E501
            raise ValueError("Invalid value for `time_out_world_id`, must not be `None`")  # noqa: E501

        self._time_out_world_id = time_out_world_id

    @property
    def timekeeping(self):
        """Gets the timekeeping of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The timekeeping of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._timekeeping

    @timekeeping.setter
    def timekeeping(self, timekeeping):
        """Sets the timekeeping of this APIConfig.

        Unknown  # noqa: E501

        :param timekeeping: The timekeeping of this APIConfig.  # noqa: E501
        :type timekeeping: bool
        """
        if self.local_vars_configuration.client_side_validation and timekeeping is None:  # noqa: E501
            raise ValueError("Invalid value for `timekeeping`, must not be `None`")  # noqa: E501

        self._timekeeping = timekeeping

    @property
    def tutorial_world_id(self):
        """Gets the tutorial_world_id of this APIConfig.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The tutorial_world_id of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._tutorial_world_id

    @tutorial_world_id.setter
    def tutorial_world_id(self, tutorial_world_id):
        """Sets the tutorial_world_id of this APIConfig.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param tutorial_world_id: The tutorial_world_id of this APIConfig.  # noqa: E501
        :type tutorial_world_id: str
        """
        if self.local_vars_configuration.client_side_validation and tutorial_world_id is None:  # noqa: E501
            raise ValueError("Invalid value for `tutorial_world_id`, must not be `None`")  # noqa: E501

        self._tutorial_world_id = tutorial_world_id

    @property
    def update_rate_ms_maximum(self):
        """Gets the update_rate_ms_maximum of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The update_rate_ms_maximum of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._update_rate_ms_maximum

    @update_rate_ms_maximum.setter
    def update_rate_ms_maximum(self, update_rate_ms_maximum):
        """Sets the update_rate_ms_maximum of this APIConfig.

        Unknown  # noqa: E501

        :param update_rate_ms_maximum: The update_rate_ms_maximum of this APIConfig.  # noqa: E501
        :type update_rate_ms_maximum: int
        """
        if self.local_vars_configuration.client_side_validation and update_rate_ms_maximum is None:  # noqa: E501
            raise ValueError("Invalid value for `update_rate_ms_maximum`, must not be `None`")  # noqa: E501

        self._update_rate_ms_maximum = update_rate_ms_maximum

    @property
    def update_rate_ms_minimum(self):
        """Gets the update_rate_ms_minimum of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The update_rate_ms_minimum of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._update_rate_ms_minimum

    @update_rate_ms_minimum.setter
    def update_rate_ms_minimum(self, update_rate_ms_minimum):
        """Sets the update_rate_ms_minimum of this APIConfig.

        Unknown  # noqa: E501

        :param update_rate_ms_minimum: The update_rate_ms_minimum of this APIConfig.  # noqa: E501
        :type update_rate_ms_minimum: int
        """
        if self.local_vars_configuration.client_side_validation and update_rate_ms_minimum is None:  # noqa: E501
            raise ValueError("Invalid value for `update_rate_ms_minimum`, must not be `None`")  # noqa: E501

        self._update_rate_ms_minimum = update_rate_ms_minimum

    @property
    def update_rate_ms_normal(self):
        """Gets the update_rate_ms_normal of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The update_rate_ms_normal of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._update_rate_ms_normal

    @update_rate_ms_normal.setter
    def update_rate_ms_normal(self, update_rate_ms_normal):
        """Sets the update_rate_ms_normal of this APIConfig.

        Unknown  # noqa: E501

        :param update_rate_ms_normal: The update_rate_ms_normal of this APIConfig.  # noqa: E501
        :type update_rate_ms_normal: int
        """
        if self.local_vars_configuration.client_side_validation and update_rate_ms_normal is None:  # noqa: E501
            raise ValueError("Invalid value for `update_rate_ms_normal`, must not be `None`")  # noqa: E501

        self._update_rate_ms_normal = update_rate_ms_normal

    @property
    def update_rate_ms_udon_manual(self):
        """Gets the update_rate_ms_udon_manual of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The update_rate_ms_udon_manual of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._update_rate_ms_udon_manual

    @update_rate_ms_udon_manual.setter
    def update_rate_ms_udon_manual(self, update_rate_ms_udon_manual):
        """Sets the update_rate_ms_udon_manual of this APIConfig.

        Unknown  # noqa: E501

        :param update_rate_ms_udon_manual: The update_rate_ms_udon_manual of this APIConfig.  # noqa: E501
        :type update_rate_ms_udon_manual: int
        """
        if self.local_vars_configuration.client_side_validation and update_rate_ms_udon_manual is None:  # noqa: E501
            raise ValueError("Invalid value for `update_rate_ms_udon_manual`, must not be `None`")  # noqa: E501

        self._update_rate_ms_udon_manual = update_rate_ms_udon_manual

    @property
    def upload_analysis_percent(self):
        """Gets the upload_analysis_percent of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The upload_analysis_percent of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._upload_analysis_percent

    @upload_analysis_percent.setter
    def upload_analysis_percent(self, upload_analysis_percent):
        """Sets the upload_analysis_percent of this APIConfig.

        Unknown  # noqa: E501

        :param upload_analysis_percent: The upload_analysis_percent of this APIConfig.  # noqa: E501
        :type upload_analysis_percent: int
        """
        if self.local_vars_configuration.client_side_validation and upload_analysis_percent is None:  # noqa: E501
            raise ValueError("Invalid value for `upload_analysis_percent`, must not be `None`")  # noqa: E501

        self._upload_analysis_percent = upload_analysis_percent

    @property
    def url_list(self):
        """Gets the url_list of this APIConfig.  # noqa: E501

        List of allowed URLs that bypass the \"Allow untrusted URL's\" setting in-game  # noqa: E501

        :return: The url_list of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._url_list

    @url_list.setter
    def url_list(self, url_list):
        """Sets the url_list of this APIConfig.

        List of allowed URLs that bypass the \"Allow untrusted URL's\" setting in-game  # noqa: E501

        :param url_list: The url_list of this APIConfig.  # noqa: E501
        :type url_list: list[str]
        """
        if self.local_vars_configuration.client_side_validation and url_list is None:  # noqa: E501
            raise ValueError("Invalid value for `url_list`, must not be `None`")  # noqa: E501

        self._url_list = url_list

    @property
    def use_reliable_udp_for_voice(self):
        """Gets the use_reliable_udp_for_voice of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The use_reliable_udp_for_voice of this APIConfig.  # noqa: E501
        :rtype: bool
        """
        return self._use_reliable_udp_for_voice

    @use_reliable_udp_for_voice.setter
    def use_reliable_udp_for_voice(self, use_reliable_udp_for_voice):
        """Sets the use_reliable_udp_for_voice of this APIConfig.

        Unknown  # noqa: E501

        :param use_reliable_udp_for_voice: The use_reliable_udp_for_voice of this APIConfig.  # noqa: E501
        :type use_reliable_udp_for_voice: bool
        """
        if self.local_vars_configuration.client_side_validation and use_reliable_udp_for_voice is None:  # noqa: E501
            raise ValueError("Invalid value for `use_reliable_udp_for_voice`, must not be `None`")  # noqa: E501

        self._use_reliable_udp_for_voice = use_reliable_udp_for_voice

    @property
    def vive_windows_url(self):
        """Gets the vive_windows_url of this APIConfig.  # noqa: E501

        Download link for game on the Steam website.  # noqa: E501

        :return: The vive_windows_url of this APIConfig.  # noqa: E501
        :rtype: str
        """
        return self._vive_windows_url

    @vive_windows_url.setter
    def vive_windows_url(self, vive_windows_url):
        """Sets the vive_windows_url of this APIConfig.

        Download link for game on the Steam website.  # noqa: E501

        :param vive_windows_url: The vive_windows_url of this APIConfig.  # noqa: E501
        :type vive_windows_url: str
        """
        if self.local_vars_configuration.client_side_validation and vive_windows_url is None:  # noqa: E501
            raise ValueError("Invalid value for `vive_windows_url`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                vive_windows_url is not None and len(vive_windows_url) < 1):
            raise ValueError("Invalid value for `vive_windows_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._vive_windows_url = vive_windows_url

    @property
    def websocket_max_friends_refresh_delay(self):
        """Gets the websocket_max_friends_refresh_delay of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The websocket_max_friends_refresh_delay of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._websocket_max_friends_refresh_delay

    @websocket_max_friends_refresh_delay.setter
    def websocket_max_friends_refresh_delay(self, websocket_max_friends_refresh_delay):
        """Sets the websocket_max_friends_refresh_delay of this APIConfig.

        Unknown  # noqa: E501

        :param websocket_max_friends_refresh_delay: The websocket_max_friends_refresh_delay of this APIConfig.  # noqa: E501
        :type websocket_max_friends_refresh_delay: int
        """
        if self.local_vars_configuration.client_side_validation and websocket_max_friends_refresh_delay is None:  # noqa: E501
            raise ValueError("Invalid value for `websocket_max_friends_refresh_delay`, must not be `None`")  # noqa: E501

        self._websocket_max_friends_refresh_delay = websocket_max_friends_refresh_delay

    @property
    def websocket_quick_reconnect_time(self):
        """Gets the websocket_quick_reconnect_time of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The websocket_quick_reconnect_time of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._websocket_quick_reconnect_time

    @websocket_quick_reconnect_time.setter
    def websocket_quick_reconnect_time(self, websocket_quick_reconnect_time):
        """Sets the websocket_quick_reconnect_time of this APIConfig.

        Unknown  # noqa: E501

        :param websocket_quick_reconnect_time: The websocket_quick_reconnect_time of this APIConfig.  # noqa: E501
        :type websocket_quick_reconnect_time: int
        """
        if self.local_vars_configuration.client_side_validation and websocket_quick_reconnect_time is None:  # noqa: E501
            raise ValueError("Invalid value for `websocket_quick_reconnect_time`, must not be `None`")  # noqa: E501

        self._websocket_quick_reconnect_time = websocket_quick_reconnect_time

    @property
    def websocket_reconnect_max_delay(self):
        """Gets the websocket_reconnect_max_delay of this APIConfig.  # noqa: E501

        Unknown  # noqa: E501

        :return: The websocket_reconnect_max_delay of this APIConfig.  # noqa: E501
        :rtype: int
        """
        return self._websocket_reconnect_max_delay

    @websocket_reconnect_max_delay.setter
    def websocket_reconnect_max_delay(self, websocket_reconnect_max_delay):
        """Sets the websocket_reconnect_max_delay of this APIConfig.

        Unknown  # noqa: E501

        :param websocket_reconnect_max_delay: The websocket_reconnect_max_delay of this APIConfig.  # noqa: E501
        :type websocket_reconnect_max_delay: int
        """
        if self.local_vars_configuration.client_side_validation and websocket_reconnect_max_delay is None:  # noqa: E501
            raise ValueError("Invalid value for `websocket_reconnect_max_delay`, must not be `None`")  # noqa: E501

        self._websocket_reconnect_max_delay = websocket_reconnect_max_delay

    @property
    def white_listed_asset_urls(self):
        """Gets the white_listed_asset_urls of this APIConfig.  # noqa: E501

        List of allowed URLs that are allowed to host avatar assets  # noqa: E501

        :return: The white_listed_asset_urls of this APIConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._white_listed_asset_urls

    @white_listed_asset_urls.setter
    def white_listed_asset_urls(self, white_listed_asset_urls):
        """Sets the white_listed_asset_urls of this APIConfig.

        List of allowed URLs that are allowed to host avatar assets  # noqa: E501

        :param white_listed_asset_urls: The white_listed_asset_urls of this APIConfig.  # noqa: E501
        :type white_listed_asset_urls: list[str]
        """
        if self.local_vars_configuration.client_side_validation and white_listed_asset_urls is None:  # noqa: E501
            raise ValueError("Invalid value for `white_listed_asset_urls`, must not be `None`")  # noqa: E501

        self._white_listed_asset_urls = white_listed_asset_urls

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, APIConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, APIConfig):
            return True

        return self.to_dict() != other.to_dict()
