# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.20.7
    Contact: vrchatapi.lpv0t@aries.fyi
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from vrchatapi.configuration import Configuration


class CreatePropRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'asset_url': 'str',
        'asset_version': 'int',
        'description': 'str',
        'id': 'str',
        'image_url': 'str',
        'name': 'str',
        'platform': 'str',
        'prop_signature': 'str',
        'spawn_type': 'int',
        'tags': 'list[str]',
        'unity_version': 'str',
        'world_placement_mask': 'int'
    }

    attribute_map = {
        'asset_url': 'assetUrl',
        'asset_version': 'assetVersion',
        'description': 'description',
        'id': 'id',
        'image_url': 'imageUrl',
        'name': 'name',
        'platform': 'platform',
        'prop_signature': 'propSignature',
        'spawn_type': 'spawnType',
        'tags': 'tags',
        'unity_version': 'unityVersion',
        'world_placement_mask': 'worldPlacementMask'
    }

    def __init__(self, asset_url=None, asset_version=None, description=None, id=None, image_url=None, name=None, platform=None, prop_signature=None, spawn_type=1, tags=None, unity_version=None, world_placement_mask=1, local_vars_configuration=None):  # noqa: E501
        """CreatePropRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._asset_url = None
        self._asset_version = None
        self._description = None
        self._id = None
        self._image_url = None
        self._name = None
        self._platform = None
        self._prop_signature = None
        self._spawn_type = None
        self._tags = None
        self._unity_version = None
        self._world_placement_mask = None
        self.discriminator = None

        self.asset_url = asset_url
        self.asset_version = asset_version
        self.description = description
        self.id = id
        self.image_url = image_url
        self.name = name
        self.platform = platform
        if prop_signature is not None:
            self.prop_signature = prop_signature
        self.spawn_type = spawn_type
        self.tags = tags
        self.unity_version = unity_version
        self.world_placement_mask = world_placement_mask

    @property
    def asset_url(self):
        """Gets the asset_url of this CreatePropRequest.  # noqa: E501


        :return: The asset_url of this CreatePropRequest.  # noqa: E501
        :rtype: str
        """
        return self._asset_url

    @asset_url.setter
    def asset_url(self, asset_url):
        """Sets the asset_url of this CreatePropRequest.


        :param asset_url: The asset_url of this CreatePropRequest.  # noqa: E501
        :type asset_url: str
        """
        if self.local_vars_configuration.client_side_validation and asset_url is None:  # noqa: E501
            raise ValueError("Invalid value for `asset_url`, must not be `None`")  # noqa: E501

        self._asset_url = asset_url

    @property
    def asset_version(self):
        """Gets the asset_version of this CreatePropRequest.  # noqa: E501


        :return: The asset_version of this CreatePropRequest.  # noqa: E501
        :rtype: int
        """
        return self._asset_version

    @asset_version.setter
    def asset_version(self, asset_version):
        """Sets the asset_version of this CreatePropRequest.


        :param asset_version: The asset_version of this CreatePropRequest.  # noqa: E501
        :type asset_version: int
        """
        if self.local_vars_configuration.client_side_validation and asset_version is None:  # noqa: E501
            raise ValueError("Invalid value for `asset_version`, must not be `None`")  # noqa: E501

        self._asset_version = asset_version

    @property
    def description(self):
        """Gets the description of this CreatePropRequest.  # noqa: E501


        :return: The description of this CreatePropRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CreatePropRequest.


        :param description: The description of this CreatePropRequest.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def id(self):
        """Gets the id of this CreatePropRequest.  # noqa: E501


        :return: The id of this CreatePropRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CreatePropRequest.


        :param id: The id of this CreatePropRequest.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def image_url(self):
        """Gets the image_url of this CreatePropRequest.  # noqa: E501


        :return: The image_url of this CreatePropRequest.  # noqa: E501
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """Sets the image_url of this CreatePropRequest.


        :param image_url: The image_url of this CreatePropRequest.  # noqa: E501
        :type image_url: str
        """
        if self.local_vars_configuration.client_side_validation and image_url is None:  # noqa: E501
            raise ValueError("Invalid value for `image_url`, must not be `None`")  # noqa: E501

        self._image_url = image_url

    @property
    def name(self):
        """Gets the name of this CreatePropRequest.  # noqa: E501


        :return: The name of this CreatePropRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreatePropRequest.


        :param name: The name of this CreatePropRequest.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def platform(self):
        """Gets the platform of this CreatePropRequest.  # noqa: E501

        This is normally `android`, `ios`, `standalonewindows`, `web`, or the empty value ``, but also supposedly can be any random Unity version such as `2019.2.4-801-Release` or `2019.2.2-772-Release` or even `unknownplatform`.  # noqa: E501

        :return: The platform of this CreatePropRequest.  # noqa: E501
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this CreatePropRequest.

        This is normally `android`, `ios`, `standalonewindows`, `web`, or the empty value ``, but also supposedly can be any random Unity version such as `2019.2.4-801-Release` or `2019.2.2-772-Release` or even `unknownplatform`.  # noqa: E501

        :param platform: The platform of this CreatePropRequest.  # noqa: E501
        :type platform: str
        """
        if self.local_vars_configuration.client_side_validation and platform is None:  # noqa: E501
            raise ValueError("Invalid value for `platform`, must not be `None`")  # noqa: E501

        self._platform = platform

    @property
    def prop_signature(self):
        """Gets the prop_signature of this CreatePropRequest.  # noqa: E501


        :return: The prop_signature of this CreatePropRequest.  # noqa: E501
        :rtype: str
        """
        return self._prop_signature

    @prop_signature.setter
    def prop_signature(self, prop_signature):
        """Sets the prop_signature of this CreatePropRequest.


        :param prop_signature: The prop_signature of this CreatePropRequest.  # noqa: E501
        :type prop_signature: str
        """

        self._prop_signature = prop_signature

    @property
    def spawn_type(self):
        """Gets the spawn_type of this CreatePropRequest.  # noqa: E501

        How a prop is summoned and interacted with. 0: the prop fixed to some surface in the world 1: the prop is a pickup and may be held by users 2: ???  # noqa: E501

        :return: The spawn_type of this CreatePropRequest.  # noqa: E501
        :rtype: int
        """
        return self._spawn_type

    @spawn_type.setter
    def spawn_type(self, spawn_type):
        """Sets the spawn_type of this CreatePropRequest.

        How a prop is summoned and interacted with. 0: the prop fixed to some surface in the world 1: the prop is a pickup and may be held by users 2: ???  # noqa: E501

        :param spawn_type: The spawn_type of this CreatePropRequest.  # noqa: E501
        :type spawn_type: int
        """
        if self.local_vars_configuration.client_side_validation and spawn_type is None:  # noqa: E501
            raise ValueError("Invalid value for `spawn_type`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                spawn_type is not None and spawn_type < 0):  # noqa: E501
            raise ValueError("Invalid value for `spawn_type`, must be a value greater than or equal to `0`")  # noqa: E501

        self._spawn_type = spawn_type

    @property
    def tags(self):
        """Gets the tags of this CreatePropRequest.  # noqa: E501


        :return: The tags of this CreatePropRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this CreatePropRequest.


        :param tags: The tags of this CreatePropRequest.  # noqa: E501
        :type tags: list[str]
        """
        if self.local_vars_configuration.client_side_validation and tags is None:  # noqa: E501
            raise ValueError("Invalid value for `tags`, must not be `None`")  # noqa: E501

        self._tags = tags

    @property
    def unity_version(self):
        """Gets the unity_version of this CreatePropRequest.  # noqa: E501


        :return: The unity_version of this CreatePropRequest.  # noqa: E501
        :rtype: str
        """
        return self._unity_version

    @unity_version.setter
    def unity_version(self, unity_version):
        """Sets the unity_version of this CreatePropRequest.


        :param unity_version: The unity_version of this CreatePropRequest.  # noqa: E501
        :type unity_version: str
        """
        if self.local_vars_configuration.client_side_validation and unity_version is None:  # noqa: E501
            raise ValueError("Invalid value for `unity_version`, must not be `None`")  # noqa: E501

        self._unity_version = unity_version

    @property
    def world_placement_mask(self):
        """Gets the world_placement_mask of this CreatePropRequest.  # noqa: E501

        Bitmask for restrictions on what world surfaces a prop may be summoned. 0: no restrictions 1: floors 2: walls 4: ceilings  # noqa: E501

        :return: The world_placement_mask of this CreatePropRequest.  # noqa: E501
        :rtype: int
        """
        return self._world_placement_mask

    @world_placement_mask.setter
    def world_placement_mask(self, world_placement_mask):
        """Sets the world_placement_mask of this CreatePropRequest.

        Bitmask for restrictions on what world surfaces a prop may be summoned. 0: no restrictions 1: floors 2: walls 4: ceilings  # noqa: E501

        :param world_placement_mask: The world_placement_mask of this CreatePropRequest.  # noqa: E501
        :type world_placement_mask: int
        """
        if self.local_vars_configuration.client_side_validation and world_placement_mask is None:  # noqa: E501
            raise ValueError("Invalid value for `world_placement_mask`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                world_placement_mask is not None and world_placement_mask < 0):  # noqa: E501
            raise ValueError("Invalid value for `world_placement_mask`, must be a value greater than or equal to `0`")  # noqa: E501

        self._world_placement_mask = world_placement_mask

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreatePropRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreatePropRequest):
            return True

        return self.to_dict() != other.to_dict()
