# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.20.7
    Contact: vrchatapi.lpv0t@aries.fyi
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from vrchatapi.configuration import Configuration


class Store(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'display_name': 'str',
        'group_id': 'str',
        'id': 'str',
        'listing_ids': 'list[str]',
        'listings': 'list[ProductListing]',
        'seller_display_name': 'str',
        'seller_id': 'str',
        'shelf_ids': 'list[str]',
        'shelves': 'list[StoreShelf]',
        'store_id': 'str',
        'store_type': 'StoreType',
        'tags': 'list[str]',
        'world_id': 'str'
    }

    attribute_map = {
        'description': 'description',
        'display_name': 'displayName',
        'group_id': 'groupId',
        'id': 'id',
        'listing_ids': 'listingIds',
        'listings': 'listings',
        'seller_display_name': 'sellerDisplayName',
        'seller_id': 'sellerId',
        'shelf_ids': 'shelfIds',
        'shelves': 'shelves',
        'store_id': 'storeId',
        'store_type': 'storeType',
        'tags': 'tags',
        'world_id': 'worldId'
    }

    def __init__(self, description=None, display_name=None, group_id=None, id=None, listing_ids=None, listings=None, seller_display_name=None, seller_id=None, shelf_ids=None, shelves=None, store_id=None, store_type=None, tags=None, world_id=None, local_vars_configuration=None):  # noqa: E501
        """Store - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._description = None
        self._display_name = None
        self._group_id = None
        self._id = None
        self._listing_ids = None
        self._listings = None
        self._seller_display_name = None
        self._seller_id = None
        self._shelf_ids = None
        self._shelves = None
        self._store_id = None
        self._store_type = None
        self._tags = None
        self._world_id = None
        self.discriminator = None

        self.description = description
        self.display_name = display_name
        if group_id is not None:
            self.group_id = group_id
        self.id = id
        if listing_ids is not None:
            self.listing_ids = listing_ids
        if listings is not None:
            self.listings = listings
        self.seller_display_name = seller_display_name
        self.seller_id = seller_id
        if shelf_ids is not None:
            self.shelf_ids = shelf_ids
        if shelves is not None:
            self.shelves = shelves
        self.store_id = store_id
        self.store_type = store_type
        self.tags = tags
        if world_id is not None:
            self.world_id = world_id

    @property
    def description(self):
        """Gets the description of this Store.  # noqa: E501


        :return: The description of this Store.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Store.


        :param description: The description of this Store.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def display_name(self):
        """Gets the display_name of this Store.  # noqa: E501


        :return: The display_name of this Store.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this Store.


        :param display_name: The display_name of this Store.  # noqa: E501
        :type display_name: str
        """
        if self.local_vars_configuration.client_side_validation and display_name is None:  # noqa: E501
            raise ValueError("Invalid value for `display_name`, must not be `None`")  # noqa: E501

        self._display_name = display_name

    @property
    def group_id(self):
        """Gets the group_id of this Store.  # noqa: E501


        :return: The group_id of this Store.  # noqa: E501
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this Store.


        :param group_id: The group_id of this Store.  # noqa: E501
        :type group_id: str
        """

        self._group_id = group_id

    @property
    def id(self):
        """Gets the id of this Store.  # noqa: E501


        :return: The id of this Store.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Store.


        :param id: The id of this Store.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def listing_ids(self):
        """Gets the listing_ids of this Store.  # noqa: E501

        Only for store type world and group  # noqa: E501

        :return: The listing_ids of this Store.  # noqa: E501
        :rtype: list[str]
        """
        return self._listing_ids

    @listing_ids.setter
    def listing_ids(self, listing_ids):
        """Sets the listing_ids of this Store.

        Only for store type world and group  # noqa: E501

        :param listing_ids: The listing_ids of this Store.  # noqa: E501
        :type listing_ids: list[str]
        """

        self._listing_ids = listing_ids

    @property
    def listings(self):
        """Gets the listings of this Store.  # noqa: E501

        Only for store type world and group  # noqa: E501

        :return: The listings of this Store.  # noqa: E501
        :rtype: list[ProductListing]
        """
        return self._listings

    @listings.setter
    def listings(self, listings):
        """Sets the listings of this Store.

        Only for store type world and group  # noqa: E501

        :param listings: The listings of this Store.  # noqa: E501
        :type listings: list[ProductListing]
        """

        self._listings = listings

    @property
    def seller_display_name(self):
        """Gets the seller_display_name of this Store.  # noqa: E501


        :return: The seller_display_name of this Store.  # noqa: E501
        :rtype: str
        """
        return self._seller_display_name

    @seller_display_name.setter
    def seller_display_name(self, seller_display_name):
        """Sets the seller_display_name of this Store.


        :param seller_display_name: The seller_display_name of this Store.  # noqa: E501
        :type seller_display_name: str
        """
        if self.local_vars_configuration.client_side_validation and seller_display_name is None:  # noqa: E501
            raise ValueError("Invalid value for `seller_display_name`, must not be `None`")  # noqa: E501

        self._seller_display_name = seller_display_name

    @property
    def seller_id(self):
        """Gets the seller_id of this Store.  # noqa: E501

        A users unique ID, usually in the form of `usr_c1644b5b-3ca4-45b4-97c6-a2a0de70d469`. Legacy players can have old IDs in the form of `8JoV9XEdpo`. The ID can never be changed.  # noqa: E501

        :return: The seller_id of this Store.  # noqa: E501
        :rtype: str
        """
        return self._seller_id

    @seller_id.setter
    def seller_id(self, seller_id):
        """Sets the seller_id of this Store.

        A users unique ID, usually in the form of `usr_c1644b5b-3ca4-45b4-97c6-a2a0de70d469`. Legacy players can have old IDs in the form of `8JoV9XEdpo`. The ID can never be changed.  # noqa: E501

        :param seller_id: The seller_id of this Store.  # noqa: E501
        :type seller_id: str
        """
        if self.local_vars_configuration.client_side_validation and seller_id is None:  # noqa: E501
            raise ValueError("Invalid value for `seller_id`, must not be `None`")  # noqa: E501

        self._seller_id = seller_id

    @property
    def shelf_ids(self):
        """Gets the shelf_ids of this Store.  # noqa: E501

        Only for store type house  # noqa: E501

        :return: The shelf_ids of this Store.  # noqa: E501
        :rtype: list[str]
        """
        return self._shelf_ids

    @shelf_ids.setter
    def shelf_ids(self, shelf_ids):
        """Sets the shelf_ids of this Store.

        Only for store type house  # noqa: E501

        :param shelf_ids: The shelf_ids of this Store.  # noqa: E501
        :type shelf_ids: list[str]
        """

        self._shelf_ids = shelf_ids

    @property
    def shelves(self):
        """Gets the shelves of this Store.  # noqa: E501

        Only for store type house  # noqa: E501

        :return: The shelves of this Store.  # noqa: E501
        :rtype: list[StoreShelf]
        """
        return self._shelves

    @shelves.setter
    def shelves(self, shelves):
        """Sets the shelves of this Store.

        Only for store type house  # noqa: E501

        :param shelves: The shelves of this Store.  # noqa: E501
        :type shelves: list[StoreShelf]
        """

        self._shelves = shelves

    @property
    def store_id(self):
        """Gets the store_id of this Store.  # noqa: E501


        :return: The store_id of this Store.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this Store.


        :param store_id: The store_id of this Store.  # noqa: E501
        :type store_id: str
        """
        if self.local_vars_configuration.client_side_validation and store_id is None:  # noqa: E501
            raise ValueError("Invalid value for `store_id`, must not be `None`")  # noqa: E501

        self._store_id = store_id

    @property
    def store_type(self):
        """Gets the store_type of this Store.  # noqa: E501


        :return: The store_type of this Store.  # noqa: E501
        :rtype: StoreType
        """
        return self._store_type

    @store_type.setter
    def store_type(self, store_type):
        """Sets the store_type of this Store.


        :param store_type: The store_type of this Store.  # noqa: E501
        :type store_type: StoreType
        """
        if self.local_vars_configuration.client_side_validation and store_type is None:  # noqa: E501
            raise ValueError("Invalid value for `store_type`, must not be `None`")  # noqa: E501

        self._store_type = store_type

    @property
    def tags(self):
        """Gets the tags of this Store.  # noqa: E501


        :return: The tags of this Store.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Store.


        :param tags: The tags of this Store.  # noqa: E501
        :type tags: list[str]
        """
        if self.local_vars_configuration.client_side_validation and tags is None:  # noqa: E501
            raise ValueError("Invalid value for `tags`, must not be `None`")  # noqa: E501

        self._tags = tags

    @property
    def world_id(self):
        """Gets the world_id of this Store.  # noqa: E501

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :return: The world_id of this Store.  # noqa: E501
        :rtype: str
        """
        return self._world_id

    @world_id.setter
    def world_id(self, world_id):
        """Sets the world_id of this Store.

        WorldID be \"offline\" on User profiles if you are not friends with that user.  # noqa: E501

        :param world_id: The world_id of this Store.  # noqa: E501
        :type world_id: str
        """

        self._world_id = world_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Store):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Store):
            return True

        return self.to_dict() != other.to_dict()
