"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class AlbToLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckAlbProps(props);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: props.publicApi ? {} : { enableDnsHostnames: true, enableDnsSupport: true }
        });
        this.loadBalancer = defaults.ObtainAlb(this, id, {
            vpc: this.vpc,
            publicApi: props.publicApi,
            existingLoadBalancerObj: props.existingLoadBalancerObj,
            loadBalancerProps: props.loadBalancerProps,
            logAccessLogs: props.logAlbAccessLogs,
            loggingBucketProps: props.albLoggingBucketProps
        });
        // Obtain Lambda function for construct (existing or created)
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc
        });
        let newListener;
        if (this.loadBalancer.listeners.length === 0) {
            newListener = true;
        }
        else {
            newListener = false;
        }
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = (0, core_1.GetActiveListener)(this.loadBalancer.listeners);
        }
        const newTargetGroup = defaults.AddLambdaTarget(this, `tg${this.loadBalancer.listeners.length + 1}`, this.listener, this.lambdaFunction, props.ruleProps, props.targetProps);
        // this.listener needs to be set on the construct.
        // could be above: else { defaults.GetActiveListener }
        // do we then move that functionality back into the construct (not the function). If so do
        // we leave it in AddNewTarget or just do it here and pass the listener?
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependency(cfnTargetGroup);
        }
    }
}
exports.AlbToLambda = AlbToLambda;
_a = JSII_RTTI_SYMBOL_1;
AlbToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-alb-lambda.AlbToLambda", version: "2.97.0" };
//# sourceMappingURL=data:application/json;base64,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