linear_tests = {'test1':
                    {'name':'test1',
					'description':'Test that linear TE is detected in a loose coupling',
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  1000, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.2, 
					'alpha': 0.1,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':None,
					'shuffles':0,
					'assertion':'(TE_XY > TE_YX)' # Boolean gets evaluated at runtime
                    },
			'test2':
					{'name':'test2',
					'description':'Test that linear TE is detected in a strong coupling',
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  1000, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.2, 
					'alpha': 0.8,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':None,
					'shuffles':0,
					'assertion':'(TE_XY > 10 * TE_YX)' # Boolean gets evaluated at runtime
                    },
			'test3':
					{'name':'test3',
					'description':'Test that linear TE is equal in both directions if time series are independent',
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  1000, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.2, 
					'alpha': 0,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':None,
					'shuffles':0,
					'assertion':'(abs(TE_XY - TE_YX) < 0.001)' # Boolean gets evaluated at runtime
                    },
			'test4':
					{'name':'test4',
					'description':'Test that linear TE is greater than zero',
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  100, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.1, 
					'alpha': 0,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':None,
					'shuffles':0,
					'assertion':'(TE_XY > 0) and (TE_YX > 0)' # Boolean gets evaluated at runtime
                    },
			'test5':
					{'name':'test5',
					'description':'Test that p-values are calculated correctly',
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  100, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.1, 
					'alpha': 0.8,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':10,
					'shuffles':50,
					'assertion':'(p_XY < 0.01) and (p_YX > 0.25)' # Boolean gets evaluated at runtime
                    },
			'test6':
					{'name':'test6',
					'description':'Test that z-scores are calculated correctly',
					'S1': 100,
					'S2': 200,
					'T':  1000,
					'N':  500, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.15, 
					'alpha': 0.8,
					'lag': 1,
					'seed': 10,
					'shuffles':25,
					'assertion':'(Z_XY > 1000) and (Z_YX < 3)' # Boolean gets evaluated at runtime
                    },	
			'test7':
					{'name':'test7',
					'description':'Test that z-scores are calculated correctly under light coupling',
					'S1': 100,
					'S2': 200,
					'T':  1000,
					'N':  500, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.15, 
					'alpha': 0.1,
					'lag': 1,
					'seed': 10,
					'shuffles':25,
					'assertion':'(Z_XY > 50) and (Z_YX < 3)' # Boolean gets evaluated at runtime
                    },	
            
}

nonlinear_tests = {'test1':
                    {'name':'test1',
					'description':'Tests using histogram that dependent time series have higher TE \
									from X to Y than in the reverse direction',
					'estimator':'histogram',
                	'bins': {'S1': [-0.5,-0.2, -0.05,-0.01,0,0.01, 0.05, 0.2, 0.5], 
							'S2': [-0.5,-0.2, -0.05,-0.01,0,0.01, 0.05, 0.2, 0.5],
							'S1_lag1': [-0.5,-0.2, -0.05,-0.01,0,0.01, 0.05, 0.2, 0.5],
							'S2_lag1': [-0.5,-0.2, -0.05,-0.01,0,0.01, 0.05, 0.2, 0.5]},
					'bandwidth':None,
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  10000, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.2, 
					'alpha': 0.1,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':None,
					'shuffles':0,
					'assertion':'(TE_XY > TE_YX)' # Boolean gets evaluated at runtime
                    },
            'test2':
                    {'name':'test2',
					'description':'Tests using histogram that highly dependent time series \
									have much higher TE from X to Y than in the reverse direction',
					'estimator':'histogram',
					'bins': {'S1': [-0.5,-0.2, -0.05,-0.01,0,0.01, 0.05, 0.2, 0.5], 
                              'S2': [-0.5,-0.2, -0.05,-0.01,0,0.01, 0.05, 0.2, 0.5],
                              'S1_lag1': [-0.5,-0.2, -0.05,-0.01,0,0.01, 0.05, 0.2, 0.5],
                              'S2_lag1': [-0.5,-0.2, -0.05,-0.01,0,0.01, 0.05, 0.2, 0.5]},
					'bandwidth':None,
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  10000, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.1,
					'sigma2': 0.05, 
					'alpha': 0.95,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':None,
					'shuffles':0,
					'assertion':'(TE_XY > 10 * TE_YX)'	# Boolean gets evaluated at runtime
                    },

			'test3':
                    {'name':'test3',
					'description':'Tests using KDE that highly dependent time series \
									have much higher TE from X to Y than in the reverse direction',
					'estimator':'kernel',
					'bins': None,
					'bandwidth':2,
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  10000, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.4,
					'sigma2': 0.3, 
					'alpha': 0.9,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':None,
					'shuffles':0,
					'assertion':'(TE_XY > 10 * TE_YX)'	# Boolean gets evaluated at runtime
                    },


			'test4':
                    {'name':'test4',
					'description':'Tests using KDE that independent time series have zero TE',
					'estimator':'kernel',
					'bins': None,
					'bandwidth':1,
					'S1': 100,
					'S2': 100,
					'T':  1000,
					'N':  10000, 
					'mu1': 0, 
					'mu2': 0,
					'sigma1': 0.5,
					'sigma2': 0.3, 
					'alpha': 0,
					'lag': 1,
					'seed': 10,
					'expected_TE':None,
					'expected_Z_score':None,
					'shuffles':0,
					'assertion':'(abs(TE_XY- TE_YX) < 0.001)'	# Boolean gets evaluated at runtime
                    }
}
