from coverage import coverage_script

from python_agent.build_scanner import file_signature
from python_agent.utils import get_top_relative_path


class CoverageFootprints(object):

    def __init__(self):
        self.files_methods = {}
        self.files_signatures = {}

    def get_footprints_from_test(self, test_name, test_coverage1=None):
        name = test_name.split("%3A%3A")[-1].split("%5B")[0] if test_name else test_name
        test_coverage = coverage_script.coverage.collector.contexts.get(name)
        # test_coverage = test_coverage1.get(name)
        if not test_coverage:
            return []

        footprints = []

        for filename, covered_lines in test_coverage.items():
            file_sig = self.files_signatures.get(filename)
            if not file_sig:
                file_sig = file_signature.calculate_file_signature(filename, get_top_relative_path(filename))
                self.files_signatures[filename] = file_sig
            covered_methods = self._lines_to_methods(file_sig["methods"], covered_lines)
            file_footprints = map(lambda method: {"name": method["uniqueName"], "hash": method["hash"], "hits": 1}, covered_methods)
            footprints.extend(file_footprints)
        return footprints

    def _lines_to_methods(self, methods, covered_lines):
        line_methods = {}
        for method in methods:
            for line_num in covered_lines.keys():
                if method["position"][0] < line_num <= method["endPosition"][0]:
                    line_methods[method["uniqueName"]] = method
                    break
        return line_methods.values()


if __name__ == '__main__':
    coverage = {'test_add_metaclass': {u'/home/shai/workspace/python-six/six.py': {814: None, 815: None, 816: None, 817: None, 818: None, 819: None, 820: None, 821: None, 822: None, 823: None, 824: None, 825: None}}, 'test_string_types': {u'/home/shai/workspace/python-six/six.py': {185: None, 187: None, 647: None}}, 'test_advance_iterator': {}, 'test_get_function_globals': {}, 'test_callable': {}, 'test_text_type': {u'/home/shai/workspace/python-six/six.py': {647: None}}, 'test_bytesiter': {u'/home/shai/workspace/python-six/six.py': {643: None}}, 'test_move_items_urllib_response': {u'/home/shai/workspace/python-six/six.py': {160: None, 161: None, 131: None, 132: None, 133: None, 97: None, 82: None, 83: None, 100: None, 92: None, 93: None, 94: None}}, 'test_move_items_urllib_request': {u'/home/shai/workspace/python-six/six.py': {160: None, 161: None, 131: None, 132: None, 133: None, 97: None, 82: None, 83: None, 100: None, 92: None, 93: None, 94: None}}, 'test_byte2int': {u'/home/shai/workspace/python-six/six.py': {643: None, 652: None}}, 'test_dictionary_views': {}, 'test_get_function_code': {}, 'test_move_items_urllib_robotparser': {u'/home/shai/workspace/python-six/six.py': {160: None, 161: None, 131: None, 132: None, 133: None, 97: None, 82: None, 83: None, 100: None, 92: None, 93: None, 94: None}}, 'test_get_unbound_function': {u'/home/shai/workspace/python-six/six.py': {547: None}}, 'test_wraps': {u'/home/shai/workspace/python-six/six.py': {792: None, 793: None, 794: None, 795: None, 791: None}}, 'test_int2byte': {u'/home/shai/workspace/python-six/six.py': {643: None}}, 'test_with_metaclass': {u'/home/shai/workspace/python-six/six.py': {808: None, 809: None, 805: None, 807: None}}, 'test_integer_types': {}, 'test_lazy': {}, 'test_assertCountEqual': {u'/home/shai/workspace/python-six/six.py': {667: None}}, 'test_create_bound_method': {u'/home/shai/workspace/python-six/six.py': {550: None}}, 'test_import_moves_error_1': {u'/home/shai/workspace/python-six/six.py': {196: None, 198: None, 199: None, 200: None, 201: None, 202: None, 205: None, 206: None, 207: None, 185: None, 186: None, 190: None, 191: None}}, 'test_import_moves_error_2': {}, 'test_import_moves_error_3': {}, 'test_empty_remove': {u'/home/shai/workspace/python-six/six.py': {493: None, 494: None, 495: None, 496: None, 497: None, 498: None, 499: None}}, 'test_get_function_defaults': {}, 'test_moved_attribute': {u'/home/shai/workspace/python-six/six.py': {142: None, 143: None, 89: None, 154: None, 155: None, 156: None, 157: None}}, 'test_zip_longest': {}, 'test_binary_type': {u'/home/shai/workspace/python-six/six.py': {643: None}}, 'test_print_': {u'/home/shai/workspace/python-six/six.py': {647: None, 780: None, 781: None, 782: None, 783: None, 784: None}}, 'test_dictionary_iterators': {u'/home/shai/workspace/python-six/six.py': {593: None, 602: None, 596: None, 599: None}}, 'test_reraise': {}, 'test_assertRegex': {u'/home/shai/workspace/python-six/six.py': {675: None}}, 'test_raise_from': {u'/home/shai/workspace/python-six/six.py': {718: None}}, 'test_skipped': {}, 'test_moved_module': {u'/home/shai/workspace/python-six/six.py': {112: None, 89: None, 106: None, 107: None}}, 'test_python_2_unicode_compatible': {u'/home/shai/workspace/python-six/six.py': {643: None, 836: None, 837: None, 647: None, 841: None, 842: None, 843: None}}, None: {u'/home/shai/workspace/python-six/six.py': {1: None, 23: None, 25: None, 26: None, 27: None, 28: None, 29: None, 31: None, 32: None, 36: None, 37: None, 38: None, 40: None, 49: None, 50: None, 51: None, 52: None, 53: None, 55: None, 60: None, 62: None, 63: None, 64: None, 65: None, 71: None, 72: None, 75: None, 77: None, 80: None, 82: None, 83: None, 86: None, 88: None, 89: None, 91: None, 92: None, 93: None, 94: None, 97: None, 100: None, 103: None, 105: None, 106: None, 107: None, 112: None, 114: None, 115: None, 117: None, 124: None, 126: None, 127: None, 128: None, 130: None, 136: None, 139: None, 141: None, 142: None, 143: None, 154: None, 155: None, 156: None, 157: None, 159: None, 160: None, 161: None, 164: None, 171: None, 173: None, 174: None, 175: None, 177: None, 178: None, 179: None, 181: None, 182: None, 184: None, 185: None, 186: None, 187: None, 189: None, 190: None, 191: None, 195: None, 196: None, 198: None, 199: None, 200: None, 201: None, 202: None, 205: None, 206: None, 207: None, 209: None, 218: None, 224: None, 226: None, 229: None, 231: None, 232: None, 236: None, 237: None, 238: None, 239: None, 240: None, 241: None, 242: None, 243: None, 244: None, 245: None, 246: None, 247: None, 248: None, 249: None, 250: None, 251: None, 252: None, 253: None, 254: None, 255: None, 256: None, 257: None, 258: None, 259: None, 260: None, 261: None, 262: None, 263: None, 264: None, 265: None, 266: None, 267: None, 268: None, 269: None, 270: None, 271: None, 272: None, 273: None, 274: None, 275: None, 276: None, 277: None, 278: None, 279: None, 280: None, 281: None, 282: None, 283: None, 284: None, 285: None, 286: None, 287: None, 288: None, 289: None, 290: None, 291: None, 292: None, 293: None, 294: None, 295: None, 296: None, 297: None, 298: None, 299: None, 300: None, 303: None, 308: None, 309: None, 310: None, 311: None, 312: None, 314: None, 316: None, 317: None, 320: None, 322: None, 326: None, 327: None, 328: None, 329: None, 330: None, 331: None, 332: None, 333: None, 334: None, 335: None, 336: None, 337: None, 338: None, 339: None, 340: None, 341: None, 342: None, 343: None, 344: None, 345: None, 346: None, 347: None, 348: None, 350: None, 351: None, 352: None, 354: None, 356: None, 357: None, 360: None, 362: None, 366: None, 367: None, 368: None, 370: None, 371: None, 372: None, 374: None, 376: None, 377: None, 380: None, 382: None, 386: None, 387: None, 388: None, 389: None, 390: None, 391: None, 392: None, 393: None, 394: None, 395: None, 396: None, 397: None, 398: None, 399: None, 400: None, 401: None, 402: None, 403: None, 404: None, 405: None, 406: None, 407: None, 408: None, 409: None, 410: None, 411: None, 412: None, 413: None, 414: None, 415: None, 416: None, 417: None, 418: None, 420: None, 421: None, 422: None, 424: None, 426: None, 427: None, 430: None, 432: None, 436: None, 437: None, 438: None, 439: None, 441: None, 442: None, 443: None, 445: None, 447: None, 448: None, 451: None, 453: None, 457: None, 459: None, 460: None, 461: None, 463: None, 465: None, 466: None, 469: None, 471: None, 472: None, 473: None, 474: None, 475: None, 476: None, 477: None, 479: None, 482: None, 483: None, 486: None, 491: None, 502: None, 511: None, 512: None, 514: None, 515: None, 516: None, 517: None, 520: None, 521: None, 525: None, 528: None, 529: None, 535: None, 546: None, 549: None, 552: None, 555: None, 557: None, 560: None, 561: None, 562: None, 565: None, 566: None, 567: None, 568: None, 569: None, 570: None, 573: None, 592: None, 595: None, 598: None, 601: None, 604: None, 606: None, 608: None, 610: None, 611: None, 612: None, 613: None, 614: None, 615: None, 618: None, 642: None, 646: None, 648: None, 649: None, 651: None, 654: None, 656: None, 657: None, 658: None, 659: None, 660: None, 661: None, 662: None, 663: None, 666: None, 670: None, 674: None, 678: None, 689: None, 691: None, 692: None, 693: None, 694: None, 695: None, 696: None, 699: None, 701: None, 703: None, 706: None, 712: None, 717: None, 721: None, 722: None, 776: None, 777: None, 779: None, 786: None, 788: None, 789: None, 790: None, 800: None, 812: None, 828: None, 849: None, 850: None, 851: None, 856: None, 857: None, 862: None, 863: None, 866: None, 868: None}}, 'test_import_module': {u'/home/shai/workspace/python-six/six.py': {82: None, 83: None}}, 'test_custom_move_attribute': {u'/home/shai/workspace/python-six/six.py': {160: None, 161: None, 97: None, 100: None, 93: None, 488: None, 493: None, 142: None, 143: None, 496: None, 497: None, 82: None, 83: None, 494: None, 495: None, 89: None, 154: None, 155: None, 92: None, 157: None, 94: None}}, 'test_move_items': {u'/home/shai/workspace/python-six/six.py': {131: None, 132: None, 133: None, 160: None, 161: None, 185: None, 186: None, 187: None, 190: None, 191: None, 196: None, 198: None, 199: None, 200: None, 201: None, 202: None, 203: None, 205: None, 206: None, 207: None, 82: None, 83: None, 92: None, 93: None, 94: None, 97: None, 100: None, 115: None}}, 'test_bytesindex': {u'/home/shai/workspace/python-six/six.py': {643: None, 655: None}}, 'test_map': {}, 'test_MAXSIZE': {}, 'test_started': {}, 'test_exec_': {u'/home/shai/workspace/python-six/six.py': {691: None, 692: None, 693: None, 694: None, 695: None, 696: None, 697: None, 698: None, 699: None}}, 'test_assertRaisesRegex': {u'/home/shai/workspace/python-six/six.py': {671: None}}, 'test_move_items_urllib_parse': {u'/home/shai/workspace/python-six/six.py': {160: None, 161: None, 131: None, 132: None, 133: None, 97: None, 82: None, 83: None, 100: None, 92: None, 93: None, 94: None}}, 'test_unichr': {u'/home/shai/workspace/python-six/six.py': {647: None}}, 'test_failed': {}, 'test_iterator': {u'/home/shai/workspace/python-six/six.py': {558: None}}, 'test_b': {u'/home/shai/workspace/python-six/six.py': {643: None}}, 'test_u_escapes': {u'/home/shai/workspace/python-six/six.py': {647: None}}, 'test_print_exceptions': {u'/home/shai/workspace/python-six/six.py': {780: None, 781: None, 782: None}}, 'test_filter': {}, 'test_filter_false': {}, 'test_custom_move_module': {u'/home/shai/workspace/python-six/six.py': {97: None, 83: None, 100: None, 488: None, 106: None, 107: None, 493: None, 494: None, 495: None, 112: None, 497: None, 82: None, 115: None, 496: None, 89: None, 92: None, 93: None, 94: None}}, 'test_StringIO': {u'/home/shai/workspace/python-six/six.py': {647: None}}, 'test_zip': {}, 'test_u': {u'/home/shai/workspace/python-six/six.py': {647: None}}, 'test_get_function_closure': {}, 'test_get_method_self': {}, 'test_get_method_function': {}, 'test_class_types': {}, 'test_create_unbound_method': {u'/home/shai/workspace/python-six/six.py': {553: None}}, 'test_add_doc': {u'/home/shai/workspace/python-six/six.py': {77: None}}, 'test_passed': {}, 'test_from_imports': {}, 'test_BytesIO': {u'/home/shai/workspace/python-six/six.py': {643: None}}, 'test_move_items_urllib_error': {u'/home/shai/workspace/python-six/six.py': {160: None, 161: None, 131: None, 132: None, 133: None, 97: None, 82: None, 83: None, 100: None, 92: None, 93: None, 94: None}}}
    test_names = ["test_add_doc", "test_import_module", "test_integer_types", "test_string_types", "test_class_types", "test_text_type", "test_binary_type", "test_MAXSIZE", "test_lazy", "test_move_items", "test_move_items_urllib_parse", "test_move_items_urllib_error", "test_move_items_urllib_request", "test_move_items_urllib_response", "test_move_items_urllib_robotparser", "test_import_moves_error_1", "test_import_moves_error_2", "test_import_moves_error_3", "test_from_imports", "test_filter", "test_filter_false", "test_map", "test_zip", "test_zip_longest", "test_moved_attribute", "test_moved_module", "test_custom_move_module", "test_custom_move_attribute", "test_empty_remove", "test_get_unbound_function", "test_get_method_self", "test_get_method_function", "test_get_function_closure", "test_get_function_code", "test_get_function_defaults", "test_get_function_globals", "test_dictionary_iterators", "test_dictionary_views", "test_advance_iterator", "test_iterator", "test_callable", "test_create_bound_method", "test_create_unbound_method", "test_b", "test_u", "test_b", "test_u", "test_u_escapes", "test_unichr", "test_int2byte", "test_byte2int", "test_bytesindex", "test_bytesiter", "test_StringIO", "test_BytesIO", "test_exec_", "test_reraise", "test_raise_from", "test_print_", "test_print_encoding", "test_print_exceptions", "test_with_metaclass", "test_wraps", "test_add_metaclass", "test_assertCountEqual", "test_assertRegex", "test_assertRaisesRegex", "test_python_2_unicode_compatible"]
    f = []
    a = CoverageFootprints()
    for test_name in test_names:
        f.extend(a.get_footprints_from_test(test_name, test_coverage1=coverage))
    import json
    print json.dumps({"footprints": f})