# coding: utf-8

"""
    Portainer API

    Portainer API is an HTTP API served by Portainer. It is used by the Portainer UI and everything you can do with the UI can be done using the HTTP API. Examples are available at https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8 You can find out more about Portainer at [http://portainer.io](http://portainer.io) and get some support on [Slack](http://portainer.io/slack/).  # Authentication  Most of the API endpoints require to be authenticated as well as some level of authorization to be used. Portainer API uses JSON Web Token to manage authentication and thus requires you to provide a token in the **Authorization** header of each request with the **Bearer** authentication mechanism.  Example: ``` Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwidXNlcm5hbWUiOiJhZG1pbiIsInJvbGUiOjEsImV4cCI6MTQ5OTM3NjE1NH0.NJ6vE8FY1WG6jsRQzfMqeatJ4vh2TWAeeYfDhP71YEE ```  # Security  Each API endpoint has an associated access policy, it is documented in the description of each endpoint.  Different access policies are available: * Public access * Authenticated access * Restricted access * Administrator access  ### Public access  No authentication is required to access the endpoints with this access policy.  ### Authenticated access  Authentication is required to access the endpoints with this access policy.  ### Restricted access  Authentication is required to access the endpoints with this access policy. Extra-checks might be added to ensure access to the resource is granted. Returned data might also be filtered.  ### Administrator access  Authentication as well as an administrator role are required to access the endpoints with this access policy.  # Execute Docker requests  Portainer **DO NOT** expose specific endpoints to manage your Docker resources (create a container, remove a volume, etc...).  Instead, it acts as a reverse-proxy to the Docker HTTP API. This means that you can execute Docker requests **via** the Portainer HTTP API.  To do so, you can use the `/endpoints/{id}/docker` Portainer API endpoint (which is not documented below due to Swagger limitations). This endpoint has a restricted access policy so you still need to be authenticated to be able to query this endpoint. Any query on this endpoint will be proxied to the Docker API of the associated endpoint (requests and responses objects are the same as documented in the Docker API).  **NOTE**: You can find more information on how to query the Docker API in the [Docker official documentation](https://docs.docker.com/engine/api/v1.30/) as well as in [this Portainer example](https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8).   # noqa: E501

    OpenAPI spec version: 1.20.0
    Contact: info@portainer.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from portainer_api.api_client import ApiClient


class StacksApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def stack_create(self, type, method, endpoint_id, **kwargs):  # noqa: E501
        """Deploy a new stack  # noqa: E501

        Deploy a new stack into a Docker environment specified via the endpoint identifier. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_create(type, method, endpoint_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int type: Stack deployment type. Possible values: 1 (Swarm stack) or 2 (Compose stack). (required)
        :param str method: Stack deployment method. Possible values: file, string or repository. (required)
        :param int endpoint_id: Identifier of the endpoint that will be used to deploy the stack. (required)
        :param StackCreateRequest body: Stack details. Required when method equals string or repository.
        :param str name: Name of the stack. Required when method equals file.
        :param str endpoint_id2: Endpoint identifier used to deploy the stack. Required when method equals file.
        :param str swarm_id: Swarm cluster identifier. Required when method equals file and type equals 1.
        :param file file: Stack file. Required when method equals file.
        :param str env: Environment variables passed during deployment, represented as a JSON array [{'name': 'name', 'value': 'value'}]. Optional, used when method equals file and type equals 1.
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.stack_create_with_http_info(type, method, endpoint_id, **kwargs)  # noqa: E501
        else:
            (data) = self.stack_create_with_http_info(type, method, endpoint_id, **kwargs)  # noqa: E501
            return data

    def stack_create_with_http_info(self, type, method, endpoint_id, **kwargs):  # noqa: E501
        """Deploy a new stack  # noqa: E501

        Deploy a new stack into a Docker environment specified via the endpoint identifier. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_create_with_http_info(type, method, endpoint_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int type: Stack deployment type. Possible values: 1 (Swarm stack) or 2 (Compose stack). (required)
        :param str method: Stack deployment method. Possible values: file, string or repository. (required)
        :param int endpoint_id: Identifier of the endpoint that will be used to deploy the stack. (required)
        :param StackCreateRequest body: Stack details. Required when method equals string or repository.
        :param str name: Name of the stack. Required when method equals file.
        :param str endpoint_id2: Endpoint identifier used to deploy the stack. Required when method equals file.
        :param str swarm_id: Swarm cluster identifier. Required when method equals file and type equals 1.
        :param file file: Stack file. Required when method equals file.
        :param str env: Environment variables passed during deployment, represented as a JSON array [{'name': 'name', 'value': 'value'}]. Optional, used when method equals file and type equals 1.
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'method', 'endpoint_id', 'body', 'name', 'endpoint_id2', 'swarm_id', 'file', 'env']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stack_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `stack_create`")  # noqa: E501
        # verify the required parameter 'method' is set
        if ('method' not in params or
                params['method'] is None):
            raise ValueError("Missing the required parameter `method` when calling `stack_create`")  # noqa: E501
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in params or
                params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `stack_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'method' in params:
            query_params.append(('method', params['method']))  # noqa: E501
        if 'endpoint_id' in params:
            query_params.append(('endpointId', params['endpoint_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('Name', params['name']))  # noqa: E501
        if 'endpoint_id2' in params:
            form_params.append(('EndpointID', params['endpoint_id2']))  # noqa: E501
        if 'swarm_id' in params:
            form_params.append(('SwarmID', params['swarm_id']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'env' in params:
            form_params.append(('Env', params['env']))  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/stacks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stack',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stack_delete(self, id, **kwargs):  # noqa: E501
        """Remove a stack  # noqa: E501

        Remove a stack. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_delete(id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :param bool external: Set to true to delete an external stack. Only external Swarm stacks are supported.
        :param str endpoint_id: Endpoint identifier used to remove an external stack (required when external is set to true)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.stack_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.stack_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def stack_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Remove a stack  # noqa: E501

        Remove a stack. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_delete_with_http_info(id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :param bool external: Set to true to delete an external stack. Only external Swarm stacks are supported.
        :param str endpoint_id: Endpoint identifier used to remove an external stack (required when external is set to true)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'external', 'endpoint_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stack_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `stack_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'external' in params:
            query_params.append(('external', params['external']))  # noqa: E501
        if 'endpoint_id' in params:
            query_params.append(('endpointId', params['endpoint_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/stacks/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stack_file_inspect(self, id, **kwargs):  # noqa: E501
        """Retrieve the content of the Stack file for the specified stack  # noqa: E501

        Get Stack file content. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_file_inspect(id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :return: StackFileInspectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.stack_file_inspect_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.stack_file_inspect_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def stack_file_inspect_with_http_info(self, id, **kwargs):  # noqa: E501
        """Retrieve the content of the Stack file for the specified stack  # noqa: E501

        Get Stack file content. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_file_inspect_with_http_info(id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :return: StackFileInspectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stack_file_inspect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `stack_file_inspect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/stacks/{id}/file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StackFileInspectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stack_inspect(self, id, **kwargs):  # noqa: E501
        """Inspect a stack  # noqa: E501

        Retrieve details about a stack. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_inspect(id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.stack_inspect_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.stack_inspect_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def stack_inspect_with_http_info(self, id, **kwargs):  # noqa: E501
        """Inspect a stack  # noqa: E501

        Retrieve details about a stack. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_inspect_with_http_info(id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stack_inspect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `stack_inspect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/stacks/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stack',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stack_list(self, **kwargs):  # noqa: E501
        """List stacks  # noqa: E501

        List all stacks based on the current user authorizations. Will return all stacks if using an administrator account otherwise it will only return the list of stacks the user have access to. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_list(async=True)
        >>> result = thread.get()

        :param async bool
        :param str filters: Filters to process on the stack list. Encoded as JSON (a map[string]string). For example, {\"SwarmID\": \"jpofkc0i9uo9wtx1zesuk649w\"} will only return stacks that are part of the specified Swarm cluster. Available filters: EndpointID, SwarmID. 
        :return: StackListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.stack_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.stack_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def stack_list_with_http_info(self, **kwargs):  # noqa: E501
        """List stacks  # noqa: E501

        List all stacks based on the current user authorizations. Will return all stacks if using an administrator account otherwise it will only return the list of stacks the user have access to. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_list_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str filters: Filters to process on the stack list. Encoded as JSON (a map[string]string). For example, {\"SwarmID\": \"jpofkc0i9uo9wtx1zesuk649w\"} will only return stacks that are part of the specified Swarm cluster. Available filters: EndpointID, SwarmID. 
        :return: StackListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filters']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stack_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/stacks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StackListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stack_migrate(self, id, **kwargs):  # noqa: E501
        """Migrate a stack to another endpoint  # noqa: E501

        Migrate a stack from an endpoint to another endpoint. It will re-create the stack inside the target endpoint before removing the original stack. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_migrate(id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :param int endpoint_id: Stacks created before version 1.18.0 might not have an associated endpoint identifier. Use this optional parameter to set the endpoint identifier used by the stack.
        :param StackMigrateRequest body: Stack migration details.
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.stack_migrate_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.stack_migrate_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def stack_migrate_with_http_info(self, id, **kwargs):  # noqa: E501
        """Migrate a stack to another endpoint  # noqa: E501

        Migrate a stack from an endpoint to another endpoint. It will re-create the stack inside the target endpoint before removing the original stack. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_migrate_with_http_info(id, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :param int endpoint_id: Stacks created before version 1.18.0 might not have an associated endpoint identifier. Use this optional parameter to set the endpoint identifier used by the stack.
        :param StackMigrateRequest body: Stack migration details.
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'endpoint_id', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stack_migrate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `stack_migrate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'endpoint_id' in params:
            query_params.append(('endpointId', params['endpoint_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/stacks/{id}/migrate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stack',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stack_update(self, id, body, **kwargs):  # noqa: E501
        """Update a stack  # noqa: E501

        Update a stack. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_update(id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :param StackUpdateRequest body: Stack details (required)
        :param int endpoint_id: Stacks created before version 1.18.0 might not have an associated endpoint identifier. Use this optional parameter to set the endpoint identifier used by the stack.
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.stack_update_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.stack_update_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def stack_update_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """Update a stack  # noqa: E501

        Update a stack. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.stack_update_with_http_info(id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param int id: Stack identifier (required)
        :param StackUpdateRequest body: Stack details (required)
        :param int endpoint_id: Stacks created before version 1.18.0 might not have an associated endpoint identifier. Use this optional parameter to set the endpoint identifier used by the stack.
        :return: Stack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'endpoint_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stack_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `stack_update`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `stack_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'endpoint_id' in params:
            query_params.append(('endpointId', params['endpoint_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/stacks/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stack',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
