# coding: utf-8

# flake8: noqa
"""
    Portainer API

    Portainer API is an HTTP API served by Portainer. It is used by the Portainer UI and everything you can do with the UI can be done using the HTTP API. Examples are available at https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8 You can find out more about Portainer at [http://portainer.io](http://portainer.io) and get some support on [Slack](http://portainer.io/slack/).  # Authentication  Most of the API endpoints require to be authenticated as well as some level of authorization to be used. Portainer API uses JSON Web Token to manage authentication and thus requires you to provide a token in the **Authorization** header of each request with the **Bearer** authentication mechanism.  Example: ``` Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwidXNlcm5hbWUiOiJhZG1pbiIsInJvbGUiOjEsImV4cCI6MTQ5OTM3NjE1NH0.NJ6vE8FY1WG6jsRQzfMqeatJ4vh2TWAeeYfDhP71YEE ```  # Security  Each API endpoint has an associated access policy, it is documented in the description of each endpoint.  Different access policies are available: * Public access * Authenticated access * Restricted access * Administrator access  ### Public access  No authentication is required to access the endpoints with this access policy.  ### Authenticated access  Authentication is required to access the endpoints with this access policy.  ### Restricted access  Authentication is required to access the endpoints with this access policy. Extra-checks might be added to ensure access to the resource is granted. Returned data might also be filtered.  ### Administrator access  Authentication as well as an administrator role are required to access the endpoints with this access policy.  # Execute Docker requests  Portainer **DO NOT** expose specific endpoints to manage your Docker resources (create a container, remove a volume, etc...).  Instead, it acts as a reverse-proxy to the Docker HTTP API. This means that you can execute Docker requests **via** the Portainer HTTP API.  To do so, you can use the `/endpoints/{id}/docker` Portainer API endpoint (which is not documented below due to Swagger limitations). This endpoint has a restricted access policy so you still need to be authenticated to be able to query this endpoint. Any query on this endpoint will be proxied to the Docker API of the associated endpoint (requests and responses objects are the same as documented in the Docker API).  **NOTE**: You can find more information on how to query the Docker API in the [Docker official documentation](https://docs.docker.com/engine/api/v1.30/) as well as in [this Portainer example](https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8).   # noqa: E501

    OpenAPI spec version: 1.20.0
    Contact: info@portainer.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from portainer_api.models.authenticate_user_request import AuthenticateUserRequest
from portainer_api.models.authenticate_user_response import AuthenticateUserResponse
from portainer_api.models.azure_credentials import AzureCredentials
from portainer_api.models.docker_hub import DockerHub
from portainer_api.models.docker_hub_subset import DockerHubSubset
from portainer_api.models.docker_hub_update_request import DockerHubUpdateRequest
from portainer_api.models.endpoint import Endpoint
from portainer_api.models.endpoint_access_update_request import EndpointAccessUpdateRequest
from portainer_api.models.endpoint_group import EndpointGroup
from portainer_api.models.endpoint_group_access_update_request import EndpointGroupAccessUpdateRequest
from portainer_api.models.endpoint_group_create_request import EndpointGroupCreateRequest
from portainer_api.models.endpoint_group_list_response import EndpointGroupListResponse
from portainer_api.models.endpoint_group_update_request import EndpointGroupUpdateRequest
from portainer_api.models.endpoint_job_request import EndpointJobRequest
from portainer_api.models.endpoint_list_response import EndpointListResponse
from portainer_api.models.endpoint_subset import EndpointSubset
from portainer_api.models.endpoint_update_request import EndpointUpdateRequest
from portainer_api.models.generic_error import GenericError
from portainer_api.models.ldap_group_search_settings import LDAPGroupSearchSettings
from portainer_api.models.ldap_search_settings import LDAPSearchSettings
from portainer_api.models.ldap_settings import LDAPSettings
from portainer_api.models.pair import Pair
from portainer_api.models.public_settings_inspect_response import PublicSettingsInspectResponse
from portainer_api.models.registry import Registry
from portainer_api.models.registry_access_update_request import RegistryAccessUpdateRequest
from portainer_api.models.registry_create_request import RegistryCreateRequest
from portainer_api.models.registry_list_response import RegistryListResponse
from portainer_api.models.registry_subset import RegistrySubset
from portainer_api.models.registry_update_request import RegistryUpdateRequest
from portainer_api.models.resource_control import ResourceControl
from portainer_api.models.resource_control_create_request import ResourceControlCreateRequest
from portainer_api.models.resource_control_update_request import ResourceControlUpdateRequest
from portainer_api.models.settings import Settings
from portainer_api.models.settings_black_listed_labels import SettingsBlackListedLabels
from portainer_api.models.settings_ldap_check_request import SettingsLDAPCheckRequest
from portainer_api.models.settings_update_request import SettingsUpdateRequest
from portainer_api.models.stack import Stack
from portainer_api.models.stack_create_request import StackCreateRequest
from portainer_api.models.stack_env import StackEnv
from portainer_api.models.stack_file_inspect_response import StackFileInspectResponse
from portainer_api.models.stack_list_response import StackListResponse
from portainer_api.models.stack_migrate_request import StackMigrateRequest
from portainer_api.models.stack_update_request import StackUpdateRequest
from portainer_api.models.status import Status
from portainer_api.models.tls_configuration import TLSConfiguration
from portainer_api.models.tag import Tag
from portainer_api.models.tag_create_request import TagCreateRequest
from portainer_api.models.tag_list_response import TagListResponse
from portainer_api.models.team import Team
from portainer_api.models.team_create_request import TeamCreateRequest
from portainer_api.models.team_list_response import TeamListResponse
from portainer_api.models.team_membership import TeamMembership
from portainer_api.models.team_membership_create_request import TeamMembershipCreateRequest
from portainer_api.models.team_membership_list_response import TeamMembershipListResponse
from portainer_api.models.team_membership_update_request import TeamMembershipUpdateRequest
from portainer_api.models.team_memberships_response import TeamMembershipsResponse
from portainer_api.models.team_update_request import TeamUpdateRequest
from portainer_api.models.template import Template
from portainer_api.models.template_create_request import TemplateCreateRequest
from portainer_api.models.template_env import TemplateEnv
from portainer_api.models.template_env_select import TemplateEnvSelect
from portainer_api.models.template_list_response import TemplateListResponse
from portainer_api.models.template_repository import TemplateRepository
from portainer_api.models.template_update_request import TemplateUpdateRequest
from portainer_api.models.template_volume import TemplateVolume
from portainer_api.models.user import User
from portainer_api.models.user_admin_init_request import UserAdminInitRequest
from portainer_api.models.user_create_request import UserCreateRequest
from portainer_api.models.user_list_response import UserListResponse
from portainer_api.models.user_memberships_response import UserMembershipsResponse
from portainer_api.models.user_password_check_request import UserPasswordCheckRequest
from portainer_api.models.user_password_check_response import UserPasswordCheckResponse
from portainer_api.models.user_subset import UserSubset
from portainer_api.models.user_update_request import UserUpdateRequest
