# coding: utf-8

"""
    Portainer API

    Portainer API is an HTTP API served by Portainer. It is used by the Portainer UI and everything you can do with the UI can be done using the HTTP API. Examples are available at https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8 You can find out more about Portainer at [http://portainer.io](http://portainer.io) and get some support on [Slack](http://portainer.io/slack/).  # Authentication  Most of the API endpoints require to be authenticated as well as some level of authorization to be used. Portainer API uses JSON Web Token to manage authentication and thus requires you to provide a token in the **Authorization** header of each request with the **Bearer** authentication mechanism.  Example: ``` Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwidXNlcm5hbWUiOiJhZG1pbiIsInJvbGUiOjEsImV4cCI6MTQ5OTM3NjE1NH0.NJ6vE8FY1WG6jsRQzfMqeatJ4vh2TWAeeYfDhP71YEE ```  # Security  Each API endpoint has an associated access policy, it is documented in the description of each endpoint.  Different access policies are available: * Public access * Authenticated access * Restricted access * Administrator access  ### Public access  No authentication is required to access the endpoints with this access policy.  ### Authenticated access  Authentication is required to access the endpoints with this access policy.  ### Restricted access  Authentication is required to access the endpoints with this access policy. Extra-checks might be added to ensure access to the resource is granted. Returned data might also be filtered.  ### Administrator access  Authentication as well as an administrator role are required to access the endpoints with this access policy.  # Execute Docker requests  Portainer **DO NOT** expose specific endpoints to manage your Docker resources (create a container, remove a volume, etc...).  Instead, it acts as a reverse-proxy to the Docker HTTP API. This means that you can execute Docker requests **via** the Portainer HTTP API.  To do so, you can use the `/endpoints/{id}/docker` Portainer API endpoint (which is not documented below due to Swagger limitations). This endpoint has a restricted access policy so you still need to be authenticated to be able to query this endpoint. Any query on this endpoint will be proxied to the Docker API of the associated endpoint (requests and responses objects are the same as documented in the Docker API).  **NOTE**: You can find more information on how to query the Docker API in the [Docker official documentation](https://docs.docker.com/engine/api/v1.30/) as well as in [this Portainer example](https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8).   # noqa: E501

    OpenAPI spec version: 1.20.0
    Contact: info@portainer.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class EndpointUpdateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'url': 'str',
        'public_url': 'str',
        'group_id': 'int',
        'tls': 'bool',
        'tls_skip_verify': 'bool',
        'tls_skip_client_verify': 'bool',
        'application_id': 'str',
        'tenant_id': 'str',
        'authentication_key': 'str'
    }

    attribute_map = {
        'name': 'Name',
        'url': 'URL',
        'public_url': 'PublicURL',
        'group_id': 'GroupID',
        'tls': 'TLS',
        'tls_skip_verify': 'TLSSkipVerify',
        'tls_skip_client_verify': 'TLSSkipClientVerify',
        'application_id': 'ApplicationID',
        'tenant_id': 'TenantID',
        'authentication_key': 'AuthenticationKey'
    }

    def __init__(self, name=None, url=None, public_url=None, group_id=None, tls=None, tls_skip_verify=None, tls_skip_client_verify=None, application_id=None, tenant_id=None, authentication_key=None):  # noqa: E501
        """EndpointUpdateRequest - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._url = None
        self._public_url = None
        self._group_id = None
        self._tls = None
        self._tls_skip_verify = None
        self._tls_skip_client_verify = None
        self._application_id = None
        self._tenant_id = None
        self._authentication_key = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if url is not None:
            self.url = url
        if public_url is not None:
            self.public_url = public_url
        if group_id is not None:
            self.group_id = group_id
        if tls is not None:
            self.tls = tls
        if tls_skip_verify is not None:
            self.tls_skip_verify = tls_skip_verify
        if tls_skip_client_verify is not None:
            self.tls_skip_client_verify = tls_skip_client_verify
        if application_id is not None:
            self.application_id = application_id
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if authentication_key is not None:
            self.authentication_key = authentication_key

    @property
    def name(self):
        """Gets the name of this EndpointUpdateRequest.  # noqa: E501

        Name that will be used to identify this endpoint  # noqa: E501

        :return: The name of this EndpointUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EndpointUpdateRequest.

        Name that will be used to identify this endpoint  # noqa: E501

        :param name: The name of this EndpointUpdateRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def url(self):
        """Gets the url of this EndpointUpdateRequest.  # noqa: E501

        URL or IP address of a Docker host  # noqa: E501

        :return: The url of this EndpointUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this EndpointUpdateRequest.

        URL or IP address of a Docker host  # noqa: E501

        :param url: The url of this EndpointUpdateRequest.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def public_url(self):
        """Gets the public_url of this EndpointUpdateRequest.  # noqa: E501

        URL or IP address where exposed containers will be reachable. Defaults to URL if not specified  # noqa: E501

        :return: The public_url of this EndpointUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._public_url

    @public_url.setter
    def public_url(self, public_url):
        """Sets the public_url of this EndpointUpdateRequest.

        URL or IP address where exposed containers will be reachable. Defaults to URL if not specified  # noqa: E501

        :param public_url: The public_url of this EndpointUpdateRequest.  # noqa: E501
        :type: str
        """

        self._public_url = public_url

    @property
    def group_id(self):
        """Gets the group_id of this EndpointUpdateRequest.  # noqa: E501

        Group identifier  # noqa: E501

        :return: The group_id of this EndpointUpdateRequest.  # noqa: E501
        :rtype: int
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this EndpointUpdateRequest.

        Group identifier  # noqa: E501

        :param group_id: The group_id of this EndpointUpdateRequest.  # noqa: E501
        :type: int
        """

        self._group_id = group_id

    @property
    def tls(self):
        """Gets the tls of this EndpointUpdateRequest.  # noqa: E501

        Require TLS to connect against this endpoint  # noqa: E501

        :return: The tls of this EndpointUpdateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._tls

    @tls.setter
    def tls(self, tls):
        """Sets the tls of this EndpointUpdateRequest.

        Require TLS to connect against this endpoint  # noqa: E501

        :param tls: The tls of this EndpointUpdateRequest.  # noqa: E501
        :type: bool
        """

        self._tls = tls

    @property
    def tls_skip_verify(self):
        """Gets the tls_skip_verify of this EndpointUpdateRequest.  # noqa: E501

        Skip server verification when using TLS  # noqa: E501

        :return: The tls_skip_verify of this EndpointUpdateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._tls_skip_verify

    @tls_skip_verify.setter
    def tls_skip_verify(self, tls_skip_verify):
        """Sets the tls_skip_verify of this EndpointUpdateRequest.

        Skip server verification when using TLS  # noqa: E501

        :param tls_skip_verify: The tls_skip_verify of this EndpointUpdateRequest.  # noqa: E501
        :type: bool
        """

        self._tls_skip_verify = tls_skip_verify

    @property
    def tls_skip_client_verify(self):
        """Gets the tls_skip_client_verify of this EndpointUpdateRequest.  # noqa: E501

        Skip client verification when using TLS  # noqa: E501

        :return: The tls_skip_client_verify of this EndpointUpdateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._tls_skip_client_verify

    @tls_skip_client_verify.setter
    def tls_skip_client_verify(self, tls_skip_client_verify):
        """Sets the tls_skip_client_verify of this EndpointUpdateRequest.

        Skip client verification when using TLS  # noqa: E501

        :param tls_skip_client_verify: The tls_skip_client_verify of this EndpointUpdateRequest.  # noqa: E501
        :type: bool
        """

        self._tls_skip_client_verify = tls_skip_client_verify

    @property
    def application_id(self):
        """Gets the application_id of this EndpointUpdateRequest.  # noqa: E501

        Azure application ID  # noqa: E501

        :return: The application_id of this EndpointUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._application_id

    @application_id.setter
    def application_id(self, application_id):
        """Sets the application_id of this EndpointUpdateRequest.

        Azure application ID  # noqa: E501

        :param application_id: The application_id of this EndpointUpdateRequest.  # noqa: E501
        :type: str
        """

        self._application_id = application_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this EndpointUpdateRequest.  # noqa: E501

        Azure tenant ID  # noqa: E501

        :return: The tenant_id of this EndpointUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this EndpointUpdateRequest.

        Azure tenant ID  # noqa: E501

        :param tenant_id: The tenant_id of this EndpointUpdateRequest.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def authentication_key(self):
        """Gets the authentication_key of this EndpointUpdateRequest.  # noqa: E501

        Azure authentication key  # noqa: E501

        :return: The authentication_key of this EndpointUpdateRequest.  # noqa: E501
        :rtype: str
        """
        return self._authentication_key

    @authentication_key.setter
    def authentication_key(self, authentication_key):
        """Sets the authentication_key of this EndpointUpdateRequest.

        Azure authentication key  # noqa: E501

        :param authentication_key: The authentication_key of this EndpointUpdateRequest.  # noqa: E501
        :type: str
        """

        self._authentication_key = authentication_key

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EndpointUpdateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
