# coding: utf-8

"""
    Portainer API

    Portainer API is an HTTP API served by Portainer. It is used by the Portainer UI and everything you can do with the UI can be done using the HTTP API. Examples are available at https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8 You can find out more about Portainer at [http://portainer.io](http://portainer.io) and get some support on [Slack](http://portainer.io/slack/).  # Authentication  Most of the API endpoints require to be authenticated as well as some level of authorization to be used. Portainer API uses JSON Web Token to manage authentication and thus requires you to provide a token in the **Authorization** header of each request with the **Bearer** authentication mechanism.  Example: ``` Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwidXNlcm5hbWUiOiJhZG1pbiIsInJvbGUiOjEsImV4cCI6MTQ5OTM3NjE1NH0.NJ6vE8FY1WG6jsRQzfMqeatJ4vh2TWAeeYfDhP71YEE ```  # Security  Each API endpoint has an associated access policy, it is documented in the description of each endpoint.  Different access policies are available: * Public access * Authenticated access * Restricted access * Administrator access  ### Public access  No authentication is required to access the endpoints with this access policy.  ### Authenticated access  Authentication is required to access the endpoints with this access policy.  ### Restricted access  Authentication is required to access the endpoints with this access policy. Extra-checks might be added to ensure access to the resource is granted. Returned data might also be filtered.  ### Administrator access  Authentication as well as an administrator role are required to access the endpoints with this access policy.  # Execute Docker requests  Portainer **DO NOT** expose specific endpoints to manage your Docker resources (create a container, remove a volume, etc...).  Instead, it acts as a reverse-proxy to the Docker HTTP API. This means that you can execute Docker requests **via** the Portainer HTTP API.  To do so, you can use the `/endpoints/{id}/docker` Portainer API endpoint (which is not documented below due to Swagger limitations). This endpoint has a restricted access policy so you still need to be authenticated to be able to query this endpoint. Any query on this endpoint will be proxied to the Docker API of the associated endpoint (requests and responses objects are the same as documented in the Docker API).  **NOTE**: You can find more information on how to query the Docker API in the [Docker official documentation](https://docs.docker.com/engine/api/v1.30/) as well as in [this Portainer example](https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8).   # noqa: E501

    OpenAPI spec version: 1.20.0
    Contact: info@portainer.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from portainer_api.models.ldap_group_search_settings import LDAPGroupSearchSettings  # noqa: F401,E501
from portainer_api.models.ldap_search_settings import LDAPSearchSettings  # noqa: F401,E501
from portainer_api.models.tls_configuration import TLSConfiguration  # noqa: F401,E501


class LDAPSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'reader_dn': 'str',
        'password': 'str',
        'url': 'str',
        'tls_config': 'TLSConfiguration',
        'start_tls': 'bool',
        'search_settings': 'list[LDAPSearchSettings]',
        'group_search_settings': 'list[LDAPGroupSearchSettings]',
        'auto_create_users': 'bool'
    }

    attribute_map = {
        'reader_dn': 'ReaderDN',
        'password': 'Password',
        'url': 'URL',
        'tls_config': 'TLSConfig',
        'start_tls': 'StartTLS',
        'search_settings': 'SearchSettings',
        'group_search_settings': 'GroupSearchSettings',
        'auto_create_users': 'AutoCreateUsers'
    }

    def __init__(self, reader_dn=None, password=None, url=None, tls_config=None, start_tls=None, search_settings=None, group_search_settings=None, auto_create_users=None):  # noqa: E501
        """LDAPSettings - a model defined in Swagger"""  # noqa: E501

        self._reader_dn = None
        self._password = None
        self._url = None
        self._tls_config = None
        self._start_tls = None
        self._search_settings = None
        self._group_search_settings = None
        self._auto_create_users = None
        self.discriminator = None

        if reader_dn is not None:
            self.reader_dn = reader_dn
        if password is not None:
            self.password = password
        if url is not None:
            self.url = url
        if tls_config is not None:
            self.tls_config = tls_config
        if start_tls is not None:
            self.start_tls = start_tls
        if search_settings is not None:
            self.search_settings = search_settings
        if group_search_settings is not None:
            self.group_search_settings = group_search_settings
        if auto_create_users is not None:
            self.auto_create_users = auto_create_users

    @property
    def reader_dn(self):
        """Gets the reader_dn of this LDAPSettings.  # noqa: E501

        Account that will be used to search for users  # noqa: E501

        :return: The reader_dn of this LDAPSettings.  # noqa: E501
        :rtype: str
        """
        return self._reader_dn

    @reader_dn.setter
    def reader_dn(self, reader_dn):
        """Sets the reader_dn of this LDAPSettings.

        Account that will be used to search for users  # noqa: E501

        :param reader_dn: The reader_dn of this LDAPSettings.  # noqa: E501
        :type: str
        """

        self._reader_dn = reader_dn

    @property
    def password(self):
        """Gets the password of this LDAPSettings.  # noqa: E501

        Password of the account that will be used to search users  # noqa: E501

        :return: The password of this LDAPSettings.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this LDAPSettings.

        Password of the account that will be used to search users  # noqa: E501

        :param password: The password of this LDAPSettings.  # noqa: E501
        :type: str
        """

        self._password = password

    @property
    def url(self):
        """Gets the url of this LDAPSettings.  # noqa: E501

        URL or IP address of the LDAP server  # noqa: E501

        :return: The url of this LDAPSettings.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this LDAPSettings.

        URL or IP address of the LDAP server  # noqa: E501

        :param url: The url of this LDAPSettings.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def tls_config(self):
        """Gets the tls_config of this LDAPSettings.  # noqa: E501


        :return: The tls_config of this LDAPSettings.  # noqa: E501
        :rtype: TLSConfiguration
        """
        return self._tls_config

    @tls_config.setter
    def tls_config(self, tls_config):
        """Sets the tls_config of this LDAPSettings.


        :param tls_config: The tls_config of this LDAPSettings.  # noqa: E501
        :type: TLSConfiguration
        """

        self._tls_config = tls_config

    @property
    def start_tls(self):
        """Gets the start_tls of this LDAPSettings.  # noqa: E501

        Whether LDAP connection should use StartTLS  # noqa: E501

        :return: The start_tls of this LDAPSettings.  # noqa: E501
        :rtype: bool
        """
        return self._start_tls

    @start_tls.setter
    def start_tls(self, start_tls):
        """Sets the start_tls of this LDAPSettings.

        Whether LDAP connection should use StartTLS  # noqa: E501

        :param start_tls: The start_tls of this LDAPSettings.  # noqa: E501
        :type: bool
        """

        self._start_tls = start_tls

    @property
    def search_settings(self):
        """Gets the search_settings of this LDAPSettings.  # noqa: E501


        :return: The search_settings of this LDAPSettings.  # noqa: E501
        :rtype: list[LDAPSearchSettings]
        """
        return self._search_settings

    @search_settings.setter
    def search_settings(self, search_settings):
        """Sets the search_settings of this LDAPSettings.


        :param search_settings: The search_settings of this LDAPSettings.  # noqa: E501
        :type: list[LDAPSearchSettings]
        """

        self._search_settings = search_settings

    @property
    def group_search_settings(self):
        """Gets the group_search_settings of this LDAPSettings.  # noqa: E501


        :return: The group_search_settings of this LDAPSettings.  # noqa: E501
        :rtype: list[LDAPGroupSearchSettings]
        """
        return self._group_search_settings

    @group_search_settings.setter
    def group_search_settings(self, group_search_settings):
        """Sets the group_search_settings of this LDAPSettings.


        :param group_search_settings: The group_search_settings of this LDAPSettings.  # noqa: E501
        :type: list[LDAPGroupSearchSettings]
        """

        self._group_search_settings = group_search_settings

    @property
    def auto_create_users(self):
        """Gets the auto_create_users of this LDAPSettings.  # noqa: E501

        Automatically provision users and assign them to matching LDAP group names  # noqa: E501

        :return: The auto_create_users of this LDAPSettings.  # noqa: E501
        :rtype: bool
        """
        return self._auto_create_users

    @auto_create_users.setter
    def auto_create_users(self, auto_create_users):
        """Sets the auto_create_users of this LDAPSettings.

        Automatically provision users and assign them to matching LDAP group names  # noqa: E501

        :param auto_create_users: The auto_create_users of this LDAPSettings.  # noqa: E501
        :type: bool
        """

        self._auto_create_users = auto_create_users

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LDAPSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
