# coding: utf-8

"""
    Portainer API

    Portainer API is an HTTP API served by Portainer. It is used by the Portainer UI and everything you can do with the UI can be done using the HTTP API. Examples are available at https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8 You can find out more about Portainer at [http://portainer.io](http://portainer.io) and get some support on [Slack](http://portainer.io/slack/).  # Authentication  Most of the API endpoints require to be authenticated as well as some level of authorization to be used. Portainer API uses JSON Web Token to manage authentication and thus requires you to provide a token in the **Authorization** header of each request with the **Bearer** authentication mechanism.  Example: ``` Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwidXNlcm5hbWUiOiJhZG1pbiIsInJvbGUiOjEsImV4cCI6MTQ5OTM3NjE1NH0.NJ6vE8FY1WG6jsRQzfMqeatJ4vh2TWAeeYfDhP71YEE ```  # Security  Each API endpoint has an associated access policy, it is documented in the description of each endpoint.  Different access policies are available: * Public access * Authenticated access * Restricted access * Administrator access  ### Public access  No authentication is required to access the endpoints with this access policy.  ### Authenticated access  Authentication is required to access the endpoints with this access policy.  ### Restricted access  Authentication is required to access the endpoints with this access policy. Extra-checks might be added to ensure access to the resource is granted. Returned data might also be filtered.  ### Administrator access  Authentication as well as an administrator role are required to access the endpoints with this access policy.  # Execute Docker requests  Portainer **DO NOT** expose specific endpoints to manage your Docker resources (create a container, remove a volume, etc...).  Instead, it acts as a reverse-proxy to the Docker HTTP API. This means that you can execute Docker requests **via** the Portainer HTTP API.  To do so, you can use the `/endpoints/{id}/docker` Portainer API endpoint (which is not documented below due to Swagger limitations). This endpoint has a restricted access policy so you still need to be authenticated to be able to query this endpoint. Any query on this endpoint will be proxied to the Docker API of the associated endpoint (requests and responses objects are the same as documented in the Docker API).  **NOTE**: You can find more information on how to query the Docker API in the [Docker official documentation](https://docs.docker.com/engine/api/v1.30/) as well as in [this Portainer example](https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8).   # noqa: E501

    OpenAPI spec version: 1.20.0
    Contact: info@portainer.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Status(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'authentication': 'bool',
        'endpoint_management': 'bool',
        'analytics': 'bool',
        'version': 'str'
    }

    attribute_map = {
        'authentication': 'Authentication',
        'endpoint_management': 'EndpointManagement',
        'analytics': 'Analytics',
        'version': 'Version'
    }

    def __init__(self, authentication=None, endpoint_management=None, analytics=None, version=None):  # noqa: E501
        """Status - a model defined in Swagger"""  # noqa: E501

        self._authentication = None
        self._endpoint_management = None
        self._analytics = None
        self._version = None
        self.discriminator = None

        if authentication is not None:
            self.authentication = authentication
        if endpoint_management is not None:
            self.endpoint_management = endpoint_management
        if analytics is not None:
            self.analytics = analytics
        if version is not None:
            self.version = version

    @property
    def authentication(self):
        """Gets the authentication of this Status.  # noqa: E501

        Is authentication enabled  # noqa: E501

        :return: The authentication of this Status.  # noqa: E501
        :rtype: bool
        """
        return self._authentication

    @authentication.setter
    def authentication(self, authentication):
        """Sets the authentication of this Status.

        Is authentication enabled  # noqa: E501

        :param authentication: The authentication of this Status.  # noqa: E501
        :type: bool
        """

        self._authentication = authentication

    @property
    def endpoint_management(self):
        """Gets the endpoint_management of this Status.  # noqa: E501

        Is endpoint management enabled  # noqa: E501

        :return: The endpoint_management of this Status.  # noqa: E501
        :rtype: bool
        """
        return self._endpoint_management

    @endpoint_management.setter
    def endpoint_management(self, endpoint_management):
        """Sets the endpoint_management of this Status.

        Is endpoint management enabled  # noqa: E501

        :param endpoint_management: The endpoint_management of this Status.  # noqa: E501
        :type: bool
        """

        self._endpoint_management = endpoint_management

    @property
    def analytics(self):
        """Gets the analytics of this Status.  # noqa: E501

        Is analytics enabled  # noqa: E501

        :return: The analytics of this Status.  # noqa: E501
        :rtype: bool
        """
        return self._analytics

    @analytics.setter
    def analytics(self, analytics):
        """Sets the analytics of this Status.

        Is analytics enabled  # noqa: E501

        :param analytics: The analytics of this Status.  # noqa: E501
        :type: bool
        """

        self._analytics = analytics

    @property
    def version(self):
        """Gets the version of this Status.  # noqa: E501

        Portainer API version  # noqa: E501

        :return: The version of this Status.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Status.

        Portainer API version  # noqa: E501

        :param version: The version of this Status.  # noqa: E501
        :type: str
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Status):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
