# coding: utf-8

"""
    Portainer API

    Portainer API is an HTTP API served by Portainer. It is used by the Portainer UI and everything you can do with the UI can be done using the HTTP API. Examples are available at https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8 You can find out more about Portainer at [http://portainer.io](http://portainer.io) and get some support on [Slack](http://portainer.io/slack/).  # Authentication  Most of the API endpoints require to be authenticated as well as some level of authorization to be used. Portainer API uses JSON Web Token to manage authentication and thus requires you to provide a token in the **Authorization** header of each request with the **Bearer** authentication mechanism.  Example: ``` Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwidXNlcm5hbWUiOiJhZG1pbiIsInJvbGUiOjEsImV4cCI6MTQ5OTM3NjE1NH0.NJ6vE8FY1WG6jsRQzfMqeatJ4vh2TWAeeYfDhP71YEE ```  # Security  Each API endpoint has an associated access policy, it is documented in the description of each endpoint.  Different access policies are available: * Public access * Authenticated access * Restricted access * Administrator access  ### Public access  No authentication is required to access the endpoints with this access policy.  ### Authenticated access  Authentication is required to access the endpoints with this access policy.  ### Restricted access  Authentication is required to access the endpoints with this access policy. Extra-checks might be added to ensure access to the resource is granted. Returned data might also be filtered.  ### Administrator access  Authentication as well as an administrator role are required to access the endpoints with this access policy.  # Execute Docker requests  Portainer **DO NOT** expose specific endpoints to manage your Docker resources (create a container, remove a volume, etc...).  Instead, it acts as a reverse-proxy to the Docker HTTP API. This means that you can execute Docker requests **via** the Portainer HTTP API.  To do so, you can use the `/endpoints/{id}/docker` Portainer API endpoint (which is not documented below due to Swagger limitations). This endpoint has a restricted access policy so you still need to be authenticated to be able to query this endpoint. Any query on this endpoint will be proxied to the Docker API of the associated endpoint (requests and responses objects are the same as documented in the Docker API).  **NOTE**: You can find more information on how to query the Docker API in the [Docker official documentation](https://docs.docker.com/engine/api/v1.30/) as well as in [this Portainer example](https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8).   # noqa: E501

    OpenAPI spec version: 1.20.0
    Contact: info@portainer.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from portainer_api.models.template_env_select import TemplateEnvSelect  # noqa: F401,E501


class TemplateEnv(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'label': 'str',
        'description': 'str',
        'default': 'str',
        'preset': 'bool',
        'select': 'list[TemplateEnvSelect]'
    }

    attribute_map = {
        'name': 'name',
        'label': 'label',
        'description': 'description',
        'default': 'default',
        'preset': 'preset',
        'select': 'select'
    }

    def __init__(self, name=None, label=None, description=None, default=None, preset=None, select=None):  # noqa: E501
        """TemplateEnv - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._label = None
        self._description = None
        self._default = None
        self._preset = None
        self._select = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if label is not None:
            self.label = label
        if description is not None:
            self.description = description
        if default is not None:
            self.default = default
        if preset is not None:
            self.preset = preset
        if select is not None:
            self.select = select

    @property
    def name(self):
        """Gets the name of this TemplateEnv.  # noqa: E501

        name of the environment variable  # noqa: E501

        :return: The name of this TemplateEnv.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TemplateEnv.

        name of the environment variable  # noqa: E501

        :param name: The name of this TemplateEnv.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def label(self):
        """Gets the label of this TemplateEnv.  # noqa: E501

        Text for the label that will be generated in the UI  # noqa: E501

        :return: The label of this TemplateEnv.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this TemplateEnv.

        Text for the label that will be generated in the UI  # noqa: E501

        :param label: The label of this TemplateEnv.  # noqa: E501
        :type: str
        """

        self._label = label

    @property
    def description(self):
        """Gets the description of this TemplateEnv.  # noqa: E501

        Content of the tooltip that will be generated in the UI  # noqa: E501

        :return: The description of this TemplateEnv.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TemplateEnv.

        Content of the tooltip that will be generated in the UI  # noqa: E501

        :param description: The description of this TemplateEnv.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def default(self):
        """Gets the default of this TemplateEnv.  # noqa: E501

        Default value that will be set for the variable  # noqa: E501

        :return: The default of this TemplateEnv.  # noqa: E501
        :rtype: str
        """
        return self._default

    @default.setter
    def default(self, default):
        """Sets the default of this TemplateEnv.

        Default value that will be set for the variable  # noqa: E501

        :param default: The default of this TemplateEnv.  # noqa: E501
        :type: str
        """

        self._default = default

    @property
    def preset(self):
        """Gets the preset of this TemplateEnv.  # noqa: E501

        If set to true, will not generate any input for this variable in the UI  # noqa: E501

        :return: The preset of this TemplateEnv.  # noqa: E501
        :rtype: bool
        """
        return self._preset

    @preset.setter
    def preset(self, preset):
        """Sets the preset of this TemplateEnv.

        If set to true, will not generate any input for this variable in the UI  # noqa: E501

        :param preset: The preset of this TemplateEnv.  # noqa: E501
        :type: bool
        """

        self._preset = preset

    @property
    def select(self):
        """Gets the select of this TemplateEnv.  # noqa: E501

        A list of name/value that will be used to generate a dropdown in the UI  # noqa: E501

        :return: The select of this TemplateEnv.  # noqa: E501
        :rtype: list[TemplateEnvSelect]
        """
        return self._select

    @select.setter
    def select(self, select):
        """Sets the select of this TemplateEnv.

        A list of name/value that will be used to generate a dropdown in the UI  # noqa: E501

        :param select: The select of this TemplateEnv.  # noqa: E501
        :type: list[TemplateEnvSelect]
        """

        self._select = select

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TemplateEnv):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
