from ck.pgm import PGM


class Hailfinder(PGM):
    """
    This PGM is the well known 'Hailfinder' Bayesian network.
    """

    def __init__(self):
        super().__init__(self.__class__.__name__)

        pgm_rv0 = self.new_rv('N0_7muVerMo', ('StrongUp', 'WeakUp', 'Neutral', 'Down'))
        pgm_rv1 = self.new_rv('SubjVertMo', ('StronUp', 'WeakUp', 'Neutral', 'Down'))
        pgm_rv2 = self.new_rv('QGVertMotion', ('StrongUp', 'WeakUp', 'Neutral', 'Down'))
        pgm_rv3 = self.new_rv('CombVerMo', ('StrongUp', 'WeakUp', 'Neutral', 'Down'))
        pgm_rv4 = self.new_rv('AreaMeso_ALS', ('StrongUp', 'WeakUp', 'Neutral', 'Down'))
        pgm_rv5 = self.new_rv('SatContMoist', ('VeryWet', 'Wet', 'Neutral', 'Dry'))
        pgm_rv6 = self.new_rv('RaoContMoist', ('VeryWet', 'Wet', 'Neutral', 'Dry'))
        pgm_rv7 = self.new_rv('CombMoisture', ('VeryWet', 'Wet', 'Neutral', 'Dry'))
        pgm_rv8 = self.new_rv('AreaMoDryAir', ('VeryWet', 'Wet', 'Neutral', 'Dry'))
        pgm_rv9 = self.new_rv('VISCloudCov', ('Cloudy', 'PC', 'Clear'))
        pgm_rv10 = self.new_rv('IRCloudCover', ('Cloudy', 'PC', 'Clear'))
        pgm_rv11 = self.new_rv('CombClouds', ('Cloudy', 'PC', 'Clear'))
        pgm_rv12 = self.new_rv('CldShadeOth', ('Cloudy', 'PC', 'Clear'))
        pgm_rv13 = self.new_rv('AMInstabMt', ('None', 'Weak', 'Strong'))
        pgm_rv14 = self.new_rv('InsInMt', ('None', 'Weak', 'Strong'))
        pgm_rv15 = self.new_rv('WndHodograph', ('DCVZFavor', 'StrongWest', 'Westerly', 'Other'))
        pgm_rv16 = self.new_rv('OutflowFrMt', ('None', 'Weak', 'Strong'))
        pgm_rv17 = self.new_rv('MorningBound', ('None', 'Weak', 'Strong'))
        pgm_rv18 = self.new_rv('Boundaries', ('None', 'Weak', 'Strong'))
        pgm_rv19 = self.new_rv('CldShadeConv', ('None', 'Some', 'Marked'))
        pgm_rv20 = self.new_rv('CompPlFcst', ('IncCapDecIns', 'LittleChange', 'DecCapIncIns'))
        pgm_rv21 = self.new_rv('CapChange', ('Decreasing', 'LittleChange', 'Increasing'))
        pgm_rv22 = self.new_rv('LoLevMoistAd', ('StrongPos', 'WeakPos', 'Neutral', 'Negative'))
        pgm_rv23 = self.new_rv('InsChange', ('Decreasing', 'LittleChange', 'Increasing'))
        pgm_rv24 = self.new_rv('MountainFcst', ('XNIL', 'SIG', 'SVR'))
        pgm_rv25 = self.new_rv('Date',
                               ('May15_Jun14', 'Jun15_Jul1', 'Jul2_Jul15', 'Jul16_Aug10', 'Aug11_Aug20', 'Aug20_Sep15'))
        pgm_rv26 = self.new_rv('Scenario', ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K'))
        pgm_rv27 = self.new_rv('ScenRelAMCIN', ('AB', 'CThruK'))
        pgm_rv28 = self.new_rv('MorningCIN', ('None', 'PartInhibit', 'Stifling', 'TotalInhibit'))
        pgm_rv29 = self.new_rv('AMCINInScen', ('LessThanAve', 'Average', 'MoreThanAve'))
        pgm_rv30 = self.new_rv('CapInScen', ('LessThanAve', 'Average', 'MoreThanAve'))
        pgm_rv31 = self.new_rv('ScenRelAMIns', ('ABI', 'CDEJ', 'F', 'G', 'H', 'K'))
        pgm_rv32 = self.new_rv('LIfr12ZDENSd', ('LIGt0', 'N1GtLIGt_4', 'N5GtLIGt_8', 'LILt_8'))
        pgm_rv33 = self.new_rv('AMDewptCalPl', ('Instability', 'Neutral', 'Stability'))
        pgm_rv34 = self.new_rv('AMInsWliScen', ('LessUnstable', 'Average', 'MoreUnstable'))
        pgm_rv35 = self.new_rv('InsSclInScen', ('LessUnstable', 'Average', 'MoreUnstable'))
        pgm_rv36 = self.new_rv('ScenRel3_4', ('ACEFK', 'B', 'D', 'GJ', 'HI'))
        pgm_rv37 = self.new_rv('LatestCIN', ('None', 'PartInhibit', 'Stifling', 'TotalInhibit'))
        pgm_rv38 = self.new_rv('LLIW', ('Unfavorable', 'Weak', 'Moderate', 'Strong'))
        pgm_rv39 = self.new_rv('CurPropConv', ('None', 'Slight', 'Moderate', 'Strong'))
        pgm_rv40 = self.new_rv('ScnRelPlFcst', ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K'))
        pgm_rv41 = self.new_rv('PlainsFcst', ('XNIL', 'SIG', 'SVR'))
        pgm_rv42 = self.new_rv('N34StarFcst', ('XNIL', 'SIG', 'SVR'))
        pgm_rv43 = self.new_rv('R5Fcst', ('XNIL', 'SIG', 'SVR'))
        pgm_rv44 = self.new_rv(
            'Dewpoints',
            ('LowEvrywhere', 'LowAtStation', 'LowSHighN', 'LowNHighS', 'LowMtsHighPl', 'HighEvrywher', 'Other'),
        )
        pgm_rv45 = self.new_rv('LowLLapse', ('CloseToDryAd', 'Steep', 'ModerateOrLe', 'Stable'))
        pgm_rv46 = self.new_rv('MeanRH', ('VeryMoist', 'Average', 'Dry'))
        pgm_rv47 = self.new_rv('MidLLapse', ('CloseToDryAd', 'Steep', 'ModerateOrLe'))
        pgm_rv48 = self.new_rv('MvmtFeatures', ('StrongFront', 'MarkedUpper', 'OtherRapid', 'NoMajor'))
        pgm_rv49 = self.new_rv('RHRatio', ('MoistMDryL', 'DryMMoistL', 'Other'))
        pgm_rv50 = self.new_rv('SfcWndShfDis',
                               ('DenvCyclone', 'E_W_N', 'E_W_S', 'MovingFtorOt', 'DryLine', 'None', 'Other'))
        pgm_rv51 = self.new_rv('SynForcng', ('SigNegative', 'NegToPos', 'SigPositive', 'PosToNeg', 'LittleChange'))
        pgm_rv52 = self.new_rv('TempDis', ('QStationary', 'Moving', 'None', 'Other'))
        pgm_rv53 = self.new_rv('WindAloft', ('LV', 'SWQuad', 'NWQuad', 'AllElse'))
        pgm_rv54 = self.new_rv('WindFieldMt', ('Westerly', 'LVorOther'))
        pgm_rv55 = self.new_rv('WindFieldPln', ('LV', 'DenvCyclone', 'LongAnticyc', 'E_NE', 'SEQuad', 'WidespdDnsl'))

        pgm_factor0 = self.new_factor(pgm_rv0)
        pgm_function_2955280956688 = pgm_factor0.set_dense()
        pgm_function_2955280956688.set_flat(0.25, 0.25, 0.25, 0.25)
        pgm_factor1 = self.new_factor(pgm_rv1)
        pgm_function_2955280953728 = pgm_factor1.set_dense()
        pgm_function_2955280953728.set_flat(0.15, 0.15, 0.5, 0.2)
        pgm_factor2 = self.new_factor(pgm_rv2)
        pgm_function_2955280955328 = pgm_factor2.set_dense()
        pgm_function_2955280955328.set_flat(0.15, 0.15, 0.5, 0.2)
        pgm_factor3 = self.new_factor(pgm_rv3, pgm_rv0, pgm_rv1, pgm_rv2)
        pgm_function_2955280955408 = pgm_factor3.set_dense()
        pgm_function_2955280955408.set_flat(
            1.0, 0.9, 0.7, 0.2, 0.9, 0.7, 0.15, 0.1, 0.7, 0.15, 0.2, 0.1, 0.2, 0.1, 0.1,
            0.1, 0.9, 0.7, 0.15, 0.1, 0.7, 0.0, 0.0, 0.0, 0.15, 0.0, 0.0, 0.0, 0.1, 0.0,
            0.0, 0.0, 0.7, 0.15, 0.2, 0.1, 0.15, 0.0, 0.0, 0.0, 0.2, 0.0, 0.0, 0.0, 0.1,
            0.0, 0.0, 0.0, 0.2, 0.1, 0.1, 0.1, 0.1, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0,
            0.1, 0.0, 0.0, 0.0, 0.0, 0.1, 0.2, 0.5, 0.1, 0.3, 0.7, 0.35, 0.2, 0.7, 0.6,
            0.2, 0.5, 0.35, 0.2, 0.1, 0.1, 0.3, 0.7, 0.35, 0.3, 1.0, 0.7, 0.2, 0.7, 0.7,
            0.3, 0.15, 0.35, 0.2, 0.15, 0.1, 0.2, 0.7, 0.6, 0.2,
            0.7, 0.7, 0.3, 0.15, 0.6, 0.3, 0.0, 0.0, 0.2, 0.15, 0.0, 0.0, 0.5, 0.35,
            0.2, 0.1, 0.35, 0.2, 0.15, 0.1, 0.2, 0.15, 0.0, 0.0, 0.1, 0.1, 0.0, 0.0,
            0.0, 0.0, 0.1, 0.2, 0.0, 0.0, 0.15, 0.45, 0.1, 0.15, 0.2, 0.6, 0.2, 0.45,
            0.6, 0.2, 0.0, 0.0, 0.15, 0.45, 0.0, 0.0, 0.3, 0.7, 0.15, 0.3, 0.7, 0.5,
            0.45, 0.7, 0.5, 0.2, 0.1, 0.15, 0.2, 0.6, 0.15, 0.3, 0.7, 0.5, 0.2, 0.7,
            1.0, 0.7, 0.6, 0.5, 0.7, 0.3, 0.2, 0.45, 0.6, 0.2, 0.45, 0.7, 0.5, 0.2, 0.6,
            0.5, 0.7, 0.3, 0.2, 0.2, 0.3, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.1,
            0.0, 0.0, 0.0, 0.1, 0.1, 0.1, 0.1, 0.6, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0,
            0.1, 0.0, 0.0, 0.0, 0.35, 0.1, 0.1, 0.35, 0.7, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0,
            0.0, 0.35, 0.0, 0.0, 0.0, 0.3, 0.1, 0.35, 0.3, 0.7, 0.1, 0.1, 0.1, 0.6, 0.1,
            0.1, 0.35, 0.7, 0.1, 0.35, 0.3, 0.7, 0.6, 0.7, 0.7, 1.0)
        pgm_factor4 = self.new_factor(pgm_rv4, pgm_rv3)
        pgm_function_2955280956848 = pgm_factor4.set_dense()
        pgm_function_2955280956848.set_flat(
            1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0,
            1.0)
        pgm_factor5 = self.new_factor(pgm_rv5)
        pgm_function_2955280953408 = pgm_factor5.set_dense()
        pgm_function_2955280953408.set_flat(0.15, 0.2, 0.4, 0.25)
        pgm_factor6 = self.new_factor(pgm_rv6)
        pgm_function_2955280955488 = pgm_factor6.set_dense()
        pgm_function_2955280955488.set_flat(0.15, 0.2, 0.4, 0.25)
        pgm_factor7 = self.new_factor(pgm_rv7, pgm_rv5, pgm_rv6)
        pgm_function_2955280954048 = pgm_factor7.set_dense()
        pgm_function_2955280954048.set_flat(
            0.9, 0.6, 0.3, 0.25, 0.55, 0.15, 0.05, 0.1, 0.25, 0.1, 0.0, 0.0, 0.25, 0.25,
            0.25, 0.25, 0.1, 0.35, 0.5, 0.35, 0.4, 0.6, 0.4, 0.3, 0.3, 0.35, 0.15, 0.1,
            0.25, 0.25, 0.25, 0.25, 0.0, 0.05, 0.2, 0.25, 0.05, 0.2, 0.45, 0.3, 0.35,
            0.5, 0.7, 0.4, 0.25, 0.25, 0.25, 0.25, 0.0, 0.0, 0.0, 0.15, 0.0, 0.05, 0.1,
            0.3, 0.1, 0.05, 0.15, 0.5, 0.25, 0.25, 0.25, 0.25)
        pgm_factor8 = self.new_factor(pgm_rv8, pgm_rv4, pgm_rv7)
        pgm_function_2955280954128 = pgm_factor8.set_dense()
        pgm_function_2955280954128.set_flat(
            0.99, 0.7, 0.2, 0.0, 0.8, 0.35, 0.01, 0.0, 0.7, 0.2, 0.01, 0.0, 0.2, 0.05,
            0.0, 0.0, 0.01, 0.29, 0.55, 0.25, 0.2, 0.55, 0.39, 0.02, 0.29, 0.6, 0.09,
            0.0, 0.74, 0.4, 0.05, 0.0, 0.0, 0.01, 0.24, 0.55, 0.0, 0.1, 0.55, 0.43,
            0.01, 0.2, 0.8, 0.3, 0.06, 0.45, 0.5, 0.01, 0.0, 0.0, 0.01, 0.2, 0.0, 0.0,
            0.05, 0.55, 0.0, 0.0, 0.1, 0.7, 0.0, 0.1, 0.45, 0.99)
        pgm_factor9 = self.new_factor(pgm_rv9)
        pgm_function_2955280953568 = pgm_factor9.set_dense()
        pgm_function_2955280953568.set_flat(0.1, 0.5, 0.4)
        pgm_factor10 = self.new_factor(pgm_rv10)
        pgm_function_2955280953648 = pgm_factor10.set_dense()
        pgm_function_2955280953648.set_flat(0.15, 0.45, 0.4)
        pgm_factor11 = self.new_factor(pgm_rv11, pgm_rv9, pgm_rv10)
        pgm_function_2955280790816 = pgm_factor11.set_dense()
        pgm_function_2955280790816.set_flat(
            0.95, 0.85, 0.8, 0.45, 0.1, 0.05, 0.1, 0.02, 0.0, 0.04, 0.13, 0.1, 0.52,
            0.8, 0.45, 0.4, 0.28, 0.02, 0.01, 0.02, 0.1, 0.03, 0.1, 0.5, 0.5, 0.7, 0.98)
        pgm_factor12 = self.new_factor(pgm_rv12, pgm_rv8, pgm_rv4, pgm_rv11)
        pgm_function_2955280788736 = pgm_factor12.set_dense()
        pgm_function_2955280788736.set_flat(
            1.0, 0.85, 0.25, 0.95, 0.4, 0.05, 0.93, 0.2, 0.01, 0.74, 0.0, 0.0, 0.92,
            0.7, 0.15, 0.9, 0.25, 0.01, 0.8, 0.01, 0.0, 0.65, 0.0, 0.0, 0.88, 0.4, 0.1,
            0.85, 0.15, 0.0, 0.8, 0.03, 0.0, 0.5, 0.01, 0.0, 0.85, 0.55, 0.1, 0.6, 0.01,
            0.0, 0.78, 0.01, 0.0, 0.42, 0.05, 0.0, 0.0, 0.15, 0.35, 0.05, 0.55, 0.45,
            0.07, 0.78, 0.29, 0.25, 0.5, 0.1, 0.08, 0.29, 0.4, 0.09, 0.6, 0.3, 0.2,
            0.89, 0.1, 0.34, 0.4, 0.02, 0.12, 0.5, 0.4, 0.15, 0.75, 0.2, 0.18, 0.85,
            0.05, 0.48, 0.74, 0.01, 0.14, 0.43, 0.25, 0.39, 0.9, 0.15, 0.2, 0.74, 0.04,
            0.55, 0.65, 0.0, 0.0, 0.0, 0.4, 0.0,
            0.05, 0.5, 0.0, 0.02, 0.7, 0.01, 0.5, 0.9, 0.0, 0.01, 0.45, 0.01, 0.15,
            0.69, 0.0, 0.1, 0.9, 0.01, 0.6, 0.98, 0.0, 0.1, 0.5, 0.0, 0.1, 0.8, 0.02,
            0.12, 0.95, 0.02, 0.25, 0.99, 0.01, 0.02, 0.65, 0.01, 0.09, 0.85, 0.02,
            0.25, 0.96, 0.03, 0.3, 1.0)
        pgm_factor13 = self.new_factor(pgm_rv13)
        pgm_function_2955280788816 = pgm_factor13.set_dense()
        pgm_function_2955280788816.set_flat(0.333333, 0.333333, 0.333334)
        pgm_factor14 = self.new_factor(pgm_rv14, pgm_rv12, pgm_rv13)
        pgm_function_2955280790736 = pgm_factor14.set_dense()
        pgm_function_2955280790736.set_flat(
            0.9, 0.01, 0.0, 0.6, 0.0, 0.0, 0.5, 0.0, 0.0, 0.1, 0.4, 0.05, 0.39, 0.4,
            0.0, 0.35, 0.15, 0.0, 0.0, 0.59, 0.95, 0.01, 0.6, 1.0, 0.15, 0.85, 1.0)
        pgm_factor15 = self.new_factor(pgm_rv15)
        pgm_function_2955280787616 = pgm_factor15.set_dense()
        pgm_function_2955280787616.set_flat(0.3, 0.25, 0.25, 0.2)
        pgm_factor16 = self.new_factor(pgm_rv16, pgm_rv14, pgm_rv15)
        pgm_function_2955280787696 = pgm_factor16.set_dense()
        pgm_function_2955280787696.set_flat(
            1.0, 1.0, 1.0, 1.0, 0.5, 0.15, 0.35, 0.8, 0.05, 0.01, 0.1, 0.6, 0.0, 0.0,
            0.0, 0.0, 0.4, 0.4, 0.6, 0.19, 0.45, 0.15, 0.25, 0.3, 0.0, 0.0, 0.0, 0.0,
            0.1, 0.45, 0.05, 0.01, 0.5, 0.84, 0.65, 0.1)
        pgm_factor17 = self.new_factor(pgm_rv17)
        pgm_function_2955280787856 = pgm_factor17.set_dense()
        pgm_function_2955280787856.set_flat(0.5, 0.35, 0.15)
        pgm_factor18 = self.new_factor(pgm_rv18, pgm_rv16, pgm_rv15, pgm_rv17)
        pgm_function_2955280791056 = pgm_factor18.set_dense()
        pgm_function_2955280791056.set_flat(
            0.5, 0.3, 0.1, 0.75, 0.45, 0.25, 0.8, 0.35, 0.25, 0.7, 0.25, 0.05, 0.3, 0.1,
            0.05, 0.15, 0.1, 0.05, 0.15, 0.05, 0.05, 0.4, 0.2, 0.05, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.02, 0.01, 0.01, 0.48, 0.5, 0.25, 0.22, 0.45, 0.4,
            0.18, 0.5, 0.35, 0.28, 0.6, 0.35, 0.63, 0.5, 0.2, 0.7, 0.75, 0.5, 0.7, 0.8,
            0.45, 0.55, 0.65, 0.3, 0.55, 0.4, 0.15, 0.5, 0.4, 0.2, 0.7, 0.5, 0.2, 0.73,
            0.5, 0.2, 0.02, 0.2, 0.65, 0.03, 0.1, 0.35, 0.02, 0.15, 0.4, 0.02, 0.15,
            0.6, 0.07, 0.4, 0.75, 0.15, 0.15, 0.45, 0.15, 0.15, 0.5, 0.05, 0.15, 0.65,
            0.45, 0.6, 0.85, 0.5,
            0.6, 0.8, 0.3, 0.5, 0.8, 0.25, 0.49, 0.79)
        pgm_factor19 = self.new_factor(pgm_rv19, pgm_rv14, pgm_rv15)
        pgm_function_2955280787936 = pgm_factor19.set_dense()
        pgm_function_2955280787936.set_flat(
            1.0, 1.0, 1.0, 1.0, 0.3, 0.2, 0.5, 0.8, 0.0, 0.0, 0.1, 0.5, 0.0, 0.0, 0.0,
            0.0, 0.6, 0.7, 0.46, 0.19, 0.3, 0.2, 0.5, 0.38, 0.0, 0.0, 0.0, 0.0, 0.1,
            0.1, 0.04, 0.01, 0.7, 0.8, 0.4, 0.12)
        pgm_factor20 = self.new_factor(pgm_rv20, pgm_rv18, pgm_rv19, pgm_rv4, pgm_rv12)
        pgm_function_2955280790896 = pgm_factor20.set_dense()
        pgm_function_2955280790896.set_flat(
            0.4, 0.1, 0.05, 0.6, 0.4, 0.2, 0.6, 0.45, 0.25, 0.7, 0.65, 0.6, 0.4, 0.25,
            0.15, 0.65, 0.45, 0.25, 0.65, 0.5, 0.3, 0.75, 0.7, 0.65, 0.45, 0.4, 0.35,
            0.7, 0.55, 0.4, 0.7, 0.6, 0.55, 0.85, 0.8, 0.75, 0.35, 0.05, 0.03, 0.5, 0.3,
            0.15, 0.55, 0.4, 0.2, 0.6, 0.6, 0.55, 0.35, 0.1, 0.05, 0.55, 0.35, 0.2, 0.6,
            0.45, 0.25, 0.65, 0.65, 0.6, 0.4, 0.25, 0.2, 0.65, 0.45, 0.3, 0.65, 0.55,
            0.5, 0.78, 0.75, 0.7, 0.3, 0.01, 0.01, 0.35, 0.15, 0.1, 0.45, 0.3, 0.15,
            0.5, 0.48, 0.45, 0.3, 0.05, 0.04, 0.4, 0.2, 0.12, 0.5, 0.35, 0.2, 0.55,
            0.55, 0.5, 0.3, 0.15, 0.13, 0.5,
            0.35, 0.2, 0.55, 0.45, 0.4, 0.7, 0.65, 0.6, 0.35, 0.35, 0.3, 0.25, 0.3, 0.5,
            0.35, 0.4, 0.45, 0.27, 0.3, 0.35, 0.35, 0.3, 0.35, 0.25, 0.3, 0.5, 0.3, 0.4,
            0.45, 0.23, 0.26, 0.32, 0.3, 0.3, 0.3, 0.22, 0.3, 0.45, 0.27, 0.3, 0.33,
            0.14, 0.17, 0.23, 0.35, 0.35, 0.25, 0.25, 0.35, 0.45, 0.3, 0.4, 0.4, 0.35,
            0.3, 0.33, 0.35, 0.35, 0.3, 0.25, 0.35, 0.5, 0.3, 0.4, 0.5, 0.3, 0.3, 0.35,
            0.35, 0.4, 0.4, 0.25, 0.35, 0.5, 0.3, 0.3, 0.3, 0.18, 0.2, 0.25, 0.3, 0.25,
            0.2, 0.25, 0.4, 0.35, 0.3, 0.4, 0.4, 0.35, 0.32, 0.35, 0.3, 0.6, 0.27, 0.25,
            0.4, 0.43, 0.3, 0.4,
            0.45, 0.35, 0.3, 0.4, 0.35, 0.35, 0.35, 0.25, 0.35, 0.45, 0.35, 0.35, 0.35,
            0.24, 0.28, 0.3, 0.25, 0.55, 0.65, 0.15, 0.3, 0.3, 0.05, 0.15, 0.3, 0.03,
            0.05, 0.05, 0.25, 0.45, 0.5, 0.1, 0.25, 0.25, 0.05, 0.1, 0.25, 0.02, 0.04,
            0.03, 0.25, 0.3, 0.35, 0.08, 0.15, 0.15, 0.03, 0.1, 0.12, 0.01, 0.03, 0.02,
            0.3, 0.6, 0.72, 0.25, 0.35, 0.4, 0.15, 0.2, 0.4, 0.05, 0.1, 0.12, 0.3, 0.55,
            0.65, 0.2, 0.3, 0.3, 0.1, 0.15, 0.25, 0.05, 0.05, 0.05, 0.25, 0.35, 0.4,
            0.1, 0.2, 0.2, 0.05, 0.15, 0.2, 0.04, 0.05, 0.05, 0.4, 0.74, 0.79, 0.4,
            0.45, 0.55, 0.25, 0.3, 0.45, 0.15, 0.2, 0.2,
            0.4, 0.35, 0.69, 0.35, 0.4, 0.45, 0.2, 0.25, 0.35, 0.1, 0.15, 0.1, 0.35,
            0.5, 0.52, 0.25, 0.3, 0.35, 0.1, 0.2, 0.25, 0.06, 0.07, 0.1)
        pgm_factor21 = self.new_factor(pgm_rv21, pgm_rv20)
        pgm_function_2955280789536 = pgm_factor21.set_dense()
        pgm_function_2955280789536.set_flat(0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0)
        pgm_factor22 = self.new_factor(pgm_rv22)
        pgm_function_2955280789616 = pgm_factor22.set_dense()
        pgm_function_2955280789616.set_flat(0.12, 0.28, 0.3, 0.3)
        pgm_factor23 = self.new_factor(pgm_rv23, pgm_rv22, pgm_rv20)
        pgm_function_2955280789456 = pgm_factor23.set_dense()
        pgm_function_2955280789456.set_flat(
            0.0, 0.0, 0.05, 0.05, 0.1, 0.25, 0.15, 0.2, 0.35, 0.5, 0.8, 0.9, 0.05, 0.12,
            0.15, 0.15, 0.4, 0.5, 0.5, 0.6, 0.5, 0.4, 0.16, 0.09, 0.95, 0.88, 0.8, 0.8,
            0.5, 0.25, 0.35, 0.2, 0.15, 0.1, 0.04, 0.01)
        pgm_factor24 = self.new_factor(pgm_rv24, pgm_rv14)
        pgm_function_2955280788016 = pgm_factor24.set_dense()
        pgm_function_2955280788016.set_flat(
            1.0, 0.48, 0.2, 0.0, 0.5, 0.5, 0.0, 0.02, 0.3)
        pgm_factor25 = self.new_factor(pgm_rv25)
        pgm_function_2955280788096 = pgm_factor25.set_dense()
        pgm_function_2955280788096.set_flat(
            0.254098, 0.131148, 0.106557, 0.213115, 0.07377, 0.221312)
        pgm_factor26 = self.new_factor(pgm_rv26, pgm_rv25)
        pgm_function_2955280789216 = pgm_factor26.set_dense()
        pgm_function_2955280789216.set_flat(
            0.1, 0.05, 0.04, 0.04, 0.04, 0.05, 0.16, 0.16, 0.13, 0.13, 0.11, 0.11, 0.1,
            0.09, 0.1, 0.09, 0.1, 0.1, 0.08, 0.09, 0.08, 0.07, 0.07, 0.08, 0.08, 0.12,
            0.15, 0.2, 0.17, 0.11, 0.01, 0.02, 0.03, 0.08, 0.05, 0.02, 0.08, 0.13, 0.14,
            0.06, 0.1, 0.11, 0.1, 0.06, 0.04, 0.05, 0.05, 0.06, 0.09, 0.07, 0.06, 0.07,
            0.07, 0.08, 0.03, 0.11, 0.15, 0.13, 0.14, 0.11, 0.17, 0.1, 0.08, 0.08, 0.1,
            0.17)
        pgm_factor27 = self.new_factor(pgm_rv27, pgm_rv26)
        pgm_function_2955280789056 = pgm_factor27.set_dense()
        pgm_function_2955280789056.set_flat(
            1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0,
            1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0)
        pgm_factor28 = self.new_factor(pgm_rv28)
        pgm_function_2955280788256 = pgm_factor28.set_dense()
        pgm_function_2955280788256.set_flat(0.15, 0.57, 0.2, 0.08)
        pgm_factor29 = self.new_factor(pgm_rv29, pgm_rv27, pgm_rv28)
        pgm_function_2955280787776 = pgm_factor29.set_dense()
        pgm_function_2955280787776.set_flat(
            1.0, 0.6, 0.25, 0.0, 0.75, 0.3, 0.01, 0.0, 0.0, 0.37, 0.45, 0.1, 0.25, 0.6,
            0.4, 0.03, 0.0, 0.03, 0.3, 0.9, 0.0, 0.1, 0.59, 0.97)
        pgm_factor30 = self.new_factor(pgm_rv30, pgm_rv29, pgm_rv21)
        pgm_function_2955280790176 = pgm_factor30.set_dense()
        pgm_function_2955280790176.set_flat(
            1.0, 0.98, 0.35, 0.75, 0.03, 0.0, 0.3, 0.0, 0.0, 0.0, 0.02, 0.35, 0.25,
            0.94, 0.25, 0.35, 0.02, 0.0, 0.0, 0.0, 0.3, 0.0, 0.03, 0.75, 0.35, 0.98,
            1.0)
        pgm_factor31 = self.new_factor(pgm_rv31, pgm_rv26)
        pgm_function_2955280787216 = pgm_factor31.set_dense()
        pgm_function_2955280787216.set_flat(
            1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0,
            1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 1.0)
        pgm_factor32 = self.new_factor(pgm_rv32)
        pgm_function_2955280787536 = pgm_factor32.set_dense()
        pgm_function_2955280787536.set_flat(0.1, 0.52, 0.3, 0.08)
        pgm_factor33 = self.new_factor(pgm_rv33)
        pgm_function_2955280790976 = pgm_factor33.set_dense()
        pgm_function_2955280790976.set_flat(0.3, 0.25, 0.45)
        pgm_factor34 = self.new_factor(pgm_rv34, pgm_rv31, pgm_rv32, pgm_rv33)
        pgm_function_2955280789936 = pgm_factor34.set_dense()
        pgm_function_2955280789936.set_flat(
            0.6, 0.85, 0.95, 0.3, 0.5, 0.75, 0.06, 0.2, 0.5, 0.01, 0.05, 0.35, 0.4, 0.7,
            0.9, 0.15, 0.25, 0.6, 0.03, 0.2, 0.45, 0.01, 0.05, 0.25, 0.35, 0.55, 0.85,
            0.07, 0.2, 0.5, 0.0, 0.05, 0.25, 0.0, 0.0, 0.04, 0.3, 0.5, 0.75, 0.15, 0.2,
            0.15, 0.07, 0.13, 0.1, 0.02, 0.04, 0.07, 0.35, 0.4, 0.58, 0.1, 0.15, 0.4,
            0.02, 0.05, 0.15, 0.01, 0.03, 0.08, 0.3, 0.4, 0.5, 0.1, 0.25, 0.3, 0.05,
            0.1, 0.15, 0.02, 0.04, 0.1, 0.3, 0.13, 0.04, 0.3, 0.3, 0.2, 0.21, 0.4, 0.4,
            0.04, 0.2, 0.35, 0.3, 0.2, 0.08, 0.3, 0.5, 0.3, 0.17, 0.3, 0.4, 0.04, 0.18,
            0.4, 0.35, 0.4, 0.13, 0.38,
            0.6, 0.43, 0.05, 0.35, 0.5, 0.02, 0.05, 0.16, 0.4, 0.3, 0.2, 0.35, 0.6, 0.7,
            0.23, 0.47, 0.75, 0.18, 0.26, 0.3, 0.45, 0.5, 0.4, 0.25, 0.45, 0.45, 0.18,
            0.25, 0.35, 0.09, 0.17, 0.32, 0.55, 0.5, 0.43, 0.35, 0.5, 0.5, 0.22, 0.35,
            0.35, 0.1, 0.16, 0.25, 0.1, 0.02, 0.01, 0.4, 0.2, 0.05, 0.73, 0.4, 0.1,
            0.95, 0.75, 0.3, 0.3, 0.1, 0.02, 0.55, 0.25, 0.1, 0.8, 0.5, 0.15, 0.95,
            0.77, 0.35, 0.3, 0.05, 0.02, 0.55, 0.2, 0.07, 0.95, 0.6, 0.25, 0.98, 0.95,
            0.8, 0.3, 0.2, 0.05, 0.5, 0.2, 0.15, 0.7, 0.4, 0.15, 0.8, 0.7, 0.63, 0.2,
            0.1, 0.02, 0.65, 0.4, 0.15, 0.8, 0.7,
            0.5, 0.9, 0.8, 0.6, 0.15, 0.1, 0.07, 0.55, 0.25, 0.2, 0.73, 0.55, 0.5, 0.88,
            0.8, 0.65)
        pgm_factor35 = self.new_factor(pgm_rv35, pgm_rv34, pgm_rv23)
        pgm_function_2955280788576 = pgm_factor35.set_dense()
        pgm_function_2955280788576.set_flat(
            1.0, 0.9, 0.4, 0.6, 0.15, 0.0, 0.25, 0.0, 0.0, 0.0, 0.1, 0.35, 0.4, 0.7,
            0.4, 0.35, 0.1, 0.0, 0.0, 0.0, 0.25, 0.0, 0.15, 0.6, 0.4, 0.9, 1.0)
        pgm_factor36 = self.new_factor(pgm_rv36, pgm_rv26)
        pgm_function_2955280789776 = pgm_factor36.set_dense()
        pgm_function_2955280789776.set_flat(
            1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0)
        pgm_factor37 = self.new_factor(pgm_rv37)
        pgm_function_2955280788336 = pgm_factor37.set_dense()
        pgm_function_2955280788336.set_flat(0.4, 0.4, 0.15, 0.05)
        pgm_factor38 = self.new_factor(pgm_rv38)
        pgm_function_2955280788896 = pgm_factor38.set_dense()
        pgm_function_2955280788896.set_flat(0.12, 0.32, 0.38, 0.18)
        pgm_factor39 = self.new_factor(pgm_rv39, pgm_rv37, pgm_rv38)
        pgm_function_2955280787296 = pgm_factor39.set_dense()
        pgm_function_2955280787296.set_flat(
            0.7, 0.1, 0.01, 0.0, 0.9, 0.65, 0.25, 0.01, 0.95, 0.75, 0.4, 0.2, 1.0, 0.95,
            0.75, 0.5, 0.28, 0.5, 0.14, 0.02, 0.09, 0.25, 0.35, 0.15, 0.05, 0.23, 0.4,
            0.3, 0.0, 0.05, 0.2, 0.35, 0.02, 0.3, 0.35, 0.18, 0.01, 0.09, 0.3, 0.33,
            0.0, 0.02, 0.18, 0.35, 0.0, 0.0, 0.05, 0.1, 0.0, 0.1, 0.5, 0.8, 0.0, 0.01,
            0.1, 0.51, 0.0, 0.0, 0.02, 0.15, 0.0, 0.0, 0.0, 0.05)
        pgm_factor40 = self.new_factor(pgm_rv40, pgm_rv26)
        pgm_function_2955280790336 = pgm_factor40.set_dense()
        pgm_function_2955280790336.set_flat(
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 1.0)
        pgm_factor41 = self.new_factor(pgm_rv41, pgm_rv39, pgm_rv35, pgm_rv30, pgm_rv40)
        pgm_function_2955280790256 = pgm_factor41.set_dense()
        pgm_function_2955280790256.set_flat(
            0.75, 0.75, 0.9, 0.9, 0.88, 0.92, 0.85, 1.0, 0.9, 0.9, 0.95, 0.75, 0.65,
            0.9, 0.91, 0.85, 0.9, 0.84, 0.99, 0.88, 0.92, 0.96, 0.75, 0.75, 0.95, 0.93,
            0.92, 0.87, 0.9, 0.98, 0.92, 0.95, 0.97, 0.5, 0.6, 0.8, 0.85, 0.85, 0.88,
            0.8, 0.92, 0.8, 0.75, 0.9, 0.35, 0.55, 0.82, 0.82, 0.75, 0.88, 0.75, 0.9,
            0.7, 0.8, 0.9, 0.5, 0.6, 0.85, 0.85, 0.75, 0.85, 0.75, 0.94, 0.65, 0.83,
            0.93, 0.35, 0.45, 0.8, 0.72, 0.78, 0.86, 0.65, 0.85, 0.65, 0.72, 0.85, 0.25,
            0.45, 0.65, 0.55, 0.55, 0.81, 0.6, 0.8, 0.6, 0.75, 0.88, 0.4, 0.45, 0.75,
            0.65, 0.52, 0.82, 0.65, 0.85, 0.5, 0.77, 0.9, 0.7,
            0.6, 0.82, 0.85, 0.82, 0.85, 0.8, 0.97, 0.88, 0.86, 0.88, 0.65, 0.58, 0.8,
            0.85, 0.8, 0.83, 0.77, 0.93, 0.85, 0.85, 0.9, 0.6, 0.65, 0.9, 0.85, 0.82,
            0.8, 0.8, 0.91, 0.85, 0.9, 0.93, 0.3, 0.55, 0.7, 0.75, 0.62, 0.85, 0.75,
            0.82, 0.6, 0.68, 0.82, 0.28, 0.48, 0.7, 0.7, 0.6, 0.82, 0.63, 0.8, 0.5, 0.7,
            0.8, 0.4, 0.5, 0.72, 0.65, 0.55, 0.78, 0.55, 0.85, 0.45, 0.73, 0.85, 0.3,
            0.4, 0.65, 0.6, 0.6, 0.83, 0.45, 0.7, 0.55, 0.6, 0.72, 0.22, 0.35, 0.45,
            0.45, 0.48, 0.72, 0.43, 0.68, 0.35, 0.6, 0.74, 0.27, 0.35, 0.55, 0.45, 0.42,
            0.74, 0.45, 0.77, 0.3, 0.68, 0.75, 0.5, 0.45,
            0.75, 0.75, 0.72, 0.78, 0.66, 0.88, 0.7, 0.78, 0.8, 0.45, 0.45, 0.7, 0.72,
            0.7, 0.75, 0.62, 0.85, 0.75, 0.76, 0.8, 0.35, 0.45, 0.75, 0.7, 0.6, 0.72,
            0.6, 0.8, 0.75, 0.75, 0.88, 0.2, 0.4, 0.7, 0.65, 0.5, 0.74, 0.6, 0.67, 0.35,
            0.6, 0.75, 0.23, 0.38, 0.58, 0.55, 0.53, 0.73, 0.35, 0.65, 0.3, 0.6, 0.68,
            0.3, 0.35, 0.55, 0.5, 0.4, 0.7, 0.35, 0.6, 0.35, 0.62, 0.7, 0.25, 0.3, 0.45,
            0.5, 0.4, 0.72, 0.25, 0.57, 0.25, 0.48, 0.6, 0.19, 0.25, 0.35, 0.35, 0.35,
            0.65, 0.22, 0.45, 0.25, 0.48, 0.58, 0.15, 0.25, 0.4, 0.3, 0.25, 0.6, 0.18,
            0.47, 0.25, 0.5, 0.5, 0.4, 0.35, 0.6,
            0.6, 0.55, 0.69, 0.54, 0.75, 0.55, 0.7, 0.7, 0.35, 0.35, 0.55, 0.55, 0.5,
            0.65, 0.38, 0.7, 0.65, 0.67, 0.7, 0.2, 0.3, 0.55, 0.5, 0.45, 0.6, 0.28,
            0.65, 0.63, 0.62, 0.8, 0.16, 0.3, 0.45, 0.52, 0.35, 0.65, 0.48, 0.58, 0.25,
            0.5, 0.65, 0.18, 0.3, 0.45, 0.45, 0.35, 0.62, 0.2, 0.52, 0.23, 0.47, 0.55,
            0.23, 0.25, 0.4, 0.4, 0.3, 0.57, 0.15, 0.5, 0.25, 0.5, 0.55, 0.18, 0.2, 0.3,
            0.4, 0.25, 0.63, 0.15, 0.4, 0.2, 0.3, 0.5, 0.15, 0.18, 0.25, 0.25, 0.25,
            0.58, 0.13, 0.3, 0.22, 0.35, 0.5, 0.1, 0.2, 0.2, 0.23, 0.15, 0.5, 0.1, 0.28,
            0.2, 0.3, 0.38, 0.2, 0.2, 0.08, 0.06,
            0.1, 0.08, 0.13, 0.0, 0.08, 0.08, 0.04, 0.2, 0.3, 0.08, 0.05, 0.13, 0.1,
            0.12, 0.01, 0.1, 0.06, 0.03, 0.2, 0.2, 0.04, 0.04, 0.06, 0.13, 0.06, 0.02,
            0.06, 0.04, 0.02, 0.3, 0.3, 0.14, 0.09, 0.1, 0.11, 0.17, 0.06, 0.12, 0.22,
            0.08, 0.3, 0.3, 0.13, 0.1, 0.18, 0.11, 0.2, 0.07, 0.2, 0.15, 0.08, 0.2,
            0.25, 0.1, 0.07, 0.15, 0.14, 0.2, 0.05, 0.22, 0.1, 0.06, 0.2, 0.35, 0.1,
            0.14, 0.15, 0.12, 0.25, 0.1, 0.2, 0.2, 0.1, 0.15, 0.35, 0.2, 0.2, 0.25,
            0.17, 0.28, 0.13, 0.2, 0.15, 0.08, 0.08, 0.25, 0.1, 0.15, 0.25, 0.16, 0.27,
            0.09, 0.2, 0.1, 0.07, 0.25, 0.33, 0.13, 0.1, 0.15,
            0.14, 0.17, 0.02, 0.1, 0.1, 0.1, 0.25, 0.32, 0.15, 0.1, 0.16, 0.16, 0.17,
            0.06, 0.12, 0.1, 0.08, 0.3, 0.28, 0.08, 0.1, 0.13, 0.19, 0.13, 0.08, 0.12,
            0.08, 0.06, 0.4, 0.34, 0.2, 0.15, 0.28, 0.14, 0.2, 0.14, 0.25, 0.22, 0.15,
            0.37, 0.35, 0.2, 0.17, 0.29, 0.16, 0.3, 0.15, 0.3, 0.2, 0.16, 0.28, 0.25,
            0.18, 0.2, 0.3, 0.2, 0.35, 0.12, 0.3, 0.15, 0.12, 0.25, 0.36, 0.2, 0.2,
            0.28, 0.14, 0.4, 0.18, 0.25, 0.25, 0.2, 0.17, 0.37, 0.3, 0.25, 0.29, 0.25,
            0.4, 0.2, 0.3, 0.2, 0.16, 0.1, 0.3, 0.22, 0.25, 0.3, 0.22, 0.4, 0.13, 0.25,
            0.15, 0.15, 0.4, 0.42, 0.18, 0.15, 0.22, 0.21,
            0.27, 0.1, 0.22, 0.16, 0.16, 0.35, 0.35, 0.2, 0.17, 0.22, 0.24, 0.3, 0.12,
            0.15, 0.17, 0.16, 0.4, 0.4, 0.19, 0.2, 0.3, 0.27, 0.3, 0.16, 0.17, 0.2, 0.1,
            0.45, 0.4, 0.2, 0.22, 0.34, 0.24, 0.3, 0.24, 0.4, 0.25, 0.2, 0.4, 0.35,
            0.25, 0.25, 0.32, 0.25, 0.53, 0.24, 0.4, 0.24, 0.24, 0.34, 0.35, 0.25, 0.27,
            0.38, 0.28, 0.5, 0.25, 0.35, 0.22, 0.22, 0.28, 0.38, 0.3, 0.25, 0.35, 0.24,
            0.57, 0.28, 0.35, 0.26, 0.26, 0.18, 0.4, 0.3, 0.3, 0.35, 0.3, 0.58, 0.35,
            0.34, 0.26, 0.25, 0.16, 0.3, 0.3, 0.3, 0.4, 0.34, 0.62, 0.3, 0.3, 0.22,
            0.27, 0.45, 0.45, 0.27, 0.22, 0.32, 0.29, 0.36,
            0.2, 0.3, 0.22, 0.25, 0.4, 0.4, 0.3, 0.27, 0.35, 0.33, 0.5, 0.24, 0.2, 0.23,
            0.25, 0.45, 0.45, 0.3, 0.3, 0.38, 0.38, 0.57, 0.28, 0.25, 0.28, 0.17, 0.47,
            0.45, 0.32, 0.26, 0.45, 0.32, 0.39, 0.3, 0.45, 0.28, 0.27, 0.45, 0.35, 0.3,
            0.3, 0.43, 0.35, 0.65, 0.33, 0.42, 0.3, 0.3, 0.4, 0.4, 0.3, 0.3, 0.45, 0.4,
            0.65, 0.33, 0.36, 0.28, 0.3, 0.3, 0.4, 0.3, 0.3, 0.48, 0.32, 0.63, 0.38,
            0.37, 0.35, 0.32, 0.2, 0.4, 0.35, 0.35, 0.42, 0.36, 0.62, 0.45, 0.35, 0.32,
            0.3, 0.2, 0.3, 0.4, 0.3, 0.45, 0.42, 0.65, 0.4, 0.32, 0.28, 0.32, 0.05,
            0.05, 0.02, 0.04, 0.02, 0.0, 0.02, 0.0,
            0.02, 0.02, 0.01, 0.05, 0.05, 0.02, 0.04, 0.02, 0.0, 0.04, 0.0, 0.02, 0.02,
            0.01, 0.05, 0.05, 0.01, 0.03, 0.02, 0.0, 0.04, 0.0, 0.02, 0.01, 0.01, 0.2,
            0.1, 0.06, 0.06, 0.05, 0.01, 0.03, 0.02, 0.08, 0.03, 0.02, 0.35, 0.15, 0.05,
            0.08, 0.07, 0.01, 0.05, 0.03, 0.1, 0.05, 0.02, 0.3, 0.15, 0.05, 0.08, 0.1,
            0.01, 0.05, 0.01, 0.13, 0.07, 0.01, 0.45, 0.2, 0.1, 0.14, 0.07, 0.02, 0.1,
            0.05, 0.15, 0.08, 0.05, 0.6, 0.2, 0.15, 0.25, 0.2, 0.02, 0.12, 0.07, 0.2,
            0.1, 0.04, 0.52, 0.3, 0.15, 0.2, 0.23, 0.02, 0.08, 0.06, 0.3, 0.13, 0.03,
            0.05, 0.07, 0.05, 0.05, 0.03, 0.01, 0.03, 0.01, 0.02,
            0.04, 0.02, 0.1, 0.1, 0.05, 0.05, 0.04, 0.01, 0.06, 0.01, 0.03, 0.05, 0.02,
            0.1, 0.07, 0.02, 0.05, 0.05, 0.01, 0.07, 0.01, 0.03, 0.02, 0.01, 0.3, 0.11,
            0.1, 0.1, 0.1, 0.01, 0.05, 0.04, 0.15, 0.1, 0.03, 0.35, 0.17, 0.1, 0.13,
            0.11, 0.02, 0.07, 0.05, 0.2, 0.1, 0.04, 0.32, 0.25, 0.1, 0.15, 0.15, 0.02,
            0.1, 0.03, 0.25, 0.12, 0.03, 0.45, 0.24, 0.15, 0.2, 0.12, 0.03, 0.15, 0.12,
            0.2, 0.15, 0.08, 0.61, 0.28, 0.25, 0.3, 0.23, 0.03, 0.17, 0.12, 0.35, 0.2,
            0.1, 0.63, 0.35, 0.23, 0.3, 0.28, 0.04, 0.15, 0.1, 0.45, 0.17, 0.1, 0.1,
            0.13, 0.07, 0.1, 0.06, 0.01, 0.07, 0.02, 0.08, 0.06,
            0.04, 0.2, 0.2, 0.1, 0.11, 0.08, 0.01, 0.08, 0.03, 0.1, 0.07, 0.04, 0.25,
            0.15, 0.06, 0.1, 0.1, 0.01, 0.1, 0.04, 0.08, 0.05, 0.02, 0.35, 0.2, 0.1,
            0.13, 0.16, 0.02, 0.1, 0.09, 0.25, 0.15, 0.05, 0.37, 0.27, 0.17, 0.2, 0.15,
            0.02, 0.12, 0.11, 0.3, 0.16, 0.08, 0.36, 0.3, 0.2, 0.23, 0.22, 0.02, 0.15,
            0.15, 0.3, 0.16, 0.08, 0.47, 0.32, 0.25, 0.25, 0.25, 0.04, 0.18, 0.15, 0.4,
            0.26, 0.14, 0.63, 0.35, 0.35, 0.35, 0.3, 0.05, 0.2, 0.2, 0.41, 0.26, 0.17,
            0.69, 0.45, 0.3, 0.4, 0.35, 0.06, 0.2, 0.23, 0.45, 0.28, 0.23, 0.15, 0.2,
            0.13, 0.18, 0.13, 0.02, 0.1, 0.05, 0.15, 0.08, 0.05,
            0.25, 0.25, 0.15, 0.18, 0.15, 0.02, 0.12, 0.06, 0.15, 0.1, 0.05, 0.35, 0.25,
            0.15, 0.2, 0.17, 0.02, 0.15, 0.07, 0.12, 0.1, 0.03, 0.37, 0.25, 0.23, 0.22,
            0.2, 0.03, 0.13, 0.12, 0.3, 0.22, 0.08, 0.37, 0.35, 0.25, 0.25, 0.22, 0.03,
            0.15, 0.15, 0.35, 0.23, 0.15, 0.37, 0.35, 0.3, 0.3, 0.25, 0.03, 0.2, 0.17,
            0.39, 0.22, 0.15, 0.52, 0.4, 0.4, 0.3, 0.27, 0.05, 0.22, 0.22, 0.43, 0.35,
            0.18, 0.65, 0.42, 0.4, 0.4, 0.33, 0.06, 0.25, 0.25, 0.43, 0.33, 0.2, 0.7,
            0.5, 0.4, 0.47, 0.4, 0.08, 0.25, 0.32, 0.48, 0.42, 0.3)
        pgm_factor42 = self.new_factor(pgm_rv42, pgm_rv36, pgm_rv41)
        pgm_function_2955280787376 = pgm_factor42.set_dense()
        pgm_function_2955280787376.set_flat(
            0.94, 0.06, 0.01, 0.98, 0.04, 0.0, 0.92, 0.01, 0.0, 0.92, 0.03, 0.01, 0.99,
            0.09, 0.03, 0.05, 0.89, 0.05, 0.02, 0.94, 0.03, 0.06, 0.89, 0.01, 0.06,
            0.92, 0.04, 0.01, 0.9, 0.12, 0.01, 0.05, 0.94, 0.0, 0.02, 0.97, 0.02, 0.1,
            0.99, 0.02, 0.05, 0.95, 0.0, 0.01, 0.85)
        pgm_factor43 = self.new_factor(pgm_rv43, pgm_rv24, pgm_rv42)
        pgm_function_2955280788976 = pgm_factor43.set_dense()
        pgm_function_2955280788976.set_flat(
            1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0,
            0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0)
        pgm_factor44 = self.new_factor(pgm_rv44, pgm_rv26)
        pgm_function_2955280788656 = pgm_factor44.set_dense()
        pgm_function_2955280788656.set_flat(
            0.04, 0.05, 0.4, 0.13, 0.15, 0.0, 0.5, 0.0, 0.0, 0.1, 0.1, 0.05, 0.07, 0.25,
            0.22, 0.2, 0.0, 0.27, 0.02, 0.02, 0.45, 0.1, 0.15, 0.15, 0.0, 0.18, 0.2,
            0.0, 0.15, 0.1, 0.7, 0.1, 0.1, 0.05, 0.1, 0.15, 0.07, 0.18, 0.0, 0.02, 0.05,
            0.0, 0.05, 0.2, 0.19, 0.3, 0.05, 0.34, 0.11, 0.0, 0.02, 0.5, 0.2, 0.26,
            0.05, 0.3, 0.27, 0.02, 0.03, 0.11, 0.98, 0.0, 0.2, 0.04, 0.02, 0.1, 0.22,
            0.06, 0.13, 0.03, 0.05, 0.02, 0.04, 0.13, 0.04, 0.02, 0.35)
        pgm_factor45 = self.new_factor(pgm_rv45, pgm_rv26)
        pgm_function_2955280790096 = pgm_factor45.set_dense()
        pgm_function_2955280790096.set_flat(
            0.04, 0.07, 0.35, 0.4, 0.45, 0.01, 0.78, 0.0, 0.22, 0.13, 0.09, 0.25, 0.31,
            0.47, 0.4, 0.35, 0.35, 0.19, 0.02, 0.4, 0.4, 0.4, 0.35, 0.31, 0.14, 0.13,
            0.15, 0.45, 0.03, 0.33, 0.3, 0.35, 0.33, 0.36, 0.31, 0.04, 0.07, 0.05, 0.19,
            0.0, 0.65, 0.08, 0.12, 0.18)
        pgm_factor46 = self.new_factor(pgm_rv46, pgm_rv26)
        pgm_function_2955280790576 = pgm_factor46.set_dense()
        pgm_function_2955280790576.set_flat(
            0.33, 0.4, 0.05, 0.1, 0.05, 1.0, 0.0, 0.4, 0.2, 0.05, 0.2, 0.5, 0.4, 0.45,
            0.5, 0.65, 0.0, 0.07, 0.55, 0.45, 0.55, 0.4, 0.17, 0.2, 0.5, 0.4, 0.3, 0.0,
            0.93, 0.05, 0.35, 0.4, 0.4)
        pgm_factor47 = self.new_factor(pgm_rv47, pgm_rv26)
        pgm_function_2955280789136 = pgm_factor47.set_dense()
        pgm_function_2955280789136.set_flat(
            0.25, 0.25, 0.4, 0.43, 0.02, 0.0, 0.84, 0.25, 0.41, 0.23, 0.16, 0.55, 0.5,
            0.38, 0.37, 0.38, 0.1, 0.16, 0.31, 0.29, 0.42, 0.28, 0.2, 0.25, 0.22, 0.2,
            0.6, 0.9, 0.0, 0.44, 0.3, 0.35, 0.56)
        pgm_factor48 = self.new_factor(pgm_rv48, pgm_rv26)
        pgm_function_2955280787456 = pgm_factor48.set_dense()
        pgm_function_2955280787456.set_flat(
            0.25, 0.05, 0.1, 0.18, 0.02, 0.05, 0.1, 0.0, 0.2, 0.04, 0.5, 0.55, 0.1, 0.3,
            0.38, 0.02, 0.07, 0.25, 0.6, 0.1, 0.0, 0.35, 0.2, 0.1, 0.3, 0.34, 0.26,
            0.05, 0.15, 0.1, 0.2, 0.04, 0.09, 0.0, 0.75, 0.3, 0.1, 0.7, 0.83, 0.5, 0.3,
            0.5, 0.92, 0.06)
        pgm_factor49 = self.new_factor(pgm_rv49, pgm_rv26)
        pgm_function_2955280788416 = pgm_factor49.set_dense()
        pgm_function_2955280788416.set_flat(
            0.05, 0.1, 0.4, 0.2, 0.8, 0.0, 0.6, 0.0, 0.1, 0.4, 0.15, 0.5, 0.5, 0.15,
            0.45, 0.05, 0.0, 0.0, 0.7, 0.7, 0.4, 0.45, 0.45, 0.4, 0.45, 0.35, 0.15, 1.0,
            0.4, 0.3, 0.2, 0.2, 0.4)
        pgm_factor50 = self.new_factor(pgm_rv50, pgm_rv26)
        pgm_function_2955280788496 = pgm_factor50.set_dense()
        pgm_function_2955280788496.set_flat(
            0.65, 0.65, 0.0, 0.12, 0.06, 0.1, 0.02, 0.01, 0.02, 0.06, 0.05, 0.05, 0.05,
            0.65, 0.02, 0.14, 0.1, 0.05, 0.1, 0.1, 0.08, 0.13, 0.1, 0.1, 0.2, 0.02,
            0.04, 0.1, 0.05, 0.15, 0.5, 0.04, 0.05, 0.08, 0.1, 0.02, 0.02, 0.04, 0.02,
            0.0, 0.4, 0.3, 0.02, 0.39, 0.04, 0.02, 0.06, 0.45, 0.25, 0.0, 0.35, 0.0,
            0.01, 0.6, 0.13, 0.07, 0.07, 0.05, 0.27, 0.4, 0.56, 0.33, 0.23, 0.02, 0.14,
            0.15, 0.01, 0.01, 0.02, 0.1, 0.07, 0.12, 0.2, 0.11, 0.05, 0.06, 0.1)
        pgm_factor51 = self.new_factor(pgm_rv51, pgm_rv26)
        pgm_function_2955280789296 = pgm_factor51.set_dense()
        pgm_function_2955280789296.set_flat(
            0.35, 0.06, 0.1, 0.35, 0.15, 0.15, 0.15, 0.25, 0.25, 0.01, 0.2, 0.25, 0.1,
            0.27, 0.2, 0.15, 0.1, 0.1, 0.25, 0.2, 0.05, 0.2, 0.0, 0.06, 0.4, 0.1, 0.1,
            0.05, 0.1, 0.25, 0.15, 0.01, 0.35, 0.35, 0.3, 0.08, 0.25, 0.15, 0.15, 0.25,
            0.15, 0.2, 0.05, 0.15, 0.05, 0.48, 0.15, 0.1, 0.45, 0.55, 0.4, 0.1, 0.2,
            0.88, 0.1)
        pgm_factor52 = self.new_factor(pgm_rv52, pgm_rv26)
        pgm_function_2955280789856 = pgm_factor52.set_dense()
        pgm_function_2955280789856.set_flat(
            0.13, 0.15, 0.12, 0.1, 0.04, 0.05, 0.03, 0.05, 0.8, 0.1, 0.2, 0.15, 0.15,
            0.1, 0.15, 0.04, 0.12, 0.03, 0.4, 0.19, 0.05, 0.3, 0.1, 0.25, 0.35, 0.4,
            0.82, 0.75, 0.84, 0.5, 0.0, 0.4, 0.3, 0.62, 0.45, 0.43, 0.35, 0.1, 0.08,
            0.1, 0.05, 0.01, 0.45, 0.2)
        pgm_factor53 = self.new_factor(pgm_rv53, pgm_rv26)
        pgm_function_2955280790416 = pgm_factor53.set_dense()
        pgm_function_2955280790416.set_flat(
            0.0, 0.2, 0.05, 0.03, 0.07, 0.5, 0.25, 0.2, 0.2, 0.96, 0.03, 0.95, 0.3,
            0.09, 0.32, 0.66, 0.0, 0.3, 0.14, 0.41, 0.0, 0.08, 0.01, 0.2, 0.59, 0.42,
            0.02, 0.0, 0.25, 0.43, 0.1, 0.0, 0.33, 0.04, 0.3, 0.27, 0.23, 0.25, 0.5,
            0.2, 0.23, 0.29, 0.04, 0.56)
        pgm_factor54 = self.new_factor(pgm_rv54, pgm_rv26)
        pgm_function_2955280790016 = pgm_factor54.set_dense()
        pgm_function_2955280790016.set_flat(
            0.8, 0.35, 0.75, 0.7, 0.65, 0.15, 0.7, 0.3, 0.5, 0.01, 0.7, 0.2, 0.65, 0.25,
            0.3, 0.35, 0.85, 0.3, 0.7, 0.5, 0.99, 0.3)
        pgm_factor55 = self.new_factor(pgm_rv55, pgm_rv26)
        pgm_function_2955280790496 = pgm_factor55.set_dense()
        pgm_function_2955280790496.set_flat(
            0.05, 0.08, 0.1, 0.1, 0.43, 0.6, 0.25, 0.04, 0.2, 0.6, 0.1, 0.6, 0.6, 0.0,
            0.15, 0.1, 0.07, 0.01, 0.02, 0.3, 0.08, 0.05, 0.02, 0.02, 0.75, 0.2, 0.15,
            0.01, 0.3, 0.04, 0.05, 0.07, 0.1, 0.1, 0.1, 0.0, 0.05, 0.06, 0.12, 0.01,
            0.8, 0.37, 0.03, 0.05, 0.23, 0.2, 0.0, 0.3, 0.06, 0.2, 0.03, 0.1, 0.07, 0.2,
            0.2, 0.0, 0.0, 0.15, 0.2, 0.2, 0.0, 0.4, 0.0, 0.01, 0.02, 0.5)
