# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class SiteLogsConfig(ProxyOnlyResource):
    """Configuration of App Service site logs.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param application_logs: Application logs configuration.
    :type application_logs: :class:`ApplicationLogsConfig
     <azure.mgmt.web.models.ApplicationLogsConfig>`
    :param http_logs: HTTP logs configuration.
    :type http_logs: :class:`HttpLogsConfig
     <azure.mgmt.web.models.HttpLogsConfig>`
    :param failed_requests_tracing: Failed requests tracing configuration.
    :type failed_requests_tracing: :class:`EnabledConfig
     <azure.mgmt.web.models.EnabledConfig>`
    :param detailed_error_messages: Detailed error messages configuration.
    :type detailed_error_messages: :class:`EnabledConfig
     <azure.mgmt.web.models.EnabledConfig>`
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'application_logs': {'key': 'properties.applicationLogs', 'type': 'ApplicationLogsConfig'},
        'http_logs': {'key': 'properties.httpLogs', 'type': 'HttpLogsConfig'},
        'failed_requests_tracing': {'key': 'properties.failedRequestsTracing', 'type': 'EnabledConfig'},
        'detailed_error_messages': {'key': 'properties.detailedErrorMessages', 'type': 'EnabledConfig'},
    }

    def __init__(self, kind=None, application_logs=None, http_logs=None, failed_requests_tracing=None, detailed_error_messages=None):
        super(SiteLogsConfig, self).__init__(kind=kind)
        self.application_logs = application_logs
        self.http_logs = http_logs
        self.failed_requests_tracing = failed_requests_tracing
        self.detailed_error_messages = detailed_error_messages
