# Generated by Django 2.1.4 on 2019-01-03 10:44

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Callback',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, null=True, verbose_name='Date Updated')),
                ('hash', models.CharField(max_length=200, unique=True, verbose_name='Hash')),
                ('method', models.CharField(max_length=200, verbose_name='Callback Method')),
                ('hooking_cls', models.CharField(max_length=200, verbose_name='HookingClass')),
                ('enabled', models.BooleanField(default=True, verbose_name='Enabled')),
            ],
            options={
                'verbose_name': 'Callback',
                'verbose_name_plural': 'Callbacks',
            },
        ),
        migrations.CreateModel(
            name='State',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, null=True, verbose_name='Date Updated')),
                ('slug', models.SlugField(blank=True, null=True, unique=True)),
                ('label', models.CharField(max_length=50)),
                ('description', models.CharField(blank=True, max_length=200, null=True, verbose_name='Description')),
            ],
            options={
                'verbose_name': 'State',
                'verbose_name_plural': 'States',
            },
        ),
        migrations.CreateModel(
            name='TransitionApproval',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, null=True, verbose_name='Date Updated')),
                ('field_name', models.CharField(max_length=200, verbose_name='Field Name')),
                ('object_id', models.CharField(max_length=50, verbose_name='Related Object')),
                ('transaction_date', models.DateTimeField(blank=True, null=True)),
                ('status', models.IntegerField(choices=[(0, 'Pending'), (1, 'Approved'), (2, 'Rejected')], default=0, verbose_name='Status')),
                ('skip', models.BooleanField(default=False, verbose_name='Skip')),
                ('priority', models.IntegerField(default=0, verbose_name='Priority')),
                ('enabled', models.BooleanField(default=True, verbose_name='Enabled?')),
                ('cloned', models.BooleanField(default=False, verbose_name='Cloned?')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='Content Type')),
                ('destination_state', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transition_approvals_as_destination', to='river.State', verbose_name='Next State')),
                ('groups', models.ManyToManyField(to='auth.Group', verbose_name='Groups')),
            ],
            options={
                'verbose_name': 'Transition Approval',
                'verbose_name_plural': 'Transition Approvals',
            },
        ),
        migrations.CreateModel(
            name='TransitionApprovalMeta',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, null=True, verbose_name='Date Updated')),
                ('field_name', models.CharField(max_length=200, verbose_name='Field Name')),
                ('priority', models.IntegerField(default=0, null=True, verbose_name='Priority')),
                ('action_text', models.TextField(blank=True, max_length=200, null=True, verbose_name='Action Text')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='Content Type')),
                ('destination_state', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transition_approval_meta_as_destination', to='river.State', verbose_name='Next State')),
                ('groups', models.ManyToManyField(blank=True, to='auth.Group', verbose_name='Groups')),
                ('parents', models.ManyToManyField(blank=True, db_index=True, related_name='children', to='river.TransitionApprovalMeta', verbose_name='parents')),
                ('permissions', models.ManyToManyField(blank=True, to='auth.Permission', verbose_name='Permissions')),
                ('source_state', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transition_approval_meta_as_source', to='river.State', verbose_name='Source State')),
            ],
            options={
                'verbose_name': 'Transition Approval Meta',
                'verbose_name_plural': 'Transition Approval Meta',
            },
        ),
        migrations.AddField(
            model_name='transitionapproval',
            name='meta',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='proceedings', to='river.TransitionApprovalMeta', verbose_name='Meta'),
        ),
        migrations.AddField(
            model_name='transitionapproval',
            name='permissions',
            field=models.ManyToManyField(to='auth.Permission', verbose_name='Permissions'),
        ),
        migrations.AddField(
            model_name='transitionapproval',
            name='previous',
            field=mptt.fields.TreeOneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='next_transition', to='river.TransitionApproval', verbose_name='Previous Transition'),
        ),
        migrations.AddField(
            model_name='transitionapproval',
            name='source_state',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transition_approvals_as_source', to='river.State', verbose_name='Source State'),
        ),
        migrations.AddField(
            model_name='transitionapproval',
            name='transactioner',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Transactioner'),
        ),
        migrations.AlterUniqueTogether(
            name='transitionapprovalmeta',
            unique_together={('content_type', 'field_name', 'source_state', 'destination_state', 'priority')},
        ),
    ]
