"""
Telescope integrations for various frameworks
"""

# Web Frameworks
from .django import DjangoIntegration
from .flask import FlaskIntegration
from .fastapi import FastAPIIntegration
from .starlette import StarletteIntegration
from .quart import QuartIntegration
from .sanic import SanicIntegration
from .tornado import TornadoIntegration

# Async Frameworks
from .aiohttp import AioHttpIntegration

# Database Integrations
from .sqlalchemy import SQLAlchemyIntegration
from .redis import RedisIntegration

# Task Queue Integrations
from .celery import CeleryIntegration

# AI/ML Integrations
from .openai import OpenAIIntegration

# HTTP Client Integrations
from .requests import RequestsIntegration

# Logging Integrations
from .logging import LoggingIntegration

# Base Integration
from .base import Integration, DidNotEnable, IntegrationRegistry

__all__ = [
    # Web Frameworks
    "DjangoIntegration",
    "FlaskIntegration", 
    "FastAPIIntegration",
    "StarletteIntegration",
    "QuartIntegration",
    "SanicIntegration",
    "TornadoIntegration",
    
    # Async Frameworks
    "AioHttpIntegration",
    
    # Database Integrations
    "SQLAlchemyIntegration",
    "RedisIntegration",
    
    # Task Queue Integrations
    "CeleryIntegration",
    
    # AI/ML Integrations
    "OpenAIIntegration",
    
    # HTTP Client Integrations
    "RequestsIntegration",
    
    # Logging Integrations
    "LoggingIntegration",
    
    # Base Integration
    "Integration",
    "DidNotEnable",
    "IntegrationRegistry",
]
