"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const follow_mode_1 = require("./follow-mode");
const utils_1 = require("./utils");
function copyDirectory(srcDir, destDir, options = {}, rootDir) {
    const follow = options.follow !== undefined ? options.follow : follow_mode_1.FollowMode.EXTERNAL;
    const exclude = options.exclude || [];
    rootDir = rootDir || srcDir;
    if (!fs.statSync(srcDir).isDirectory()) {
        throw new Error(`${srcDir} is not a directory`);
    }
    const files = fs.readdirSync(srcDir);
    for (const file of files) {
        const sourceFilePath = path.join(srcDir, file);
        if (utils_1.shouldExclude(exclude, path.relative(rootDir, sourceFilePath))) {
            continue;
        }
        const destFilePath = path.join(destDir, file);
        let stat = follow === follow_mode_1.FollowMode.ALWAYS
            ? fs.statSync(sourceFilePath)
            : fs.lstatSync(sourceFilePath);
        if (stat && stat.isSymbolicLink()) {
            const target = fs.readlinkSync(sourceFilePath);
            // determine if this is an external link (i.e. the target's absolute path
            // is outside of the root directory).
            const targetPath = path.normalize(path.resolve(srcDir, target));
            if (utils_1.shouldFollow(follow, rootDir, targetPath)) {
                stat = fs.statSync(sourceFilePath);
            }
            else {
                fs.symlinkSync(target, destFilePath);
                stat = undefined;
            }
        }
        if (stat && stat.isDirectory()) {
            fs.mkdirSync(destFilePath);
            copyDirectory(sourceFilePath, destFilePath, options, rootDir);
            stat = undefined;
        }
        if (stat && stat.isFile()) {
            fs.copyFileSync(sourceFilePath, destFilePath);
            stat = undefined;
        }
    }
}
exports.copyDirectory = copyDirectory;
//# sourceMappingURL=data:application/json;base64,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