# Generated by 'python3 -m parameter_persistence.generate_models'

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field


class BowStbd(BaseModel):
    contains: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class Analyzers(BaseModel):
    bow_stbd: Optional[BowStbd] = None


class Cameras(BaseModel):
    analyzers: Optional[Analyzers] = None
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class ObjectAlerts(BaseModel):
    find_and_remove_prefix: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class ObjectTracker(BaseModel):
    find_and_remove_prefix: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class RoiDetector(BaseModel):
    find_and_remove_prefix: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class RoiTracker(BaseModel):
    find_and_remove_prefix: Optional[List[str]] = Field(None, description="")
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class VesselComputer1(BaseModel):
    path: Optional[str] = Field(None, description="")
    startswith: Optional[List[str]] = Field(None, description="")
    timeout: Optional[float] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class Analyzers1(BaseModel):
    vessel_computer: Optional[VesselComputer1] = None


class VesselComputer(BaseModel):
    analyzers: Optional[Analyzers1] = None
    path: Optional[str] = Field(None, description="")
    type: Optional[str] = Field(None, description="")


class DiagnosticAggregatorParameters(BaseModel):
    cameras: Optional[Cameras] = None
    object_alerts: Optional[ObjectAlerts] = None
    object_tracker: Optional[ObjectTracker] = None
    path: Optional[str] = Field(None, description="")
    publish_values: Optional[bool] = Field(None, description="")
    roi_detector: Optional[RoiDetector] = None
    roi_tracker: Optional[RoiTracker] = None
    vessel_computer: Optional[VesselComputer] = None


class DiagnosticUpdater(BaseModel):
    period: Optional[float] = Field(None, description="")
    use_fqn: Optional[bool] = Field(None, description="")


class RoiTrackerParameters(BaseModel):
    detection_threshold: Optional[float] = Field(
        None, description="Detections above this threshold will be tracked"
    )
    iou_threshold: Optional[float] = Field(
        None,
        description="IoU threshold for association of dets with propagated track boxes",
    )
    max_age: Optional[int] = Field(
        None,
        description="The maximum number of consecutive misses before the track state is deleted",
    )
    min_hits: Optional[int] = Field(None, description="Min number of detections to create track")
    classification_history_window: Optional[int] = Field(
        None,
        description="Numbers of frames to keep classification history (used for class/probability temporal smoothing)",
    )
    reset_on_old_time: Optional[bool] = Field(
        None, description="Reset the tracker if an old timestamp is received"
    )
    roi_topics: Optional[List[str]] = Field(
        None, description="List of topics to subscribe to for ROIs"
    )
    roi_track_topics: Optional[List[str]] = Field(
        None, description="List of topics to publish tracked ROIs"
    )
    diagnostic_updater: Optional[DiagnosticUpdater] = None


class DataRecorderParameters(BaseModel):
    bag_directory: Optional[str] = Field(None, description="")
    diagnostic_updater: Optional[DiagnosticUpdater] = None
    storage_id: Optional[str] = Field(None, description="")
    storage_preset_profile: Optional[str] = Field(None, description="")
    topic_exclude_regexs: Optional[List[str]] = Field(None, description="")
    topic_include_regexs: Optional[List[str]] = Field(None, description="")
    trigger_topic_active: Optional[bool] = Field(None, description="")


class CoreUsageAverageERROR(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class CoreUsageAverageWARN(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class CPU(BaseModel):
    Core_Usage_Average_ERROR: Optional[CoreUsageAverageERROR] = Field(
        None, alias="Core Usage Average ERROR"
    )
    Core_Usage_Average_WARN: Optional[CoreUsageAverageWARN] = Field(
        None, alias="Core Usage Average WARN"
    )


class FieldUsedPercentERROR(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class FieldUsedPercentWARN(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class Disk(BaseModel):
    field__Used_Percent_ERROR: Optional[FieldUsedPercentERROR] = Field(
        None, alias="/ Used Percent ERROR"
    )
    field__Used_Percent_WARN: Optional[FieldUsedPercentWARN] = Field(
        None, alias="/ Used Percent WARN"
    )


class UsagePercentERROR(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class UsagePercentWARN(BaseModel):
    max: Optional[float] = Field(None, description="")
    min: Optional[float] = Field(None, description="")


class RAM(BaseModel):
    Usage_Percent_ERROR: Optional[UsagePercentERROR] = Field(None, alias="Usage Percent ERROR")
    Usage_Percent_WARN: Optional[UsagePercentWARN] = Field(None, alias="Usage Percent WARN")


class DiagnosticUpdater2(BaseModel):
    CPU: Optional[CPU] = None
    Disk: Optional[Disk] = None
    RAM: Optional[RAM] = None
    period: Optional[float] = Field(None, description="")
    use_fqn: Optional[bool] = Field(None, description="")


class SystemResourceMonitorParameters(BaseModel):
    calculation_rate: Optional[float] = Field(None, description="")
    diagnostic_updater: Optional[DiagnosticUpdater2] = None
    diagnostics: Optional[bool] = Field(None, description="")
    diagnostics_log: Optional[bool] = Field(None, description="")
    disk_directories: Optional[List[str]] = Field(None, description="")
    publish: Optional[bool] = Field(None, description="")
    publish_individual_cores: Optional[bool] = Field(None, description="")
    publish_rate: Optional[float] = Field(None, description="")


class GeolocationParameters(BaseModel):
    publish_horizon_rate: Optional[float] = Field(None, description="")
    use_geopose: Optional[bool] = Field(None, description="")
    max_time_diff: Optional[float] = Field(None, description="")
    frame_id_base_link: Optional[str] = Field(None, description="")
    horizon_padding: Optional[int] = Field(None, description="")
    use_geopose_altitude: Optional[bool] = Field(None, description="")
    camera_info_topics: Optional[List[str]] = Field(
        None, description="List of camera info topics to use for geolocation"
    )
    horizon_marker_topics: Optional[List[str]] = Field(
        None, description="List of horizon marker topics to use for geolocation"
    )


class NodeConfigurationModel(BaseModel):
    node_name_regex: str = Field(..., title="Node Name Regex")
    parameter_name_regexes: List[str] = Field(..., title="Parameter Name Regexes")
    dedicated_file_path: Optional[str] = Field("", title="Dedicated File Path")


class ParameterPersistenceParameters(BaseModel):
    params_path: Optional[str] = Field(
        None, description="Path to the file where the parameters are stored"
    )
    file_header: Optional[str] = Field(
        None, description="A message to add to the top of the params file"
    )
    path_within_file: Optional[str] = Field(
        None, description="Path within the file to store the parameters"
    )
    persistent_parameters: Optional[List[NodeConfigurationModel]] = Field(
        None, description="Regex describing which parameters should persist"
    )
    ignore_namespace: Optional[str] = Field(
        None,
        description="Which (if any) part of the node namespace to ignore. Treated as regex.",
    )


class DiagnosticUpdater3(BaseModel):
    period: Optional[float] = Field(None, description="")
    use_fqn: Optional[bool] = Field(None, description="")


class DetectorOnnxParameters(BaseModel):
    enabled: Optional[bool] = Field(None, description="Should the detector be enabled")
    use_nms: Optional[bool] = Field(None, description="Use NMS to suppress overlapping boxes")
    rate: Optional[float] = Field(
        None, description="REQUIRES RESTART. Batch inference callback rate"
    )
    image_buffer_size: Optional[int] = Field(
        None, description="Number of images to store in buffer for batch inference"
    )
    onnx_batch_size: Optional[int] = Field(
        None, description="Only for .onnx models. Batch size for inference"
    )
    threshold: Optional[float] = Field(
        None, description="Only publish rois above this objectness threshold"
    )
    nms_iou_threshold: Optional[float] = Field(
        None,
        description="Keeps the highest-scoring ROI where overlaps (IoU >= threshold) occur. Threshold=1 allows all overlaps; 0 suppresses any overlap. Used when use_nms=True",
    )
    model_path: Optional[str] = Field(None, description="Path to the onnx or trt engine model")
    best_effort: Optional[bool] = Field(
        None, description="REQUIRES RESTART. Enable BEST_EFFORT reliability for frame subscriber"
    )
    ignore_regions: Optional[str] = Field(
        None, description="REQUIRES RESTART. Region of image for detector to ignore"
    )
    camera_frame_topics: Optional[List[str]] = Field(
        None, description="REQUIRES RESTART. Topics to subscribe to for camera frames"
    )
    roi_topics: Optional[List[str]] = Field(
        None, description="REQUIRES RESTART. Topics to publish ROIs to"
    )
    class_names: Optional[List[str]] = Field(
        None,
        description="REQUIRES RESTART. Only needed if using TensorRT. Class names to be listed in the order they were trained on",
    )
    diagnostic_updater: Optional[DiagnosticUpdater3] = None


class VesselOffsetsParameters(BaseModel):
    frame_prefix: Optional[str] = Field(None, description="")
    ignore_timestamp: Optional[bool] = Field(None, description="")
    publish_frequency: Optional[float] = Field(None, description="")
    robot_description: Optional[str] = Field(None, description="")


class Ais(BaseModel):
    heading_format: Optional[str] = Field(
        None, description="Heading format for AIS messages. 'radians' or 'degrees'"
    )


class ObjectTrackerParameters(BaseModel):
    ownship_name: Optional[str] = Field(None, description="")
    ownship_mmsi: Optional[str] = Field(None, description="The MMSI of the ego vessel to ignore")
    sources_fused: Optional[List[str]] = Field(None, description="")
    sources_enabled: Optional[List[str]] = Field(None, description="")
    required_times_seen_arpa: Optional[int] = Field(None, description="")
    sources_back_projected: Optional[List[str]] = Field(
        None, description="Project various sensor sources e.g. ais, arpa into the image"
    )
    use_geopose: Optional[bool] = Field(None, description="")
    use_geopose_altitude: Optional[bool] = Field(None, description="")
    max_time_diff: Optional[float] = Field(None, description="")
    frame_id_base_link: Optional[str] = Field(None, description="")
    horizon_padding: Optional[int] = Field(None, description="")
    bearing_angle_tolerance: Optional[float] = Field(
        None,
        description="The maximum difference in bearing (degrees) between the object and the track for the object to be associated with the track.",
    )
    range_angle_tolerance: Optional[float] = Field(
        None,
        description="The maximum difference in range (m) between the object and the track for the object to be associated with the track.",
    )
    range_sensor_height: Optional[float] = Field(
        None, description="The height of the range sensor (m)"
    )
    max_age_til_stale_rois: Optional[float] = Field(None, description="Age til stale (seconds)")
    max_age_til_stale_arpa: Optional[float] = Field(None, description="Age til stale (seconds)")
    max_age_til_stale_ais: Optional[float] = Field(None, description="Age til stale (seconds)")
    max_age_til_stale_objects: Optional[float] = Field(None, description="Age til stale (seconds)")
    roi_pf_sensitivity: Optional[float] = Field(None, description="Particle filter sensitivity")
    roi_pf_dist_percentile: Optional[int] = Field(
        None,
        description="Particle filter distance percentile (to mean) for confident particles",
    )
    roi_pf_min_measurements: Optional[int] = Field(
        None, description="Particle filter min number of measurements"
    )
    roi_pf_polygon_max_history: Optional[int] = Field(
        None, description="Particle filter polygon max history"
    )
    roi_pf_polygon_max_update_hz: Optional[int] = Field(
        None, description="Particle filter polygon max update hz"
    )
    roi_pf_measurement_pixel_error: Optional[float] = Field(
        None, description="Particle filter pixel error (noise) for measurement update"
    )
    roi_pf_max_hist_mean_seconds: Optional[float] = Field(
        None,
        description="Particle filter maximum temporal filtering window for cloud means",
    )
    roi_pf_cloud_exp_decay_rate: Optional[float] = Field(
        None,
        description="Particle filter decay rate for particle cloud when no measurements",
    )
    publish_rate: Optional[float] = Field(None, description="Publish rate (Hz)")
    publish_particles: Optional[bool] = Field(
        None, description="Publish particles to a pointcloud topic"
    )
    camera_info_topics: Optional[List[str]] = Field(
        None, description="List of camera info topics to use for geolocation"
    )
    roi_track_topics: Optional[List[str]] = Field(None, description="List of roi_track topics")
    ais: Optional[Ais] = None
    exclusion_zone_radius: Optional[float] = Field(
        None,
        description="Objects that are within this zone when first detected are ignored.",
    )
    diagnostic_updater: Optional[DiagnosticUpdater3] = None


class ObjectHistoryParameters(BaseModel):
    filter: Optional[str] = Field(None, description="")
    alerts: Optional[List[str]] = Field(None, description="")
    object_stale_timeout: Optional[float] = Field(
        None, description="How long to wait before removing object from history"
    )
    notifications_use_sim_time: Optional[bool] = Field(
        None, description="Whether to use the sim time for alerts"
    )
    diagnostic_updater: Optional[DiagnosticUpdater3] = None


class LookoutGreenstreamBringupParameters(BaseModel):
    launch_package: Optional[str] = Field(None, description="")
    launch_executable: Optional[str] = Field(None, description="")


class LookoutConfigManagerParameters(BaseModel):
    launch_package: Optional[str] = Field(None, description="")
    launch_executable: Optional[str] = Field(None, description="")


class WebBridgeParameters(BaseModel):
    address: Optional[str] = Field(
        None, description="The host address to bind the WebSocket server to"
    )
    asset_uri_allowlist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    best_effort_qos_send_buffer_limit: Optional[int] = Field(
        None,
        description="Connection send buffer limit in bytes for 'best_effort' messages",
    )
    best_effort_qos_topic_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) for topics that should be forced to use 'best_effort' QoS. Unmatched topics will use 'reliable' QoS if ALL publishers are 'reliable', 'best_effort' if any publishers are 'best_effort'.",
    )
    capabilities: Optional[List[str]] = Field(None, description="Server capabilities")
    certfile: Optional[str] = Field(None, description="Path to the certificate to use for TLS")
    client_topic_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    disable_load_message: Optional[bool] = Field(
        None,
        description="Do not publish as loaned message when publishing a client message",
    )
    include_hidden: Optional[bool] = Field(None, description="Include hidden topics and services")
    keyfile: Optional[str] = Field(None, description="Path to the private key to use for TLS")
    max_qos_depth: Optional[int] = Field(
        None, description="Maximum depth used for the QoS profile of subscriptions."
    )
    min_qos_depth: Optional[int] = Field(
        None, description="Minimum depth used for the QoS profile of subscriptions."
    )
    param_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    port: Optional[int] = Field(None, description="The TCP port to bind the WebSocket server to")
    send_buffer_limit: Optional[int] = Field(
        None,
        description="Connection send buffer limit in bytes. Messages will be dropped when a connection's send buffer reaches this limit to avoid a queue of outdated messages building up.",
    )
    service_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted service names.",
    )
    tls: Optional[bool] = Field(
        None, description="Use Transport Layer Security for encrypted communication"
    )
    topic_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted topic names.",
    )
    use_compression: Optional[bool] = Field(
        None,
        description="Use websocket compression (permessage-deflate). Suited for connections with smaller bandwidth, at the cost of additional CPU load.",
    )


class Camera(BaseModel):
    name: Optional[str] = Field(None, description="The name of the camera")
    order: Optional[int] = Field(None, description="The order of the camera")
    type: Optional[str] = Field(None, description="The camera type")


class Crop(BaseModel):
    top: Optional[int] = Field(
        None, description="Number of pixels to crop from the top of the video stream"
    )
    left: Optional[int] = Field(
        None, description="Number of pixels to crop from the left of the video stream"
    )
    bottom: Optional[int] = Field(
        None, description="Number of pixels to crop from the bottom of the video stream"
    )
    right: Optional[int] = Field(
        None, description="Number of pixels to crop from the right of the video stream"
    )


class Rtsp(BaseModel):
    username: Optional[str] = Field(None, description="RTSP Camera username")
    password: Optional[str] = Field(None, description="RTSP Camera password")
    ip_address: Optional[str] = Field(None, description="RTSP Camera IP address")
    port: Optional[int] = Field(None, description="RTSP Camera port")
    stream: Optional[str] = Field(None, description="RTSP Camera stream")


class Test(BaseModel):
    pattern: Optional[str] = Field(None, description="Test pattern for videotestsrc")


class Pipeline(BaseModel):
    name: Optional[str] = Field(
        None, description="Node name of main stream for this pipeline to stream from"
    )


class V4l2(BaseModel):
    device: Optional[str] = Field(None, description="V4L2 device path")


class Genicam(BaseModel):
    camera_name: Optional[str] = Field(None, description="GenICam camera name")
    auto_exposure: Optional[bool] = Field(None, description="Enable camera auto exposure")
    auto_gain: Optional[bool] = Field(None, description="Enable camera auto gain")


class RosDds(BaseModel):
    topic: Optional[str] = Field(None, description="Incoming topic for camera stream")


class Custom(BaseModel):
    pipeline: Optional[str] = Field(None, description="Custom camera pipeline")


class Webrtc(BaseModel):
    peer_id: Optional[str] = Field(None, description="Peer ID for WebRTC source")


class SignallingServer(BaseModel):
    host: Optional[str] = Field(None, description="Signalling server host IP")
    port: Optional[int] = Field(None, description="Signalling server port")


class Ue(BaseModel):
    signalling_server: Optional[SignallingServer] = None
    streamer_id: Optional[str] = Field(None, description="Camera ID for the UE Streamer")


class Source(BaseModel):
    type: Optional[str] = Field(None, description="The type of stream source")
    framerate: Optional[int] = Field(
        None, description="Framerate for video stream to scale to (FPS)"
    )
    pixel_height: Optional[int] = Field(
        None, description="Pixel height of scaled video resolution"
    )
    pixel_width: Optional[int] = Field(None, description="Pixel width of scaled video resolution")
    format: Optional[str] = Field(None, description="Format of video stream")
    crop: Optional[Crop] = None
    rtsp: Optional[Rtsp] = None
    test: Optional[Test] = None
    pipeline: Optional[Pipeline] = None
    v4l2: Optional[V4l2] = None
    genicam: Optional[Genicam] = None
    ros_dds: Optional[RosDds] = None
    custom: Optional[Custom] = None
    webrtc: Optional[Webrtc] = None
    ue: Optional[Ue] = None


class Undistort(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable image undistortion")
    k_intrinsic: Optional[List[float]] = Field(None, description="Camera intrinsic matrix")
    distortion_parameters: Optional[List[float]] = Field(
        None, description="Camera distortion parameters"
    )


class SignallingServer1(BaseModel):
    protocol: Optional[str] = Field(None, description="Signalling server protocol. 'ws' or 'wss'")
    host: Optional[str] = Field(None, description="Signalling server host IP")
    port: Optional[int] = Field(None, description="Signalling server port")


class VeryLow(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="Very Low Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="Very Low Quality max bitrate (bits/s)")


class Low(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="Low Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="Low Quality max bitrate (bits/s)")


class Medium(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="Medium Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="Medium Quality max bitrate (bits/s)")


class High(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="High Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="High Quality max bitrate (bits/s)")


class VeryHigh(BaseModel):
    min_bitrate: Optional[int] = Field(None, description="Very High Quality min bitrate (bits/s)")
    max_bitrate: Optional[int] = Field(None, description="Very High Quality max bitrate (bits/s)")


class Quality(BaseModel):
    level: Optional[str] = Field(None, description="Quality level for WebRTC publishing")
    very_low: Optional[VeryLow] = None
    low: Optional[Low] = None
    medium: Optional[Medium] = None
    high: Optional[High] = None
    very_high: Optional[VeryHigh] = None


class Webrtc1(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable WebRTC publishing")
    signalling_server: Optional[SignallingServer1] = None
    congestion_control: Optional[str] = Field(None, description="WebRTC congestion control mode")
    quality: Optional[Quality] = None


class Topic(BaseModel):
    enabled: Optional[bool] = Field(None, description="Enable image topic publishing")
    name: Optional[str] = Field(None, description="Name of image topic")
    throttle_time: Optional[float] = Field(
        None,
        description="Time kept between rendered buffers for the ROS topic in seconds",
    )
    frame_id: Optional[str] = Field(None, description="Camera frame ID of image stream")


class Publish(BaseModel):
    webrtc: Optional[Webrtc1] = None
    topic: Optional[Topic] = None


class PipelineBowStbdColorParameters(BaseModel):
    namespace_vessel_application: Optional[str] = Field(
        None,
        description="The namespace of the vessel and application, separated by '/'",
    )
    recreate_pipeline_on_eos: Optional[bool] = Field(
        None, description="Enable pipeline recreation on EOS"
    )
    latency_tracer: Optional[bool] = Field(None, description="Enable latency tracer")
    debug_plugins: Optional[List[str]] = Field(
        None, description="List of plugins to enable debug logging for"
    )
    camera: Optional[Camera] = None
    source: Optional[Source] = None
    undistort: Optional[Undistort] = None
    publish: Optional[Publish] = None
    diagnostic_updater: Optional[DiagnosticUpdater3] = None


class GstRosimagesinkBowStbdColorParameters(BaseModel):
    pass


class InfoBowStbdColorParameters(BaseModel):
    frame_id: Optional[str] = Field(None, description="Frame id / Camera id")
    model: Optional[str] = Field(None, description="Camera model")
    type: Optional[str] = Field(None, description="Camera type")
    pixel_width: Optional[int] = Field(None, description="Pixel width (pixels)")
    pixel_height: Optional[int] = Field(None, description="Pixel height (pixels)")
    distortion_model: Optional[str] = Field(None, description="Distortion model type")
    distortion_params: Optional[List[float]] = Field(None, description="Distortion parameters")
    k_intrinsic: Optional[List[float]] = Field(None, description="Intrinsic matrix")
    distortion_kmat_alpha: Optional[float] = Field(
        None,
        description="Free scaling parameter for undistorted image between 0 (all pixels are valid), and 1 (all source pixels are retained i.e. max distortion FOV)",
    )
    publish_camera_info: Optional[bool] = Field(
        None,
        description="If false, will subscribe to an existing camera info topic instead for camera_info_distorted",
    )


class LaunchParameters(BaseModel):
    diagnostic_aggregator: Optional[DiagnosticAggregatorParameters] = None
    roi_tracker: Optional[RoiTrackerParameters] = None
    data_recorder: Optional[DataRecorderParameters] = None
    system_resource_monitor: Optional[SystemResourceMonitorParameters] = None
    geolocation: Optional[GeolocationParameters] = None
    parameter_persistence: Optional[ParameterPersistenceParameters] = None
    detector_onnx: Optional[DetectorOnnxParameters] = None
    vessel_offsets: Optional[VesselOffsetsParameters] = None
    object_tracker: Optional[ObjectTrackerParameters] = None
    object_history: Optional[ObjectHistoryParameters] = None
    lookout_greenstream_bringup: Optional[LookoutGreenstreamBringupParameters] = None
    lookout_config_manager: Optional[LookoutConfigManagerParameters] = None
    web_bridge: Optional[WebBridgeParameters] = None
    pipeline_bow_stbd_color: Optional[PipelineBowStbdColorParameters] = None
    gst_rosimagesink_bow_stbd_color: Optional[GstRosimagesinkBowStbdColorParameters] = None
    info_bow_stbd_color: Optional[InfoBowStbdColorParameters] = None
