# -*- coding: utf-8 -*-
"""ocb-dc-ose-2021-data.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1loU6EQEIUEm2Ei7kT0swQWtGK_ysS6q9

# Data Access for the Oceanbench v2 datachallenge demo

## Colab setup
- [x] Install condacolab to create conda environment
- [x] Fetch and install conda dependencies
- [x] **[Requires credentials]** Login to copernicus marine services for data access (uses colab secrets)
- [ ] **[Requires credentials]** Set environment variable for AWS and github access (uses colab secrets)
"""

try:
    import google.colab
    !pip install -q condacolab conda-merge
    import condacolab
    condacolab.install_mambaforge()
except:
    print("Not installing since not in colab")

try:
    import google.colab
    !wget -nc https://raw.githubusercontent.com/quentinf00/ocb-dc-ose-2021/main/envs/{docs,base,dc,dvc-s3}.yaml
    !conda merge {docs,base,dc,dvc-s3}.yaml  > env.yaml
    !cat env.yaml
    !mamba env update --quiet -n base -f env.yaml
except:
    print("Not installing since not in colab")

try:
    import copernicusmarine
    from google.colab import userdata
    copernicusmarine.login(username=userdata.get('COPERNICUSUSER'), password=userdata.get('COPERNICUSPWD'))
except:
    print("Not installing since not in colab")

"""## Reusing processing steps and reproducing data preparation

# Use the configured `ocb-dc_ose_2021-input_data` pipeline

#### Reproduce processing of single satellite
"""

!ocb-dc_ose_2021-input_data params.sat=j2g

ds = xr.open_mfdataset('data/prepared/input/*.nc', combine='nested',concat_dim='time')
ds

# 2D map
bin_size = 1/20
(
    ds.sel(time='2017-01-01').assign(
        lat=ds.lat / bin_size // 1 * bin_size,
        lon=ds.lon / bin_size // 1 * bin_size
    )[['ssh', 'lat', 'lon']].load()
    .drop_vars('time')
    .to_dataframe()
    .groupby(['lat', 'lon']).mean()
    .to_xarray()
).ssh.plot()

"""#### Dry (without actual execution) run for all satellites"""

!ocb-dc_ose_2021-input_data --multirun dry=True

"""## Downloading versioned and preprocessed data

### Listing datachallenge content
"""

# Commented out IPython magic to ensure Python compatibility.
# Storing the repo url for convenience
# %env DC_REPO=https://github.com/quentinf00/ocb-dc-ose-2021.git

# Listing and pretty printing all files of the datachallenge
!dvc ls -R $DC_REPO datachallenge/data \
| tree --fromfile

"""### Downloading prepared input data"""

!dvc get -q $DC_REPO datachallenge/data/prepared/input

!tree input

"""### Visualize input data"""

import xarray as xr
ds = xr.open_mfdataset('input/*.nc', combine='nested',concat_dim='time')
ds

# 2D map
bin_size = 1/20
(
    ds.sel(time='2017-01-01').assign(
        lat=ds.lat / bin_size // 1 * bin_size,
        lon=ds.lon / bin_size // 1 * bin_size
    )[['ssh', 'lat', 'lon']].load()
    .drop_vars('time')
    .to_dataframe()
    .groupby(['lat', 'lon']).mean()
    .to_xarray()
).ssh.plot()

"""### Checking generated data VS downloaded"""

xr.testing.assert_allclose(
    xr.open_dataset('data/prepared/input/j2g.nc'),
    xr.open_dataset('input/j2g.nc'),
)
print("Successful reproduction")

"""### More on pipeline usage (help, doc, ...)"""

!ocb-dc_ose_2021-input_data --help

!ocb-dc_ose_2021-input_data params.sat=alg dry=True 'hydra.verbose=[aprl.appareil]'
