"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Expression = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Expression for events in Detector Model state.
 * @see https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
 */
class Expression {
    /**
     * Create a expression from the given string.
     */
    static fromString(value) {
        return new StringExpression(value);
    }
    /**
     * Create a expression for function `currentInput()`.
     * It is evaluated to true if the specified input message was received.
     */
    static currentInput(input) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_IInput(input);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.currentInput);
            }
            throw error;
        }
        return this.fromString(`currentInput("${input.inputName}")`);
    }
    /**
     * Create a expression for function `timeout("timer-name")`.
     * It is evaluated to true if the specified timer has elapsed.
     * You can define a timer only using the `setTimer` action.
     */
    static timeout(timerName) {
        return this.fromString(`timeout("${timerName}")`);
    }
    /**
     * Create a expression for get an input attribute as `$input.TemperatureInput.temperatures[2]`.
     */
    static inputAttribute(input, path) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_IInput(input);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inputAttribute);
            }
            throw error;
        }
        return this.fromString(`$input.${input.inputName}.${path}`);
    }
    /**
     * Create a expression for the Addition operator.
     */
    static add(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.add);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '+', right, 12);
    }
    /**
     * Create a expression for the Subtraction operator.
     */
    static subtract(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.subtract);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '-', right, 12);
    }
    /**
     * Create a expression for the Division operator.
     */
    static divide(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.divide);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '/', right, 13);
    }
    /**
     * Create a expression for the Multiplication operator.
     */
    static multiply(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.multiply);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '*', right, 13);
    }
    /**
     * Create a expression for the String Concatenation operator.
     */
    static concat(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.concat);
            }
            throw error;
        }
        return this.add(left, right);
    }
    /**
     * Create a expression for the Bitwise OR operator.
     */
    static bitwiseOr(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bitwiseOr);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '|', right, 6);
    }
    /**
     * Create a expression for the Bitwise AND operator.
     */
    static bitwiseAnd(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bitwiseAnd);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '&', right, 8);
    }
    /**
     * Create a expression for the Bitwise XOR operator.
     */
    static bitwiseXor(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bitwiseXor);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '^', right, 7);
    }
    /**
     * Create a expression for the Equal operator.
     */
    static eq(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.eq);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '==', right, 9);
    }
    /**
     * Create a expression for the Not Equal operator.
     */
    static neq(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.neq);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '!=', right, 9);
    }
    /**
     * Create a expression for the Less Than operator.
     */
    static lt(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.lt);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '<', right, 10);
    }
    /**
     * Create a expression for the Less Than Or Equal operator.
     */
    static lte(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.lte);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '<=', right, 10);
    }
    /**
     * Create a expression for the Greater Than operator.
     */
    static gt(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.gt);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '>', right, 10);
    }
    /**
     * Create a expression for the Greater Than Or Equal operator.
     */
    static gte(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.gte);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '>=', right, 10);
    }
    /**
     * Create a expression for the AND operator.
     */
    static and(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.and);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '&&', right, 5);
    }
    /**
     * Create a expression for the OR operator.
     */
    static or(left, right) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(left);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_Expression(right);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.or);
            }
            throw error;
        }
        return new BinaryOperationExpression(left, '||', right, 4);
    }
    constructor() {
    }
}
exports.Expression = Expression;
_a = JSII_RTTI_SYMBOL_1;
Expression[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.Expression", version: "2.185.0-alpha.0" };
class StringExpression extends Expression {
    constructor(value) {
        super();
        this.value = value;
    }
    evaluate() {
        return this.value;
    }
}
class BinaryOperationExpression extends Expression {
    constructor(left, operator, right, 
    /**
     * Indicates the priority of the operator.
     * This is intended to be set according to MDN rules.
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Operator_Precedence#table
     */
    priority) {
        super();
        this.left = left;
        this.operator = operator;
        this.right = right;
        this.priority = priority;
    }
    evaluate(parentPriority) {
        const expression = `${this.left.evaluate(this.priority)} ${this.operator} ${this.right.evaluate(this.priority)}`;
        return parentPriority === undefined || parentPriority <= this.priority
            ? expression
            : `(${expression})`;
    }
}
//# sourceMappingURL=data:application/json;base64,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