from django.contrib import admin
from django.utils.html import format_html

from .models import PointOfInterest


class PointOfInterestAdmin(admin.ModelAdmin):
    list_display = (
        'name',
        'position',
        'position_map',
    )

    def position_map(self, instance):
        if instance.position is not None:
            # TODO Maybe need to add client ID and signature
            return format_html(
                '<img src="http://maps.googleapis.com/maps/api/staticmap?center=%(latitude)s,%(longitude)s&zoom=%(zoom)s&size=%(width)sx%(height)s&maptype=roadmap&markers=%(latitude)s,%(longitude)s&sensor=false&visual_refresh=true&scale=%(scale)s" width="%(width)s" height="%(height)s">'
                % {
                    'latitude': instance.position.latitude,
                    'longitude': instance.position.longitude,
                    'zoom': 14,
                    'width': 100,
                    'height': 100,
                    'scale': 2
                })


admin.site.register(PointOfInterest, PointOfInterestAdmin)
