#===----------------------------------------------------------------------===#
#
#         STAIRLab -- STructural Artificial Intelligence Laboratory
#
#===----------------------------------------------------------------------===#
CESMD = {
    "56-0586G":  ("CE13705", "08-RIV-15-R41.57"   , "Corona - I15/Hwy91 Interchange Bridge"),
    "53-1471":   ("CE14406", "07-LA-47-0.86"      , "Vincent Thomas Bridge"),
    "53-2791":   ("CE24704", "07-LA-10-8.8"       , "La Cienega Bridge"),
    "53-1794":   ("CE24706", "07-LA-14-R57.37"    , "Palmdale - Hwy 14/Barrel Springs Bridge"),
    "50-0271":   ("CE24775", "06-KER-5-4.1"       , "Grapevine - I5/Lebec Rd Bridge"),
    "43-0031E":  ("CE47315", "05-SBT-156-0.00"    , "San Juan Bautista - Hwy 101/156 Overpass"),
    "28-0352L":  ("CE68185", "04-SOL-80-0.01"     , "Vallejo - Carquinez/I80 West Bridge"),
    "23-0015R":  ("CE68184", "04-SOL-80-12.8"     , "Vallejo - Carquinez/I80 East Bridge"),
    "10-0299":   ("CE79421", "01-MEN-101-160.03"  , "Confusion Hill Bridge (Leggett, Hwy 101)"),
    "04-0170":   ("CE89708", "01-HUM-101-R92.99"  , "Arcata - Hwy 101/Murray Road Bridge"),
    "04-0229":   ("CE89735", "01-HUM-255-0.7"     , "Eureka - Middle Channel Bridge"),
    "04-0230":   ("CE89736", "01-HUM-255-0.2"     , "Eureka - Eureka Channel Bridge"),
    "04-0016R":  ("CE89973", "01-HUM-101-53.9"    , "Rio Dell - Hwy 101/Eel River Bridge"),
    "50-0340":   ("CE33742", "09-KER-395-R25.08"  , "Ridgecrest - Hwy 395/Brown Road Bridge"),
    "53-2795F":  ("CE24694", "07-LA-5-24.5"       , "Sylmar - I5/14 Interchange Bridge"),
    "55-0225":   ("CE13795", "07-ORA-5-6.62"      , "Capistrano Beach - I5/Via Calif. Bridge"),

#   "58-0215":   ("CE01336",                  None, "El Centro - Hwy8/Meloland Overpass [Abandoned]"),
    "47-0048":   ("CE54730",                  None, "Lake Crowley - Hwy 395 Bridge"),
    "04-0228":   ("CE89686",                  None, "Eureka - Samoa Channel Bridge"),
    "04-0236":   ("CE89324",                  None, "Rio Dell - Hwy 101/Painter St. Overpass"),
    "54-0823G":  ("CE23631",                  None, "San Bernardino - I10/215 Interchange Br"),
    "33-0214L":  ("CE58658",                  None, "Hayward - Hwy 580/238 Interchange Bridge"),
# }

# TODO: Need to get NBI/CGS Data for these 
# {
#-------------------------------------

    "34-0006":   ("CE58600",                  None, "Oakland - SF Bay Bridge/East: SAS"),
#   "34-0006":   ("CE58601", "04-SF-80-8.7" , "Oakland - SF Bay Bridge/East: Skyway"),
#   "34-0006":   ("CE58602",                  None, "Oakland - SF Bay Bridge/East: YBITS"),
#   "34-0006":   ("CE58603",                  None, "Oakland - SF Bay Bridge/East: E Approach"),
    "34-0003":   ("CE58632", "04-SF-80-5.6" , "San Francisco - Bay Bridge/West"),

    "35-0054":   ("CE58677",                  None, "San Mateo Bridge"),
#   "35-0054":   ("CE58799",                  None, "San Mateo Bridge Trestle"),
#   "53-3032":   ("CE14709",                  None, "Long Beach - Schuyler Heim Bridge"),
    "51-0104":   ("CE25749",                  None, "Santa Barbara - San Roque Canyon Bridge"),
    "44-0298":   ("CE47646",                  None, "Big Sur - New Hwy 1/Pfeiffer Cnyn Bridge"),
    "44-0060":   ("CE47729",                  None, "Big Sur - Hwy 1/Pfeiffer Canyon Bridge [Demolished]"),
#   "37-0470L":  ("CE57748",                  None, "Santa Clara - Hwy 237/Alviso Overpass"),
#   "37-0470K":  ("CE57748",                  None, "Santa Clara - Hwy 237/Alviso Overpass"),
    "27-0013":   ("CE68778",                  None, "Novato - Hwy37/Petaluma River Bridge"),
    "17-0058L":  ("CE76741",                  None, "Truckee - I80/Truckee River Bridge"),
    "06-0210":   ("CE88638",                  None, "Shasta Lake - I5/Antlers Bridge"),
#   "54-0474F":  ("CE12666",                  None, "North Palm Springs - I10/Hwy 62 Bridge"),
    "53-1185":   ("CE14690",                  None, "Los Angeles - I405/San Gabriel River Br"),
    "50-0402R":  ("CE34715",                  None, "Mojave - Hwy 14/Railroad Bridge"),
    "33-0347S":  ("CE58656",                  None, "Oakland - Hwy 580/13 Interchange Bridge"),
    "33-0302H":  ("CE58657",                  None, "Oakland - Hwy 580/24 Interchange Bridge"),
#   "35-0285":   ("CE58678",                  None, "Belmont - I280 Pedestrian Bridge"),

    "01-0020":   ("CE99190", "01-DN-101-36.06"     , "Crescent City - Hwy 101/Smith Rvr Bridge"),
    "01-0028":   ("CE99710", "01-DN-101-R4.04"     , "Klamath - Hwy 101/Klamath River Bridge"),
    "10-0081":   ("CE69760", "01-MEN-101-R9.53"    , "Hopland - Hwy 101/Railroad Bridge"),
    "10-0134":   ("CE79683", "01-MEN-1-43.00"      , "Albion - Hwy 1/Salmon Creek Bridge"),
    "10-0031":   ("CE79757", "01-MEN-271-5.2"      , "Leggett - Cedar Creek Bridge"),
    "10-0030":   ("CE79761", "01-MEN-271-4.9"      , "Leggett - Big Dann Bridge"),
    "10-0176":   ("CE79296", "01-MEN-1-96.9"       , "Fort Bragg - Hwy 1/Noyo River Bridge"),

    "06-0021":   ("CE88194", "02-SHA-5-R28.14"     , "Redding - I5/Shasta Lake Bridge"),

    "24-0045":   ("CE67972", "03-YOL-80-7.25"      , "West Sacramento - I80/Yolo Causeway"),

    "35-0038":   ("CE58596", "04-SM-84-29.0"       , "Dumbarton Bridge"),
    "35-0130":   ("CE58536", "04-SM-101-23.7"      , "South San Francisco - Sierra Pt Overpass"),
    "35-0031":   ("CE58754", "04-SM-1-20.82"       , "Half Moon Bay - Hwy 1/Tunitas Cr. Bridge"),
    "28-0009":   ("CE67771", "04-CC-160-0.82"      , "Antioch - San Joaquin River Bridge"),
    "28-0153":   ("CE68682", "04-CC-68-25.04"      , "Benicia - Martinez"),
    "28-0153R":  ("CE68322", "04-CC,Sol-680-L0.0"  , "Benicia - Martinez/I680 East Bridge"),
    "28-0100":   ("CE58258", "04-CC,MRN-580-6.1/7.8,0.0/2.6" , "Richmond - San Rafael Bridge"),
    "36-0088R":  ("CE47707", "04-SCR-1-R1.59"      , "Watsonville - Hwy1/Struve Slough Bridge"),
    "20-0195":   ("CE69671", "04-SON-1-19.72"      , "Jenner - Hwy 1/Russian River Bridge"),
    "20-0235":   ("CE68717", "04-SON-101-13.88"    , "Rohnert Park - Hwy 101 Bridge"),

    "51-0090":   ("CE26917", "05-SB-01-R6.78"      , "Lompoc - Hwy 1/El Jaro Creek Bridge"),
    "49-0036":   ("CE36668", "05-SLO-46-54.77"     , "Parkfield - Hwy 46/Cholame Creek Bridge"),
    "49-0046":   ("CE37728", "05-SLO-52.92"        , "San Simeon - Hwy 1/San Simeon Crk Bridge"),
    "51-0066":   ("CE25758", "05-SB-166-R69.94"    , "Cuyama - Hwy 166/Cuyama River Bridge"),

    "53-1630G":  ("CE24670", "07-LS-405-29.43"     , "Los Angeles - I10/405 Interchange Bridge"),
    "53-2318G":  ("CE24689", "07-LA-134-R13.25"    , "Pasadena - I210/Hwy134 Interchnge Bridge"),
    "52-0449":   ("CE25324", "07-VEN-101-37.21"    , "Oxnard - Hwy 101/Santa Clara Rvr Bridge"),
    "52-0331L":  ("CE24738", "07-VEN-023/118-21.0" , "Moorpark - Hwy 23/118 Bridge"),
    "52-0214L":  ("CE25725", "07-VEN-101-R26"      , "Ventura - Hwy101/Telephone Rd. Bridge"),

    "54-1177":   ("CE22503", "08-SBd-18,38-44.4"   , "Big Bear Lake - Hwys 18 & 38 Bridge"),
    "56-0452F":  ("CE12649", "08-RIV-10-6.67"      , "Beaumont - I10/60 Interchange Bridge"),
    "54-0783R":  ("CE23650", "08-SBD-15-16.35"     , "Devore - I15/215 Interchange Bridge"),

    "23-0064":   ("CE68065", "10-SOL-37-R7.39"     , "Vallejo - Hwy 37/Napa River Bridge"),

    "57-0520L":  ("CE03731", "11-SD-5-25.91"       , "San Diego - I5/Hwy 52 Interchange Bridge"),
    "57-0857":   ("CE03679", "11-SD-75-R20.49"     , "San Diego - Coronado Bridge"),
    "27-0052":   ("CE58700", ""                    , "San Francisco - Golden Gate Bridge"),
}

"""
    "":   ("CE24714",                  None, "San Fernando - I210/Hwy 118 Bridge [Abandoned]"),
    "":   ("CE25697",                  None, "Cuyama Valley - Hwy 33/Quatal Cyn Bridge [Abandoned]"),
    "":   "NP5235",  # "Riverside; Santa Ana River Bridge"
    "":   "NP1571",  # "San Jose; Interchange 101/280/680"

    "":   ("CE58414",                  None, "Pacifica - Hwy1/Devils Slide Bridge"),
    "":   ("CE57595",                  None, "Fremont - Channel B Bridge"),
    "":   "CE14703", # "Long Beach - Gerald Desmond Bridge",
    "":   "CE58501", # "Hayward - BART Elevated Section",
    "":   "CE58633", # "San Francisco - Bay Bridge/East [Abandoned]",
"""

CALID = {v[0]: k for k, v in CESMD.items()}

CESMD_LONG_LAT = {
 '89973': [40.5093, -124.1196],
 '89324': [40.5031, -124.1009],
 '89686': [40.8216, -124.1697],
 '89736': [40.809, -124.1547],
 '89735': [40.8136, -124.1594],
 '47315': [36.8619, -121.5796],
 '23631': [34.065, -117.2962],
 '58700': [37.8198, -122.4788],
 '25749': [34.4497, -119.735],
 '14406': [33.7494, -118.2715],
 '58632': [37.7982, -122.3774],
 '58657': [37.8286, -122.2666],
 '24775': [34.8663, -118.8836],
 '58601': [37.8198, -122.3429],
 '24706': [34.5463, -118.1301],
 '33742': [35.6696, -117.8187],
 '24704': [34.0368, -118.3762],
 '24689': [34.1486, -118.1561],
 '54730': [37.5733, -118.739],
 '13705': [33.882, -117.5497],
 '13795': [33.4659, -117.6674],
 '68065': [38.1205, -122.2801],
 '57595': [37.4639, -121.9302],
 '68185': [38.061, -122.2265],
 '68717': [38.3484, -122.713],
 '58754': [37.3574, -122.397],
 '58658': [37.6907, -122.0993],
 '76741': [39.368, -120.1151],
 '89708': [40.9563, -124.1161],
 '24714': [34.2878, -118.4084],
 '79421': [39.9213, -123.7634],
 '68778': [38.1157, -122.5054],
 '58602': [37.8126, -122.3627],
 '68184': [38.061, -122.2252],
 '12666': [33.9153, -116.6085],
 '68682': [38.0414, -122.1238],
 '12649': [33.9332, -116.9907],
 '67771': [38.0278, -121.7514],
 '57748': [37.4176, -121.9738],
 '58600': [37.8152, -122.3589],
 '69760': [38.955, -123.1051],
 '47707': [36.9067, -121.7818],
 '03679': [32.6891, -117.1538],
 '24738': [34.2878, -118.865],
 '36668': [35.7331, -120.2901],
 '37728': [35.5955, -121.1256],
 '03731': [32.838, -117.234],
 '99190': [41.8797, -124.1373],
 '25324': [34.2428, -119.1905],
 '58258': [37.9344, -122.4346],
 '79757': [39.8485, -123.7019],
 '68322': [38.0441, -122.1229],
 '58596': [37.505, -122.12],
 '24694': [34.3349, -118.5084],
 '79683': [39.2157, -123.7678],
 '24670': [34.0314, -118.4354],
 '69671': [38.4347, -123.1017],
 '79761': [39.8471, -123.6967],
 '58656': [37.7837, -122.1769],
 '67972': [38.5728, -121.587],
 '99710': [41.5174, -124.0307],
 '23650': [34.2251, -117.4096],
 '58677': [37.5836, -122.2515],
 '25758': [34.9331, -119.5941],
 '79296': [39.4274, -123.8068],
 '58536': [37.6746, -122.3895],
 '58501': [37.6708, -122.0885],
 '58414': [37.584, -122.509],
 '01571':  [37.34105, -121.8514],
 '05235':  [33.96843, -117.44815],
 '25725': [34.2622, -119.231],
 '58799': [37.6083, -122.1842],
 '47646': [36.2391, -121.7747],
 '88638': [40.881, -122.3809],
 '22503': [34.2419, -116.9775],
 '88194': [40.7597, -122.3188],
 '26917': [34.5215, -120.3369],
 '34715': [35.0387, -118.1696],
 '14690': [33.7865, -118.0939],
 '58678': [37.5048, -122.3346]
}
