from typing import Any, Dict, Optional

from gigachat.pydantic_v1 import BaseModel


class Storage(BaseModel):
    """Данные для хранения контекста на стороне GigaChat"""

    is_stateful: bool
    """
    Режим сохранения сообщений контекста.
    При работе с данным режимом не требуется передавать сообщения контекста каждый раз.
    Достаточно передать только новое сообщение
    """
    limit: Optional[int] = None
    """
    Максимальное количество сообщений исторического контекста, которые посылаются в модель в запросе.
    Если пользователь передает limit на генерацию ответа от модели и у него есть system в истории или
    инструкция у ассистента, то кол-во сообщений отправленных в модель = limit + 1,
    т.е. к лимиту добавляется систем промпт.
    Если параметр не передан, считаем что необходимо отправить весь контекст.
    """
    assistant_id: Optional[str] = None
    """
    Идентификатор ассистента при создании треда (только в первом сообщении).
    При передаче идентификатора  нельзя передавать поле model.
    При передаче id треда этот идентификатор не передается
    """
    thread_id: Optional[str] = None
    """Идентификатор треда. Не заполняется для первого сообщения"""
    metadata: Optional[Dict[Any, Any]] = None
