# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Literal, Optional

from pydantic import BaseModel, ConfigDict, Field, constr

from .. import EnvScopedObjectReference
from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    ccl_v1 = 'ccl/v1'


class Kind(Enum):
    custom_code_logging = 'CustomCodeLogging'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/ccl/v1/custom-code-loggings/ccl-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/custom-code-logging=ccl-12345'
        ],
    )


class Kind1Model(Enum):
    kafka = 'Kafka'


class KafkaDestinationSettings(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Kafka'] = Field(
        ..., description='The destination where Custom Code Logging is sent.'
    )
    cluster_id: constr(max_length=255) = Field(
        ...,
        description='The kafka cluster id where Custom Code Logging is sent.',
        examples=['lkc-123'],
    )
    topic: constr(max_length=255) = Field(
        ...,
        description='The kafka topic where Custom Code Logging is sent.',
        examples=['topic-123'],
    )
    log_level: Optional[constr(max_length=60)] = Field(
        'INFO',
        description='Minimum log level for Custom Code Logging.',
        examples=['INFO'],
    )


class Kind1Model1(Enum):
    custom_code_logging_list = 'CustomCodeLoggingList'


class Metadata1Model(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/ccl/v1/custom-code-loggings']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/ccl/v1/custom-code-loggings?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/ccl/v1/custom-code-loggings?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/ccl/v1/custom-code-loggings?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Kind1Model2(Enum):
    custom_code_logging = 'CustomCodeLogging'


class Metadata1Model1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/ccl/v1/custom-code-loggings/ccl-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/custom-code-logging=ccl-12345'
        ],
    )


class CustomCodeLoggingUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model2] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model1] = None
    destination_settings: Optional[KafkaDestinationSettings] = Field(
        None,
        description='Destination Settings of the Custom Code Logging.',
        discriminator='kind',
    )
    environment: Optional[EnvScopedObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class CustomCodeLogging(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    cloud: Optional[constr(max_length=60)] = Field(
        None,
        description='Cloud provider where the Custom Code Logging is sent.',
        examples=['AWS'],
    )
    region: Optional[constr(max_length=60)] = Field(
        None,
        description='The Cloud provider region the Custom Code Logging is sent.',
        examples=['us-west-2'],
    )
    destination_settings: Optional[KafkaDestinationSettings] = Field(
        None,
        description='Destination Settings of the Custom Code Logging.',
        discriminator='kind',
    )
    environment: Optional[EnvScopedObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class CustomCodeLoggingList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model1 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model
    data: List[CustomCodeLogging] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
