/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BackupProtectedFileShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#backup_policy_id BackupProtectedFileShare#backup_policy_id}
    */
    readonly backupPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#id BackupProtectedFileShare#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#recovery_vault_name BackupProtectedFileShare#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#resource_group_name BackupProtectedFileShare#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#source_file_share_name BackupProtectedFileShare#source_file_share_name}
    */
    readonly sourceFileShareName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#source_storage_account_id BackupProtectedFileShare#source_storage_account_id}
    */
    readonly sourceStorageAccountId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#timeouts BackupProtectedFileShare#timeouts}
    */
    readonly timeouts?: BackupProtectedFileShareTimeouts;
}
export interface BackupProtectedFileShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#create BackupProtectedFileShare#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#delete BackupProtectedFileShare#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#read BackupProtectedFileShare#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#update BackupProtectedFileShare#update}
    */
    readonly update?: string;
}
export declare function backupProtectedFileShareTimeoutsToTerraform(struct?: BackupProtectedFileShareTimeouts | cdktf.IResolvable): any;
export declare class BackupProtectedFileShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupProtectedFileShareTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BackupProtectedFileShareTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share azurerm_backup_protected_file_share}
*/
export declare class BackupProtectedFileShare extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_backup_protected_file_share";
    /**
    * Generates CDKTF code for importing a BackupProtectedFileShare resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BackupProtectedFileShare to import
    * @param importFromId The id of the existing BackupProtectedFileShare that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BackupProtectedFileShare to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/backup_protected_file_share azurerm_backup_protected_file_share} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupProtectedFileShareConfig
    */
    constructor(scope: Construct, id: string, config: BackupProtectedFileShareConfig);
    private _backupPolicyId?;
    get backupPolicyId(): string;
    set backupPolicyId(value: string);
    get backupPolicyIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceFileShareName?;
    get sourceFileShareName(): string;
    set sourceFileShareName(value: string);
    get sourceFileShareNameInput(): string | undefined;
    private _sourceStorageAccountId?;
    get sourceStorageAccountId(): string;
    set sourceStorageAccountId(value: string);
    get sourceStorageAccountIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): BackupProtectedFileShareTimeoutsOutputReference;
    putTimeouts(value: BackupProtectedFileShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BackupProtectedFileShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
