/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CognitiveAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#custom_question_answering_search_service_id CognitiveAccount#custom_question_answering_search_service_id}
    */
    readonly customQuestionAnsweringSearchServiceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#custom_question_answering_search_service_key CognitiveAccount#custom_question_answering_search_service_key}
    */
    readonly customQuestionAnsweringSearchServiceKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#custom_subdomain_name CognitiveAccount#custom_subdomain_name}
    */
    readonly customSubdomainName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#dynamic_throttling_enabled CognitiveAccount#dynamic_throttling_enabled}
    */
    readonly dynamicThrottlingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#fqdns CognitiveAccount#fqdns}
    */
    readonly fqdns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#id CognitiveAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#kind CognitiveAccount#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#local_auth_enabled CognitiveAccount#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#location CognitiveAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#metrics_advisor_aad_client_id CognitiveAccount#metrics_advisor_aad_client_id}
    */
    readonly metricsAdvisorAadClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#metrics_advisor_aad_tenant_id CognitiveAccount#metrics_advisor_aad_tenant_id}
    */
    readonly metricsAdvisorAadTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#metrics_advisor_super_user_name CognitiveAccount#metrics_advisor_super_user_name}
    */
    readonly metricsAdvisorSuperUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#metrics_advisor_website_name CognitiveAccount#metrics_advisor_website_name}
    */
    readonly metricsAdvisorWebsiteName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#name CognitiveAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#outbound_network_access_restricted CognitiveAccount#outbound_network_access_restricted}
    */
    readonly outboundNetworkAccessRestricted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#public_network_access_enabled CognitiveAccount#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#qna_runtime_endpoint CognitiveAccount#qna_runtime_endpoint}
    */
    readonly qnaRuntimeEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#resource_group_name CognitiveAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#sku_name CognitiveAccount#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#tags CognitiveAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * customer_managed_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#customer_managed_key CognitiveAccount#customer_managed_key}
    */
    readonly customerManagedKey?: CognitiveAccountCustomerManagedKey;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#identity CognitiveAccount#identity}
    */
    readonly identity?: CognitiveAccountIdentity;
    /**
    * network_acls block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#network_acls CognitiveAccount#network_acls}
    */
    readonly networkAcls?: CognitiveAccountNetworkAcls;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#storage CognitiveAccount#storage}
    */
    readonly storage?: CognitiveAccountStorage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#timeouts CognitiveAccount#timeouts}
    */
    readonly timeouts?: CognitiveAccountTimeouts;
}
export interface CognitiveAccountCustomerManagedKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#identity_client_id CognitiveAccount#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#key_vault_key_id CognitiveAccount#key_vault_key_id}
    */
    readonly keyVaultKeyId: string;
}
export declare function cognitiveAccountCustomerManagedKeyToTerraform(struct?: CognitiveAccountCustomerManagedKeyOutputReference | CognitiveAccountCustomerManagedKey): any;
export declare class CognitiveAccountCustomerManagedKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveAccountCustomerManagedKey | undefined;
    set internalValue(value: CognitiveAccountCustomerManagedKey | undefined);
    private _identityClientId?;
    get identityClientId(): string;
    set identityClientId(value: string);
    resetIdentityClientId(): void;
    get identityClientIdInput(): string | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    get keyVaultKeyIdInput(): string | undefined;
}
export interface CognitiveAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#identity_ids CognitiveAccount#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#type CognitiveAccount#type}
    */
    readonly type: string;
}
export declare function cognitiveAccountIdentityToTerraform(struct?: CognitiveAccountIdentityOutputReference | CognitiveAccountIdentity): any;
export declare class CognitiveAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveAccountIdentity | undefined;
    set internalValue(value: CognitiveAccountIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface CognitiveAccountNetworkAclsVirtualNetworkRules {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#ignore_missing_vnet_service_endpoint CognitiveAccount#ignore_missing_vnet_service_endpoint}
    */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#subnet_id CognitiveAccount#subnet_id}
    */
    readonly subnetId: string;
}
export declare function cognitiveAccountNetworkAclsVirtualNetworkRulesToTerraform(struct?: CognitiveAccountNetworkAclsVirtualNetworkRules | cdktf.IResolvable): any;
export declare class CognitiveAccountNetworkAclsVirtualNetworkRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CognitiveAccountNetworkAclsVirtualNetworkRules | cdktf.IResolvable | undefined;
    set internalValue(value: CognitiveAccountNetworkAclsVirtualNetworkRules | cdktf.IResolvable | undefined);
    private _ignoreMissingVnetServiceEndpoint?;
    get ignoreMissingVnetServiceEndpoint(): boolean | cdktf.IResolvable;
    set ignoreMissingVnetServiceEndpoint(value: boolean | cdktf.IResolvable);
    resetIgnoreMissingVnetServiceEndpoint(): void;
    get ignoreMissingVnetServiceEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class CognitiveAccountNetworkAclsVirtualNetworkRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CognitiveAccountNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CognitiveAccountNetworkAclsVirtualNetworkRulesOutputReference;
}
export interface CognitiveAccountNetworkAcls {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#default_action CognitiveAccount#default_action}
    */
    readonly defaultAction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#ip_rules CognitiveAccount#ip_rules}
    */
    readonly ipRules?: string[];
    /**
    * virtual_network_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#virtual_network_rules CognitiveAccount#virtual_network_rules}
    */
    readonly virtualNetworkRules?: CognitiveAccountNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable;
}
export declare function cognitiveAccountNetworkAclsToTerraform(struct?: CognitiveAccountNetworkAclsOutputReference | CognitiveAccountNetworkAcls): any;
export declare class CognitiveAccountNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveAccountNetworkAcls | undefined;
    set internalValue(value: CognitiveAccountNetworkAcls | undefined);
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    get ipRules(): string[];
    set ipRules(value: string[]);
    resetIpRules(): void;
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkRules;
    get virtualNetworkRules(): CognitiveAccountNetworkAclsVirtualNetworkRulesList;
    putVirtualNetworkRules(value: CognitiveAccountNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable): void;
    resetVirtualNetworkRules(): void;
    get virtualNetworkRulesInput(): cdktf.IResolvable | CognitiveAccountNetworkAclsVirtualNetworkRules[] | undefined;
}
export interface CognitiveAccountStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#identity_client_id CognitiveAccount#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#storage_account_id CognitiveAccount#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function cognitiveAccountStorageToTerraform(struct?: CognitiveAccountStorage | cdktf.IResolvable): any;
export declare class CognitiveAccountStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CognitiveAccountStorage | cdktf.IResolvable | undefined;
    set internalValue(value: CognitiveAccountStorage | cdktf.IResolvable | undefined);
    private _identityClientId?;
    get identityClientId(): string;
    set identityClientId(value: string);
    resetIdentityClientId(): void;
    get identityClientIdInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
}
export declare class CognitiveAccountStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CognitiveAccountStorage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CognitiveAccountStorageOutputReference;
}
export interface CognitiveAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#create CognitiveAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#delete CognitiveAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#read CognitiveAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#update CognitiveAccount#update}
    */
    readonly update?: string;
}
export declare function cognitiveAccountTimeoutsToTerraform(struct?: CognitiveAccountTimeouts | cdktf.IResolvable): any;
export declare class CognitiveAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CognitiveAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account azurerm_cognitive_account}
*/
export declare class CognitiveAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cognitive_account";
    /**
    * Generates CDKTF code for importing a CognitiveAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CognitiveAccount to import
    * @param importFromId The id of the existing CognitiveAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CognitiveAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/cognitive_account azurerm_cognitive_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitiveAccountConfig
    */
    constructor(scope: Construct, id: string, config: CognitiveAccountConfig);
    private _customQuestionAnsweringSearchServiceId?;
    get customQuestionAnsweringSearchServiceId(): string;
    set customQuestionAnsweringSearchServiceId(value: string);
    resetCustomQuestionAnsweringSearchServiceId(): void;
    get customQuestionAnsweringSearchServiceIdInput(): string | undefined;
    private _customQuestionAnsweringSearchServiceKey?;
    get customQuestionAnsweringSearchServiceKey(): string;
    set customQuestionAnsweringSearchServiceKey(value: string);
    resetCustomQuestionAnsweringSearchServiceKey(): void;
    get customQuestionAnsweringSearchServiceKeyInput(): string | undefined;
    private _customSubdomainName?;
    get customSubdomainName(): string;
    set customSubdomainName(value: string);
    resetCustomSubdomainName(): void;
    get customSubdomainNameInput(): string | undefined;
    private _dynamicThrottlingEnabled?;
    get dynamicThrottlingEnabled(): boolean | cdktf.IResolvable;
    set dynamicThrottlingEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicThrottlingEnabled(): void;
    get dynamicThrottlingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _fqdns?;
    get fqdns(): string[];
    set fqdns(value: string[]);
    resetFqdns(): void;
    get fqdnsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _metricsAdvisorAadClientId?;
    get metricsAdvisorAadClientId(): string;
    set metricsAdvisorAadClientId(value: string);
    resetMetricsAdvisorAadClientId(): void;
    get metricsAdvisorAadClientIdInput(): string | undefined;
    private _metricsAdvisorAadTenantId?;
    get metricsAdvisorAadTenantId(): string;
    set metricsAdvisorAadTenantId(value: string);
    resetMetricsAdvisorAadTenantId(): void;
    get metricsAdvisorAadTenantIdInput(): string | undefined;
    private _metricsAdvisorSuperUserName?;
    get metricsAdvisorSuperUserName(): string;
    set metricsAdvisorSuperUserName(value: string);
    resetMetricsAdvisorSuperUserName(): void;
    get metricsAdvisorSuperUserNameInput(): string | undefined;
    private _metricsAdvisorWebsiteName?;
    get metricsAdvisorWebsiteName(): string;
    set metricsAdvisorWebsiteName(value: string);
    resetMetricsAdvisorWebsiteName(): void;
    get metricsAdvisorWebsiteNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outboundNetworkAccessRestricted?;
    get outboundNetworkAccessRestricted(): boolean | cdktf.IResolvable;
    set outboundNetworkAccessRestricted(value: boolean | cdktf.IResolvable);
    resetOutboundNetworkAccessRestricted(): void;
    get outboundNetworkAccessRestrictedInput(): boolean | cdktf.IResolvable | undefined;
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _qnaRuntimeEndpoint?;
    get qnaRuntimeEndpoint(): string;
    set qnaRuntimeEndpoint(value: string);
    resetQnaRuntimeEndpoint(): void;
    get qnaRuntimeEndpointInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _customerManagedKey;
    get customerManagedKey(): CognitiveAccountCustomerManagedKeyOutputReference;
    putCustomerManagedKey(value: CognitiveAccountCustomerManagedKey): void;
    resetCustomerManagedKey(): void;
    get customerManagedKeyInput(): CognitiveAccountCustomerManagedKey | undefined;
    private _identity;
    get identity(): CognitiveAccountIdentityOutputReference;
    putIdentity(value: CognitiveAccountIdentity): void;
    resetIdentity(): void;
    get identityInput(): CognitiveAccountIdentity | undefined;
    private _networkAcls;
    get networkAcls(): CognitiveAccountNetworkAclsOutputReference;
    putNetworkAcls(value: CognitiveAccountNetworkAcls): void;
    resetNetworkAcls(): void;
    get networkAclsInput(): CognitiveAccountNetworkAcls | undefined;
    private _storage;
    get storage(): CognitiveAccountStorageList;
    putStorage(value: CognitiveAccountStorage[] | cdktf.IResolvable): void;
    resetStorage(): void;
    get storageInput(): cdktf.IResolvable | CognitiveAccountStorage[] | undefined;
    private _timeouts;
    get timeouts(): CognitiveAccountTimeoutsOutputReference;
    putTimeouts(value: CognitiveAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CognitiveAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
