/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAppEnvironmentDaprComponentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Dapr Component Type. For example `state.azure.blobstorage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#component_type ContainerAppEnvironmentDaprComponent#component_type}
    */
    readonly componentType: string;
    /**
    * The Container App Managed Environment ID to configure this Dapr component on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#container_app_environment_id ContainerAppEnvironmentDaprComponent#container_app_environment_id}
    */
    readonly containerAppEnvironmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#id ContainerAppEnvironmentDaprComponent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Should the Dapr sidecar to continue initialisation if the component fails to load. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#ignore_errors ContainerAppEnvironmentDaprComponent#ignore_errors}
    */
    readonly ignoreErrors?: boolean | cdktf.IResolvable;
    /**
    * The component initialisation timeout in ISO8601 format. e.g. `5s`, `2h`, `1m`. Defaults to `5s`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#init_timeout ContainerAppEnvironmentDaprComponent#init_timeout}
    */
    readonly initTimeout?: string;
    /**
    * The name for this Dapr Component.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#name ContainerAppEnvironmentDaprComponent#name}
    */
    readonly name: string;
    /**
    * A list of scopes to which this component applies. e.g. a Container App's `dapr.app_id` value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#scopes ContainerAppEnvironmentDaprComponent#scopes}
    */
    readonly scopes?: string[];
    /**
    * The version of the component.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#version ContainerAppEnvironmentDaprComponent#version}
    */
    readonly version: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#metadata ContainerAppEnvironmentDaprComponent#metadata}
    */
    readonly metadata?: ContainerAppEnvironmentDaprComponentMetadata[] | cdktf.IResolvable;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#secret ContainerAppEnvironmentDaprComponent#secret}
    */
    readonly secret?: ContainerAppEnvironmentDaprComponentSecret[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#timeouts ContainerAppEnvironmentDaprComponent#timeouts}
    */
    readonly timeouts?: ContainerAppEnvironmentDaprComponentTimeouts;
}
export interface ContainerAppEnvironmentDaprComponentMetadata {
    /**
    * The name of the Metadata configuration item.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#name ContainerAppEnvironmentDaprComponent#name}
    */
    readonly name: string;
    /**
    * The name of a secret specified in the `secrets` block that contains the value for this metadata configuration item.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#secret_name ContainerAppEnvironmentDaprComponent#secret_name}
    */
    readonly secretName?: string;
    /**
    * The value for this metadata configuration item.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#value ContainerAppEnvironmentDaprComponent#value}
    */
    readonly value?: string;
}
export declare function containerAppEnvironmentDaprComponentMetadataToTerraform(struct?: ContainerAppEnvironmentDaprComponentMetadata | cdktf.IResolvable): any;
export declare class ContainerAppEnvironmentDaprComponentMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppEnvironmentDaprComponentMetadata | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppEnvironmentDaprComponentMetadata | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ContainerAppEnvironmentDaprComponentMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppEnvironmentDaprComponentMetadata[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppEnvironmentDaprComponentMetadataOutputReference;
}
export interface ContainerAppEnvironmentDaprComponentSecret {
    /**
    * The Secret name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#name ContainerAppEnvironmentDaprComponent#name}
    */
    readonly name: string;
    /**
    * The value for this secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#value ContainerAppEnvironmentDaprComponent#value}
    */
    readonly value: string;
}
export declare function containerAppEnvironmentDaprComponentSecretToTerraform(struct?: ContainerAppEnvironmentDaprComponentSecret | cdktf.IResolvable): any;
export declare class ContainerAppEnvironmentDaprComponentSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppEnvironmentDaprComponentSecret | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppEnvironmentDaprComponentSecret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAppEnvironmentDaprComponentSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppEnvironmentDaprComponentSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppEnvironmentDaprComponentSecretOutputReference;
}
export interface ContainerAppEnvironmentDaprComponentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#create ContainerAppEnvironmentDaprComponent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#delete ContainerAppEnvironmentDaprComponent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#read ContainerAppEnvironmentDaprComponent#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#update ContainerAppEnvironmentDaprComponent#update}
    */
    readonly update?: string;
}
export declare function containerAppEnvironmentDaprComponentTimeoutsToTerraform(struct?: ContainerAppEnvironmentDaprComponentTimeouts | cdktf.IResolvable): any;
export declare class ContainerAppEnvironmentDaprComponentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppEnvironmentDaprComponentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppEnvironmentDaprComponentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component azurerm_container_app_environment_dapr_component}
*/
export declare class ContainerAppEnvironmentDaprComponent extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_app_environment_dapr_component";
    /**
    * Generates CDKTF code for importing a ContainerAppEnvironmentDaprComponent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerAppEnvironmentDaprComponent to import
    * @param importFromId The id of the existing ContainerAppEnvironmentDaprComponent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerAppEnvironmentDaprComponent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment_dapr_component azurerm_container_app_environment_dapr_component} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAppEnvironmentDaprComponentConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAppEnvironmentDaprComponentConfig);
    private _componentType?;
    get componentType(): string;
    set componentType(value: string);
    get componentTypeInput(): string | undefined;
    private _containerAppEnvironmentId?;
    get containerAppEnvironmentId(): string;
    set containerAppEnvironmentId(value: string);
    get containerAppEnvironmentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreErrors?;
    get ignoreErrors(): boolean | cdktf.IResolvable;
    set ignoreErrors(value: boolean | cdktf.IResolvable);
    resetIgnoreErrors(): void;
    get ignoreErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _initTimeout?;
    get initTimeout(): string;
    set initTimeout(value: string);
    resetInitTimeout(): void;
    get initTimeoutInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _metadata;
    get metadata(): ContainerAppEnvironmentDaprComponentMetadataList;
    putMetadata(value: ContainerAppEnvironmentDaprComponentMetadata[] | cdktf.IResolvable): void;
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | ContainerAppEnvironmentDaprComponentMetadata[] | undefined;
    private _secret;
    get secret(): ContainerAppEnvironmentDaprComponentSecretList;
    putSecret(value: ContainerAppEnvironmentDaprComponentSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | ContainerAppEnvironmentDaprComponentSecret[] | undefined;
    private _timeouts;
    get timeouts(): ContainerAppEnvironmentDaprComponentTimeoutsOutputReference;
    putTimeouts(value: ContainerAppEnvironmentDaprComponentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAppEnvironmentDaprComponentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
