/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAppEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Application Insights connection string used by Dapr to export Service to Service communication telemetry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#dapr_application_insights_connection_string ContainerAppEnvironment#dapr_application_insights_connection_string}
    */
    readonly daprApplicationInsightsConnectionString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#id ContainerAppEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The existing Subnet to use for the Container Apps Control Plane. **NOTE:** The Subnet must have a `/21` or larger address space.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#infrastructure_subnet_id ContainerAppEnvironment#infrastructure_subnet_id}
    */
    readonly infrastructureSubnetId?: string;
    /**
    * Should the Container Environment operate in Internal Load Balancing Mode? Defaults to `false`. **Note:** can only be set to `true` if `infrastructure_subnet_id` is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#internal_load_balancer_enabled ContainerAppEnvironment#internal_load_balancer_enabled}
    */
    readonly internalLoadBalancerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#location ContainerAppEnvironment#location}
    */
    readonly location: string;
    /**
    * The ID for the Log Analytics Workspace to link this Container Apps Managed Environment to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#log_analytics_workspace_id ContainerAppEnvironment#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId?: string;
    /**
    * The name of the Container Apps Managed Environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#name ContainerAppEnvironment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#resource_group_name ContainerAppEnvironment#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#tags ContainerAppEnvironment#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#zone_redundancy_enabled ContainerAppEnvironment#zone_redundancy_enabled}
    */
    readonly zoneRedundancyEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#timeouts ContainerAppEnvironment#timeouts}
    */
    readonly timeouts?: ContainerAppEnvironmentTimeouts;
    /**
    * workload_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#workload_profile ContainerAppEnvironment#workload_profile}
    */
    readonly workloadProfile?: ContainerAppEnvironmentWorkloadProfile[] | cdktf.IResolvable;
}
export interface ContainerAppEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#create ContainerAppEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#delete ContainerAppEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#read ContainerAppEnvironment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#update ContainerAppEnvironment#update}
    */
    readonly update?: string;
}
export declare function containerAppEnvironmentTimeoutsToTerraform(struct?: ContainerAppEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class ContainerAppEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ContainerAppEnvironmentWorkloadProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#maximum_count ContainerAppEnvironment#maximum_count}
    */
    readonly maximumCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#minimum_count ContainerAppEnvironment#minimum_count}
    */
    readonly minimumCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#name ContainerAppEnvironment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#workload_profile_type ContainerAppEnvironment#workload_profile_type}
    */
    readonly workloadProfileType: string;
}
export declare function containerAppEnvironmentWorkloadProfileToTerraform(struct?: ContainerAppEnvironmentWorkloadProfile | cdktf.IResolvable): any;
export declare class ContainerAppEnvironmentWorkloadProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppEnvironmentWorkloadProfile | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppEnvironmentWorkloadProfile | cdktf.IResolvable | undefined);
    private _maximumCount?;
    get maximumCount(): number;
    set maximumCount(value: number);
    get maximumCountInput(): number | undefined;
    private _minimumCount?;
    get minimumCount(): number;
    set minimumCount(value: number);
    get minimumCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _workloadProfileType?;
    get workloadProfileType(): string;
    set workloadProfileType(value: string);
    get workloadProfileTypeInput(): string | undefined;
}
export declare class ContainerAppEnvironmentWorkloadProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppEnvironmentWorkloadProfile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppEnvironmentWorkloadProfileOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment azurerm_container_app_environment}
*/
export declare class ContainerAppEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_app_environment";
    /**
    * Generates CDKTF code for importing a ContainerAppEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerAppEnvironment to import
    * @param importFromId The id of the existing ContainerAppEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerAppEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/resources/container_app_environment azurerm_container_app_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAppEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAppEnvironmentConfig);
    private _daprApplicationInsightsConnectionString?;
    get daprApplicationInsightsConnectionString(): string;
    set daprApplicationInsightsConnectionString(value: string);
    resetDaprApplicationInsightsConnectionString(): void;
    get daprApplicationInsightsConnectionStringInput(): string | undefined;
    get defaultDomain(): string;
    get dockerBridgeCidr(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _infrastructureSubnetId?;
    get infrastructureSubnetId(): string;
    set infrastructureSubnetId(value: string);
    resetInfrastructureSubnetId(): void;
    get infrastructureSubnetIdInput(): string | undefined;
    private _internalLoadBalancerEnabled?;
    get internalLoadBalancerEnabled(): boolean | cdktf.IResolvable;
    set internalLoadBalancerEnabled(value: boolean | cdktf.IResolvable);
    resetInternalLoadBalancerEnabled(): void;
    get internalLoadBalancerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    resetLogAnalyticsWorkspaceId(): void;
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformReservedCidr(): string;
    get platformReservedDnsIpAddress(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get staticIpAddress(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneRedundancyEnabled?;
    get zoneRedundancyEnabled(): boolean | cdktf.IResolvable;
    set zoneRedundancyEnabled(value: boolean | cdktf.IResolvable);
    resetZoneRedundancyEnabled(): void;
    get zoneRedundancyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): ContainerAppEnvironmentTimeoutsOutputReference;
    putTimeouts(value: ContainerAppEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAppEnvironmentTimeouts | undefined;
    private _workloadProfile;
    get workloadProfile(): ContainerAppEnvironmentWorkloadProfileList;
    putWorkloadProfile(value: ContainerAppEnvironmentWorkloadProfile[] | cdktf.IResolvable): void;
    resetWorkloadProfile(): void;
    get workloadProfileInput(): cdktf.IResolvable | ContainerAppEnvironmentWorkloadProfile[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
