/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppConfigurationKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys#configuration_store_id DataAzurermAppConfigurationKeys#configuration_store_id}
    */
    readonly configurationStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys#id DataAzurermAppConfigurationKeys#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys#key DataAzurermAppConfigurationKeys#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys#label DataAzurermAppConfigurationKeys#label}
    */
    readonly label?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys#timeouts DataAzurermAppConfigurationKeys#timeouts}
    */
    readonly timeouts?: DataAzurermAppConfigurationKeysTimeouts;
}
export interface DataAzurermAppConfigurationKeysItems {
}
export declare function dataAzurermAppConfigurationKeysItemsToTerraform(struct?: DataAzurermAppConfigurationKeysItems): any;
export declare class DataAzurermAppConfigurationKeysItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationKeysItems | undefined;
    set internalValue(value: DataAzurermAppConfigurationKeysItems | undefined);
    get contentType(): string;
    get etag(): string;
    get key(): string;
    get label(): string;
    get locked(): cdktf.IResolvable;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
    get value(): string;
    get vaultKeyReference(): string;
}
export declare class DataAzurermAppConfigurationKeysItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationKeysItemsOutputReference;
}
export interface DataAzurermAppConfigurationKeysTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys#read DataAzurermAppConfigurationKeys#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppConfigurationKeysTimeoutsToTerraform(struct?: DataAzurermAppConfigurationKeysTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppConfigurationKeysTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAppConfigurationKeysTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAppConfigurationKeysTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys azurerm_app_configuration_keys}
*/
export declare class DataAzurermAppConfigurationKeys extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_app_configuration_keys";
    /**
    * Generates CDKTF code for importing a DataAzurermAppConfigurationKeys resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAppConfigurationKeys to import
    * @param importFromId The id of the existing DataAzurermAppConfigurationKeys that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAppConfigurationKeys to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/app_configuration_keys azurerm_app_configuration_keys} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppConfigurationKeysConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppConfigurationKeysConfig);
    private _configurationStoreId?;
    get configurationStoreId(): string;
    set configurationStoreId(value: string);
    get configurationStoreIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _items;
    get items(): DataAzurermAppConfigurationKeysItemsList;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermAppConfigurationKeysTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppConfigurationKeysTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAppConfigurationKeysTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
