/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermConfidentialLedgerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/confidential_ledger#id DataAzurermConfidentialLedger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/confidential_ledger#name DataAzurermConfidentialLedger#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/confidential_ledger#resource_group_name DataAzurermConfidentialLedger#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/confidential_ledger#timeouts DataAzurermConfidentialLedger#timeouts}
    */
    readonly timeouts?: DataAzurermConfidentialLedgerTimeouts;
}
export interface DataAzurermConfidentialLedgerAzureadBasedServicePrincipal {
}
export declare function dataAzurermConfidentialLedgerAzureadBasedServicePrincipalToTerraform(struct?: DataAzurermConfidentialLedgerAzureadBasedServicePrincipal): any;
export declare class DataAzurermConfidentialLedgerAzureadBasedServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConfidentialLedgerAzureadBasedServicePrincipal | undefined;
    set internalValue(value: DataAzurermConfidentialLedgerAzureadBasedServicePrincipal | undefined);
    get ledgerRoleName(): string;
    get principalId(): string;
    get tenantId(): string;
}
export declare class DataAzurermConfidentialLedgerAzureadBasedServicePrincipalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConfidentialLedgerAzureadBasedServicePrincipalOutputReference;
}
export interface DataAzurermConfidentialLedgerCertificateBasedSecurityPrincipal {
}
export declare function dataAzurermConfidentialLedgerCertificateBasedSecurityPrincipalToTerraform(struct?: DataAzurermConfidentialLedgerCertificateBasedSecurityPrincipal): any;
export declare class DataAzurermConfidentialLedgerCertificateBasedSecurityPrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConfidentialLedgerCertificateBasedSecurityPrincipal | undefined;
    set internalValue(value: DataAzurermConfidentialLedgerCertificateBasedSecurityPrincipal | undefined);
    get ledgerRoleName(): string;
    get pemPublicKey(): string;
}
export declare class DataAzurermConfidentialLedgerCertificateBasedSecurityPrincipalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConfidentialLedgerCertificateBasedSecurityPrincipalOutputReference;
}
export interface DataAzurermConfidentialLedgerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/confidential_ledger#read DataAzurermConfidentialLedger#read}
    */
    readonly read?: string;
}
export declare function dataAzurermConfidentialLedgerTimeoutsToTerraform(struct?: DataAzurermConfidentialLedgerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermConfidentialLedgerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermConfidentialLedgerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermConfidentialLedgerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/confidential_ledger azurerm_confidential_ledger}
*/
export declare class DataAzurermConfidentialLedger extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_confidential_ledger";
    /**
    * Generates CDKTF code for importing a DataAzurermConfidentialLedger resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermConfidentialLedger to import
    * @param importFromId The id of the existing DataAzurermConfidentialLedger that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/confidential_ledger#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermConfidentialLedger to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/confidential_ledger azurerm_confidential_ledger} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermConfidentialLedgerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermConfidentialLedgerConfig);
    private _azureadBasedServicePrincipal;
    get azureadBasedServicePrincipal(): DataAzurermConfidentialLedgerAzureadBasedServicePrincipalList;
    private _certificateBasedSecurityPrincipal;
    get certificateBasedSecurityPrincipal(): DataAzurermConfidentialLedgerCertificateBasedSecurityPrincipalList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get identityServiceEndpoint(): string;
    get ledgerEndpoint(): string;
    get ledgerType(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermConfidentialLedgerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermConfidentialLedgerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermConfidentialLedgerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
