/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermConsumptionBudgetResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/consumption_budget_resource_group#id DataAzurermConsumptionBudgetResourceGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/consumption_budget_resource_group#name DataAzurermConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/consumption_budget_resource_group#resource_group_id DataAzurermConsumptionBudgetResourceGroup#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/consumption_budget_resource_group#timeouts DataAzurermConsumptionBudgetResourceGroup#timeouts}
    */
    readonly timeouts?: DataAzurermConsumptionBudgetResourceGroupTimeouts;
}
export interface DataAzurermConsumptionBudgetResourceGroupFilterDimension {
}
export declare function dataAzurermConsumptionBudgetResourceGroupFilterDimensionToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupFilterDimension): any;
export declare class DataAzurermConsumptionBudgetResourceGroupFilterDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupFilterDimension | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupFilterDimension | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetResourceGroupFilterDimensionOutputReference;
}
export interface DataAzurermConsumptionBudgetResourceGroupFilterNotDimension {
}
export declare function dataAzurermConsumptionBudgetResourceGroupFilterNotDimensionToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupFilterNotDimension): any;
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupFilterNotDimension | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupFilterNotDimension | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetResourceGroupFilterNotDimensionOutputReference;
}
export interface DataAzurermConsumptionBudgetResourceGroupFilterNotTag {
}
export declare function dataAzurermConsumptionBudgetResourceGroupFilterNotTagToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupFilterNotTag): any;
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupFilterNotTag | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupFilterNotTag | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetResourceGroupFilterNotTagOutputReference;
}
export interface DataAzurermConsumptionBudgetResourceGroupFilterNot {
}
export declare function dataAzurermConsumptionBudgetResourceGroupFilterNotToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupFilterNot): any;
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupFilterNot | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupFilterNot | undefined);
    private _dimension;
    get dimension(): DataAzurermConsumptionBudgetResourceGroupFilterNotDimensionList;
    private _tag;
    get tag(): DataAzurermConsumptionBudgetResourceGroupFilterNotTagList;
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetResourceGroupFilterNotOutputReference;
}
export interface DataAzurermConsumptionBudgetResourceGroupFilterTag {
}
export declare function dataAzurermConsumptionBudgetResourceGroupFilterTagToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupFilterTag): any;
export declare class DataAzurermConsumptionBudgetResourceGroupFilterTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupFilterTag | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupFilterTag | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetResourceGroupFilterTagOutputReference;
}
export interface DataAzurermConsumptionBudgetResourceGroupFilter {
}
export declare function dataAzurermConsumptionBudgetResourceGroupFilterToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupFilter): any;
export declare class DataAzurermConsumptionBudgetResourceGroupFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupFilter | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupFilter | undefined);
    private _dimension;
    get dimension(): DataAzurermConsumptionBudgetResourceGroupFilterDimensionList;
    private _not;
    get not(): DataAzurermConsumptionBudgetResourceGroupFilterNotList;
    private _tag;
    get tag(): DataAzurermConsumptionBudgetResourceGroupFilterTagList;
}
export declare class DataAzurermConsumptionBudgetResourceGroupFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetResourceGroupFilterOutputReference;
}
export interface DataAzurermConsumptionBudgetResourceGroupNotification {
}
export declare function dataAzurermConsumptionBudgetResourceGroupNotificationToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupNotification): any;
export declare class DataAzurermConsumptionBudgetResourceGroupNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupNotification | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupNotification | undefined);
    get contactEmails(): string[];
    get contactGroups(): string[];
    get contactRoles(): string[];
    get enabled(): cdktf.IResolvable;
    get operator(): string;
    get threshold(): number;
    get thresholdType(): string;
}
export declare class DataAzurermConsumptionBudgetResourceGroupNotificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetResourceGroupNotificationOutputReference;
}
export interface DataAzurermConsumptionBudgetResourceGroupTimePeriod {
}
export declare function dataAzurermConsumptionBudgetResourceGroupTimePeriodToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupTimePeriod): any;
export declare class DataAzurermConsumptionBudgetResourceGroupTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupTimePeriod | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupTimePeriod | undefined);
    get endDate(): string;
    get startDate(): string;
}
export declare class DataAzurermConsumptionBudgetResourceGroupTimePeriodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermConsumptionBudgetResourceGroupTimePeriodOutputReference;
}
export interface DataAzurermConsumptionBudgetResourceGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/consumption_budget_resource_group#read DataAzurermConsumptionBudgetResourceGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermConsumptionBudgetResourceGroupTimeoutsToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermConsumptionBudgetResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/consumption_budget_resource_group azurerm_consumption_budget_resource_group}
*/
export declare class DataAzurermConsumptionBudgetResourceGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_consumption_budget_resource_group";
    /**
    * Generates CDKTF code for importing a DataAzurermConsumptionBudgetResourceGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermConsumptionBudgetResourceGroup to import
    * @param importFromId The id of the existing DataAzurermConsumptionBudgetResourceGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/consumption_budget_resource_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermConsumptionBudgetResourceGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/consumption_budget_resource_group azurerm_consumption_budget_resource_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermConsumptionBudgetResourceGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermConsumptionBudgetResourceGroupConfig);
    get amount(): number;
    private _filter;
    get filter(): DataAzurermConsumptionBudgetResourceGroupFilterList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notification;
    get notification(): DataAzurermConsumptionBudgetResourceGroupNotificationList;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    get timeGrain(): string;
    private _timePeriod;
    get timePeriod(): DataAzurermConsumptionBudgetResourceGroupTimePeriodList;
    private _timeouts;
    get timeouts(): DataAzurermConsumptionBudgetResourceGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermConsumptionBudgetResourceGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermConsumptionBudgetResourceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
