/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDevTestVirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network#id DataAzurermDevTestVirtualNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network#lab_name DataAzurermDevTestVirtualNetwork#lab_name}
    */
    readonly labName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network#name DataAzurermDevTestVirtualNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network#resource_group_name DataAzurermDevTestVirtualNetwork#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network#timeouts DataAzurermDevTestVirtualNetwork#timeouts}
    */
    readonly timeouts?: DataAzurermDevTestVirtualNetworkTimeouts;
}
export interface DataAzurermDevTestVirtualNetworkAllowedSubnets {
}
export declare function dataAzurermDevTestVirtualNetworkAllowedSubnetsToTerraform(struct?: DataAzurermDevTestVirtualNetworkAllowedSubnets): any;
export declare class DataAzurermDevTestVirtualNetworkAllowedSubnetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDevTestVirtualNetworkAllowedSubnets | undefined;
    set internalValue(value: DataAzurermDevTestVirtualNetworkAllowedSubnets | undefined);
    get allowPublicIp(): string;
    get labSubnetName(): string;
    get resourceId(): string;
}
export declare class DataAzurermDevTestVirtualNetworkAllowedSubnetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDevTestVirtualNetworkAllowedSubnetsOutputReference;
}
export interface DataAzurermDevTestVirtualNetworkSubnetOverrides {
}
export declare function dataAzurermDevTestVirtualNetworkSubnetOverridesToTerraform(struct?: DataAzurermDevTestVirtualNetworkSubnetOverrides): any;
export declare class DataAzurermDevTestVirtualNetworkSubnetOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDevTestVirtualNetworkSubnetOverrides | undefined;
    set internalValue(value: DataAzurermDevTestVirtualNetworkSubnetOverrides | undefined);
    get labSubnetName(): string;
    get resourceId(): string;
    get useInVmCreationPermission(): string;
    get usePublicIpAddressPermission(): string;
    get virtualNetworkPoolName(): string;
}
export declare class DataAzurermDevTestVirtualNetworkSubnetOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDevTestVirtualNetworkSubnetOverridesOutputReference;
}
export interface DataAzurermDevTestVirtualNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network#read DataAzurermDevTestVirtualNetwork#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDevTestVirtualNetworkTimeoutsToTerraform(struct?: DataAzurermDevTestVirtualNetworkTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDevTestVirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDevTestVirtualNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDevTestVirtualNetworkTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network azurerm_dev_test_virtual_network}
*/
export declare class DataAzurermDevTestVirtualNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dev_test_virtual_network";
    /**
    * Generates CDKTF code for importing a DataAzurermDevTestVirtualNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDevTestVirtualNetwork to import
    * @param importFromId The id of the existing DataAzurermDevTestVirtualNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDevTestVirtualNetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/dev_test_virtual_network azurerm_dev_test_virtual_network} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDevTestVirtualNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDevTestVirtualNetworkConfig);
    private _allowedSubnets;
    get allowedSubnets(): DataAzurermDevTestVirtualNetworkAllowedSubnetsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labName?;
    get labName(): string;
    set labName(value: string);
    get labNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subnetOverrides;
    get subnetOverrides(): DataAzurermDevTestVirtualNetworkSubnetOverridesList;
    get uniqueIdentifier(): string;
    private _timeouts;
    get timeouts(): DataAzurermDevTestVirtualNetworkTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDevTestVirtualNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDevTestVirtualNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
