/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKubernetesClusterNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool#id DataAzurermKubernetesClusterNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool#kubernetes_cluster_name DataAzurermKubernetesClusterNodePool#kubernetes_cluster_name}
    */
    readonly kubernetesClusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool#name DataAzurermKubernetesClusterNodePool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool#resource_group_name DataAzurermKubernetesClusterNodePool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool#timeouts DataAzurermKubernetesClusterNodePool#timeouts}
    */
    readonly timeouts?: DataAzurermKubernetesClusterNodePoolTimeouts;
}
export interface DataAzurermKubernetesClusterNodePoolUpgradeSettings {
}
export declare function dataAzurermKubernetesClusterNodePoolUpgradeSettingsToTerraform(struct?: DataAzurermKubernetesClusterNodePoolUpgradeSettings): any;
export declare class DataAzurermKubernetesClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKubernetesClusterNodePoolUpgradeSettings | undefined;
    set internalValue(value: DataAzurermKubernetesClusterNodePoolUpgradeSettings | undefined);
    get maxSurge(): string;
}
export declare class DataAzurermKubernetesClusterNodePoolUpgradeSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKubernetesClusterNodePoolUpgradeSettingsOutputReference;
}
export interface DataAzurermKubernetesClusterNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool#read DataAzurermKubernetesClusterNodePool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKubernetesClusterNodePoolTimeoutsToTerraform(struct?: DataAzurermKubernetesClusterNodePoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKubernetesClusterNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKubernetesClusterNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool}
*/
export declare class DataAzurermKubernetesClusterNodePool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_kubernetes_cluster_node_pool";
    /**
    * Generates CDKTF code for importing a DataAzurermKubernetesClusterNodePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermKubernetesClusterNodePool to import
    * @param importFromId The id of the existing DataAzurermKubernetesClusterNodePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermKubernetesClusterNodePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.84.0/docs/data-sources/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKubernetesClusterNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesClusterNodePoolConfig);
    get enableAutoScaling(): cdktf.IResolvable;
    get enableNodePublicIp(): cdktf.IResolvable;
    get evictionPolicy(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesClusterName?;
    get kubernetesClusterName(): string;
    set kubernetesClusterName(value: string);
    get kubernetesClusterNameInput(): string | undefined;
    get maxCount(): number;
    get maxPods(): number;
    get minCount(): number;
    get mode(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nodeCount(): number;
    private _nodeLabels;
    get nodeLabels(): cdktf.StringMap;
    get nodePublicIpPrefixId(): string;
    get nodeTaints(): string[];
    get orchestratorVersion(): string;
    get osDiskSizeGb(): number;
    get osDiskType(): string;
    get osType(): string;
    get priority(): string;
    get proximityPlacementGroupId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get spotMaxPrice(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    private _upgradeSettings;
    get upgradeSettings(): DataAzurermKubernetesClusterNodePoolUpgradeSettingsList;
    get vmSize(): string;
    get vnetSubnetId(): string;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermKubernetesClusterNodePoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKubernetesClusterNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKubernetesClusterNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
